/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JarStream;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLStream;
import org.armedbear.lisp.util.RandomAccessCharacterFile;

public final class FileStream
extends Stream {
    private final RandomAccessCharacterFile racf;
    private final Pathname pathname;
    private final int bytesPerUnit;
    private static final Primitive MAKE_FILE_STREAM = new Primitive("make-file-stream", Lisp.PACKAGE_SYS, true, "pathname namestring element-type direction if-exists external-format"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            if (!(first instanceof Pathname)) {
                return Lisp.type_error(first, Symbol.PATHNAME);
            }
            Pathname pathname = (Pathname)first;
            AbstractString namestring = Lisp.checkString(second);
            LispObject elementType = third;
            LispObject direction = fourth;
            LispObject ifExists = fifth;
            LispObject externalFormat = sixth;
            if (direction != Keyword.INPUT && direction != Keyword.OUTPUT && direction != Keyword.IO) {
                Lisp.error(new LispError("Direction must be :INPUT, :OUTPUT, or :IO."));
            }
            if (pathname.isJar()) {
                if (direction != Keyword.INPUT) {
                    Lisp.error(new FileError("Only direction :INPUT is supported for jar files.", pathname));
                }
                try {
                    return new JarStream(pathname, namestring.getStringValue(), elementType, direction, ifExists, externalFormat);
                }
                catch (IOException e) {
                    return Lisp.error(new StreamError(null, e));
                }
            }
            if (pathname.isURL()) {
                if (direction != Keyword.INPUT) {
                    Lisp.error(new FileError("Only direction :INPUT is supported for URLs.", pathname));
                }
                try {
                    return new URLStream(pathname, namestring.getStringValue(), elementType, direction, ifExists, externalFormat);
                }
                catch (IOException e) {
                    return Lisp.error(new StreamError(null, e));
                }
            }
            try {
                return new FileStream(pathname, namestring.getStringValue(), elementType, direction, ifExists, externalFormat);
            }
            catch (FileNotFoundException e) {
                return Lisp.NIL;
            }
            catch (IOException e) {
                return Lisp.error(new StreamError(null, e));
            }
        }
    };

    public FileStream(Pathname pathname, String namestring, LispObject elementType, LispObject direction, LispObject ifExists, LispObject format) throws IOException {
        super(Symbol.FILE_STREAM);
        File file = new File(namestring);
        String mode = null;
        if (direction == Keyword.INPUT) {
            mode = "r";
            this.isInputStream = true;
        } else if (direction == Keyword.OUTPUT) {
            mode = "rw";
            this.isOutputStream = true;
        } else if (direction == Keyword.IO) {
            mode = "rw";
            this.isInputStream = true;
            this.isOutputStream = true;
        }
        Debug.assertTrue(mode != null);
        RandomAccessFile raf = new RandomAccessFile(file, mode);
        if (this.isOutputStream) {
            long length;
            long l = length = file.isFile() ? file.length() : 0L;
            if (length > 0L) {
                if (ifExists == Keyword.OVERWRITE) {
                    raf.seek(0L);
                } else if (ifExists == Keyword.APPEND) {
                    raf.seek(raf.length());
                } else {
                    raf.setLength(0L);
                }
            }
        }
        this.setExternalFormat(format);
        this.racf = new RandomAccessCharacterFile(raf, this.encoding);
        this.pathname = pathname;
        this.elementType = elementType;
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            this.isCharacterStream = true;
            this.bytesPerUnit = 1;
            if (this.isInputStream) {
                this.initAsCharacterInputStream(this.racf.getReader());
            }
            if (this.isOutputStream) {
                this.initAsCharacterOutputStream(this.racf.getWriter());
            }
        } else {
            this.isBinaryStream = true;
            int width = Fixnum.getValue(elementType.cadr());
            this.bytesPerUnit = width / 8;
            if (this.isInputStream) {
                this.initAsBinaryInputStream(this.racf.getInputStream());
            }
            if (this.isOutputStream) {
                this.initAsBinaryOutputStream(this.racf.getOutputStream());
            }
        }
    }

    @Override
    public LispObject typeOf() {
        return Symbol.FILE_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.FILE_STREAM;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.FILE_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.FILE_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public void setExternalFormat(LispObject format) {
        super.setExternalFormat(format);
        if (this.racf != null) {
            this.racf.setEncoding(this.encoding);
        }
    }

    public Pathname getPathname() {
        return this.pathname;
    }

    @Override
    public LispObject fileLength() {
        long length;
        if (this.isOpen()) {
            try {
                length = this.racf.length();
            }
            catch (IOException e) {
                Lisp.error(new StreamError((Stream)this, e));
                return Lisp.NIL;
            }
        } else {
            String namestring = this.pathname.getNamestring();
            if (namestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + this.pathname.princToString()));
            }
            File file = new File(namestring);
            length = file.length();
        }
        if (this.isCharacterStream) {
            return Lisp.number(length);
        }
        return Lisp.number(length / (long)this.bytesPerUnit);
    }

    @Override
    protected boolean _charReady() {
        return true;
    }

    @Override
    public void _clearInput() {
        try {
            if (this.isInputStream) {
                this.racf.position(this.racf.length());
            } else {
                this.streamNotInputStream();
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
    }

    @Override
    protected long _getFilePosition() {
        try {
            long pos = this.racf.position();
            return pos / (long)this.bytesPerUnit;
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
            return -1L;
        }
    }

    @Override
    protected boolean _setFilePosition(LispObject arg) {
        try {
            long pos = 0L;
            if (arg == Keyword.START) {
                pos = 0L;
            } else if (arg == Keyword.END) {
                pos = this.racf.length();
            } else if (arg instanceof Fixnum) {
                pos = ((Fixnum)arg).value * this.bytesPerUnit;
            } else if (arg instanceof Bignum) {
                pos = ((Bignum)arg).longValue() * (long)this.bytesPerUnit;
            } else {
                Lisp.type_error(arg, Symbol.INTEGER);
            }
            this.racf.position(pos);
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
        return true;
    }

    @Override
    public void _close() {
        try {
            this.racf.close();
            this.setOpen(false);
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
    }

    @Override
    public String printObject() {
        return this.unreadableString("FILE-STREAM");
    }
}

