/**
 * @file spill_tree.hpp
 * @author Marcos Pividori
 *
 * Include all the necessary files to use the SpillTree class.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_CORE_TREE_SPILL_TREE_HPP
#define MLPACK_CORE_TREE_SPILL_TREE_HPP

#include <mlpack/prereqs.hpp>
#include "bounds.hpp"
#include "spill_tree/is_spill_tree.hpp"
#include "spill_tree/spill_tree.hpp"
#include "spill_tree/spill_single_tree_traverser.hpp"
#include "spill_tree/spill_single_tree_traverser_impl.hpp"
#include "spill_tree/spill_dual_tree_traverser.hpp"
#include "spill_tree/spill_dual_tree_traverser_impl.hpp"
#include "spill_tree/traits.hpp"
#include "spill_tree/typedef.hpp"

#endif
