/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.RestService;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.collector.SnmpTrapReceiver;
import onl.netfishers.netshot.collector.SyslogServer;
import onl.netfishers.netshot.device.DeviceDriver;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Netshot
extends Thread {
    public static final String VERSION = "0.14.0";
    private static final String[] CONFIG_FILENAMES = new String[]{"netshot.conf", "/etc/netshot.conf"};
    private static Properties config;
    private static Logger logger;
    public static final Logger aaaLogger;
    public static Thread.UncaughtExceptionHandler exceptionHandler;

    public static Properties getConfig() {
        return config;
    }

    public static String getConfig(String key, String defaultValue) {
        return config.getProperty(key, defaultValue);
    }

    public static int getConfig(String key, int defaultValue) {
        String textValue = Netshot.getConfig(key);
        if (textValue != null) {
            try {
                return Integer.parseInt(textValue);
            }
            catch (Exception e) {
                logger.error("Unable to parse the integer value of configuration item '{}'.", (Object)key);
            }
        }
        return defaultValue;
    }

    public static String getConfig(String key) {
        return config.getProperty(key);
    }

    protected static boolean initConfig() {
        config = new Properties();
        for (String fileName : CONFIG_FILENAMES) {
            try {
                logger.trace("Trying to load the configuration file {}.", (Object)fileName);
                FileInputStream fileStream = new FileInputStream(fileName);
                config.load(fileStream);
                ((InputStream)fileStream).close();
                break;
            }
            catch (Exception e) {
                logger.error("Unable to read the configuration file {}.", (Object)fileName);
            }
        }
        if (config.isEmpty()) {
            logger.error(MarkerFactory.getMarker("FATAL"), "No configuration file was found. Exiting.");
            return false;
        }
        return true;
    }

    protected static boolean initMainLogging() {
        OutputStreamAppender appender;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        System.setProperty("org.jboss.logging.provider", "slf4j");
        String logFile = Netshot.getConfig("netshot.log.file", "netshot.log");
        String logLevelCfg = Netshot.getConfig("netshot.log.level");
        String logCountCfg = Netshot.getConfig("netshot.log.count", "5");
        String logMaxSizeCfg = Netshot.getConfig("netshot.log.maxsize", "2");
        int logCount = 5;
        try {
            logCount = Integer.parseInt(logCountCfg);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number of log files (netshot.log.count config line). Using {}.", (Object)logCount);
        }
        int logMaxSize = 5;
        try {
            logMaxSize = Integer.parseInt(logMaxSizeCfg);
            if (logMaxSize < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e1) {
            logger.error("Invalid max size of log files (netshot.log.maxsize config line). Using {}.", (Object)logMaxSize);
        }
        Level logLevel = Level.toLevel(logLevelCfg, Level.WARN);
        if (logLevelCfg != null && !logLevel.toString().equals(logLevelCfg)) {
            logger.error("Invalid log level (netshot.log.level) '{}'. Using {}.", (Object)logLevelCfg, (Object)logLevel);
        }
        if (logFile.equals("CONSOLE")) {
            ConsoleAppender<ILoggingEvent> cAppender = new ConsoleAppender<ILoggingEvent>();
            logger.info("Will go on logging to the console.");
            appender = cAppender;
        } else {
            logger.info("Switching to file logging, into {}, level {}, rotation using {} files of max {}MB.", logFile, logLevel, logCount, logMaxSize);
            loggerContext.reset();
            try {
                RollingFileAppender rfAppender = new RollingFileAppender();
                rfAppender.setContext(loggerContext);
                rfAppender.setFile(logFile);
                FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
                fwRollingPolicy.setContext(loggerContext);
                fwRollingPolicy.setFileNamePattern(logFile + ".%i.gz");
                fwRollingPolicy.setMinIndex(1);
                fwRollingPolicy.setMaxIndex(logCount);
                fwRollingPolicy.setParent(rfAppender);
                fwRollingPolicy.start();
                SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
                triggeringPolicy.setMaxFileSize(new FileSize((long)logMaxSize * 0x100000L));
                triggeringPolicy.start();
                rfAppender.setRollingPolicy(fwRollingPolicy);
                rfAppender.setTriggeringPolicy(triggeringPolicy);
                appender = rfAppender;
            }
            catch (Exception e) {
                logger.error(MarkerFactory.getMarker("FATAL"), "Unable to log into file {}. Exiting.", (Object)logFile, (Object)e);
                return false;
            }
        }
        rootLogger.setLevel(logLevel);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(loggerContext);
        encoder.setPattern("%d %-5level [%thread] %logger{0}: %msg%n");
        encoder.start();
        appender.setEncoder(encoder);
        appender.setContext(loggerContext);
        ((OutputStreamAppender)appender).start();
        rootLogger.addAppender(appender);
        Pattern logSetting = Pattern.compile("^netshot\\.log\\.class\\.(?<class>.*)");
        Enumeration<?> propertyNames = config.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            Matcher matcher = logSetting.matcher(propertyName);
            if (!matcher.find()) continue;
            String propertyValue = Netshot.getConfig(propertyName);
            String className = matcher.group("class").trim();
            ch.qos.logback.classic.Logger classLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(className);
            try {
                Level classLevel = Level.valueOf(propertyValue);
                classLogger.setLevel(classLevel);
                logger.info("Assigning level {} to class {}.", (Object)classLevel, (Object)className);
            }
            catch (Exception e) {
                logger.error("Invalid log level for class {}.", (Object)className);
            }
        }
        return true;
    }

    protected static boolean initAuditLogging() {
        String auditFile = Netshot.getConfig("netshot.log.audit.file");
        String auditLevelCfg = Netshot.getConfig("netshot.log.audit.level");
        String auditCountCfg = Netshot.getConfig("netshot.log.audit.count", "5");
        String auditMaxSizeCfg = Netshot.getConfig("netshot.log.audit.maxsize", "2");
        int auditCount = 5;
        try {
            auditCount = Integer.parseInt(auditCountCfg);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number of log files (netshot.log.audit.count config line). Using {}.", (Object)auditCount);
        }
        int auditMaxSize = 5;
        try {
            auditMaxSize = Integer.parseInt(auditMaxSizeCfg);
            if (auditMaxSize < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e1) {
            logger.error("Invalid max size of log files (netshot.log.audit.maxsize config line). Using {}.", (Object)auditMaxSize);
        }
        ((ch.qos.logback.classic.Logger)aaaLogger).setAdditive(false);
        Level logLevel = Level.toLevel(auditLevelCfg, Level.OFF);
        if (auditLevelCfg != null && !logLevel.toString().equals(auditLevelCfg)) {
            logger.error("Invalid log level (netshot.log.audit.level) '{}'. Using {}.", (Object)auditLevelCfg, (Object)logLevel);
        }
        ((ch.qos.logback.classic.Logger)aaaLogger).setLevel(logLevel);
        if (auditFile != null) {
            try {
                LoggerContext loggerContext = ((ch.qos.logback.classic.Logger)aaaLogger).getLoggerContext();
                RollingFileAppender<ILoggingEvent> appender = new RollingFileAppender<ILoggingEvent>();
                appender.setContext(loggerContext);
                appender.setFile(auditFile);
                FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
                fwRollingPolicy.setContext(loggerContext);
                fwRollingPolicy.setFileNamePattern(auditFile + ".%i.gz");
                fwRollingPolicy.setMinIndex(1);
                fwRollingPolicy.setMaxIndex(auditCount);
                fwRollingPolicy.setParent(appender);
                fwRollingPolicy.start();
                SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
                triggeringPolicy.setMaxFileSize(new FileSize((long)auditMaxSize * 0x100000L));
                triggeringPolicy.start();
                appender.setRollingPolicy(fwRollingPolicy);
                appender.setTriggeringPolicy(triggeringPolicy);
                PatternLayoutEncoder encoder = new PatternLayoutEncoder();
                encoder.setContext(loggerContext);
                encoder.setPattern("%d %logger{0}: %msg%n");
                encoder.start();
                appender.setEncoder(encoder);
                appender.setContext(loggerContext);
                appender.start();
                ((ch.qos.logback.classic.Logger)aaaLogger).addAppender((Appender<ILoggingEvent>)appender);
                logger.warn("Audit information will be logged to {}.", (Object)auditFile);
                aaaLogger.error("Audit starting.");
            }
            catch (Exception e) {
                logger.error("Unable to log AAA data into file {}. Exiting.", (Object)auditFile, (Object)e);
            }
        }
        return true;
    }

    protected static boolean initSyslogLogging() {
        String host;
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        int syslogIndex = 1;
        while ((host = Netshot.getConfig(String.format("netshot.log.syslog%d.host", syslogIndex))) != null && !(host = host.trim()).equals("")) {
            String facility;
            SyslogAppender appender = new SyslogAppender();
            appender.setSyslogHost(host);
            appender.setContext(loggerContext);
            appender.setSuffixPattern("[Netshot] %logger{0}: %msg");
            String port = Netshot.getConfig(String.format("netshot.log.syslog%d.port", syslogIndex));
            if (port != null) {
                try {
                    appender.setPort(Integer.parseInt(port));
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid syslog port number ({}).", (Object)String.format("netshot.log.syslog%d.port", syslogIndex));
                }
            }
            appender.setFacility((facility = Netshot.getConfig(String.format("netshot.log.syslog%d.facility", syslogIndex))) == null ? "LOCAL7" : facility);
            rootLogger.addAppender(appender);
            ((ch.qos.logback.classic.Logger)aaaLogger).addAppender(appender);
            try {
                appender.start();
            }
            catch (Exception e) {
                logger.error("Unable to start syslog instance {}: {}.", (Object)syslogIndex, (Object)e.getMessage());
            }
            logger.warn("Logging to syslog {}:{} has started", (Object)appender.getSyslogHost(), (Object)appender.getPort());
            ++syslogIndex;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(String.format("Starting Netshot version %s.", VERSION));
        logger.info("Starting Netshot");
        if (!Netshot.initConfig()) {
            System.exit(1);
        }
        if (!(Netshot.initMainLogging() && Netshot.initAuditLogging() && Netshot.initSyslogLogging())) {
            System.exit(1);
        }
        try {
            logger.info("Enabling BouncyCastle security.");
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
            logger.info("Initializing the task manager.");
            TaskManager.init();
            logger.info("Updating the database schema, if necessary.");
            Database.update();
            logger.info("Initializing access to the database.");
            Database.init();
            logger.info("Loading the device drivers");
            DeviceDriver.refreshDrivers();
            logger.info("Starting the Syslog server.");
            SyslogServer.init();
            logger.info("Starting the SNMP v1/v2c trap receiver");
            SnmpTrapReceiver.init();
            logger.info("Starting the REST service");
            RestService.init();
            logger.info("Scheduling the existing tasks.");
            TaskManager.rescheduleAll();
            logger.warn("Netshot is started");
        }
        catch (Exception e) {
            System.err.println("NETSHOT FATAL ERROR: " + e.getMessage());
            System.exit(1);
        }
    }

    static {
        logger = LoggerFactory.getLogger(Netshot.class);
        aaaLogger = LoggerFactory.getLogger("AAA");
        exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                System.err.println("NETSHOT FATAL ERROR");
                ex.printStackTrace();
                System.exit(1);
            }
        };
    }
}

