/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;

@Entity
@DiscriminatorValue(value="N")
public class DiagnosticNumericResult
extends DiagnosticResult {
    private Double number;

    protected DiagnosticNumericResult() {
    }

    public DiagnosticNumericResult(Device device, Diagnostic diagnostic, double value) {
        super(device, diagnostic);
        this.number = value;
    }

    public DiagnosticNumericResult(Device device, Diagnostic diagnostic, String value) {
        super(device, diagnostic);
        this.number = Double.parseDouble(value);
    }

    @XmlElement
    public Double getNumber() {
        return this.number;
    }

    public void setNumber(Double value) {
        this.number = value;
    }

    @Override
    @Transient
    public String getAsText() {
        if (this.number == null) {
            return "";
        }
        return this.number.toString();
    }

    @Override
    @Transient
    public Object getData() {
        return this.getNumber();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagnosticNumericResult)) {
            return false;
        }
        DiagnosticNumericResult other = (DiagnosticNumericResult)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }
}

