/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.batch.internal.AbstractBatchImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class NonBatchingBatch
extends AbstractBatchImpl {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NonBatchingBatch.class.getName());
    private JdbcCoordinator jdbcCoordinator;

    protected NonBatchingBatch(BatchKey key, JdbcCoordinator jdbcCoordinator) {
        super(key, jdbcCoordinator);
        this.jdbcCoordinator = jdbcCoordinator;
    }

    @Override
    public void addToBatch() {
        this.notifyObserversImplicitExecution();
        for (Map.Entry<String, PreparedStatement> entry : this.getStatements().entrySet()) {
            try {
                PreparedStatement statement = entry.getValue();
                int rowCount = this.jdbcCoordinator.getResultSetReturn().executeUpdate(statement);
                this.getKey().getExpectation().verifyOutcome(rowCount, statement, 0);
                this.jdbcCoordinator.release(statement);
            }
            catch (SQLException e) {
                this.abortBatch();
                throw this.sqlExceptionHelper().convert(e, "could not execute non-batched batch statement", entry.getKey());
            }
            catch (JDBCException e) {
                this.abortBatch();
                throw e;
            }
        }
        this.getStatements().clear();
    }

    @Override
    protected void clearBatch(PreparedStatement statement) {
    }

    @Override
    protected void doExecuteBatch() {
    }
}

