/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntrySet$RegularEntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapKeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapValues;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class JdkBackedImmutableMap
extends ImmutableMap {
    private final transient Map delegateMap;
    private final transient ImmutableList entries;

    static ImmutableMap create(int n, Map.Entry[] entryArray) {
        HashMap hashMap = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            entryArray[i] = RegularImmutableMap.makeImmutable(entryArray[i]);
            Object v = hashMap.putIfAbsent(entryArray[i].getKey(), entryArray[i].getValue());
            if (v == null) continue;
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i], entryArray[i].getKey() + "=" + v);
        }
        return new JdkBackedImmutableMap(hashMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map map, ImmutableList immutableList) {
        this.delegateMap = map;
        this.entries = immutableList;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object get(@NullableDecl Object object) {
        return this.delegateMap.get(object);
    }

    @Override
    ImmutableSet createEntrySet() {
        return new ImmutableMapEntrySet$RegularEntrySet((ImmutableMap)this, this.entries);
    }

    public void forEach(BiConsumer biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        this.entries.forEach((T entry) -> biConsumer.accept(entry.getKey(), entry.getValue()));
    }

    @Override
    ImmutableSet createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

