/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

public class SimpleTextCompoundFormat
extends CompoundFormat {
    static final String DATA_EXTENSION = "scf";
    static final BytesRef HEADER = new BytesRef((CharSequence)"cfs entry for: ");
    static final BytesRef TABLE = new BytesRef((CharSequence)"table of contents, size: ");
    static final BytesRef TABLENAME = new BytesRef((CharSequence)"  filename: ");
    static final BytesRef TABLESTART = new BytesRef((CharSequence)"    start: ");
    static final BytesRef TABLEEND = new BytesRef((CharSequence)"    end: ");
    static final BytesRef TABLEPOS = new BytesRef((CharSequence)"table of contents begins at offset: ");
    static final String OFFSETPATTERN;

    public Directory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)DATA_EXTENSION);
        final IndexInput in = dir.openInput(dataFile, context);
        BytesRefBuilder scratch = new BytesRefBuilder();
        DecimalFormat df = new DecimalFormat(OFFSETPATTERN, DecimalFormatSymbols.getInstance(Locale.ROOT));
        long pos = in.length() - (long)SimpleTextCompoundFormat.TABLEPOS.length - (long)OFFSETPATTERN.length() - 1L;
        in.seek(pos);
        SimpleTextUtil.readLine((DataInput)in, scratch);
        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)TABLEPOS));
        long tablePos = -1L;
        try {
            tablePos = df.parse(this.stripPrefix(scratch, TABLEPOS)).longValue();
        }
        catch (ParseException e) {
            throw new CorruptIndexException("can't parse CFS trailer, got: " + scratch.get().utf8ToString(), (DataInput)in);
        }
        in.seek(tablePos);
        SimpleTextUtil.readLine((DataInput)in, scratch);
        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)TABLE));
        int numEntries = Integer.parseInt(this.stripPrefix(scratch, TABLE));
        final String[] fileNames = new String[numEntries];
        final long[] startOffsets = new long[numEntries];
        final long[] endOffsets = new long[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)TABLENAME));
            fileNames[i] = si.name + IndexFileNames.stripSegmentName((String)this.stripPrefix(scratch, TABLENAME));
            if (i > 0) assert (fileNames[i].compareTo(fileNames[i - 1]) > 0);
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)TABLESTART));
            startOffsets[i] = Long.parseLong(this.stripPrefix(scratch, TABLESTART));
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)TABLEEND));
            endOffsets[i] = Long.parseLong(this.stripPrefix(scratch, TABLEEND));
        }
        return new Directory(){

            private int getIndex(String name) throws IOException {
                int index = Arrays.binarySearch(fileNames, name);
                if (index < 0) {
                    throw new FileNotFoundException("No sub-file found (fileName=" + name + " files: " + Arrays.toString(fileNames) + ")");
                }
                return index;
            }

            public String[] listAll() throws IOException {
                this.ensureOpen();
                return (String[])fileNames.clone();
            }

            public long fileLength(String name) throws IOException {
                this.ensureOpen();
                int index = this.getIndex(name);
                return endOffsets[index] - startOffsets[index];
            }

            public IndexInput openInput(String name, IOContext context) throws IOException {
                this.ensureOpen();
                int index = this.getIndex(name);
                return in.slice(name, startOffsets[index], endOffsets[index] - startOffsets[index]);
            }

            public void close() throws IOException {
                in.close();
            }

            public Set<String> getPendingDeletions() throws IOException {
                return Collections.emptySet();
            }

            public IndexOutput createOutput(String name, IOContext context) {
                throw new UnsupportedOperationException();
            }

            public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
                throw new UnsupportedOperationException();
            }

            public void sync(Collection<String> names) {
                throw new UnsupportedOperationException();
            }

            public void deleteFile(String name) {
                throw new UnsupportedOperationException();
            }

            public void rename(String source, String dest) {
                throw new UnsupportedOperationException();
            }

            public void syncMetaData() {
                throw new UnsupportedOperationException();
            }

            public Lock obtainLock(String name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void write(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)DATA_EXTENSION);
        int numFiles = si.files().size();
        Object[] names = si.files().toArray(new String[numFiles]);
        Arrays.sort(names);
        long[] startOffsets = new long[numFiles];
        long[] endOffsets = new long[numFiles];
        BytesRefBuilder scratch = new BytesRefBuilder();
        try (IndexOutput out = dir.createOutput(dataFile, context);){
            for (int i = 0; i < names.length; ++i) {
                SimpleTextUtil.write((DataOutput)out, HEADER);
                SimpleTextUtil.write((DataOutput)out, (String)names[i], scratch);
                SimpleTextUtil.writeNewline((DataOutput)out);
                startOffsets[i] = out.getFilePointer();
                try (IndexInput in = dir.openInput((String)names[i], IOContext.READONCE);){
                    out.copyBytes((DataInput)in, in.length());
                }
                endOffsets[i] = out.getFilePointer();
            }
            long tocPos = out.getFilePointer();
            SimpleTextUtil.write((DataOutput)out, TABLE);
            SimpleTextUtil.write((DataOutput)out, Integer.toString(numFiles), scratch);
            SimpleTextUtil.writeNewline((DataOutput)out);
            for (int i = 0; i < names.length; ++i) {
                SimpleTextUtil.write((DataOutput)out, TABLENAME);
                SimpleTextUtil.write((DataOutput)out, (String)names[i], scratch);
                SimpleTextUtil.writeNewline((DataOutput)out);
                SimpleTextUtil.write((DataOutput)out, TABLESTART);
                SimpleTextUtil.write((DataOutput)out, Long.toString(startOffsets[i]), scratch);
                SimpleTextUtil.writeNewline((DataOutput)out);
                SimpleTextUtil.write((DataOutput)out, TABLEEND);
                SimpleTextUtil.write((DataOutput)out, Long.toString(endOffsets[i]), scratch);
                SimpleTextUtil.writeNewline((DataOutput)out);
            }
            DecimalFormat df = new DecimalFormat(OFFSETPATTERN, DecimalFormatSymbols.getInstance(Locale.ROOT));
            SimpleTextUtil.write((DataOutput)out, TABLEPOS);
            SimpleTextUtil.write((DataOutput)out, df.format(tocPos), scratch);
            SimpleTextUtil.writeNewline((DataOutput)out);
        }
    }

    private String stripPrefix(BytesRefBuilder scratch, BytesRef prefix) {
        return new String(scratch.bytes(), prefix.length, scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    static {
        int numDigits = Long.toString(Long.MAX_VALUE).length();
        char[] pattern = new char[numDigits];
        Arrays.fill(pattern, '0');
        OFFSETPATTERN = new String(pattern);
    }
}

