/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp.PoolingConnection;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedObjectPoolFactory;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory<PoolableConnection> {
    protected volatile ConnectionFactory _connFactory = null;
    protected volatile String _validationQuery = null;
    protected volatile int _validationQueryTimeout = -1;
    protected Collection<String> _connectionInitSqls = null;
    protected volatile ObjectPool<PoolableConnection> _pool = null;
    protected volatile KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> _stmtPoolFactory = null;
    protected Boolean _defaultReadOnly = null;
    protected boolean _defaultAutoCommit = true;
    protected int _defaultTransactionIsolation = -1;
    protected String _defaultCatalog;
    protected AbandonedConfig _config = null;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, Collection<String> connectionInitSqls, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, Collection<String> connectionInitSqls, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, Collection<String> connectionInitSqls, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, Collection<String> connectionInitSqls, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, Collection<String> connectionInitSqls, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool<PoolableConnection> pool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory, String validationQuery, int validationQueryTimeout, Collection<String> connectionInitSqls, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory(this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._connectionInitSqls = connectionInitSqls;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(int timeout) {
        this._validationQueryTimeout = timeout;
    }

    public synchronized void setConnectionInitSql(Collection<String> connectionInitSqls) {
        this._connectionInitSqls = connectionInitSqls;
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this._pool;
    }

    public void setStatementPoolFactory(KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this._defaultCatalog = defaultCatalog;
    }

    @Override
    public PoolableConnection makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(conn);
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((PoolingConnection)conn);
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConnection(Connection conn) throws SQLException {
        Collection<String> sqls = this._connectionInitSqls;
        if (conn.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != sqls) {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                for (String sql : sqls) {
                    if (sql == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    stmt.execute(sql);
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception t) {}
                }
            }
        }
    }

    @Override
    public void destroyObject(PoolableConnection obj) throws Exception {
        obj.reallyClose();
    }

    @Override
    public boolean validateObject(PoolableConnection obj) {
        try {
            this.validateConnection(obj);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection conn) throws SQLException {
        String query = this._validationQuery;
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (null != query) {
            Statement stmt = null;
            ResultSet rset = null;
            try {
                stmt = conn.createStatement();
                if (this._validationQueryTimeout > 0) {
                    stmt.setQueryTimeout(this._validationQueryTimeout);
                }
                if (!(rset = stmt.executeQuery(query)).next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
            finally {
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (Exception t) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception t) {}
                }
            }
        }
    }

    @Override
    public void passivateObject(PoolableConnection conn) throws Exception {
        if (!conn.getAutoCommit() && !conn.isReadOnly()) {
            conn.rollback();
        }
        conn.clearWarnings();
        if (!conn.getAutoCommit()) {
            conn.setAutoCommit(true);
        }
        conn.passivate();
    }

    @Override
    public void activateObject(PoolableConnection conn) throws Exception {
        conn.activate();
        if (conn.getAutoCommit() != this._defaultAutoCommit) {
            conn.setAutoCommit(this._defaultAutoCommit);
        }
        if (this._defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this._defaultTransactionIsolation) {
            conn.setTransactionIsolation(this._defaultTransactionIsolation);
        }
        if (this._defaultReadOnly != null && conn.isReadOnly() != this._defaultReadOnly.booleanValue()) {
            conn.setReadOnly(this._defaultReadOnly);
        }
        if (this._defaultCatalog != null && !this._defaultCatalog.equals(conn.getCatalog())) {
            conn.setCatalog(this._defaultCatalog);
        }
    }
}

