/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.util.List;

public interface LoadBalancedList<E> {
    public List<Node<E>> getValues();

    public void clear();

    public boolean contains(E var1);

    public E getNext();

    public int getSize();

    public void remove(E var1);

    public void set(E var1, int var2);

    public static class Node<E> {
        private final E value;
        private int weight;
        private int count;

        public Node(E value) {
            this(value, 0);
        }

        public Node(E value, int weight) {
            this.value = value;
            this.weight = weight;
            this.count = 0;
        }

        public E getValue() {
            return this.value;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int value) {
            this.weight = value;
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void setCount(int value) {
            this.count = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Node)) {
                return false;
            }
            Node otherNode = (Node)other;
            return this.value.equals(otherNode.value);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return new StringBuilder(50).append(this.value).append(" {weight=").append(this.weight).append(" count=").append(this.count).append("}").toString();
        }
    }
}

