/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.ss.util.WorkbookUtil;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.Maintenance;
import org.traccar.reports.ReportUtils;
import org.traccar.reports.model.DeviceReport;

public final class Events {
    private Events() {
    }

    public static Collection<Event> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Collection<String> types, Date from, Date to) throws SQLException {
        ReportUtils.checkPeriodLimit(from, to);
        ArrayList<Event> result = new ArrayList<Event>();
        for (long deviceId : ReportUtils.getDeviceList(deviceIds, groupIds)) {
            Context.getPermissionsManager().checkDevice(userId, deviceId);
            Collection<Event> events = Context.getDataManager().getEvents(deviceId, from, to);
            boolean all = types.isEmpty() || types.contains("allEvents");
            for (Event event : events) {
                if (!all && !types.contains(event.getType())) continue;
                long geofenceId = event.getGeofenceId();
                long maintenanceId = event.getMaintenanceId();
                if (geofenceId != 0L && !Context.getGeofenceManager().checkItemPermission(userId, geofenceId) || maintenanceId != 0L && !Context.getMaintenancesManager().checkItemPermission(userId, maintenanceId)) continue;
                result.add(event);
            }
        }
        return result;
    }

    public static void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Collection<String> types, Date from, Date to) throws SQLException, IOException {
        ReportUtils.checkPeriodLimit(from, to);
        ArrayList<DeviceReport> devicesEvents = new ArrayList<DeviceReport>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        HashMap<Long, String> geofenceNames = new HashMap<Long, String>();
        HashMap<Long, String> maintenanceNames = new HashMap<Long, String>();
        for (long deviceId : ReportUtils.getDeviceList(deviceIds, groupIds)) {
            Group group;
            Context.getPermissionsManager().checkDevice(userId, deviceId);
            Collection<Event> events = Context.getDataManager().getEvents(deviceId, from, to);
            boolean all = types.isEmpty() || types.contains("allEvents");
            Iterator<Event> iterator = events.iterator();
            while (iterator.hasNext()) {
                Event event = iterator.next();
                if (all || types.contains(event.getType())) {
                    long geofenceId = event.getGeofenceId();
                    long maintenanceId = event.getMaintenanceId();
                    if (geofenceId != 0L) {
                        if (Context.getGeofenceManager().checkItemPermission(userId, geofenceId)) {
                            Geofence geofence = (Geofence)Context.getGeofenceManager().getById(geofenceId);
                            if (geofence == null) continue;
                            geofenceNames.put(geofenceId, geofence.getName());
                            continue;
                        }
                        iterator.remove();
                        continue;
                    }
                    if (maintenanceId == 0L) continue;
                    if (Context.getMaintenancesManager().checkItemPermission(userId, maintenanceId)) {
                        Maintenance maintenance = (Maintenance)Context.getMaintenancesManager().getById(maintenanceId);
                        if (maintenance == null) continue;
                        maintenanceNames.put(maintenanceId, maintenance.getName());
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
            DeviceReport deviceEvents = new DeviceReport();
            Device device = Context.getIdentityManager().getById(deviceId);
            deviceEvents.setDeviceName(device.getName());
            sheetNames.add(WorkbookUtil.createSafeSheetName((String)deviceEvents.getDeviceName()));
            if (device.getGroupId() != 0L && (group = (Group)Context.getGroupsManager().getById(device.getGroupId())) != null) {
                deviceEvents.setGroupName(group.getName());
            }
            deviceEvents.setObjects(events);
            devicesEvents.add(deviceEvents);
        }
        String templatePath = Context.getConfig().getString("report.templatesPath", "templates/export/");
        try (FileInputStream inputStream = new FileInputStream(templatePath + "/events.xlsx");){
            org.jxls.common.Context jxlsContext = ReportUtils.initializeContext(userId);
            jxlsContext.putVar("devices", devicesEvents);
            jxlsContext.putVar("sheetNames", sheetNames);
            jxlsContext.putVar("geofenceNames", geofenceNames);
            jxlsContext.putVar("maintenanceNames", maintenanceNames);
            jxlsContext.putVar("from", (Object)from);
            jxlsContext.putVar("to", (Object)to);
            ReportUtils.processTemplateWithSheets(inputStream, outputStream, jxlsContext);
        }
    }
}

