/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.io;

import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import nu.validator.htmlparser.common.ByteReadable;
import nu.validator.htmlparser.impl.MetaScanner;
import nu.validator.htmlparser.io.Encoding;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetaSniffer
extends MetaScanner
implements Locator {
    private Encoding characterEncoding = null;
    private final ErrorHandler errorHandler;
    private final Locator locator;
    private int line = 1;
    private int col = 0;
    private boolean prevWasCR = false;

    public MetaSniffer(ErrorHandler eh, Locator locator) {
        this.errorHandler = eh;
        this.locator = locator;
        this.characterEncoding = null;
    }

    @Override
    protected int read() throws IOException {
        int b = this.readable.readByte();
        switch (b) {
            case 10: {
                if (!this.prevWasCR) {
                    ++this.line;
                    this.col = 0;
                }
                this.prevWasCR = false;
                break;
            }
            case 13: {
                ++this.line;
                this.col = 0;
                this.prevWasCR = true;
                break;
            }
            default: {
                ++this.col;
                this.prevWasCR = false;
            }
        }
        return b;
    }

    public Encoding sniff(ByteReadable readable) throws SAXException, IOException {
        this.readable = readable;
        this.stateLoop(this.stateSave);
        return this.characterEncoding;
    }

    private void err(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this);
            this.errorHandler.error(spe);
        }
    }

    private void warn(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this);
            this.errorHandler.warning(spe);
        }
    }

    @Override
    public int getColumnNumber() {
        return this.col;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public String getPublicId() {
        if (this.locator != null) {
            return this.locator.getPublicId();
        }
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.locator != null) {
            return this.locator.getSystemId();
        }
        return null;
    }

    @Override
    protected boolean tryCharset(String encoding) throws SAXException {
        encoding = Encoding.toAsciiLowerCase(encoding);
        try {
            if ("utf-16".equals(encoding) || "utf-16be".equals(encoding) || "utf-16le".equals(encoding) || "utf-32".equals(encoding) || "utf-32be".equals(encoding) || "utf-32le".equals(encoding)) {
                this.characterEncoding = Encoding.UTF8;
                this.err("The internal character encoding declaration specified \u201c" + encoding + "\u201d which is not a rough superset of ASCII. Using \u201cUTF-8\u201d instead.");
                return true;
            }
            Encoding cs = Encoding.forName(encoding);
            String canonName = cs.getCanonName();
            if (!cs.isAsciiSuperset()) {
                this.err("The encoding \u201c" + encoding + "\u201d is not an ASCII superset and, therefore, cannot be used in an internal encoding declaration. Continuing the sniffing algorithm.");
                return false;
            }
            if (!cs.isRegistered()) {
                if (encoding.startsWith("x-")) {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding. (Charmod C022)");
                } else {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding and did not use the \u201cx-\u201d prefix. (Charmod C023)");
                }
            } else if (!cs.getCanonName().equals(encoding)) {
                this.err("The encoding \u201c" + encoding + "\u201d is not the preferred name of the character encoding in use. The preferred name is \u201c" + canonName + "\u201d. (Charmod C024)");
            }
            if (cs.isShouldNot()) {
                this.warn("Authors should not use the character encoding \u201c" + encoding + "\u201d. It is recommended to use \u201cUTF-8\u201d.");
            } else if (cs.isObscure()) {
                this.warn("The character encoding \u201c" + encoding + "\u201d is not widely supported. Better interoperability may be achieved by using \u201cUTF-8\u201d.");
            }
            Encoding actual = cs.getActualHtmlEncoding();
            if (actual == null) {
                this.characterEncoding = cs;
            } else {
                this.warn("Using \u201c" + actual.getCanonName() + "\u201d instead of the declared encoding \u201c" + encoding + "\u201d.");
                this.characterEncoding = actual;
            }
            return true;
        }
        catch (UnsupportedCharsetException e) {
            this.err("Unsupported character encoding name: \u201c" + encoding + "\u201d. Will continue sniffing.");
            return false;
        }
    }
}

