/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2;

import java.util.List;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.SpringXmlPreprocessor;
import org.apache.xbean.spring.context.v2.XBeanBeanDefinitionDocumentReader;
import org.apache.xbean.spring.context.v2.XBeanNamespaceHandlerResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public class XBeanXmlBeanDefinitionReader
extends XmlBeanDefinitionReader {
    private final SpringApplicationContext applicationContext;
    private final List xmlPreprocessors;

    public XBeanXmlBeanDefinitionReader(SpringApplicationContext applicationContext, BeanDefinitionRegistry beanFactory, List xmlPreprocessors) {
        super(beanFactory);
        this.applicationContext = applicationContext;
        this.xmlPreprocessors = xmlPreprocessors;
        this.setNamespaceAware(true);
        this.setValidationMode(0);
        if (applicationContext != null) {
            this.setResourceLoader(applicationContext);
            this.setEntityResolver(new ResourceEntityResolver(applicationContext));
        }
        this.setDocumentReaderClass(XBeanBeanDefinitionDocumentReader.class);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        this.preprocess(doc);
        return super.registerBeanDefinitions(doc, resource);
    }

    protected NamespaceHandlerResolver createDefaultNamespaceHandlerResolver() {
        ClassLoader classLoader = this.getBeanClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return new XBeanNamespaceHandlerResolver(classLoader);
    }

    private void preprocess(Document doc) {
        for (SpringXmlPreprocessor preprocessor : this.xmlPreprocessors) {
            preprocessor.preprocess(this.applicationContext, this, doc);
        }
    }
}

