/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.ddl.LiquibaseSettings;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LiquibaseDDLGenerator
extends GenericDDLGenerator
implements DDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 3271 $";
    private static final Logger logger = Logger.getLogger(LiquibaseDDLGenerator.class);
    private boolean separateChangeSets;
    private String author;
    private boolean generateId;
    private int currentId = 1;
    private boolean useAddPKSingleColumn = false;

    public LiquibaseDDLGenerator() throws SQLException {
        super(false);
    }

    @Override
    public String getName() {
        return "Liquibase";
    }

    @Override
    public void writeHeader() {
        this.println("<!-- Created by SQLPower Generic DDL Generator $Revision: 3271 $ -->");
    }

    @Override
    public String getStatementTerminator() {
        return "";
    }

    public void applySettings(LiquibaseSettings options) {
        this.setUseSeparateChangeSets(options.getUseSeparateChangeSets());
        this.setAuthor(options.getAuthor());
        this.setGenerateId(options.getGenerateId());
        this.setIdStart(options.getIdStart());
        this.setUseAddPKTagForSingleColumns(options.getUseAddPKTagForSingleColumns());
    }

    public void setUseAddPKTagForSingleColumns(boolean flag) {
        this.useAddPKSingleColumn = flag;
    }

    public void setUseSeparateChangeSets(boolean flag) {
        this.separateChangeSets = flag;
    }

    public void setAuthor(String name) {
        this.author = name;
    }

    public void setIdStart(int startValue) {
        this.currentId = startValue;
    }

    public void setGenerateId(boolean flag) {
        this.generateId = flag;
    }

    protected void startOfStatement() {
        if (this.separateChangeSets) {
            this.writeOpenChangeSet();
        }
    }

    protected void writeOpenChangeSet() {
        String tag = this.getChangeSetStartTag();
        this.println(tag);
    }

    protected String getChangeSetStartTag() {
        StringBuilder tag = new StringBuilder(100);
        tag.append("<changeSet");
        if (StringUtils.isBlank((String)this.author)) {
            tag.append(" author=\"CHANGEME\"");
        } else {
            tag.append(" author=");
            tag.append(this.escapeAttributeValue(this.author));
        }
        if (this.generateId) {
            tag.append(" id=\"");
            tag.append(Integer.toString(this.currentId));
            tag.append("\"");
            ++this.currentId;
        } else {
            tag.append(" id=\"CHANGEME\"");
        }
        tag.append(">");
        return tag.toString();
    }

    protected void endOfStatement() {
        if (this.separateChangeSets) {
            this.println("</changeSet>");
        }
    }

    @Override
    public void writeDDLTransactionBegin() {
    }

    @Override
    public void writeDDLTransactionEnd() {
    }

    @Override
    public void writeCreateDB(SQLDatabase db) {
    }

    @Override
    public List<DDLStatement> getDdlStatements() {
        List<DDLStatement> result = super.getDdlStatements();
        if (!this.separateChangeSets) {
            DDLStatement startTag = new DDLStatement(null, DDLStatement.StatementType.XMLTAG, this.getChangeSetStartTag() + EOL, "", null, null);
            result.add(0, startTag);
            DDLStatement endTag = new DDLStatement(null, DDLStatement.StatementType.XMLTAG, "</changeSet>", "", null, null);
            result.add(endTag);
        }
        return result;
    }

    @Override
    public void dropRelationship(SQLRelationship r) {
        this.startOfStatement();
        this.print("<dropForeignKeyConstraint ");
        this.print(this.getTableQualifier((SQLObject)r.getFkTable(), "baseTableName", "baseSchemaName"));
        this.print(" constraintName=\"");
        this.print(this.getName((SQLObject)r));
        this.println("\"/>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)r);
    }

    private String getName(SQLObject o) {
        if (StringUtils.isEmpty((String)o.getPhysicalName())) {
            return o.getName();
        }
        return o.getPhysicalName();
    }

    @Override
    public void renameRelationship(SQLRelationship oldFK, SQLRelationship newFK) {
        this.startOfStatement();
        this.println("<comment>Renaming foreign key " + this.getName((SQLObject)oldFK) + " to " + this.getName((SQLObject)newFK) + "</comment>");
        this.dropRelationship(oldFK);
        this.addRelationship(newFK);
        this.endOfStatement();
    }

    @Override
    public void addRelationship(SQLRelationship r) {
        SQLColumn c;
        StringBuilder sql = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        StringBuilder typesMismatchMsg = new StringBuilder();
        sql.append("<addForeignKeyConstraint ");
        sql.append(this.getTableQualifier((SQLObject)r.getFkTable(), "baseTableName", "baseSchemaName"));
        sql.append(" constraintName=\"");
        sql.append(this.getName((SQLObject)r));
        sql.append("\" baseColumnNames=\"");
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        boolean firstColumn = true;
        for (SQLRelationship.ColumnMapping cm : r.getChildren(SQLRelationship.ColumnMapping.class)) {
            c = cm.getFkColumn();
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                sql.append(this.createPhysicalName(colNameMap, (SQLObject)c));
            } else {
                sql.append(", " + this.createPhysicalName(colNameMap, (SQLObject)c));
            }
            colNameMap.put(c.getName(), (SQLObject)c);
        }
        sql.append("\"");
        sql.append(" referencedTableName=\"");
        sql.append(this.toQualifiedName(r.getPkTable()));
        sql.append("\" referencedColumnNames=\"");
        colNameMap.clear();
        firstColumn = true;
        if (r.getChildren().isEmpty()) {
            errorMsg.append("Warning: Relationship has no columns to map:\n");
        }
        for (SQLRelationship.ColumnMapping cm : r.getChildren(SQLRelationship.ColumnMapping.class)) {
            c = cm.getPkColumn();
            SQLColumn fkCol = cm.getFkColumn();
            if (ArchitectUtils.columnTypesDiffer(c.getType(), fkCol.getType())) {
                typesMismatchMsg.append("        " + c + " -- " + fkCol + "\n");
            }
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                sql.append(this.createPhysicalName(colNameMap, (SQLObject)c));
            } else {
                sql.append(", " + this.createPhysicalName(colNameMap, (SQLObject)c));
            }
            colNameMap.put(c.getName(), (SQLObject)c);
        }
        sql.append("\"");
        if (typesMismatchMsg.length() != 0) {
            errorMsg.append("Warning: Column types mismatch in the following column mapping(s):\n");
            errorMsg.append(typesMismatchMsg.toString());
        }
        if (!"NO ACTION".equals(this.getDeleteActionClause(r))) {
            sql.append(" onDelete=\"");
            sql.append(this.getDeleteActionClause(r));
            sql.append("\"");
        }
        if (!"NO ACTION".equals(this.getUpdateActionClause(r))) {
            sql.append(" onUpdate=\"");
            sql.append(this.getUpdateActionClause(r));
            sql.append("\"");
        }
        if (this.isDeferrable(r)) {
            sql.append(" deferrable=\"");
            sql.append(this.isDeferrable(r));
            sql.append("\"");
            sql.append(" initiallyDeferred=\"");
            sql.append(this.isInitiallyDeferred(r));
            sql.append("\"");
        }
        sql.append("/>");
        this.startOfStatement();
        this.println(sql.toString());
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)r);
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        return true;
    }

    @Override
    public String getDeleteActionClause(SQLRelationship r) {
        return this.getUpdateDeleteRule(r.getDeleteRule());
    }

    private String getUpdateDeleteRule(SQLRelationship.UpdateDeleteRule rule) {
        String action;
        if (rule == SQLRelationship.UpdateDeleteRule.CASCADE) {
            action = "CASCADE";
        } else if (rule == SQLRelationship.UpdateDeleteRule.NO_ACTION) {
            action = "NO ACTION";
        } else if (rule == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            action = "RESTRICT";
        } else if (rule == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            action = "SET DEFAULT";
        } else if (rule == SQLRelationship.UpdateDeleteRule.SET_NULL) {
            action = "SET NULL";
        } else {
            throw new IllegalArgumentException("Unknown enum value: " + rule);
        }
        return action;
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        return true;
    }

    @Override
    public String getUpdateActionClause(SQLRelationship r) {
        return this.getUpdateDeleteRule(r.getUpdateRule());
    }

    public boolean isDeferrable(SQLRelationship r) {
        return r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_DEFERRED || r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_IMMEDIATE;
    }

    public boolean isInitiallyDeferred(SQLRelationship r) {
        return r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_DEFERRED;
    }

    @Override
    public void addComment(SQLObject o) {
        if (o instanceof SQLColumn) {
            this.modifyColumnComment((SQLColumn)o);
        }
    }

    @Override
    public void modifyComment(SQLObject o) {
        if (o instanceof SQLColumn) {
            this.modifyColumnComment((SQLColumn)o);
        }
    }

    @Override
    public void addComment(SQLColumn c) {
        this.modifyColumnComment(c);
    }

    private void modifyColumnComment(SQLColumn c) {
        SQLTable t = c.getParent();
        this.startOfStatement();
        this.print("<modifyColumn ");
        this.print(this.getTableQualifier((SQLObject)t));
        this.println(">");
        this.print("  <column name=\"");
        this.print(this.getName((SQLObject)c));
        this.print("\" remarks=");
        this.print(this.escapeAttributeValue(c.getRemarks()));
        this.println("/>");
        this.println("</modifyColumn>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)c);
    }

    @Override
    public void addComment(SQLTable t, boolean includeColumns) {
        this.println("<!-- The following comment should be added to the table " + StringEscapeUtils.escapeXml((String)this.getName((SQLObject)t)) + "-->");
        this.println("<!-- " + StringEscapeUtils.escapeXml((String)t.getRemarks()) + "-->");
        if (includeColumns) {
            this.addColumnComments(t);
        }
    }

    @Override
    public void addColumn(SQLColumn c) {
        this.startOfStatement();
        this.print("<addColumn ");
        this.print(this.getTableQualifier((SQLObject)c.getParent()));
        this.println(">");
        this.println(this.columnDefinition("  ", c, false));
        this.println("</addColumn>");
        if (c.isAutoIncrementSequenceNameSet() && c.isAutoIncrement()) {
            this.print("<createSequence sequenceName=\"");
            this.print(c.getAutoIncrementSequenceName());
            this.println("\"/>");
        }
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)c);
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        this.startOfStatement();
        this.print("<renameColumn ");
        this.print(this.getTableQualifier((SQLObject)oldCol.getParent()));
        this.print(" oldColumnName=\"");
        this.print(this.getName((SQLObject)oldCol));
        this.print("\" newColumnName=\"");
        this.print(this.getName((SQLObject)newCol));
        this.println("\"/>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)newCol);
    }

    @Override
    public void dropColumn(SQLColumn c) {
        this.startOfStatement();
        this.print("<dropColumn ");
        this.print(this.getTableQualifier((SQLObject)c.getParent()));
        this.print(" columnName=\"");
        this.print(this.getName((SQLObject)c));
        this.println("\"/>");
        if (c.isAutoIncrement() && c.isAutoIncrementSequenceNameSet()) {
            this.print("<dropSequence sequenceName=\"");
            this.print(c.getAutoIncrementSequenceName());
            this.println("\"/>");
        }
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)c);
    }

    public void modifyColumn(SQLColumn c) {
        this.startOfStatement();
        SQLTable t = c.getParent();
        this.print("<modifyColumn ");
        this.print(this.getTableQualifier((SQLObject)t));
        this.println(">");
        this.println(this.columnDefinition("  ", c, false));
        this.println("</modifyColumn>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)c);
    }

    @Override
    public void dropTable(SQLTable t) {
        this.startOfStatement();
        this.print("<dropTable ");
        this.print(this.getTableQualifier((SQLObject)t));
        this.println("/>");
        this.endOfStatement();
        try {
            for (SQLColumn col : t.getColumns()) {
                if (!col.isAutoIncrement() || !col.isAutoIncrementSequenceNameSet()) continue;
                this.startOfStatement();
                this.print("<dropSequence sequenceName=\"");
                this.print(col.getAutoIncrementSequenceName());
                this.println("\"/>");
                this.endOfStatement();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when creating dropSequence", (Throwable)e);
        }
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)t);
    }

    protected String columnDefinition(String indent, SQLColumn c, boolean tableHasSingleColumnPK) {
        boolean needsConstraint;
        StringBuilder def = new StringBuilder(50);
        def.append(indent);
        def.append("<column name=\"");
        def.append(this.getName((SQLObject)c));
        GenericTypeDescriptor type = this.getTypeDescriptor(c);
        def.append("\" type=\"");
        def.append(this.columnType(c));
        def.append("\"");
        if (StringUtils.isNotBlank((String)c.getRemarks())) {
            def.append(" remarks=");
            def.append(this.escapeAttributeValue(c.getRemarks()));
        }
        if (StringUtils.isNotBlank((String)c.getDefaultValue())) {
            if (this.isNumericType(type)) {
                def.append(" defaultValueNumeric=\"");
                def.append(c.getDefaultValue());
                def.append("\"");
            } else if (this.isDateType(type)) {
                def.append(" defaultValueDate=\"");
                def.append(c.getDefaultValue());
                def.append("\"");
            } else if (type.getDataType() == 16) {
                def.append(" defaultValueBoolean=\"");
                def.append(c.getDefaultValue());
                def.append("\"");
            } else {
                def.append(" defaultValue=\"");
                def.append(c.getDefaultValue());
                def.append("\"");
            }
        }
        if (c.isAutoIncrement()) {
            def.append(" autoIncrement=\"true\"");
        }
        boolean bl = needsConstraint = !c.isDefinitelyNullable() || tableHasSingleColumnPK && c.isPrimaryKey() && !this.useAddPKSingleColumn;
        if (needsConstraint) {
            def.append(">");
            def.append(EOL);
            def.append(indent);
            def.append(indent);
            def.append("<constraints");
            if (tableHasSingleColumnPK && c.isPrimaryKey() && !this.useAddPKSingleColumn) {
                def.append(" primaryKey=\"true\"");
                SQLTable tbl = c.getParent();
                try {
                    SQLIndex pk = tbl.getPrimaryKeyIndex();
                    def.append(" constraintName=\"");
                    def.append(this.getName((SQLObject)pk));
                    def.append("\"");
                }
                catch (Exception e) {
                    logger.error((Object)"Could not obtain PK index", (Throwable)e);
                }
            }
            if (!c.isDefinitelyNullable()) {
                def.append(" nullable=\"false\"");
            }
            def.append("/>");
            def.append(EOL);
            def.append(indent);
            def.append("</column>");
        } else {
            def.append("/>");
        }
        return def.toString();
    }

    private boolean isDateType(GenericTypeDescriptor td) {
        int type = td.getDataType();
        return type == 91 || type == 93;
    }

    private boolean isNumericType(GenericTypeDescriptor td) {
        int type = td.getDataType();
        return type == -5 || type == 4 || type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == 5 || type == -6;
    }

    @Override
    public String columnType(SQLColumn c) {
        return this.getColumnDataTypeName(c);
    }

    @Override
    public String getColumnDataTypeName(SQLColumn c) {
        StringBuilder def = new StringBuilder();
        GenericTypeDescriptor td = this.getTypeDescriptor(c);
        def.append(td.getName());
        if (td.getHasPrecision()) {
            def.append("(" + c.getPrecision());
            if (td.getHasScale()) {
                def.append("," + c.getScale());
            }
            def.append(")");
        }
        return def.toString();
    }

    protected GenericTypeDescriptor getTypeDescriptor(SQLColumn c) {
        return super.failsafeGetTypeDescriptor(c);
    }

    private String escapeAttributeValue(String value) {
        return "\"" + StringEscapeUtils.escapeXml((String)value) + "\"";
    }

    @Override
    public void renameTable(SQLTable oldTable, SQLTable newTable) {
        this.startOfStatement();
        this.print("<renameTable ");
        this.print(this.getTableQualifier((SQLObject)oldTable, "oldTableName", "schemaName"));
        this.print(" newTableName=\"");
        this.print(newTable.getPhysicalName());
        this.println("\"/>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)newTable);
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        HashSet<SQLColumn> sequenceColumns = new HashSet<SQLColumn>(t.getChildCount());
        this.startOfStatement();
        SQLIndex pk = t.getPrimaryKeyIndex();
        boolean singleColumnPK = pk.getChildren(SQLIndex.Column.class).size() == 1;
        this.print("<createTable ");
        this.print(this.getTableQualifier((SQLObject)t));
        if (StringUtils.isNotBlank((String)t.getRemarks())) {
            this.print(" remarks=");
            this.print(this.escapeAttributeValue(t.getRemarks()));
        }
        this.println(">");
        for (SQLColumn c : t.getColumns()) {
            this.println(this.columnDefinition("  ", c, singleColumnPK));
            if (!c.isAutoIncrementSequenceNameSet() || !c.isAutoIncrement()) continue;
            sequenceColumns.add(c);
        }
        this.println("</createTable>");
        this.endOfStatement();
        if (pk.getChildCount() > 0 && singleColumnPK && this.useAddPKSingleColumn) {
            this.writePKConstraintClause(pk);
        }
        for (SQLColumn col : sequenceColumns) {
            this.startOfStatement();
            this.print("<createSequence sequenceName=\"");
            this.print(col.getAutoIncrementSequenceName());
            this.println("\"/>");
            this.endOfStatement();
        }
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)t);
    }

    @Override
    protected void writePKConstraintClause(SQLIndex pk) throws SQLObjectException {
        if (!pk.isPrimaryKeyIndex()) {
            throw new IllegalArgumentException("The given index is not a primary key");
        }
        this.startOfStatement();
        this.print("<addPrimaryKey ");
        this.print(this.getTableQualifier((SQLObject)pk.getParent()));
        this.print(" constraintName=\"");
        this.print(this.getName((SQLObject)pk));
        this.print("\" columnNames=\"");
        boolean firstCol = true;
        for (SQLIndex.Column col : pk.getChildren(SQLIndex.Column.class)) {
            if (!firstCol) {
                this.print(", ");
            }
            if (col.getColumn() == null) {
                throw new IllegalStateException("Index column is not associated with the real column in the table.");
            }
            this.print(this.getName((SQLObject)col));
            firstCol = false;
        }
        this.println("\"/>");
        this.endOfStatement();
    }

    @Override
    protected void writePrimaryKey(SQLTable t) throws SQLObjectException {
        this.writePKConstraintClause(t.getPrimaryKeyIndex());
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)t);
    }

    @Override
    public boolean getAllowConnection() {
        return false;
    }

    @Override
    public void setAllowConnection(boolean argAllowConnection) {
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    @Override
    public String makeDropTableSQL(String table) {
        return "<dropTable " + this.getTableQualifier(table) + "/>";
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "<dropForeignKeyConstraint " + this.getTableQualifier(fkTable, "baseTableName", "baseTableSchemaName") + " constraintName=\"" + fkName + "\"/>";
    }

    @Override
    public void dropPrimaryKey(SQLTable t) throws SQLObjectException {
        SQLIndex pk = t.getPrimaryKeyIndex();
        this.startOfStatement();
        this.println("<dropPrimaryKey " + this.getTableQualifier((SQLObject)t) + " constraintName=\"" + this.getName((SQLObject)pk) + "\"/>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)t);
    }

    @Override
    public void addPrimaryKey(SQLTable t) throws SQLObjectException {
        StringBuilder sql = new StringBuilder(100);
        boolean first = true;
        sql.append("<addPrimaryKey " + this.getTableQualifier((SQLObject)t));
        sql.append(" constraintName=\"" + t.getPrimaryKeyIndex() + "\"");
        sql.append(" columnNames=\"");
        for (SQLColumn c : t.getColumns()) {
            if (!c.isPrimaryKey()) continue;
            if (!first) {
                sql.append(",");
            } else {
                first = false;
            }
            sql.append(this.getName((SQLObject)c));
        }
        sql.append("\"/>");
        this.startOfStatement();
        this.println(sql.toString());
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)t);
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.dropIndex(oldIndex);
        this.addIndex(newIndex);
    }

    @Override
    public void dropIndex(SQLIndex index) throws SQLObjectException {
        this.startOfStatement();
        this.print("<dropIndex indexName=\"");
        this.print(this.getName((SQLObject)index));
        this.print("\" tableName=\"");
        this.print(this.getName((SQLObject)index.getParent()));
        this.println("\"/>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)index);
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        this.startOfStatement();
        this.print("<createIndex ");
        this.print(this.getTableQualifier((SQLObject)index.getParent()));
        this.print(" indexName=\"");
        this.print(this.getName((SQLObject)index));
        this.print("\"");
        if (index.isUnique()) {
            this.print(" unique=\"true\"");
        }
        this.println(">");
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            this.println("  <column name=\"" + this.getName((SQLObject)c) + "\"/>");
        }
        this.println("</createIndex>");
        this.endOfStatement();
        this.endStatement(DDLStatement.StatementType.XMLTAG, (SQLObject)index);
    }

    private String getTableQualifier(SQLObject o) {
        return this.getTableQualifier(o, "tableName", "schemaName");
    }

    private String getTableQualifier(String tablename) {
        return this.getTableQualifier(tablename, "tableName", "schemaName");
    }

    private String getTableQualifier(SQLObject o, String tableNameAttr, String schemaNameAttr) {
        return this.getTableQualifier(this.getName(o), tableNameAttr, schemaNameAttr);
    }

    private String getTableQualifier(String tableName, String tableNameAttr, String schemaNameAttr) {
        StringBuilder result = new StringBuilder(50);
        result.append(tableNameAttr);
        result.append("=\"");
        result.append(tableName);
        result.append("\"");
        String schema = this.getTargetSchema();
        if (StringUtils.isNotBlank((String)schema)) {
            result.append(" ");
            result.append(schemaNameAttr);
            result.append("=\"");
            result.append(schema);
            result.append("\"");
        }
        return result.toString();
    }

    @Override
    public boolean supportsCheckConstraint() {
        return false;
    }
}

