/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.ResponseCollectorService;

public class OperationRouting {
    public static final Setting<Boolean> USE_ADAPTIVE_REPLICA_SELECTION_SETTING = Setting.boolSetting("cluster.routing.use_adaptive_replica_selection", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(OperationRouting.class));
    private static final String IGNORE_AWARENESS_ATTRIBUTES_PROPERTY = "es.search.ignore_awareness_attributes";
    static final String IGNORE_AWARENESS_ATTRIBUTES_DEPRECATION_MESSAGE = "searches will not be routed based on awareness attributes starting in version 8.0.0; to opt into this behaviour now please set the system property [es.search.ignore_awareness_attributes] to [true]";
    private List<String> awarenessAttributes;
    private boolean useAdaptiveReplicaSelection;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    public OperationRouting(Settings settings, ClusterSettings clusterSettings) {
        boolean ignoreAwarenessAttr = Booleans.parseBoolean((String)System.getProperty(IGNORE_AWARENESS_ATTRIBUTES_PROPERTY), (boolean)false);
        if (!ignoreAwarenessAttr) {
            this.awarenessAttributes = AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
            if (!this.awarenessAttributes.isEmpty()) {
                deprecationLogger.deprecated(IGNORE_AWARENESS_ATTRIBUTES_DEPRECATION_MESSAGE, new Object[0]);
            }
            clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        } else {
            this.awarenessAttributes = Collections.emptyList();
        }
        this.useAdaptiveReplicaSelection = USE_ADAPTIVE_REPLICA_SELECTION_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, this::setUseAdaptiveReplicaSelection);
    }

    void setUseAdaptiveReplicaSelection(boolean useAdaptiveReplicaSelection) {
        this.useAdaptiveReplicaSelection = useAdaptiveReplicaSelection;
    }

    List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        boolean ignoreAwarenessAttr = Booleans.parseBoolean((String)System.getProperty(IGNORE_AWARENESS_ATTRIBUTES_PROPERTY), (boolean)false);
        if (!ignoreAwarenessAttr) {
            if (this.awarenessAttributes.isEmpty() && !awarenessAttributes.isEmpty()) {
                deprecationLogger.deprecated(IGNORE_AWARENESS_ATTRIBUTES_DEPRECATION_MESSAGE, new Object[0]);
            }
            this.awarenessAttributes = awarenessAttributes;
        }
    }

    public ShardIterator indexShards(ClusterState clusterState, String index, String id, @Nullable String routing) {
        return this.shards(clusterState, index, id, routing).shardsIt();
    }

    public ShardIterator getShards(ClusterState clusterState, String index, String id, @Nullable String routing, @Nullable String preference) {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, id, routing), clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = clusterState.getRoutingTable().shardRoutingTable(index, shardId);
        return this.preferenceActiveShardIterator(indexShard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        return this.searchShards(clusterState, concreteIndices, routing, preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<ShardIterator> set = new HashSet<ShardIterator>(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, collectorService, nodeCounts);
            if (iterator == null) continue;
            set.add(iterator);
        }
        return new GroupShardsIterator<ShardIterator>(new ArrayList(set));
    }

    private Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            IndexMetaData indexMetaData = this.indexMetaData(clusterState, index);
            Set<String> effectiveRouting = routing.get(index);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int routingPartitionSize = indexMetaData.getRoutingPartitionSize();
                    for (int partitionOffset = 0; partitionOffset < routingPartitionSize; ++partitionOffset) {
                        set.add(RoutingTable.shardRoutingTable(indexRouting, OperationRouting.calculateScaledShardId(indexMetaData, r, partitionOffset)));
                    }
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (preference == null || preference.isEmpty()) {
            return this.shardRoutings(indexShard, nodes, collectorService, nodeCounts);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(124);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    return this.shardRoutings(indexShard, nodes, collectorService, nodeCounts);
                }
                preference = preference.substring(index + 1);
            }
            preferenceType = Preference.parse(preference);
            switch (preferenceType) {
                case PREFER_NODES: {
                    Set<String> nodesIds = Arrays.stream(preference.substring(Preference.PREFER_NODES.type().length() + 1).split(",")).collect(Collectors.toSet());
                    return indexShard.preferNodeActiveInitializingShardsIt(nodesIds);
                }
                case LOCAL: {
                    return indexShard.preferNodeActiveInitializingShardsIt(Collections.singleton(localNodeId));
                }
                case ONLY_LOCAL: {
                    return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                }
                case ONLY_NODES: {
                    String nodeAttributes = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                    return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttributes.split(","), nodes);
                }
            }
            throw new IllegalArgumentException("unknown preference [" + (Object)((Object)preferenceType) + "]");
        }
        int routingHash = Murmur3HashFunction.hash(preference);
        if (nodes.getMinNodeVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            routingHash = 31 * routingHash + indexShard.shardId.hashCode();
        }
        if (this.awarenessAttributes.isEmpty()) {
            return indexShard.activeInitializingShardsIt(routingHash);
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes, routingHash);
    }

    private ShardIterator shardRoutings(IndexShardRoutingTable indexShard, DiscoveryNodes nodes, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (this.awarenessAttributes.isEmpty()) {
            if (this.useAdaptiveReplicaSelection) {
                return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
            }
            return indexShard.activeInitializingShardsRandomIt();
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes);
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    protected IndexMetaData indexMetaData(ClusterState clusterState, String index) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexNotFoundException(index);
        }
        return indexMetaData;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String id, String routing) {
        int shardId = OperationRouting.generateShardId(this.indexMetaData(clusterState, index), id, routing);
        return clusterState.getRoutingTable().shardRoutingTable(index, shardId);
    }

    public ShardId shardId(ClusterState clusterState, String index, String id, @Nullable String routing) {
        IndexMetaData indexMetaData = this.indexMetaData(clusterState, index);
        return new ShardId(indexMetaData.getIndex(), OperationRouting.generateShardId(indexMetaData, id, routing));
    }

    public static int generateShardId(IndexMetaData indexMetaData, @Nullable String id, @Nullable String routing) {
        String effectiveRouting;
        if (routing == null) {
            assert (!indexMetaData.isRoutingPartitionedIndex()) : "A routing value is required for gets from a partitioned index";
            effectiveRouting = id;
        } else {
            effectiveRouting = routing;
        }
        int partitionOffset = indexMetaData.isRoutingPartitionedIndex() ? Math.floorMod(Murmur3HashFunction.hash(id), indexMetaData.getRoutingPartitionSize()) : 0;
        return OperationRouting.calculateScaledShardId(indexMetaData, effectiveRouting, partitionOffset);
    }

    private static int calculateScaledShardId(IndexMetaData indexMetaData, String effectiveRouting, int partitionOffset) {
        int hash = Murmur3HashFunction.hash(effectiveRouting) + partitionOffset;
        return Math.floorMod(hash, indexMetaData.getRoutingNumShards()) / indexMetaData.getRoutingFactor();
    }
}

