/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Objects;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.symbol.FunctionTable;

public class ScriptRoot {
    protected final PainlessLookup painlessLookup;
    protected final CompilerSettings compilerSettings;
    protected final ScriptClassInfo scriptClassInfo;
    protected final SClass classNode;
    protected final FunctionTable functionTable = new FunctionTable();
    protected int syntheticCounter = 0;
    protected boolean deterministic = true;

    public ScriptRoot(PainlessLookup painlessLookup, CompilerSettings compilerSettings, ScriptClassInfo scriptClassInfo, SClass classRoot) {
        this.painlessLookup = Objects.requireNonNull(painlessLookup);
        this.compilerSettings = Objects.requireNonNull(compilerSettings);
        this.scriptClassInfo = Objects.requireNonNull(scriptClassInfo);
        this.classNode = Objects.requireNonNull(classRoot);
    }

    public PainlessLookup getPainlessLookup() {
        return this.painlessLookup;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public ScriptClassInfo getScriptClassInfo() {
        return this.scriptClassInfo;
    }

    public SClass getClassNode() {
        return this.classNode;
    }

    public FunctionTable getFunctionTable() {
        return this.functionTable;
    }

    public String getNextSyntheticName(String prefix) {
        return prefix + "$synthetic$" + this.syntheticCounter++;
    }

    public void markNonDeterministic(boolean nondeterministic) {
        this.deterministic &= !nondeterministic;
    }
}

