/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.goal;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.goal.Goal;

public class GotoAdjacentGoal
extends Goal {
    private static final Logger logger = Logger.getLogger(GotoAdjacentGoal.class.getName());
    private final Tile target;

    public GotoAdjacentGoal(AIPlayer p, Goal g, float w, AIUnit u, Tile t) {
        super(p, g, w, u);
        this.target = t;
    }

    @Override
    protected Iterator<AIUnit> getOwnedAIUnitsIterator() {
        return this.availableUnitsList.iterator();
    }

    @Override
    protected Iterator<Goal> getSubGoalIterator() {
        return null;
    }

    @Override
    protected void removeUnit(AIUnit u) {
        Iterator uit = this.availableUnitsList.iterator();
        while (uit.hasNext()) {
            AIUnit unit = (AIUnit)uit.next();
            if (!unit.equals(u)) continue;
            uit.remove();
        }
    }

    @Override
    protected void plan() {
        this.isFinished = false;
        Iterator uit = this.availableUnitsList.iterator();
        block0: while (uit.hasNext()) {
            AIUnit u = (AIUnit)uit.next();
            PathNode pathNode = u.getUnit().findPath(this.target);
            if (pathNode == null) {
                uit.remove();
                this.addUnitToParent(u);
                continue;
            }
            while (pathNode.next != null && pathNode.getTurns() == 0 && pathNode.getTile() != this.target && (u.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.MOVE || u.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR)) {
                if (u.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR) {
                    logger.warning("Accidental rumour exploration!");
                }
                u.move(pathNode.getDirection());
                if (u.getUnit() == null || u.getUnit().isDisposed()) continue block0;
                pathNode = pathNode.next;
            }
            if (!u.getUnit().getTile().isAdjacent(this.target)) continue;
            uit.remove();
            this.addUnitToParent(u);
        }
        if (this.availableUnitsList.isEmpty()) {
            this.isFinished = true;
        }
    }

    @Override
    public String getGoalDescription() {
        String descr = super.getGoalDescription();
        descr = this.target != null ? descr + ":" + this.target.getX() + "," + this.target.getY() : descr + ":null";
        return descr;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
    }

    @Override
    public String getXMLTagName() {
        return GotoAdjacentGoal.getXMLElementTagName();
    }
}

