"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var react_redux_1 = require("react-redux");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var axis_utils_1 = require("../../utils/axis_utils");
var theme_1 = require("../../../../utils/themes/theme");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var get_specs_1 = require("../../state/selectors/get_specs");
var compute_axis_visible_ticks_1 = require("../../state/selectors/compute_axis_visible_ticks");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var utils_1 = require("../../state/utils");
var GridComponent = /** @class */ (function (_super) {
    __extends(GridComponent, _super);
    function GridComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderGridLine = function (linePosition, i, gridLineStyle) {
            return react_1.default.createElement(react_konva_1.Line, __assign({}, gridLineStyle, { key: "tick-" + i, points: linePosition }));
        };
        return _this;
    }
    GridComponent.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    GridComponent.prototype.render = function () {
        var _this = this;
        var _a = this.props, axesGridLinesPositions = _a.axesGridLinesPositions, axesSpecs = _a.axesSpecs, chartDimensions = _a.chartDimensions, chartTheme = _a.chartTheme;
        var gridComponents = [];
        axesGridLinesPositions.forEach(function (axisGridLinesPositions, axisId) {
            var axisSpec = utils_1.getSpecsById(axesSpecs, axisId);
            if (axisSpec && axisGridLinesPositions.length > 0) {
                var themeConfig = axis_utils_1.isVerticalGrid(axisSpec.position)
                    ? chartTheme.axes.gridLineStyle.vertical
                    : chartTheme.axes.gridLineStyle.horizontal;
                var axisSpecConfig = axisSpec.gridLineStyle;
                var gridLineStyle_1 = axisSpecConfig ? theme_1.mergeGridLineConfigs(axisSpecConfig, themeConfig) : themeConfig;
                gridComponents.push(react_1.default.createElement(react_konva_1.Group, { key: "axis-grid-" + axisId, x: chartDimensions.left, y: chartDimensions.top },
                    react_1.default.createElement(react_konva_1.Group, { key: "grid-lines" }, axisGridLinesPositions.map(function (linePosition, index) {
                        return _this.renderGridLine(linePosition, index, gridLineStyle_1);
                    }))));
            }
        });
        return gridComponents;
    };
    return GridComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (!state.specsInitialized) {
        return {
            chartTheme: light_theme_1.LIGHT_THEME,
            chartDimensions: {
                width: 0,
                left: 0,
                top: 0,
                height: 0,
            },
            axesSpecs: [],
            axesGridLinesPositions: new Map(),
        };
    }
    return {
        chartTheme: get_chart_theme_1.getChartThemeSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        axesSpecs: get_specs_1.getAxisSpecsSelector(state),
        axesGridLinesPositions: compute_axis_visible_ticks_1.computeAxisVisibleTicksSelector(state).axisGridLinesPositions,
    };
};
exports.Grid = react_redux_1.connect(mapStateToProps)(GridComponent);
//# sourceMappingURL=grid.js.map