"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_oriented_projected_pointer_position_1 = require("./get_oriented_projected_pointer_position");
var get_computed_scales_1 = require("./get_computed_scales");
var get_geometries_index_keys_1 = require("./get_geometries_index_keys");
var get_geometries_index_1 = require("./get_geometries_index");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var events_1 = require("../../../../utils/events");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getExternalPointerEventStateSelector = function (state) { return state.externalEvents.pointer; };
exports.getElementAtCursorPositionSelector = re_reselect_1.default([
    get_oriented_projected_pointer_position_1.getOrientedProjectedPointerPositionSelector,
    get_computed_scales_1.getComputedScalesSelector,
    get_geometries_index_keys_1.getGeometriesIndexKeysSelector,
    get_geometries_index_1.getGeometriesIndexSelector,
    getExternalPointerEventStateSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
], getElementAtCursorPosition)(get_chart_id_1.getChartIdSelector);
function getElementAtCursorPosition(orientedProjectedPoinerPosition, scales, geometriesIndexKeys, geometriesIndex, externalPointerEvent, _a) {
    var chartDimensions = _a.chartDimensions;
    if (events_1.isValidPointerOverEvent(scales.xScale, externalPointerEvent)) {
        var x = scales.xScale.pureScale(externalPointerEvent.value);
        if (x == null || x > chartDimensions.width + chartDimensions.left) {
            return [];
        }
        return geometriesIndex.get(externalPointerEvent.value) || [];
    }
    var xValue = scales.xScale.invertWithStep(orientedProjectedPoinerPosition.x, geometriesIndexKeys);
    if (!xValue) {
        return [];
    }
    // get the elements on at this cursor position
    return geometriesIndex.get(xValue.value) || [];
}
//# sourceMappingURL=get_elements_at_cursor_pos.js.map