"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ON_POINTER_MOVE = 'ON_POINTER_MOVE';
exports.ON_MOUSE_DOWN = 'ON_MOUSE_DOWN';
exports.ON_MOUSE_UP = 'ON_MOUSE_UP';
/**
 * Action called on mouse button down event
 * @param position the x and y position (native event offsetX, offsetY)
 * @param time the timestamp of the event (native event timeStamp)
 */
function onMouseDown(position, time) {
    return { type: exports.ON_MOUSE_DOWN, position: position, time: time };
}
exports.onMouseDown = onMouseDown;
/**
 * Action called on mouse button up event
 * @param position the x and y position (native event offsetX, offsetY)
 * @param time the timestamp of the event (native event timeStamp)
 */
function onMouseUp(position, time) {
    return { type: exports.ON_MOUSE_UP, position: position, time: time };
}
exports.onMouseUp = onMouseUp;
/**
 * Action called with the mouse coordinates relatives to the chart container (exclude the legend)
 * @param position the x and y position (native event offsetX, offsetY)
 * @param time the timestamp of the event (native event timeStamp)
 */
function onPointerMove(position, time) {
    return { type: exports.ON_POINTER_MOVE, position: position, time: time };
}
exports.onPointerMove = onPointerMove;
//# sourceMappingURL=mouse.js.map