"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Return an accessor function using the accessor passed as argument
 * @param accessor the spec accessor
 */
function getAccessorFn(accessor) {
    if (typeof accessor === 'string' || typeof accessor === 'number') {
        return function (datum) {
            return datum[accessor];
        };
    }
    if (typeof accessor === 'function') {
        return accessor;
    }
    throw new Error('Accessor must be a string or a function');
}
exports.getAccessorFn = getAccessorFn;
/**
 * Return the accessor label given as `AccessorFormat`
 */
function getAccessorFormatLabel(accessor, label) {
    if (typeof accessor === 'string') {
        return "" + label + accessor;
    }
    return accessor(label);
}
exports.getAccessorFormatLabel = getAccessorFormatLabel;
//# sourceMappingURL=accessor.js.map