/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class XIntervals {
    private static final IntervalIterator EMPTY = new IntervalIterator(){

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }

        public int start() {
            return -1;
        }

        public int end() {
            return -1;
        }

        public int gaps() {
            throw new UnsupportedOperationException();
        }

        public int nextInterval() {
            return Integer.MAX_VALUE;
        }

        public float matchCost() {
            return 0.0f;
        }
    };
    private static final IntervalIterator EXHAUSTED = new IntervalIterator(){

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }

        public int start() {
            return Integer.MAX_VALUE;
        }

        public int end() {
            return Integer.MAX_VALUE;
        }

        public int gaps() {
            throw new UnsupportedOperationException();
        }

        public int nextInterval() {
            return Integer.MAX_VALUE;
        }

        public float matchCost() {
            return 0.0f;
        }
    };

    private XIntervals() {
    }

    public static IntervalsSource wildcard(BytesRef wildcard) {
        CompiledAutomaton ca = new CompiledAutomaton(WildcardQuery.toAutomaton((Term)new Term("", wildcard)));
        return new MultiTermIntervalsSource(ca, 128, wildcard.utf8ToString());
    }

    public static IntervalsSource prefix(BytesRef prefix) {
        CompiledAutomaton ca = new CompiledAutomaton(PrefixQuery.toAutomaton((BytesRef)prefix));
        return new MultiTermIntervalsSource(ca, 128, prefix.utf8ToString());
    }

    public static IntervalsSource multiterm(CompiledAutomaton ca, String label) {
        return new MultiTermIntervalsSource(ca, 128, label);
    }

    static class MultiTermIntervalsSource
    extends IntervalsSource {
        private final CompiledAutomaton automaton;
        private final int maxExpansions;
        private final String pattern;

        MultiTermIntervalsSource(CompiledAutomaton automaton, int maxExpansions, String pattern) {
            this.automaton = automaton;
            if (maxExpansions > BooleanQuery.getMaxClauseCount()) {
                throw new IllegalArgumentException("maxExpansions [" + maxExpansions + "] cannot be greater than BooleanQuery.getMaxClauseCount [" + BooleanQuery.getMaxClauseCount() + "]");
            }
            this.maxExpansions = maxExpansions;
            this.pattern = pattern;
        }

        public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
            BytesRef term;
            Terms terms = ctx.reader().terms(field);
            if (terms == null) {
                return null;
            }
            ArrayList<IntervalIterator> subSources = new ArrayList<IntervalIterator>();
            TermsEnum te = this.automaton.getTermsEnum(terms);
            int count = 0;
            while ((term = te.next()) != null) {
                subSources.add(TermIntervalsSource.intervals(term, te));
                if (++count <= this.maxExpansions) continue;
                throw new IllegalStateException("Automaton [" + this.pattern + "] expanded to too many terms (limit " + this.maxExpansions + ")");
            }
            if (subSources.size() == 0) {
                return null;
            }
            return new DisjunctionIntervalIterator(subSources);
        }

        public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
            BytesRef term;
            Terms terms = ctx.reader().terms(field);
            if (terms == null) {
                return null;
            }
            ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
            TermsEnum te = this.automaton.getTermsEnum(terms);
            int count = 0;
            while ((term = te.next()) != null) {
                MatchesIterator mi = TermIntervalsSource.matches(te, doc);
                if (mi == null) continue;
                subMatches.add(mi);
                if (count++ <= this.maxExpansions) continue;
                throw new IllegalStateException("Automaton " + term + " expanded to too many terms (limit " + this.maxExpansions + ")");
            }
            return MatchesUtils.disjunction(subMatches);
        }

        public void visit(String field, QueryVisitor visitor) {
            visitor.visitLeaf((Query)new IntervalQuery(field, (IntervalsSource)this));
        }

        public int minExtent() {
            return 1;
        }

        public Collection<IntervalsSource> pullUpDisjunctions() {
            return Collections.singleton(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MultiTermIntervalsSource that = (MultiTermIntervalsSource)((Object)o);
            return this.maxExpansions == that.maxExpansions && Objects.equals(this.automaton, that.automaton) && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.automaton, this.maxExpansions, this.pattern);
        }

        public String toString() {
            return "MultiTerm(" + this.pattern + ")";
        }
    }

    static class TermIntervalsSource
    extends IntervalsSource {
        final BytesRef term;
        private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
        private static final int TERM_OPS_PER_POS = 7;

        TermIntervalsSource(BytesRef term) {
            this.term = term;
        }

        public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
            Terms terms = ctx.reader().terms(field);
            if (terms == null) {
                return null;
            }
            if (!terms.hasPositions()) {
                throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
            }
            TermsEnum te = terms.iterator();
            if (!te.seekExact(this.term)) {
                return null;
            }
            return TermIntervalsSource.intervals(this.term, te);
        }

        static IntervalIterator intervals(final BytesRef term, TermsEnum te) throws IOException {
            final PostingsEnum pe = te.postings(null, 24);
            final float cost = TermIntervalsSource.termPositionsCost(te);
            return new IntervalIterator(){
                int pos = -1;
                int upto;

                public int docID() {
                    return pe.docID();
                }

                public int nextDoc() throws IOException {
                    int doc = pe.nextDoc();
                    this.reset();
                    return doc;
                }

                public int advance(int target) throws IOException {
                    int doc = pe.advance(target);
                    this.reset();
                    return doc;
                }

                public long cost() {
                    return pe.cost();
                }

                public int start() {
                    return this.pos;
                }

                public int end() {
                    return this.pos;
                }

                public int gaps() {
                    return 0;
                }

                public int nextInterval() throws IOException {
                    if (this.upto <= 0) {
                        this.pos = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    --this.upto;
                    this.pos = pe.nextPosition();
                    return this.pos;
                }

                public float matchCost() {
                    return cost;
                }

                private void reset() throws IOException {
                    if (pe.docID() == Integer.MAX_VALUE) {
                        this.upto = -1;
                        this.pos = Integer.MAX_VALUE;
                    } else {
                        this.upto = pe.freq();
                        this.pos = -1;
                    }
                }

                public String toString() {
                    return term.utf8ToString() + ":" + super.toString();
                }
            };
        }

        public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
            Terms terms = ctx.reader().terms(field);
            if (terms == null) {
                return null;
            }
            if (!terms.hasPositions()) {
                throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
            }
            TermsEnum te = terms.iterator();
            if (!te.seekExact(this.term)) {
                return null;
            }
            return TermIntervalsSource.matches(te, doc);
        }

        static MatchesIterator matches(TermsEnum te, int doc) throws IOException {
            final PostingsEnum pe = te.postings(null, 56);
            if (pe.advance(doc) != doc) {
                return null;
            }
            return new MatchesIterator(){
                int upto;
                int pos;
                {
                    this.upto = pe.freq();
                    this.pos = -1;
                }

                public boolean next() throws IOException {
                    if (this.upto <= 0) {
                        this.pos = Integer.MAX_VALUE;
                        return false;
                    }
                    --this.upto;
                    this.pos = pe.nextPosition();
                    return true;
                }

                public int startPosition() {
                    return this.pos;
                }

                public int endPosition() {
                    return this.pos;
                }

                public int startOffset() throws IOException {
                    return pe.startOffset();
                }

                public int endOffset() throws IOException {
                    return pe.endOffset();
                }

                public MatchesIterator getSubMatches() {
                    return null;
                }

                public Query getQuery() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int minExtent() {
            return 1;
        }

        public Collection<IntervalsSource> pullUpDisjunctions() {
            return Collections.singleton(this);
        }

        public int hashCode() {
            return Objects.hash(this.term);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TermIntervalsSource that = (TermIntervalsSource)((Object)o);
            return Objects.equals(this.term, that.term);
        }

        public String toString() {
            return this.term.utf8ToString();
        }

        public void visit(String field, QueryVisitor visitor) {
            visitor.consumeTerms((Query)new IntervalQuery(field, (IntervalsSource)this), new Term[]{new Term(field, this.term)});
        }

        static float termPositionsCost(TermsEnum termsEnum) throws IOException {
            int docFreq = termsEnum.docFreq();
            assert (docFreq > 0);
            long totalTermFreq = termsEnum.totalTermFreq();
            float expOccurrencesInMatchingDoc = (float)totalTermFreq / (float)docFreq;
            return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
        }
    }

    static class DisjunctionIntervalIterator
    extends IntervalIterator {
        final DocIdSetIterator approximation;
        final PriorityQueue<IntervalIterator> intervalQueue;
        final DisiPriorityQueue disiQueue;
        final List<IntervalIterator> iterators;
        final float matchCost;
        IntervalIterator current = XIntervals.access$000();

        DisjunctionIntervalIterator(List<IntervalIterator> iterators) {
            this.disiQueue = new DisiPriorityQueue(iterators.size());
            for (IntervalIterator it : iterators) {
                this.disiQueue.add(new DisiWrapper(it));
            }
            this.approximation = new DisjunctionDISIApproximation(this.disiQueue);
            this.iterators = iterators;
            this.intervalQueue = new PriorityQueue<IntervalIterator>(iterators.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.end() < b.end() || a.end() == b.end() && a.start() >= b.start();
                }
            };
            float costsum = 0.0f;
            for (IntervalIterator it : iterators) {
                costsum += (float)it.cost();
            }
            this.matchCost = costsum;
        }

        public float matchCost() {
            return this.matchCost;
        }

        public int start() {
            return this.current.start();
        }

        public int end() {
            return this.current.end();
        }

        public int gaps() {
            return this.current.gaps();
        }

        private void reset() throws IOException {
            this.intervalQueue.clear();
            DisiWrapper dw = this.disiQueue.topList();
            while (dw != null) {
                dw.intervals.nextInterval();
                this.intervalQueue.add((Object)dw.intervals);
                dw = dw.next;
            }
            this.current = EMPTY;
        }

        public int nextInterval() throws IOException {
            if (this.current == EMPTY || this.current == EXHAUSTED) {
                if (this.intervalQueue.size() > 0) {
                    this.current = (IntervalIterator)this.intervalQueue.top();
                }
                return this.current.start();
            }
            int start = this.current.start();
            int end = this.current.end();
            while (this.intervalQueue.size() > 0 && this.contains((IntervalIterator)this.intervalQueue.top(), start, end)) {
                IntervalIterator it = (IntervalIterator)this.intervalQueue.pop();
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.intervalQueue.add((Object)it);
            }
            if (this.intervalQueue.size() == 0) {
                this.current = EXHAUSTED;
                return Integer.MAX_VALUE;
            }
            this.current = (IntervalIterator)this.intervalQueue.top();
            return this.current.start();
        }

        private boolean contains(IntervalIterator it, int start, int end) {
            return start >= it.start() && start <= it.end() && end >= it.start() && end <= it.end();
        }

        public int docID() {
            return this.approximation.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.approximation.nextDoc();
            this.reset();
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.approximation.advance(target);
            this.reset();
            return doc;
        }

        public long cost() {
            return this.approximation.cost();
        }
    }

    static class DisjunctionDISIApproximation
    extends DocIdSetIterator {
        final DisiPriorityQueue subIterators;
        final long cost;

        DisjunctionDISIApproximation(DisiPriorityQueue subIterators) {
            this.subIterators = subIterators;
            long cost = 0L;
            for (DisiWrapper w : subIterators) {
                cost += w.cost;
            }
            this.cost = cost;
        }

        public long cost() {
            return this.cost;
        }

        public int docID() {
            return this.subIterators.top().doc;
        }

        public int nextDoc() throws IOException {
            DisiWrapper top = this.subIterators.top();
            int doc = top.doc;
            do {
                top.doc = top.approximation.nextDoc();
                top = this.subIterators.updateTop();
            } while (top.doc == doc);
            return top.doc;
        }

        public int advance(int target) throws IOException {
            DisiWrapper top = this.subIterators.top();
            do {
                top.doc = top.approximation.advance(target);
                top = this.subIterators.updateTop();
            } while (top.doc < target);
            return top.doc;
        }
    }

    static final class DisiPriorityQueue
    implements Iterable<DisiWrapper> {
        private final DisiWrapper[] heap;
        private int size;

        static int leftNode(int node) {
            return (node + 1 << 1) - 1;
        }

        static int rightNode(int leftNode) {
            return leftNode + 1;
        }

        static int parentNode(int node) {
            return (node + 1 >>> 1) - 1;
        }

        DisiPriorityQueue(int maxSize) {
            this.heap = new DisiWrapper[maxSize];
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public DisiWrapper top() {
            return this.heap[0];
        }

        DisiWrapper topList() {
            DisiWrapper[] heap = this.heap;
            int size = this.size;
            DisiWrapper list = heap[0];
            list.next = null;
            if (size >= 3) {
                list = this.topList(list, heap, size, 1);
                list = this.topList(list, heap, size, 2);
            } else if (size == 2 && heap[1].doc == list.doc) {
                list = this.prepend(heap[1], list);
            }
            return list;
        }

        private DisiWrapper prepend(DisiWrapper w1, DisiWrapper w2) {
            w1.next = w2;
            return w1;
        }

        private DisiWrapper topList(DisiWrapper list, DisiWrapper[] heap, int size, int i) {
            DisiWrapper w = heap[i];
            if (w.doc == list.doc) {
                list = this.prepend(w, list);
                int left = DisiPriorityQueue.leftNode(i);
                int right = left + 1;
                if (right < size) {
                    list = this.topList(list, heap, size, left);
                    list = this.topList(list, heap, size, right);
                } else if (left < size && heap[left].doc == list.doc) {
                    list = this.prepend(heap[left], list);
                }
            }
            return list;
        }

        public DisiWrapper add(DisiWrapper entry) {
            DisiWrapper[] heap = this.heap;
            int size = this.size;
            heap[size] = entry;
            this.upHeap(size);
            this.size = size + 1;
            return heap[0];
        }

        public DisiWrapper pop() {
            DisiWrapper[] heap = this.heap;
            DisiWrapper result = heap[0];
            int i = --this.size;
            heap[0] = heap[i];
            heap[i] = null;
            this.downHeap(i);
            return result;
        }

        DisiWrapper updateTop() {
            this.downHeap(this.size);
            return this.heap[0];
        }

        void upHeap(int i) {
            DisiWrapper node = this.heap[i];
            int nodeDoc = node.doc;
            int j = DisiPriorityQueue.parentNode(i);
            while (j >= 0 && nodeDoc < this.heap[j].doc) {
                this.heap[i] = this.heap[j];
                i = j;
                j = DisiPriorityQueue.parentNode(j);
            }
            this.heap[i] = node;
        }

        void downHeap(int size) {
            int i = 0;
            DisiWrapper node = this.heap[0];
            int j = DisiPriorityQueue.leftNode(i);
            if (j < size) {
                int k = DisiPriorityQueue.rightNode(j);
                if (k < size && this.heap[k].doc < this.heap[j].doc) {
                    j = k;
                }
                if (this.heap[j].doc < node.doc) {
                    do {
                        this.heap[i] = this.heap[j];
                        i = j;
                        k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                        if (k >= size || this.heap[k].doc >= this.heap[j].doc) continue;
                        j = k;
                    } while (j < size && this.heap[j].doc < node.doc);
                    this.heap[i] = node;
                }
            }
        }

        @Override
        public Iterator<DisiWrapper> iterator() {
            return Arrays.asList(this.heap).subList(0, this.size).iterator();
        }
    }

    static class DisiWrapper {
        public final DocIdSetIterator iterator;
        public final IntervalIterator intervals;
        public final long cost;
        public final float matchCost;
        public int doc;
        public DisiWrapper next;
        public final DocIdSetIterator approximation;

        DisiWrapper(IntervalIterator iterator) {
            this.intervals = iterator;
            this.iterator = iterator;
            this.cost = iterator.cost();
            this.doc = -1;
            this.approximation = iterator;
            this.matchCost = iterator.matchCost();
        }
    }
}

