/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class RemoveCustomsCommand
extends ElasticsearchNodeCommand {
    static final String CUSTOMS_REMOVED_MSG = "Customs were successfully removed from the cluster state";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have broken custom metadata in the\ncluster state that prevents the cluster state from being loaded.\nThis tool can cause data loss and its use should be your last resort.\n\nDo you want to proceed?\n";
    private final OptionSpec<String> arguments;

    public RemoveCustomsCommand() {
        super("Removes custom metadata from the cluster state");
        this.arguments = this.parser.nonOptions("custom metadata names");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException, UserException {
        List customsToRemove = this.arguments.values(options);
        if (customsToRemove.isEmpty()) {
            throw new UserException(64, "Must supply at least one custom metadata name to remove");
        }
        PersistedClusterStateService persistedClusterStateService = RemoveCustomsCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        Tuple<Long, ClusterState> termAndClusterState = RemoveCustomsCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)termAndClusterState.v2();
        terminal.println(Terminal.Verbosity.VERBOSE, "custom metadata names: " + oldClusterState.metaData().customs().keys());
        MetaData.Builder metaDataBuilder = MetaData.builder(oldClusterState.metaData());
        for (String customToRemove : customsToRemove) {
            boolean matched = false;
            for (ObjectCursor customKeyCur : oldClusterState.metaData().customs().keys()) {
                String customKey = (String)customKeyCur.value;
                if (!Regex.simpleMatch(customToRemove, customKey)) continue;
                metaDataBuilder.removeCustom(customKey);
                if (!matched) {
                    terminal.println("The following customs will be removed:");
                }
                matched = true;
                terminal.println(customKey);
            }
            if (matched) continue;
            throw new UserException(64, "No custom metadata matching [" + customToRemove + "] were found on this node");
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metaData(metaDataBuilder.build()).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + oldClusterState + ", new cluster state = " + newClusterState + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit((Long)termAndClusterState.v1(), newClusterState);
        }
        terminal.println(CUSTOMS_REMOVED_MSG);
    }
}

