/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.BLOBInDataStore;
import org.apache.jackrabbit.core.value.BLOBInMemory;
import org.apache.jackrabbit.core.value.BLOBInResource;
import org.apache.jackrabbit.core.value.BLOBInTempFile;
import org.apache.jackrabbit.core.value.BLOBValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.NameValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.StringValue;

public class InternalValue {
    public static final InternalValue[] EMPTY_ARRAY;
    private static final InternalValue BOOLEAN_TRUE;
    private static final InternalValue BOOLEAN_FALSE;
    public static final boolean USE_DATA_STORE;
    private static final int MIN_BLOB_FILE_SIZE = 1024;
    private Object val;
    private final int type;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static InternalValue create(Value value, NamePathResolver resolver) throws ValueFormatException, RepositoryException {
        return InternalValue.create(value, resolver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalValue create(Value value, NamePathResolver resolver, DataStore store) throws ValueFormatException, RepositoryException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        switch (value.getType()) {
            case 2: {
                if (USE_DATA_STORE) {
                    return new InternalValue(InternalValue.getBLOBFileValue(store, value.getStream(), true));
                }
                if (value instanceof BLOBFileValue) {
                    return new InternalValue((BLOBFileValue)value);
                }
                InputStream stream = value.getStream();
                try {
                    InternalValue internalValue = InternalValue.createTemporary(stream);
                    return internalValue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            case 6: {
                return InternalValue.create(value.getBoolean());
            }
            case 5: {
                return InternalValue.create(value.getDate());
            }
            case 4: {
                return InternalValue.create(value.getDouble());
            }
            case 3: {
                return InternalValue.create(value.getLong());
            }
            case 9: {
                return InternalValue.create(new UUID(value.getString()));
            }
            case 7: {
                try {
                    return InternalValue.create(resolver.getQName(value.getString()));
                }
                catch (NameException e) {
                    throw new ValueFormatException(e.getMessage());
                }
            }
            case 8: {
                try {
                    return InternalValue.create(resolver.getQPath(value.getString()));
                }
                catch (MalformedPathException mpe) {
                    throw new ValueFormatException(mpe.getMessage());
                }
            }
            case 1: {
                return InternalValue.create(value.getString());
            }
        }
        throw new IllegalArgumentException("illegal value");
    }

    public static InternalValue create(String value) {
        return new InternalValue(value);
    }

    public static InternalValue create(long value) {
        return new InternalValue(value);
    }

    public static InternalValue create(double value) {
        return new InternalValue(value);
    }

    public static InternalValue create(Calendar value) {
        return new InternalValue(value);
    }

    public static InternalValue create(boolean value) {
        return value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public static InternalValue create(byte[] value) {
        if (USE_DATA_STORE) {
            return new InternalValue(BLOBInMemory.getInstance(value));
        }
        return new InternalValue(new BLOBValue(value));
    }

    public static InternalValue createTemporary(InputStream value) throws RepositoryException {
        if (USE_DATA_STORE) {
            return new InternalValue(InternalValue.getBLOBFileValue(null, value, true));
        }
        try {
            return new InternalValue(new BLOBValue(value, true));
        }
        catch (IOException e) {
            throw new RepositoryException("Error creating temporary file", (Throwable)e);
        }
    }

    public static InternalValue createTemporary(InputStream value, DataStore store) throws RepositoryException {
        if (USE_DATA_STORE) {
            return new InternalValue(InternalValue.getBLOBFileValue(store, value, true));
        }
        try {
            return new InternalValue(new BLOBValue(value, true));
        }
        catch (IOException e) {
            throw new RepositoryException("Error creating temporary file", (Throwable)e);
        }
    }

    public static InternalValue create(InputStream value) throws RepositoryException {
        if (USE_DATA_STORE) {
            return new InternalValue(InternalValue.getBLOBFileValue(null, value, false));
        }
        try {
            return new InternalValue(new BLOBValue(value, false));
        }
        catch (IOException e) {
            throw new RepositoryException("Error creating file", (Throwable)e);
        }
    }

    public static InternalValue create(FileSystemResource value) throws IOException {
        if (USE_DATA_STORE) {
            return new InternalValue(BLOBInResource.getInstance(value));
        }
        return new InternalValue(new BLOBValue(value));
    }

    public static InternalValue create(File value) throws IOException {
        if (!$assertionsDisabled && USE_DATA_STORE) {
            throw new AssertionError();
        }
        return new InternalValue(new BLOBValue(value));
    }

    public static InternalValue create(DataStore store, String id) {
        if (!($assertionsDisabled || USE_DATA_STORE && store != null)) {
            throw new AssertionError();
        }
        return new InternalValue(InternalValue.getBLOBFileValue(store, id));
    }

    public static InternalValue create(Name value) {
        return new InternalValue(value);
    }

    public static InternalValue[] create(Name[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue[] create(String[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue create(Path value) {
        return new InternalValue(value);
    }

    public static InternalValue create(UUID value) {
        return new InternalValue(value);
    }

    public Value toJCRValue(NamePathResolver resolver) throws RepositoryException {
        switch (this.type) {
            case 2: {
                return new BinaryValue(((BLOBFileValue)this.val).getStream());
            }
            case 6: {
                return new BooleanValue((Boolean)this.val);
            }
            case 5: {
                return new DateValue((Calendar)this.val);
            }
            case 4: {
                return new DoubleValue((Double)this.val);
            }
            case 3: {
                return new LongValue((Long)this.val);
            }
            case 9: {
                return ReferenceValue.valueOf(this.val.toString());
            }
            case 8: {
                return PathValue.valueOf(resolver.getJCRPath((Path)this.val));
            }
            case 7: {
                return NameValue.valueOf(resolver.getJCRName((Name)this.val), false);
            }
            case 1: {
                return new StringValue((String)this.val);
            }
        }
        throw new RepositoryException("illegal internal value type");
    }

    public Object internalValue() {
        return this.val;
    }

    public BLOBFileValue getBLOBFileValue() {
        if (!($assertionsDisabled || this.val != null && this.type == 2)) {
            throw new AssertionError();
        }
        return (BLOBFileValue)this.val;
    }

    public UUID getUUID() {
        if (!($assertionsDisabled || this.val != null && this.type == 9)) {
            throw new AssertionError();
        }
        return (UUID)this.val;
    }

    public boolean getBoolean() {
        if (!($assertionsDisabled || this.val != null && this.type == 6)) {
            throw new AssertionError();
        }
        return (Boolean)this.val;
    }

    public Name getQName() {
        if (!($assertionsDisabled || this.val != null && this.type == 7)) {
            throw new AssertionError();
        }
        return (Name)this.val;
    }

    public Path getPath() {
        if (!($assertionsDisabled || this.val != null && this.type == 8)) {
            throw new AssertionError();
        }
        return (Path)this.val;
    }

    public long getLong() {
        if (!($assertionsDisabled || this.val != null && this.type == 3)) {
            throw new AssertionError();
        }
        return (Long)this.val;
    }

    public double getDouble() {
        if (!($assertionsDisabled || this.val != null && this.type == 4)) {
            throw new AssertionError();
        }
        return (Double)this.val;
    }

    public Calendar getDate() {
        if (!($assertionsDisabled || this.val != null && this.type == 5)) {
            throw new AssertionError();
        }
        return (Calendar)this.val;
    }

    public String getString() {
        if (!($assertionsDisabled || this.val != null && this.type == 1)) {
            throw new AssertionError();
        }
        return (String)this.val;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalValue createCopy() throws RepositoryException {
        if (this.type != 2) {
            return this;
        }
        BLOBFileValue v = (BLOBFileValue)this.val;
        if (USE_DATA_STORE && v.isImmutable()) {
            return this;
        }
        InputStream stream = v.getStream();
        try {
            InternalValue internalValue = InternalValue.createTemporary(stream);
            return internalValue;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    public static InternalValue valueOf(String s, int type) {
        switch (type) {
            case 6: {
                return InternalValue.create(Boolean.valueOf(s));
            }
            case 5: {
                return InternalValue.create(ISO8601.parse(s));
            }
            case 4: {
                return InternalValue.create(Double.parseDouble(s));
            }
            case 3: {
                return InternalValue.create(Long.parseLong(s));
            }
            case 9: {
                return InternalValue.create(new UUID(s));
            }
            case 8: {
                return InternalValue.create(PathFactoryImpl.getInstance().create(s));
            }
            case 7: {
                return InternalValue.create(NameFactoryImpl.getInstance().create(s));
            }
            case 1: {
                return InternalValue.create(s);
            }
            case 2: {
                throw new IllegalArgumentException("this method does not support the type PropertyType.BINARY");
            }
        }
        throw new IllegalArgumentException("illegal type: " + type);
    }

    public String toString() {
        if (this.type == 5) {
            return ISO8601.format((Calendar)this.val);
        }
        return this.val.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InternalValue) {
            InternalValue other = (InternalValue)obj;
            return this.val.equals(other.val);
        }
        return false;
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    private InternalValue(String value) {
        this.val = value;
        this.type = 1;
    }

    private InternalValue(Name value) {
        this.val = value;
        this.type = 7;
    }

    private InternalValue(long value) {
        this.val = new Long(value);
        this.type = 3;
    }

    private InternalValue(double value) {
        this.val = new Double(value);
        this.type = 4;
    }

    private InternalValue(Calendar value) {
        this.val = value;
        this.type = 5;
    }

    private InternalValue(boolean value) {
        this.val = value;
        this.type = 6;
    }

    private InternalValue(BLOBFileValue value) {
        this.val = value;
        this.type = 2;
    }

    private InternalValue(Path value) {
        this.val = value;
        this.type = 8;
    }

    private InternalValue(UUID value) {
        this.val = value;
        this.type = 9;
    }

    private static BLOBFileValue getBLOBFileValue(DataStore store, InputStream in, boolean temporary) throws RepositoryException {
        int maxMemorySize = store != null ? store.getMinRecordLength() - 1 : 1024;
        maxMemorySize = Math.max(0, maxMemorySize);
        byte[] buffer = new byte[maxMemorySize];
        int pos = 0;
        int len = maxMemorySize;
        try {
            int l;
            while (pos < maxMemorySize && (l = in.read(buffer, pos, len)) >= 0) {
                pos += l;
                len -= l;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read from stream", (Throwable)e);
        }
        if (pos < maxMemorySize) {
            byte[] data = new byte[pos];
            System.arraycopy(buffer, 0, data, 0, pos);
            return BLOBInMemory.getInstance(data);
        }
        in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, pos), in);
        if (store != null) {
            return BLOBInDataStore.getInstance(store, in);
        }
        return BLOBInTempFile.getInstance(in, temporary);
    }

    private static BLOBFileValue getBLOBFileValue(DataStore store, String id) {
        if (BLOBInMemory.isInstance(id)) {
            return BLOBInMemory.getInstance(id);
        }
        if (BLOBInDataStore.isInstance(id)) {
            return BLOBInDataStore.getInstance(store, id);
        }
        throw new IllegalArgumentException("illegal binary id: " + id);
    }

    public void store(DataStore dataStore) throws RepositoryException, IOException {
        if (!$assertionsDisabled && !USE_DATA_STORE) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dataStore == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.type != 2) {
            throw new AssertionError();
        }
        BLOBFileValue v = (BLOBFileValue)this.val;
        if (v instanceof BLOBInDataStore) {
            return;
        }
        if (v instanceof BLOBInMemory && v.getLength() < (long)dataStore.getMinRecordLength()) {
            return;
        }
        this.val = InternalValue.getBLOBFileValue(dataStore, v.getStream(), false);
    }

    static {
        $assertionsDisabled = !InternalValue.class.desiredAssertionStatus();
        EMPTY_ARRAY = new InternalValue[0];
        BOOLEAN_TRUE = new InternalValue(true);
        BOOLEAN_FALSE = new InternalValue(false);
        USE_DATA_STORE = Boolean.valueOf(System.getProperty("org.jackrabbit.useDataStore", "true"));
    }
}

