/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import ghidra.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ToolBarItemManager
implements PropertyChangeListener,
ActionListener,
MouseListener {
    private static final String START_KEYBINDING_TEXT = "<BR><HR><CENTER>(";
    private static final String END_KEYBINDNIG_TEXT = ")</CENTER>";
    private DockingActionIf toolBarAction;
    private JButton toolBarButton;
    private final DockingWindowManager windowManager;

    public ToolBarItemManager(DockingActionIf action, DockingWindowManager windowManager) {
        this.toolBarAction = action;
        this.windowManager = windowManager;
        action.addPropertyChangeListener(this);
    }

    String getGroup() {
        return this.toolBarAction.getToolBarData().getToolBarGroup();
    }

    public JButton getButton() {
        if (this.toolBarButton == null) {
            this.toolBarButton = this.createButton(this.toolBarAction);
            this.toolBarButton.setEnabled(this.toolBarAction.isEnabled());
        }
        return this.toolBarButton;
    }

    public JButton createButton(DockingActionIf action) {
        JButton button = action.createButton();
        button.addActionListener(this);
        button.addMouseListener(this);
        button.setName(action.getName());
        this.setToolTipText(button, action, this.getToolTipText(action));
        return button;
    }

    private void setToolTipText(JButton button, DockingActionIf action, String toolTipText) {
        String keyBindingText = this.getKeyBindingAcceleratorText(action.getKeyBinding());
        if (keyBindingText != null) {
            button.setToolTipText(this.combingToolTipTextWithKeyBinding(toolTipText, keyBindingText));
        } else {
            button.setToolTipText(toolTipText);
        }
        ToolTipManager instance = ToolTipManager.sharedInstance();
    }

    private String combingToolTipTextWithKeyBinding(String toolTipText, String keyBindingText) {
        StringBuilder buffy = new StringBuilder(toolTipText);
        if (StringUtilities.startsWithIgnoreCase((String)toolTipText, (String)"<HTML>")) {
            String endHTMLTag = "</HTML>";
            int closeTagIndex = StringUtilities.indexOfIgnoreCase((String)toolTipText, (String)endHTMLTag);
            if (closeTagIndex < 0) {
                buffy.append(START_KEYBINDING_TEXT).append(keyBindingText).append(END_KEYBINDNIG_TEXT);
            } else {
                buffy.delete(closeTagIndex, closeTagIndex + endHTMLTag.length() + 1);
                buffy.append(START_KEYBINDING_TEXT).append(keyBindingText).append(END_KEYBINDNIG_TEXT).append(endHTMLTag);
            }
            return buffy.toString();
        }
        return toolTipText + " (" + keyBindingText + ")";
    }

    private String getToolTipText(DockingActionIf action) {
        String description = action.getDescription();
        if (description != null && description.trim().length() > 0) {
            return description;
        }
        return action.getName();
    }

    private String getKeyBindingAcceleratorText(KeyStroke keyStroke) {
        int keyCode;
        if (keyStroke == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int modifiers = keyStroke.getModifiers();
        if (modifiers > 0) {
            builder.append(KeyEvent.getKeyModifiersText(modifiers));
            builder.append('+');
        }
        if ((keyCode = keyStroke.getKeyCode()) != 0) {
            builder.append(KeyEvent.getKeyText(keyCode));
        } else {
            builder.append(keyStroke.getKeyChar());
        }
        return builder.toString();
    }

    public DockingActionIf getAction() {
        return this.toolBarAction;
    }

    void dispose() {
        this.toolBarAction.removePropertyChangeListener(this);
        if (this.toolBarButton != null) {
            this.toolBarButton.removeActionListener(this);
            this.toolBarButton = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.toolBarButton == null) {
            return;
        }
        String name = e.getPropertyName();
        if (name.equals("enabled")) {
            this.toolBarButton.setEnabled((Boolean)e.getNewValue());
        } else if (name.equals("description")) {
            this.setToolTipText(this.toolBarButton, this.toolBarAction, (String)e.getNewValue());
        } else if (name.equals("ToolBar")) {
            ToolBarData toolBarData = (ToolBarData)e.getNewValue();
            this.toolBarButton.setIcon(toolBarData == null ? null : toolBarData.getIcon());
        } else if (name.equals("selectState")) {
            this.toolBarButton.setSelected((Boolean)e.getNewValue());
        } else if (name.equals("KeyBindings")) {
            this.setToolTipText(this.toolBarButton, this.toolBarAction, this.getToolTipText(this.toolBarAction));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        ActionContext localContext = this.getActionContext();
        ActionContext globalContext = null;
        if (this.windowManager != null) {
            globalContext = this.windowManager.getGlobalContext();
        }
        ActionContext tempContext = null;
        if (this.toolBarAction.isValidContext(localContext)) {
            tempContext = localContext;
        } else if (this.toolBarAction.isValidGlobalContext(globalContext)) {
            tempContext = globalContext;
        } else {
            return;
        }
        tempContext.setSource(event.getSource());
        final ActionContext finalContext = tempContext;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ToolBarItemManager.this.toolBarAction.isEnabledForContext(finalContext)) {
                    if (ToolBarItemManager.this.toolBarAction instanceof ToggleDockingActionIf) {
                        ToggleDockingActionIf toggleAction;
                        toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)ToolBarItemManager.this.toolBarAction).isSelected());
                    }
                    ToolBarItemManager.this.toolBarAction.actionPerformed(finalContext);
                }
            }
        });
    }

    public String toString() {
        return this.toolBarAction.getName();
    }

    private ActionContext getActionContext() {
        ComponentProvider provider = this.getComponentProvider();
        ActionContext context = provider == null ? null : provider.getActionContext(null);
        ActionContext actionContext = context == null ? new ActionContext() : context;
        return actionContext;
    }

    private ComponentProvider getComponentProvider() {
        DockingWindowManager manager = this.windowManager;
        if (manager == null) {
            manager = DockingWindowManager.getActiveInstance();
        }
        return manager.getActiveComponentProvider();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        DockingWindowManager.setMouseOverAction(this.toolBarAction);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

