/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangLabelToken
extends ClangToken {
    private Address blockaddr = null;

    public ClangLabelToken(ClangNode par) {
        super(par);
    }

    @Override
    public boolean isVariableRef() {
        return false;
    }

    @Override
    public Address getMinAddress() {
        return this.blockaddr;
    }

    @Override
    public Address getMaxAddress() {
        return this.blockaddr;
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        super.restoreFromXML(el, end, pfactory);
        String name = el.getAttribute("space");
        AddressSpace spc = pfactory.getAddressFactory().getAddressSpace(name);
        long offset = SpecXmlUtils.decodeLong((String)el.getAttribute("off"));
        this.blockaddr = spc.getAddress(offset);
    }
}

