/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DecompilerUtils {
    public static Varnode getVarnodeRef(ClangToken vartoken) {
        Varnode res;
        if (vartoken == null) {
            return null;
        }
        if (vartoken instanceof ClangVariableToken && (res = vartoken.getVarnode()) != null) {
            return res;
        }
        ClangNode parent = vartoken.Parent();
        if (parent instanceof ClangVariableDecl) {
            HighVariable high = ((ClangVariableDecl)parent).getHighVariable();
            if ((parent = parent.Parent()) instanceof ClangFuncProto && high != null) {
                Varnode[] instances;
                for (Varnode instance : instances = high.getInstances()) {
                    if (!instance.isInput()) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    public static Set<Varnode> getForwardSlice(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn)) continue;
            Iterator it = curvn.getDescendants();
            while (it.hasNext()) {
                PcodeOp op = (PcodeOp)it.next();
                if (op == null || (curvn = op.getOutput()) == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
                worklist.add(curvn);
            }
        }
        return varnodes;
    }

    public static Set<Varnode> getBackwardSlice(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            PcodeOp op;
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn) || (op = curvn.getDef()) == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
            for (int j = 0; j < op.getNumInputs(); ++j) {
                curvn = op.getInput(j);
                if (curvn == null) continue;
                worklist.add(curvn);
            }
        }
        return varnodes;
    }

    public static Set<PcodeOp> getForwardSliceToPCodeOps(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        HashSet<PcodeOp> pcodeops = new HashSet<PcodeOp>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn)) continue;
            Iterator it = curvn.getDescendants();
            while (it.hasNext()) {
                PcodeOp op = (PcodeOp)it.next();
                if (op == null) continue;
                pcodeops.add(op);
                curvn = op.getOutput();
                if (curvn == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
                worklist.add(curvn);
            }
        }
        return pcodeops;
    }

    public static Set<PcodeOp> getBackwardSliceToPCodeOps(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        HashSet<PcodeOp> pcodeops = new HashSet<PcodeOp>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            PcodeOp op;
            Varnode curvn = (Varnode)worklist.get(i);
            worklist.get(i);
            if (!varnodes.add(curvn) || (op = curvn.getDef()) == null) continue;
            pcodeops.add(op);
            if (op.getOpcode() == 7 || op.getOpcode() == 8) continue;
            for (int j = 0; j < op.getNumInputs(); ++j) {
                Varnode input = op.getInput(j);
                if (input == null) continue;
                worklist.add(input);
            }
        }
        return pcodeops;
    }

    public static Function getFunction(Program program, ClangFuncNameToken token) {
        PcodeOp pcodeOp;
        ClangFunction clangFunction;
        ClangNode parent = token.Parent();
        if (parent instanceof ClangFuncProto && (clangFunction = parent.getClangFunction()) != null) {
            return clangFunction.getHighFunction().getFunction();
        }
        if (parent instanceof ClangStatement && (pcodeOp = token.getPcodeOp()) != null && pcodeOp.getOpcode() == 7) {
            Address functionAddr = pcodeOp.getInput(0).getAddress();
            return program.getFunctionManager().getReferencedFunction(functionAddr);
        }
        return null;
    }

    public static int findIndexOfFirstField(List<ClangToken> tokenlist, Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            ClangTextField f = (ClangTextField)fields[i];
            List<ClangToken> tokenList = f.getTokens();
            for (int j = 0; j < tokenList.size(); ++j) {
                ClangNode token = tokenList.get(j);
                if (!tokenlist.contains(token)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<ClangToken> getTokens(ClangNode root, AddressSetView addressSet) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        DecompilerUtils.collectTokens(tokenList, root, addressSet);
        return tokenList;
    }

    public static List<ClangToken> getTokens(ClangNode root, Address address) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        DecompilerUtils.collectTokens(tokenList, root, address);
        return tokenList;
    }

    private static void collectTokens(List<ClangToken> tokenList, ClangNode parentNode, Address address) {
        int nchild = parentNode.numChildren();
        for (int i = 0; i < nchild; ++i) {
            ClangToken token;
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                DecompilerUtils.collectTokens(tokenList, node, address);
                continue;
            }
            if (!(node instanceof ClangToken) || !DecompilerUtils.intersects(token = (ClangToken)node, address)) continue;
            tokenList.add((ClangToken)node);
        }
    }

    private static void collectTokens(List<ClangToken> tokenList, ClangNode parentNode, AddressSetView addressSet) {
        int nchild = parentNode.numChildren();
        for (int i = 0; i < nchild; ++i) {
            ClangToken token;
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                DecompilerUtils.collectTokens(tokenList, node, addressSet);
                continue;
            }
            if (!(node instanceof ClangToken) || !DecompilerUtils.intersects(token = (ClangToken)node, addressSet)) continue;
            tokenList.add((ClangToken)node);
        }
    }

    private static boolean intersects(ClangToken token, AddressSetView addressSet) {
        Address minAddress = token.getMinAddress();
        if (minAddress == null) {
            return false;
        }
        Address maxAddress = token.getMaxAddress();
        maxAddress = maxAddress == null ? minAddress : maxAddress;
        return addressSet.intersects(minAddress, maxAddress);
    }

    private static boolean intersects(ClangToken token, Address address) {
        Address minAddress = token.getMinAddress();
        if (minAddress == null) {
            return false;
        }
        Address maxAddress = token.getMaxAddress();
        if (maxAddress == null) {
            return minAddress.equals((Object)maxAddress);
        }
        return address.compareTo((Object)minAddress) >= 0 && address.compareTo((Object)maxAddress) <= 0;
    }

    public static Address getClosestAddress(ClangToken token) {
        Address address = token.getMinAddress();
        if (address != null) {
            return address;
        }
        ClangToken addressedToken = DecompilerUtils.findClosestAddressedToken(token);
        if (addressedToken == null) {
            return null;
        }
        return addressedToken.getMinAddress();
    }

    public static AddressSet findClosestAddressSet(Program program, AddressSpace functionSpace, List<ClangToken> tokenList) {
        AddressSet addressSet = new AddressSet();
        for (int i = 0; i < tokenList.size(); ++i) {
            ClangToken tok = tokenList.get(i);
            DecompilerUtils.addTokenAddressRangeToSet(addressSet, tok, functionSpace);
        }
        if (addressSet.isEmpty()) {
            ClangLine lastLine = null;
            for (ClangToken token : tokenList) {
                if (token.getLineParent() == lastLine) continue;
                lastLine = token.getLineParent();
                token = DecompilerUtils.findClosestAddressedToken(token);
                DecompilerUtils.addTokenAddressRangeToSet(addressSet, token, functionSpace);
            }
        }
        return addressSet;
    }

    private static void addTokenAddressRangeToSet(AddressSet addrs, ClangToken token, AddressSpace space) {
        if (token == null || token.getMinAddress() == null) {
            return;
        }
        Address minAddress = token.getMinAddress();
        Address maxAddress = token.getMaxAddress();
        maxAddress = maxAddress == null ? minAddress : maxAddress;
        minAddress = space.getOverlayAddress(minAddress);
        maxAddress = space.getOverlayAddress(maxAddress);
        addrs.addRange(minAddress, maxAddress);
    }

    private static ClangToken findClosestAddressedToken(ClangToken token) {
        int i;
        if (token == null) {
            return null;
        }
        if (token.getMinAddress() != null) {
            return token;
        }
        ArrayList<ClangToken> lineTokens = token.getLineParent().getAllTokens();
        int tokIndex = -1;
        int lastIndex = lineTokens.size() - 1;
        for (i = 0; i <= lastIndex; ++i) {
            if (lineTokens.get(i) != token) continue;
            tokIndex = i;
            break;
        }
        if (tokIndex != -1) {
            ClangToken tok;
            for (i = tokIndex + 1; i <= lastIndex; ++i) {
                tok = (ClangToken)lineTokens.get(i);
                if (tok.getMinAddress() == null) continue;
                return tok;
            }
            for (i = tokIndex - 1; i >= 0; --i) {
                tok = (ClangToken)lineTokens.get(i);
                if (tok.getMinAddress() == null) continue;
                return tok;
            }
        }
        return null;
    }

    public static FieldSelection getFieldSelection(List<ClangToken> tokens) {
        FieldSelection fieldSelection = new FieldSelection();
        for (ClangToken clangToken : tokens) {
            ClangLine lineParent = clangToken.getLineParent();
            int lineNumber = lineParent.getLineNumber();
            fieldSelection.addRange(lineNumber - 1, lineNumber);
        }
        return fieldSelection;
    }

    public static List<ClangToken> getTokensInSelection(FieldSelection selection, Field[] lines) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange subSelectionRange = selection.getFieldRange(i);
            DecompilerUtils.addTokensInSelectionRange(tokenList, subSelectionRange, lines);
        }
        return tokenList;
    }

    private static void addTokensInSelectionRange(List<ClangToken> tokenList, FieldRange selectionRange, Field[] lines) {
        FieldLocation end;
        FieldLocation start = selectionRange.getStart();
        if (start.equals((Object)(end = selectionRange.getEnd()))) {
            return;
        }
        if (start.getIndex().intValue() == end.getIndex().intValue()) {
            DecompilerUtils.addTokens(tokenList, lines, start.getIndex().intValue(), start, end);
        } else {
            DecompilerUtils.addTokens(tokenList, lines, start.getIndex().intValue(), start, null);
            for (int i = start.getIndex().intValue() + 1; i < end.getIndex().intValue(); ++i) {
                DecompilerUtils.addTokens(tokenList, lines, i, null, null);
            }
            DecompilerUtils.addTokens(tokenList, lines, end.getIndex().intValue(), null, end);
        }
    }

    private static void addTokens(List<ClangToken> tokenList, Field[] lines, int lineNumber, FieldLocation start, FieldLocation end) {
        if (lineNumber >= lines.length) {
            return;
        }
        ClangTextField textLine = (ClangTextField)lines[lineNumber];
        int startIndex = DecompilerUtils.getStartIndex(textLine, start);
        int endIndex = DecompilerUtils.getEndIndex(textLine, end);
        tokenList.addAll(textLine.getTokens().subList(startIndex, endIndex));
    }

    private static int getStartIndex(ClangTextField textLine, FieldLocation location) {
        if (location == null) {
            return 0;
        }
        int tokenIndex = textLine.getTokenIndex(location);
        return tokenIndex;
    }

    private static int getEndIndex(ClangTextField textLine, FieldLocation location) {
        if (location == null) {
            return textLine.getTokens().size();
        }
        if (location.row == 0 && location.col == 0) {
            return 0;
        }
        int nextTokenIndex = textLine.getNextTokenIndexStartingAfter(location);
        return nextTokenIndex;
    }

    public static Address findAddressBefore(Field[] lines, ClangToken token) {
        ClangLine lineParent = token.getLineParent();
        int lineNumber = lineParent.getLineNumber();
        for (int i = lineNumber - 1; i >= 0; --i) {
            ClangTextField textLine = (ClangTextField)lines[i];
            List<ClangToken> tokens = textLine.getTokens();
            ClangToken addressedToken = DecompilerUtils.findClosestAddressedToken(tokens.get(0));
            if (addressedToken == null) continue;
            return addressedToken.getMinAddress();
        }
        return null;
    }

    public static ArrayList<ClangLine> toLines(ClangTokenGroup group) {
        ClangLine current;
        ClangBreak brk;
        ArrayList<ClangNode> alltoks = new ArrayList<ClangNode>();
        group.flatten(alltoks);
        if (alltoks.isEmpty()) {
            return new ArrayList<ClangLine>();
        }
        int i = 0;
        int lineNumber = 1;
        ArrayList<ClangLine> lines = new ArrayList<ClangLine>();
        if (alltoks.get(0) instanceof ClangBreak) {
            brk = (ClangBreak)alltoks.get(0);
            current = new ClangLine(lineNumber++, brk.getIndent());
            ++i;
        } else {
            current = new ClangLine(lineNumber++, 0);
        }
        while (i < alltoks.size()) {
            ClangToken tok = (ClangToken)alltoks.get(i);
            if (tok instanceof ClangBreak) {
                lines.add(current);
                brk = (ClangBreak)tok;
                current = new ClangLine(lineNumber++, brk.getIndent());
            } else {
                tok.setLineParent(current);
                current.addToken(tok);
            }
            ++i;
        }
        lines.add(current);
        return lines;
    }
}

