/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.jung.JungDirectedGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import util.CollectionUtils;

public class MutableGDirectedGraphWrapper<V, E extends GEdge<V>>
implements GDirectedGraph<V, E> {
    private GDirectedGraph<V, E> delegate;
    private GDirectedGraph<Object, DefaultGEdge<Object>> mutatedGraph;

    public MutableGDirectedGraphWrapper(GDirectedGraph<V, E> delegate) {
        this.delegate = delegate;
        this.mutatedGraph = new JungDirectedGraph<Object, DefaultGEdge<Object>>();
    }

    public V addDummyVertex(String name) {
        DummyVertex v = new DummyVertex(name);
        this.mutatedGraph.addVertex(v);
        return (V)v;
    }

    public boolean isDummy(V v) {
        return v instanceof DummyVertex;
    }

    public boolean isDummy(E e) {
        return e instanceof DummyEdge;
    }

    public E addDummyEdge(V start, V end) {
        DummyEdge e = new DummyEdge((Object)start, (Object)end);
        this.mutatedGraph.addEdge(e);
        return (E)e;
    }

    @Override
    public boolean addVertex(V v) {
        return this.mutatedGraph.addVertex(v);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.delegate.containsVertex(v)) {
            throw new UnsupportedOperationException();
        }
        return this.mutatedGraph.removeVertex(v);
    }

    @Override
    public void removeVertices(Iterable<V> vertices) {
        vertices.forEach(v -> this.removeVertex(v));
    }

    @Override
    public void removeEdges(Iterable<E> edges) {
        edges.forEach(e -> this.removeEdge(e));
    }

    @Override
    public void addEdge(E e) {
        this.mutatedGraph.addEdge((DefaultGEdge)e);
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.delegate.containsEdge(e)) {
            throw new UnsupportedOperationException();
        }
        return this.mutatedGraph.removeEdge((DefaultGEdge)e);
    }

    @Override
    public Collection<V> getVertices() {
        Set set = this.callOnBothGraphs(GDirectedGraph::getVertices);
        return set;
    }

    @Override
    public Collection<E> getEdges() {
        Set set = this.callOnBothGraphs(GDirectedGraph::getEdges);
        return set;
    }

    @Override
    public boolean containsVertex(V v) {
        return this.delegate.containsVertex(v) || this.mutatedGraph.containsVertex(v);
    }

    @Override
    public boolean containsEdge(E e) {
        return this.delegate.containsEdge(e) || this.mutatedGraph.containsEdge((DefaultGEdge)e);
    }

    @Override
    public boolean containsEdge(V from, V to) {
        return this.delegate.containsEdge(from, to) || this.mutatedGraph.containsEdge(from, to);
    }

    @Override
    public E findEdge(V start, V end) {
        DefaultGEdge<Object> e = this.mutatedGraph.findEdge(start, end);
        if (e != null) {
            return (E)e;
        }
        return this.delegate.findEdge(start, end);
    }

    @Override
    public boolean isEmpty() {
        return this.getVertexCount() == 0;
    }

    @Override
    public int getVertexCount() {
        return this.delegate.getVertexCount() + this.mutatedGraph.getVertexCount();
    }

    @Override
    public int getEdgeCount() {
        return this.delegate.getEdgeCount() + this.mutatedGraph.getEdgeCount();
    }

    @Override
    public Collection<E> getInEdges(V v) {
        Set set = this.callOnBothGraphs(GDirectedGraph::getInEdges, v);
        return set;
    }

    @Override
    public Collection<E> getOutEdges(V v) {
        Set set = this.callOnBothGraphs(GDirectedGraph::getOutEdges, v);
        return set;
    }

    @Override
    public Collection<V> getPredecessors(V v) {
        Set set = this.callOnBothGraphs(GDirectedGraph::getPredecessors, v);
        return set;
    }

    @Override
    public Collection<V> getSuccessors(V v) {
        Set set = this.callOnBothGraphs(GDirectedGraph::getSuccessors, v);
        return set;
    }

    @Override
    public GDirectedGraph<V, E> copy() {
        MutableGDirectedGraphWrapper<V, E> copy = new MutableGDirectedGraphWrapper<V, E>(this.delegate.copy());
        for (Object object : this.mutatedGraph.getVertices()) {
            copy.mutatedGraph.addVertex(object);
        }
        for (DefaultGEdge defaultGEdge : this.mutatedGraph.getEdges()) {
            copy.mutatedGraph.addEdge(defaultGEdge);
        }
        return copy;
    }

    @Override
    public GDirectedGraph<V, E> emptyCopy() {
        return this.delegate.emptyCopy();
    }

    private <R> Set<R> callOnBothGraphs(Function<GDirectedGraph<V, E>, Collection<R>> f) {
        HashSet set = new HashSet();
        set.addAll(CollectionUtils.nonNull(f.apply(this.mutatedGraph)));
        set.addAll(CollectionUtils.nonNull(f.apply(this.delegate)));
        return set;
    }

    private <R> Set<R> callOnBothGraphs(BiFunction<GDirectedGraph<V, E>, V, Collection<R>> f, V v) {
        HashSet set = new HashSet();
        set.addAll(CollectionUtils.nonNull(f.apply(this.mutatedGraph, v)));
        set.addAll(CollectionUtils.nonNull(f.apply(this.delegate, v)));
        return set;
    }

    public static class DummyEdge
    extends DefaultGEdge<Object> {
        public DummyEdge(Object start, Object end) {
            super(start, end);
        }
    }

    private static class DummyVertex {
        private String name;

        public DummyVertex(String name) {
            this.name = name;
        }

        public String toString() {
            return "Dummy " + this.name;
        }
    }
}

