/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.line;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.properties.CompoundLineProperty;
import com.jeta.forms.store.properties.LineProperty;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.JComponent;

public abstract class LineComponent
extends JComponent {
    private boolean m_design_mode = false;
    private CompoundLineProperty m_prop = new CompoundLineProperty();
    private Dimension m_pref_size;

    public LineComponent() {
        this.m_prop.addLine(new LineProperty());
        this.m_design_mode = FormUtils.isDesignMode();
    }

    public CompoundLineProperty getLineDefinition() {
        return this.m_prop;
    }

    public int getPosition() {
        return this.m_prop.getPosition();
    }

    public Dimension getPreferredSize() {
        if (this.m_pref_size == null) {
            if (this.isHorizontal()) {
                int n = 0;
                int n2 = 0;
                if (this.m_prop != null) {
                    n2 = this.getThickness();
                }
                if (n == 0) {
                    n = 10;
                }
                if (n2 == 0) {
                    n2 = 1;
                }
                this.m_pref_size = new Dimension(n, n2);
            } else {
                int n = 0;
                int n3 = 0;
                if (this.m_prop != null) {
                    n = this.getThickness();
                }
                if (n == 0) {
                    n = 1;
                }
                if (n3 == 0) {
                    n3 = 10;
                }
                this.m_pref_size = new Dimension(n, n3);
            }
        }
        return this.m_pref_size;
    }

    public int getThickness() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LineProperty lineProperty = (LineProperty)iterator.next();
            n += lineProperty.getThickness();
        }
        return n;
    }

    boolean isDesignMode() {
        return this.m_design_mode;
    }

    public abstract boolean isHorizontal();

    public Iterator iterator() {
        return this.m_prop.iterator();
    }

    public void setLineDefinition(CompoundLineProperty compoundLineProperty) {
        this.m_prop = compoundLineProperty;
        this.m_pref_size = null;
        this.revalidate();
        this.repaint();
    }

    public void setLineDefinitionEx(LineProperty lineProperty) {
        this.setLineDefinition(new CompoundLineProperty(lineProperty));
    }

    public void print() {
        System.out.println("LineComponent.....................");
        this.m_prop.print();
    }

    public void setPosition(int n) {
        this.m_prop.setPosition(n);
    }
}

