/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import java.io.File;
import utility.module.ModuleUtilities;

public class TestApplicationUtils {
    public static File getTestApplicationRootDirectory() {
        File repo = TestApplicationUtils.getCurrentRepoDirectory();
        return new File(repo, "Ghidra");
    }

    public static File getCurrentRepoDirectory() {
        String userDir = System.getProperty("user.dir");
        File repo = ModuleUtilities.findRepo((File)new File(userDir));
        return repo;
    }

    public static File getRepoContainerDirectory() {
        File repo = TestApplicationUtils.getCurrentRepoDirectory();
        File repoContainer = repo.getParentFile();
        return repoContainer;
    }

    public static File getUniqueTempFolder() {
        File reposContainer = TestApplicationUtils.getRepoContainerDirectory();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String tempName = tmpDir.getName();
        String name = reposContainer.getName() + tempName;
        return new File(tmpDir, name);
    }
}

