/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.NoSuchIndexException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class LongRedBlackTree
implements Serializable {
    private transient RBNode root;
    private transient int size;
    private transient long modification = 0L;
    private static final byte RED = 0;
    private static final byte BLACK = 1;

    public int size() {
        return this.size;
    }

    public boolean containsKey(long key) {
        RBNode node = this.root;
        while (node != null) {
            if (key == node.key) {
                return true;
            }
            if (key < node.key) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return false;
    }

    public Object get(long key) {
        RBNode node = this.root;
        while (node != null) {
            if (key == node.key) {
                return node.value;
            }
            if (key < node.key) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return null;
    }

    public Object getAtOrAfter(long key) {
        Object bestValue = null;
        RBNode node = this.root;
        while (node != null) {
            if (key == node.key) {
                return node.value;
            }
            if (key > node.key) {
                node = node.right;
                continue;
            }
            bestValue = node.value;
            node = node.left;
        }
        return bestValue;
    }

    public Object getAtOrBefore(long key) {
        Object bestValue = null;
        RBNode node = this.root;
        while (node != null) {
            if (key == node.key) {
                return node.value;
            }
            if (key <= node.key) {
                node = node.left;
                continue;
            }
            bestValue = node.value;
            node = node.right;
        }
        return bestValue;
    }

    public long getFirst() throws NoSuchIndexException {
        if (this.root == null) {
            throw NoSuchIndexException.noSuchIndexException;
        }
        RBNode node = this.root;
        while (node.left != null) {
            node = node.left;
        }
        return node.key;
    }

    public long getLast() throws NoSuchIndexException {
        if (this.root == null) {
            throw NoSuchIndexException.noSuchIndexException;
        }
        RBNode node = this.root;
        while (node.right != null) {
            node = node.right;
        }
        return node.key;
    }

    public long getNext(long key) throws NoSuchIndexException {
        boolean foundValue = false;
        long bestkey = Long.MIN_VALUE;
        RBNode node = this.root;
        while (node != null) {
            if (key >= node.key) {
                node = node.right;
                continue;
            }
            foundValue = true;
            bestkey = node.key;
            node = node.left;
        }
        if (foundValue) {
            return bestkey;
        }
        throw NoSuchIndexException.noSuchIndexException;
    }

    public long getPrevious(long key) throws NoSuchIndexException {
        boolean foundValue = false;
        long bestkey = 0L;
        RBNode node = this.root;
        while (node != null) {
            if (key <= node.key) {
                node = node.left;
                continue;
            }
            foundValue = true;
            bestkey = node.key;
            node = node.right;
        }
        if (foundValue) {
            return bestkey;
        }
        throw NoSuchIndexException.noSuchIndexException;
    }

    public void put(long key, Object obj) {
        ++this.modification;
        if (this.root == null) {
            ++this.size;
            this.root = new RBNode(key, obj, null);
        }
        RBNode node = this.root;
        while (true) {
            if (key == node.key) {
                node.value = obj;
                return;
            }
            if (key < node.key) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                ++this.size;
                node.left = new RBNode(key, obj, node);
                this.fixAfterInsertion(node.left);
                return;
            }
            if (node.right == null) break;
            node = node.right;
        }
        ++this.size;
        node.right = new RBNode(key, obj, node);
        this.fixAfterInsertion(node.right);
    }

    public Object remove(long key) {
        ++this.modification;
        RBNode node = this.root;
        while (node != null && key != node.key) {
            if (key < node.key) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        if (node == null) {
            return null;
        }
        Object obj = node.value;
        --this.size;
        this.deleteEntry(node);
        return obj;
    }

    public void removeAll() {
        ++this.modification;
        this.size = 0;
        this.root = null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator<?> iterator() {
        return new LongRedBlackTreeIterator();
    }

    private static byte colorOf(RBNode p) {
        return p == null ? (byte)1 : p.color;
    }

    private static RBNode parentOf(RBNode p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(RBNode p, byte c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static RBNode leftOf(RBNode p) {
        return p == null ? null : p.left;
    }

    private static RBNode rightOf(RBNode p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(RBNode p) {
        RBNode r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(RBNode p) {
        RBNode l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(RBNode x) {
        x.color = 0;
        while (x != null && x != this.root && x.parent.color == 0) {
            RBNode y;
            if (LongRedBlackTree.parentOf(x) == LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)))) {
                y = LongRedBlackTree.rightOf(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)));
                if (LongRedBlackTree.colorOf(y) == 0) {
                    LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
                    LongRedBlackTree.setColor(y, (byte)1);
                    LongRedBlackTree.setColor(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)), (byte)0);
                    x = LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x));
                    continue;
                }
                if (x == LongRedBlackTree.rightOf(LongRedBlackTree.parentOf(x))) {
                    x = LongRedBlackTree.parentOf(x);
                    this.rotateLeft(x);
                }
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)), (byte)0);
                if (LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)) == null) continue;
                this.rotateRight(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)));
                continue;
            }
            y = LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)));
            if (LongRedBlackTree.colorOf(y) == 0) {
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
                LongRedBlackTree.setColor(y, (byte)1);
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)), (byte)0);
                x = LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x));
                continue;
            }
            if (x == LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(x))) {
                x = LongRedBlackTree.parentOf(x);
                this.rotateRight(x);
            }
            LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
            LongRedBlackTree.setColor(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)), (byte)0);
            if (LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)) == null) continue;
            this.rotateLeft(LongRedBlackTree.parentOf(LongRedBlackTree.parentOf(x)));
        }
        this.root.color = 1;
    }

    private void deleteEntry(RBNode p) {
        RBNode replacement;
        if (p.left != null && p.right != null) {
            RBNode s = null;
            RBNode node = this.root;
            while (node != null) {
                if (p.key >= node.key) {
                    node = node.right;
                    continue;
                }
                s = node;
                node = node.left;
            }
            this.swapPosition(s, p);
        }
        RBNode rBNode = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color == 1) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color == 1) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(RBNode x) {
        while (x != this.root && LongRedBlackTree.colorOf(x) == 1) {
            RBNode sib;
            if (x == LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(x))) {
                sib = LongRedBlackTree.rightOf(LongRedBlackTree.parentOf(x));
                if (LongRedBlackTree.colorOf(sib) == 0) {
                    LongRedBlackTree.setColor(sib, (byte)1);
                    LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)0);
                    this.rotateLeft(LongRedBlackTree.parentOf(x));
                    sib = LongRedBlackTree.rightOf(LongRedBlackTree.parentOf(x));
                }
                if (LongRedBlackTree.colorOf(LongRedBlackTree.leftOf(sib)) == 1 && LongRedBlackTree.colorOf(LongRedBlackTree.rightOf(sib)) == 1) {
                    LongRedBlackTree.setColor(sib, (byte)0);
                    x = LongRedBlackTree.parentOf(x);
                    continue;
                }
                if (LongRedBlackTree.colorOf(LongRedBlackTree.rightOf(sib)) == 1) {
                    LongRedBlackTree.setColor(LongRedBlackTree.leftOf(sib), (byte)1);
                    LongRedBlackTree.setColor(sib, (byte)0);
                    this.rotateRight(sib);
                    sib = LongRedBlackTree.rightOf(LongRedBlackTree.parentOf(x));
                }
                LongRedBlackTree.setColor(sib, LongRedBlackTree.colorOf(LongRedBlackTree.parentOf(x)));
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
                LongRedBlackTree.setColor(LongRedBlackTree.rightOf(sib), (byte)1);
                this.rotateLeft(LongRedBlackTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(x));
            if (LongRedBlackTree.colorOf(sib) == 0) {
                LongRedBlackTree.setColor(sib, (byte)1);
                LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)0);
                this.rotateRight(LongRedBlackTree.parentOf(x));
                sib = LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(x));
            }
            if (LongRedBlackTree.colorOf(LongRedBlackTree.rightOf(sib)) == 1 && LongRedBlackTree.colorOf(LongRedBlackTree.leftOf(sib)) == 1) {
                LongRedBlackTree.setColor(sib, (byte)0);
                x = LongRedBlackTree.parentOf(x);
                continue;
            }
            if (LongRedBlackTree.colorOf(LongRedBlackTree.leftOf(sib)) == 1) {
                LongRedBlackTree.setColor(LongRedBlackTree.rightOf(sib), (byte)1);
                LongRedBlackTree.setColor(sib, (byte)0);
                this.rotateLeft(sib);
                sib = LongRedBlackTree.leftOf(LongRedBlackTree.parentOf(x));
            }
            LongRedBlackTree.setColor(sib, LongRedBlackTree.colorOf(LongRedBlackTree.parentOf(x)));
            LongRedBlackTree.setColor(LongRedBlackTree.parentOf(x), (byte)1);
            LongRedBlackTree.setColor(LongRedBlackTree.leftOf(sib), (byte)1);
            this.rotateRight(LongRedBlackTree.parentOf(x));
            x = this.root;
        }
        LongRedBlackTree.setColor(x, (byte)1);
    }

    private void swapPosition(RBNode x, RBNode y) {
        boolean yWasLeftChild;
        RBNode px = x.parent;
        RBNode lx = x.left;
        RBNode rx = x.right;
        RBNode py = y.parent;
        RBNode ly = y.left;
        RBNode ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        byte c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        if (this.root != null) {
            this.writeInOrder(s, this.root);
        }
    }

    private void writeInOrder(ObjectOutputStream s, RBNode node) throws IOException {
        if (node.left != null) {
            this.writeInOrder(s, node.left);
        }
        s.writeLong(node.key);
        s.writeObject(node.value);
        if (node.right != null) {
            this.writeInOrder(s, node.right);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = s.readInt();
        this.root = LongRedBlackTree.buildFromSorted(0, 0, this.size - 1, LongRedBlackTree.computeRedLevel(this.size), s);
    }

    private static RBNode buildFromSorted(int level, int lo, int hi, int redLevel, ObjectInputStream str) throws IOException, ClassNotFoundException {
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        RBNode left = null;
        if (lo < mid) {
            left = LongRedBlackTree.buildFromSorted(level + 1, lo, mid - 1, redLevel, str);
        }
        long key = str.readLong();
        Object value = str.readObject();
        RBNode middle = new RBNode(key, value, null);
        if (level == redLevel) {
            middle.color = 0;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            RBNode right;
            middle.right = right = LongRedBlackTree.buildFromSorted(level + 1, mid + 1, hi, redLevel, str);
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    class LongRedBlackTreeIterator
    implements Iterator<Object> {
        private long mod;
        private RBNode cur;

        public LongRedBlackTreeIterator() {
            this.mod = LongRedBlackTree.this.modification;
            this.cur = LongRedBlackTree.this.root;
            if (LongRedBlackTree.this.root == null) {
                return;
            }
            while (this.cur.left != null) {
                this.cur = this.cur.left;
            }
        }

        @Override
        public boolean hasNext() {
            if (LongRedBlackTree.this.modification != this.mod) {
                throw new ConcurrentModificationException();
            }
            return this.cur != null;
        }

        @Override
        public Object next() {
            if (LongRedBlackTree.this.modification != this.mod) {
                throw new ConcurrentModificationException();
            }
            if (this.cur == null) {
                return null;
            }
            Object obj = this.cur.value;
            this.findNext();
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            if (this.cur.right != null) {
                this.cur = this.cur.right;
                while (this.cur.left != null) {
                    this.cur = this.cur.left;
                }
                return;
            }
            RBNode child = this.cur;
            this.cur = this.cur.parent;
            while (this.cur != null) {
                if (this.cur.left == child) {
                    return;
                }
                child = this.cur;
                this.cur = this.cur.parent;
            }
        }
    }

    static class RBNode {
        long key;
        Object value;
        byte color;
        RBNode parent;
        RBNode left;
        RBNode right;

        RBNode(long key, Object value, RBNode parent) {
            this.key = key;
            this.color = 1;
            this.parent = parent;
            this.value = value;
        }
    }
}

