/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.stream;

import db.buffers.BlockStream;
import db.buffers.BlockStreamHandle;
import db.buffers.BufferFileBlock;
import db.buffers.InputBlockStream;
import ghidra.server.stream.BlockStreamServer;
import ghidra.server.stream.RemoteBlockStreamHandle;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class RemoteInputBlockStreamHandle
extends RemoteBlockStreamHandle<InputBlockStream>
implements BlockStreamHandle<InputBlockStream> {
    public static final long serialVersionUID = 1L;
    private boolean includesHeaderBlock;

    public RemoteInputBlockStreamHandle(BlockStreamServer server, InputBlockStream inputBlockStream) throws IOException {
        super(server, inputBlockStream.getBlockCount(), inputBlockStream.getBlockSize());
        this.includesHeaderBlock = inputBlockStream.includesHeaderBlock();
    }

    public InputBlockStream openBlockStream() throws IOException {
        Socket socket = this.connect();
        socket.setReceiveBufferSize(this.getPreferredBufferSize());
        return new ClientInputBlockStream(socket);
    }

    @Override
    void serveBlockStream(Socket socket, BlockStream blockStream) throws IOException {
        if (!(blockStream instanceof InputBlockStream)) {
            throw new IllegalArgumentException("expected InputBlockStream");
        }
        socket.setSendBufferSize(this.getPreferredBufferSize());
        InputBlockStream inputBlockStream = (InputBlockStream)blockStream;
        try (OutputStream out = socket.getOutputStream();){
            this.copyBlockData(inputBlockStream, out);
            this.writeStreamEnd(socket);
            this.readStreamEnd(socket, false);
        }
        catch (SocketException e) {
            if (e.getMessage().startsWith("Broken pipe")) {
                throw new EOFException("unexpected end of stream");
            }
            throw e;
        }
    }

    private void copyBlockData(InputBlockStream inputBlockStream, OutputStream out) throws IOException {
        BufferFileBlock block;
        if (this.compressed) {
            out = new DeflaterOutputStream(out, new Deflater(1));
        }
        int blocksRemaining = this.getBlockCount();
        while ((block = inputBlockStream.readBlock()) != null) {
            if (blocksRemaining == 0) {
                throw new IOException("unexpected data in stream");
            }
            out.write(block.toBytes());
            --blocksRemaining;
        }
        if (out instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)out).finish();
        }
    }

    private class ClientInputBlockStream
    implements InputBlockStream {
        private final Socket socket;
        private final InputStream in;
        private int blocksRemaining = this.getBlockCount();

        ClientInputBlockStream(Socket socket) throws IOException {
            this.socket = socket;
            this.in = RemoteInputBlockStreamHandle.this.compressed ? new InflaterInputStream(socket.getInputStream()) : socket.getInputStream();
        }

        public void close() throws IOException {
            this.socket.getInputStream().close();
            this.socket.close();
        }

        public BufferFileBlock readBlock() throws IOException {
            int readlen;
            if (this.blocksRemaining == 0) {
                return null;
            }
            byte[] bytes = new byte[this.getBlockSize() + 4];
            for (int total = 0; total < bytes.length; total += readlen) {
                readlen = this.in.read(bytes, total, bytes.length - total);
                if (readlen >= 0) continue;
                throw new EOFException("unexpected end of stream");
            }
            if (--this.blocksRemaining == 0) {
                if (RemoteInputBlockStreamHandle.this.compressed && this.in.read() != -1) {
                    throw new IOException("expected end of compressed stream");
                }
                RemoteInputBlockStreamHandle.this.readStreamEnd(this.socket, true);
                RemoteInputBlockStreamHandle.this.writeStreamEnd(this.socket);
            }
            return new BufferFileBlock(bytes);
        }

        public boolean includesHeaderBlock() {
            return RemoteInputBlockStreamHandle.this.includesHeaderBlock;
        }

        public int getBlockCount() {
            return RemoteInputBlockStreamHandle.this.getBlockCount();
        }

        public int getBlockSize() {
            return RemoteInputBlockStreamHandle.this.getBlockSize();
        }
    }
}

