/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDetailsPanel
extends JPanel {
    protected static final int LEFT_COLUMN_WIDTH = 150;
    protected static final int RIGHT_MARGIN = 30;
    protected static SimpleAttributeSet titleAttrSet;
    protected JLabel textLabel;
    protected Font defaultFont;
    protected JScrollPane sp;

    protected abstract void createFieldAttributes();

    protected SimpleAttributeSet createAttributeSet(String fontFamily, int fontSize, boolean bold, Color color) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        attrSet.addAttribute(StyleConstants.FontFamily, fontFamily);
        attrSet.addAttribute(StyleConstants.FontSize, new Integer(fontSize));
        attrSet.addAttribute(StyleConstants.Bold, bold);
        attrSet.addAttribute(StyleConstants.Foreground, color);
        return attrSet;
    }

    protected SimpleAttributeSet createAttributeSet(Color color) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        attrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        attrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        attrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        attrSet.addAttribute(StyleConstants.Foreground, color);
        return attrSet;
    }

    protected void clear() {
        this.textLabel.setText("");
    }

    protected void createMainPanel() {
        this.setLayout(new BorderLayout());
        this.textLabel = new JLabel("");
        this.textLabel.setVerticalAlignment(1);
        this.textLabel.setOpaque(true);
        this.textLabel.setBackground(Color.WHITE);
        this.sp = new JScrollPane(this.textLabel);
        this.sp.getVerticalScrollBar().setUnitIncrement(10);
        this.sp.setPreferredSize(new Dimension(700, 200));
        this.add((Component)this.sp, "Center");
        this.defaultFont = new Font("Tahoma", 1, 12);
    }

    protected void insertRowTitle(StringBuilder buffer, String rowName) {
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(rowName + ":", titleAttrSet, buffer);
        buffer.append("</TD>");
    }

    protected void insertRowValue(StringBuilder buffer, String value, SimpleAttributeSet attrSet) {
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(value, attrSet, buffer);
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    protected void insertHTMLString(String string, SimpleAttributeSet attributeSet, StringBuilder buffer) {
        if (string == null) {
            return;
        }
        buffer.append("<FONT COLOR=\"#");
        Color foregroundColor = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        buffer.append(this.createColorString(foregroundColor));
        buffer.append("\" FACE=\"");
        buffer.append(attributeSet.getAttribute(StyleConstants.FontFamily).toString());
        buffer.append("\">");
        Boolean isBold = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
        Boolean bl = isBold = isBold == null ? Boolean.FALSE : isBold;
        if (isBold.booleanValue()) {
            buffer.append("<B>");
        }
        buffer.append(string);
        if (isBold.booleanValue()) {
            buffer.append("</B>");
        }
        buffer.append("</FONT>");
    }

    protected void insertHTMLLine(String string, SimpleAttributeSet attributeSet, StringBuilder buffer) {
        if (string == null) {
            return;
        }
        this.insertHTMLString(string, attributeSet, buffer);
        buffer.append("<BR>");
    }

    protected String createColorString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return StringUtils.leftPad((String)Integer.toHexString(red), (int)2, (String)"0") + StringUtils.leftPad((String)Integer.toHexString(green), (int)2, (String)"0") + StringUtils.leftPad((String)Integer.toHexString(blue), (int)2, (String)"0");
    }

    protected String formatDescription(String descr) {
        int maxWidth;
        if (descr == null) {
            return "";
        }
        int remainingWidth = maxWidth = this.getMaxStringWidth();
        FontMetrics fm = this.textLabel.getFontMetrics(this.defaultFont);
        int spaceSize = fm.charWidth(' ');
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(descr, " ");
        while (st.hasMoreTokens()) {
            int strWidth;
            Object str = st.nextToken();
            if (((String)str).endsWith(".")) {
                str = (String)str + "  ";
            }
            if ((strWidth = fm.stringWidth((String)str)) + spaceSize <= remainingWidth) {
                sb.append(" ");
                sb.append((String)str);
                remainingWidth -= strWidth + spaceSize;
                continue;
            }
            sb.append("<BR>");
            sb.append((String)str + " ");
            remainingWidth = maxWidth - strWidth;
        }
        return sb.toString();
    }

    protected int getMaxStringWidth() {
        int width = this.textLabel.getWidth();
        if (width == 0) {
            width = 700;
        }
        return width -= 180;
    }
}

