/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    protected final Writer writer;
    protected final char[] buffer = new char[16];
    protected int indentLevel = 0;
    private boolean beginningOfLine = true;
    private static final String newLine = System.getProperty("line.separator");

    public IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    protected void writeLineStart() throws IOException {
    }

    protected void writeIndent() throws IOException {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.write(32);
        }
    }

    @Override
    public void write(int chr) throws IOException {
        if (this.beginningOfLine) {
            this.writeLineStart();
        }
        if (chr == 10) {
            this.writer.write(newLine);
            this.beginningOfLine = true;
        } else {
            if (this.beginningOfLine) {
                this.writeIndent();
            }
            this.beginningOfLine = false;
            this.writer.write(chr);
        }
    }

    @Override
    public void write(char[] chars) throws IOException {
        for (char chr : chars) {
            this.write(chr);
        }
    }

    @Override
    public void write(char[] chars, int start, int len) throws IOException {
        len = start + len;
        while (start < len) {
            this.write(chars[start++]);
        }
    }

    @Override
    public void write(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void write(String str, int start, int len) throws IOException {
        len = start + len;
        while (start < len) {
            this.write(str.charAt(start++));
        }
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.write(((Object)charSequence).toString());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int start, int len) throws IOException {
        this.write(((Object)charSequence.subSequence(start, len)).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void indent(int indentAmount) {
        this.indentLevel += indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void deindent(int indentAmount) {
        this.indentLevel -= indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void printUnsignedLongAsHex(long value) throws IOException {
        int bufferIndex = 0;
        do {
            int digit;
            this.buffer[bufferIndex++] = (digit = (int)(value & 0xFL)) < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97);
        } while ((value >>>= 4) != 0L);
        while (bufferIndex > 0) {
            this.write(this.buffer[--bufferIndex]);
        }
    }

    public void printSignedIntAsDec(int value) throws IOException {
        int bufferIndex = 0;
        if (value < 0) {
            value *= -1;
            this.write(45);
        }
        do {
            int digit = value % 10;
            this.buffer[bufferIndex++] = (char)(digit + 48);
        } while ((value /= 10) != 0);
        while (bufferIndex > 0) {
            this.write(this.buffer[--bufferIndex]);
        }
    }
}

