/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import docking.widgets.OptionDialog;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.ApplyDataTypes;
import ghidra.app.util.bin.format.pdb.ApplyEnums;
import ghidra.app.util.bin.format.pdb.ApplyFunctions;
import ghidra.app.util.bin.format.pdb.ApplyTables;
import ghidra.app.util.bin.format.pdb.ApplyTypeDefs;
import ghidra.app.util.bin.format.pdb.PdbErrorHandler;
import ghidra.app.util.bin.format.pdb.PdbErrorReaderThread;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbProgramAttributes;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PdbParserNEW {
    private static final String PDB_EXE = "pdb.exe";
    private static final String README_FILENAME = Application.getInstallationDirectory() + "\\docs\\README_PDB.html";
    public static final File SPECIAL_PDB_LOCATION = new File("C:/WINDOWS/Symbols");
    public static final String PDB_STORAGE_PROPERTY = "PDB Storage Directory";
    private static final String NO_TYPE = "NoType";
    static final String STRUCTURE_KIND = "Structure";
    static final String UNION_KIND = "Union";
    public static final boolean onWindows = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS;
    private final boolean forceAnalysis;
    private final File pdbFile;
    private final boolean isXML;
    private final Program program;
    private final DataTypeManagerService service;
    private final PdbProgramAttributes programAttributes;
    private Process process;
    private XmlPullParser parser;
    private PdbErrorHandler errHandler;
    private PdbErrorReaderThread thread;
    private boolean parsed = false;
    private String categoryPrefix;
    private CategoryPath pdbCategory;
    private Map<String, DataType> dataTypeCache = new HashMap<String, DataType>();
    private Map<SymbolPath, Boolean> namespaceMap = new TreeMap<SymbolPath, Boolean>();

    public PdbParserNEW(File pdbFile, Program program, DataTypeManagerService service, boolean forceAnalysis) {
        this(pdbFile, program, service, PdbParserNEW.getPdbAttributes(program), forceAnalysis);
    }

    public PdbParserNEW(File pdbFile, Program program, DataTypeManagerService service, PdbProgramAttributes programAttributes, boolean forceAnalysis) {
        this.pdbFile = pdbFile;
        this.categoryPrefix = "/" + pdbFile.getName();
        this.pdbCategory = new CategoryPath(this.categoryPrefix);
        this.program = program;
        this.service = service;
        this.forceAnalysis = forceAnalysis;
        this.isXML = pdbFile.getAbsolutePath().endsWith(PdbFileType.XML.toString());
        this.programAttributes = programAttributes;
    }

    DataTypeManager getProgramDataTypeManager() {
        return this.program.getDataTypeManager();
    }

    Program getProgram() {
        return this.program;
    }

    public void parse() throws IOException, PdbException {
        this.checkPdbLoaded();
        this.checkFileType();
        this.checkOSCompatibility();
        if (!this.forceAnalysis && !this.programAttributes.isProgramAnalyzed()) {
            throw new PdbException("Before loading a PDB, you must first analyze the program.");
        }
        this.processPdbContents(false);
        if (!this.isXML) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.hasErrors()) {
                throw new PdbException(this.getErrorAndWarningMessages());
            }
            if (this.hasWarnings()) {
                if (SystemUtilities.isInHeadlessMode()) {
                    throw new PdbException(this.getErrorAndWarningMessages() + "..  Skipping PDB processing.");
                }
                int option = OptionDialog.showYesNoDialog(null, (String)"Continue Loading PDB?", (String)(this.getErrorAndWarningMessages() + "\n \nContinue anyway?\n \nPlease note: Invalid disassembly may be produced!"));
                if (option == 1) {
                    this.cleanup();
                    this.processPdbContents(true);
                } else {
                    throw new PdbException(this.getErrorAndWarningMessages());
                }
            }
        }
        this.parsed = true;
    }

    private void checkFileType() throws PdbException {
        String pdbFilename = this.pdbFile.getName();
        if (!pdbFilename.endsWith(PdbFileType.PDB.toString()) && !pdbFilename.endsWith(PdbFileType.XML.toString())) {
            throw new PdbException("\nInvalid file type (expecting .pdb or .pdb.xml): '" + pdbFilename + "'");
        }
    }

    private void checkOSCompatibility() throws PdbException {
        if (!this.isXML && !onWindows) {
            throw new PdbException("\n.pdb files may only be loaded when running Windows. To load PDBs\non other platforms, use Windows to pre-dump the .pdb file to .pdb.xml\nusing 'CreatePdbXmlFilesScript.java' or 'createPdbXmlFiles.bat'.");
        }
        if (onWindows && this.isXML) {
            Msg.warn((Object)this, (Object)("Could not find .pdb file in the classpath or the given Symbol Repository Directory. Using " + this.pdbFile.getAbsolutePath() + ", instead."));
        }
    }

    private void checkPdbLoaded() throws PdbException {
        if (this.isPdbLoaded()) {
            throw new PdbException("PDB file has already been loaded.");
        }
    }

    private boolean hasErrors() {
        return this.thread != null && this.thread.hasErrors();
    }

    private boolean hasWarnings() {
        return this.thread != null && this.thread.hasWarnings();
    }

    private String getErrorAndWarningMessages() {
        return this.thread == null ? "" : this.thread.getErrorAndWarningMessages();
    }

    public void openDataTypeArchives() throws IOException, Exception {
        if (this.program != null) {
            List archiveList = DataTypeArchiveUtility.getArchiveList((Program)this.program);
            for (String string : archiveList) {
                this.service.openDataTypeArchive(string);
            }
        }
    }

    private String[] getCommandLineArray(boolean noValidation) throws PdbException {
        String pdbExe = null;
        try {
            File pdbExeFile = Application.getOSFile((String)PDB_EXE);
            pdbExe = pdbExeFile.getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            throw new PdbException("Unable to find pdb.exe");
        }
        if (noValidation) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath()};
        }
        String pdbAge = this.programAttributes.getPdbAge();
        String pdbGuid = this.programAttributes.getPdbGuid();
        String pdbSignature = this.programAttributes.getPdbSignature();
        if (pdbAge != null && pdbGuid != null) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath(), pdbGuid, pdbAge};
        }
        if (pdbAge != null && pdbSignature != null) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath(), pdbSignature, pdbAge};
        }
        throw new PdbException("Unable to determine PDB GUID/Signature or Age. Please re-import the executable and try again.");
    }

    private void completeDefferedTypeParsing(ApplyDataTypes applyDataTypes, ApplyDataTypes applyClasses, ApplyTypeDefs applyTypeDefs, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.defineClasses(monitor, log);
        if (applyDataTypes != null) {
            applyDataTypes.buildDataTypes(monitor);
        }
        if (applyClasses != null) {
            applyClasses.buildDataTypes(monitor);
        }
        if (applyTypeDefs != null) {
            applyTypeDefs.buildTypeDefs(monitor);
        }
        this.flushDataTypeCache();
    }

    public void applyTo(TaskMonitor monitor, MessageLog log) throws IOException, PdbException, CancelledException {
        if (!this.parsed) {
            throw new IOException("PDB: parse() must be called before applyTo()");
        }
        this.checkPdbLoaded();
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        this.errHandler.setMessageLog(log);
        Msg.debug((Object)this, (Object)("Found PDB for " + this.program.getName()));
        try {
            PdbUtil.createMandatoryDataTypes(this, monitor);
            ApplyDataTypes applyDataTypes = null;
            ApplyDataTypes applyClasses = null;
            ApplyTypeDefs applyTypeDefs = null;
            boolean typesFlushed = false;
            while (this.parser.hasNext()) {
                if (this.hasErrors()) {
                    throw new IOException(this.getErrorAndWarningMessages());
                }
                if (monitor.isCancelled()) {
                    return;
                }
                XmlElement element = this.parser.next();
                if (!element.isStart() || element.getName().equals("pdb")) continue;
                if (element.getName().equals("enums")) {
                    ApplyEnums.applyTo(this.parser, this, monitor, log);
                    continue;
                }
                if (element.getName().equals("datatypes")) {
                    applyDataTypes = new ApplyDataTypes(this, this.parser, false, monitor, log);
                    continue;
                }
                if (element.getName().equals("classes")) {
                    applyClasses = new ApplyDataTypes(this, this.parser, true, monitor, log);
                    continue;
                }
                if (element.getName().equals("typedefs")) {
                    applyTypeDefs = new ApplyTypeDefs(this, this.parser, monitor, log);
                    continue;
                }
                if (element.getName().equals("functions")) {
                    if (!typesFlushed) {
                        this.completeDefferedTypeParsing(applyDataTypes, applyClasses, applyTypeDefs, monitor, log);
                        typesFlushed = true;
                    }
                    ApplyFunctions.applyTo(this, this.parser, monitor, log);
                    continue;
                }
                if (!element.getName().equals("tables")) continue;
                if (!typesFlushed) {
                    this.completeDefferedTypeParsing(applyDataTypes, applyClasses, applyTypeDefs, monitor, log);
                    typesFlushed = true;
                }
                ApplyTables.applyTo(this, this.parser, monitor, log);
            }
            if (!typesFlushed) {
                this.completeDefferedTypeParsing(applyDataTypes, applyClasses, applyTypeDefs, monitor, log);
            }
            Options options = this.program.getOptions("Program Information");
            options.setBoolean("PDB Loaded", true);
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Exception e) {
            Object message = e.getMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            }
            message = "Problem parsing or applying PDB information: " + (String)message;
            Msg.error((Object)this, (Object)message, (Throwable)e);
            throw new IOException((String)message, e);
        }
        finally {
            this.cleanup();
        }
        if (this.hasErrors()) {
            throw new IOException(this.getErrorAndWarningMessages());
        }
    }

    private void flushDataTypeCache() {
        DataTypeManager dtm = this.program.getDataTypeManager();
        for (DataType dt : this.dataTypeCache.values()) {
            dtm.resolve(dt, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
        }
        this.dataTypeCache.clear();
    }

    void predefineClass(String classname) {
        SymbolPath classPath = new SymbolPath(classname);
        this.namespaceMap.put(classPath, true);
        for (SymbolPath path = classPath.getParent(); path != null; path = path.getParent()) {
            if (this.namespaceMap.containsKey(path)) continue;
            this.namespaceMap.put(path, false);
        }
    }

    private void defineClasses(TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.initialize((long)this.namespaceMap.size());
        for (SymbolPath path : this.namespaceMap.keySet()) {
            monitor.checkCanceled();
            boolean isClass = this.namespaceMap.get(path);
            Namespace parentNamespace = NamespaceUtils.getNamespace((Program)this.program, (SymbolPath)path.getParent(), null);
            if (parentNamespace == null) {
                String type = isClass ? "class" : "namespace";
                log.appendMsg("Error: failed to define " + type + ": " + path);
                continue;
            }
            this.defineNamespace(parentNamespace, path.getName(), isClass, log);
            monitor.incrementProgress(1L);
        }
        monitor.initialize(100L);
    }

    private void defineNamespace(Namespace parentNamespace, String name, boolean isClass, MessageLog log) {
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            Namespace namespace = symbolTable.getNamespace(name, parentNamespace);
            if (namespace != null) {
                if (isClass) {
                    if (namespace instanceof GhidraClass) {
                        return;
                    }
                    if (this.isSimpleNamespaceSymbol(namespace)) {
                        NamespaceUtils.convertNamespaceToClass((Namespace)namespace);
                        return;
                    }
                } else if (namespace.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                    return;
                }
                log.appendMsg("Unable to create class namespace due to conflicting symbol: " + namespace.getName(true));
            } else if (isClass) {
                symbolTable.createClass(parentNamespace, name, SourceType.IMPORTED);
            } else {
                symbolTable.createNameSpace(parentNamespace, name, SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create class namespace: " + parentNamespace.getName(true) + "::" + name);
        }
    }

    private boolean isSimpleNamespaceSymbol(Namespace namespace) {
        Symbol s = namespace.getSymbol();
        if (s.getSymbolType() != SymbolType.NAMESPACE) {
            return false;
        }
        for (Namespace n = namespace; n != null; n = n.getParentNamespace()) {
            if (!(n instanceof Function)) continue;
            return false;
        }
        return true;
    }

    private void processPdbContents(boolean skipValidation) throws PdbException, IOException {
        InputStream in = null;
        if (!this.isXML) {
            String[] cmd = this.getCommandLineArray(skipValidation);
            Runtime runtime = Runtime.getRuntime();
            try {
                this.process = runtime.exec(cmd);
            }
            catch (IOException e) {
                if (e.getMessage().endsWith("14001")) {
                    throw new PdbException("Missing runtime libraries. Please refer to " + README_FILENAME + " and follow instructions.");
                }
                throw e;
            }
            in = this.process.getInputStream();
            InputStream err = this.process.getErrorStream();
            this.thread = new PdbErrorReaderThread(err);
            this.thread.start();
        } else {
            in = new FileInputStream(this.pdbFile);
        }
        this.errHandler = new PdbErrorHandler();
        try {
            this.parser = XmlPullParserFactory.create((InputStream)in, (String)this.pdbFile.getName(), (ErrorHandler)this.errHandler, (boolean)false);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        this.verifyPdbSignature(in);
    }

    private void verifyPdbSignature(InputStream in) throws IOException, PdbException {
        String pdbSignature;
        XmlElement xmlelem;
        try {
            xmlelem = this.parser.peek();
        }
        catch (Exception e) {
            if (!this.isXML) {
                if (this.hasErrors()) {
                    throw new PdbException(this.getErrorAndWarningMessages());
                }
                throw new PdbException("PDB Execution failure of pdb.exe.\nThis was likely caused by severe execution failure which can occur if executed\non an unsupported platform. It may be neccessary to rebuild the PDB executable\nfor your platform (see Ghidra/Features/PDB/src).");
            }
            throw new PdbException("PDB parsing problem: " + e.getMessage());
        }
        if (!"pdb".equals(xmlelem.getName())) {
            throw new PdbException("Unexpected PDB XML element: " + xmlelem.getName());
        }
        String xmlGuid = xmlelem.getAttribute("guid");
        String xmlAge = xmlelem.getAttribute("age");
        Object warning = "";
        Object pdbGuid = this.programAttributes.getPdbGuid();
        if (pdbGuid == null && (pdbSignature = this.programAttributes.getPdbSignature()) != null) {
            pdbGuid = this.reformatSignatureToGuidForm(pdbSignature);
        }
        String pdbAge = this.programAttributes.getPdbAge();
        if (xmlGuid == null || pdbGuid == null) {
            if (xmlGuid == null) {
                warning = (String)warning + "No GUID was listed in the XML file.";
            }
            if (pdbGuid == null) {
                warning = (String)warning + " Could not find a PDB GUID for the binary.";
            }
            warning = (String)warning + " Could not complete verification of matching PDB signatures.";
        } else {
            pdbGuid = ((String)pdbGuid).toUpperCase();
            if (!xmlGuid.equals(pdbGuid = "{" + (String)pdbGuid + "}")) {
                warning = "PDB signature does not match.";
            } else if (xmlAge != null && pdbAge != null) {
                int pdbAgeDecimal = Integer.parseInt(pdbAge, 16);
                int xmlAgeDecimal = Integer.parseInt(xmlAge);
                if (xmlAgeDecimal != pdbAgeDecimal) {
                    warning = "PDB ages do not match.";
                }
            }
        }
        if (((String)warning).length() > 0) {
            if (SystemUtilities.isInHeadlessMode()) {
                throw new PdbException((String)warning + ".. Skipping PDB processing.");
            }
            int option = OptionDialog.showYesNoDialog(null, (String)"Continue Loading PDB?", (String)((String)warning + "\n \nContinue anyway?\n \nPlease note: Invalid disassembly may be produced!"));
            if (option != 1) {
                throw new PdbException((String)warning);
            }
        }
    }

    private String reformatSignatureToGuidForm(String pdbSignature) {
        if (pdbSignature.length() > 32) {
            pdbSignature = pdbSignature.substring(0, 32);
        }
        StringBuilder builder = new StringBuilder(pdbSignature);
        for (int i = pdbSignature.length(); i < 32; ++i) {
            builder = builder.append('0');
        }
        builder = builder.insert(8, '-').insert(13, '-').insert(18, '-').insert(23, '-');
        return builder.toString();
    }

    public boolean isPdbLoaded() {
        return this.programAttributes.isPdbLoaded();
    }

    private void cleanup() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.parser != null) {
            this.parser.dispose();
            this.parser = null;
        }
        this.dataTypeCache.clear();
    }

    boolean isCorrectKind(DataType dt, String kind) {
        if (STRUCTURE_KIND.equals(kind)) {
            return dt instanceof Structure;
        }
        if (UNION_KIND.equals(kind)) {
            return dt instanceof Union;
        }
        return false;
    }

    Composite createComposite(String kind, String name) {
        if (STRUCTURE_KIND.equals(kind)) {
            return this.createStructure(name, 0);
        }
        if (UNION_KIND.equals(kind)) {
            return this.createUnion(name);
        }
        return null;
    }

    Structure createStructure(String name, int length) {
        return new StructureDataType(this.getCategory(name, true), this.stripNamespace(name), length, this.program.getDataTypeManager());
    }

    Union createUnion(String name) {
        return new UnionDataType(this.getCategory(name, true), this.stripNamespace(name), this.program.getDataTypeManager());
    }

    TypedefDataType createTypeDef(String name, DataType baseDataType) {
        return new TypedefDataType(this.getCategory(name, true), this.stripNamespace(name), baseDataType, this.program.getDataTypeManager());
    }

    EnumDataType createEnum(String name, int length) {
        return new EnumDataType(this.getCategory(name, true), this.stripNamespace(name), length, this.program.getDataTypeManager());
    }

    void createString(boolean isUnicode, Address address, MessageLog log, TaskMonitor monitor) {
        UnicodeDataType dataType = isUnicode ? new UnicodeDataType() : new StringDataType();
        this.createData(address, (DataType)dataType, log, monitor);
    }

    void createData(Address address, String datatype, MessageLog log, TaskMonitor monitor) throws CancelledException {
        WrappedDataType wrappedDt = this.findDataType(datatype, monitor);
        if (wrappedDt == null) {
            log.appendMsg("Error: Failed to resolve datatype " + datatype + " at " + address);
        } else if (wrappedDt.isZeroLengthArray) {
            Msg.debug((Object)this, (Object)("Did not apply zero length array data " + datatype + " at " + address));
        } else {
            this.createData(address, wrappedDt.dataType, log, monitor);
        }
    }

    void createData(Address address, DataType dataType, MessageLog log, TaskMonitor monitor) {
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.program.getMemory(), address);
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)dataType, (MemBuffer)memBuffer);
        if (dti == null) {
            log.appendMsg("Error: Failed to apply datatype " + dataType.getName() + " at " + address);
        } else {
            this.createData(address, dti.getDataType(), dti.getLength(), log, monitor);
        }
    }

    private void createData(Address address, DataType dataType, int dataTypeLength, MessageLog log, TaskMonitor monitor) {
        block18: {
            DataType existingDataType;
            Data existingData = null;
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(address);
            if (cu != null) {
                if (cu instanceof Instruction || !address.equals((Object)cu.getAddress())) {
                    log.appendMsg("Warning: Did not create data type \"" + dataType.getDisplayName() + "\" at address " + address + " due to conflict");
                    return;
                }
                Data d = (Data)cu;
                if (d.isDefined()) {
                    existingData = d;
                }
            }
            if (dataType == null) {
                return;
            }
            if (dataType.getLength() <= 0 && dataTypeLength <= 0) {
                log.appendMsg("Unknown dataTypeLength specified at address " + address + " for " + dataType.getName());
                return;
            }
            if (existingData != null) {
                existingDataType = existingData.getDataType();
                if (this.isEquivalent(existingData, existingData.getLength(), dataType)) {
                    return;
                }
                if (this.isEquivalent2(existingDataType, dataType)) {
                    return;
                }
                if (existingDataType.isEquivalent(dataType)) {
                    return;
                }
            }
            if (existingData == null) {
                try {
                    this.program.getListing().clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    if (dataType.getLength() == -1) {
                        this.program.getListing().createData(address, dataType, dataTypeLength);
                        break block18;
                    }
                    this.program.getListing().createData(address, dataType);
                }
                catch (Exception e) {
                    log.appendMsg("Unable to create " + dataType.getDisplayName() + " at 0x" + address + ": " + e.getMessage());
                }
            } else if (this.isDataReplaceable(existingData)) {
                try {
                    this.program.getListing().clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    this.program.getListing().createData(address, dataType, dataTypeLength);
                }
                catch (Exception e) {
                    log.appendMsg("Unable to replace " + dataType.getDisplayName() + " at 0x" + address + ": " + e.getMessage());
                }
            } else {
                existingDataType = existingData.getDataType();
                String existingDataTypeString = existingDataType == null ? "null" : existingDataType.getDisplayName();
                log.appendMsg("Warning: Did not create data type \"" + dataType.getDisplayName() + "\" at address " + address + ".  Preferring existing datatype \"" + existingDataTypeString + "\"");
            }
        }
    }

    private boolean isDataReplaceable(Data data) {
        Array array;
        DataType arrayDataType;
        Pointer pointer;
        DataType pointerDataType;
        DataType dataType = data.getDataType();
        if (dataType instanceof Pointer ? (pointerDataType = (pointer = (Pointer)dataType).getDataType()) == null || pointerDataType.isEquivalent(DataType.DEFAULT) : dataType instanceof Array && ((arrayDataType = (array = (Array)dataType).getDataType()) == null || arrayDataType.isEquivalent(DataType.DEFAULT))) {
            return true;
        }
        return Undefined.isUndefined((DataType)dataType);
    }

    private boolean isEquivalent(Data existingData, int existingDataTypeLength, DataType newDataType) {
        Array array;
        DataType arrayDataType;
        return existingData.hasStringValue() && newDataType instanceof ArrayDataType && (arrayDataType = (array = (Array)newDataType).getDataType()) instanceof ArrayStringable && array.getLength() == existingDataTypeLength;
    }

    private boolean isEquivalent2(DataType datatype1, DataType datatype2) {
        if (datatype1 == datatype2) {
            return true;
        }
        if (datatype1 == null || datatype2 == null) {
            return false;
        }
        if (datatype1 instanceof Array) {
            Array array1 = (Array)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(array1.getDataType(), array2.getDataType());
            }
        } else if (datatype1 instanceof Pointer) {
            Pointer pointer1 = (Pointer)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(pointer1.getDataType(), array2.getDataType());
            }
        }
        return datatype1.isEquivalent(datatype2);
    }

    boolean createSymbol(Address address, String symbolPathString, boolean forcePrimary, MessageLog log, TaskMonitor monitor) throws CancelledException {
        try {
            Symbol s;
            Namespace namespace = this.program.getGlobalNamespace();
            SymbolPath symbolPath = new SymbolPath(symbolPathString);
            symbolPath = symbolPath.replaceInvalidChars();
            String name = symbolPath.getName();
            String namespacePath = symbolPath.getParentPath();
            if (namespacePath != null) {
                namespace = NamespaceUtils.createNamespaceHierarchy((String)namespacePath, (Namespace)namespace, (Program)this.program, (Address)address, (SourceType)SourceType.IMPORTED);
            }
            if ((s = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)this.program, (Address)address, (Namespace)namespace, (String)name, (SourceType)SourceType.IMPORTED)) != null && forcePrimary) {
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, s.getName(), s.getParentNamespace());
                cmd.applyTo((DomainObject)this.program);
            }
            return true;
        }
        catch (InvalidInputException e) {
            log.appendMsg("Unable to create symbol: " + e.getMessage());
            return false;
        }
    }

    DataType createPointer(DataType dt) {
        return PointerDataType.getPointer((DataType)dt, (DataTypeManager)this.program.getDataTypeManager());
    }

    WrappedDataType findDataType(String datatype, TaskMonitor monitor) throws CancelledException {
        DataType dt;
        if ((datatype = datatype.trim()) == null || datatype.length() == 0) {
            return null;
        }
        if (NO_TYPE.equals(datatype)) {
            return new WrappedDataType((DataType)VoidDataType.dataType, false);
        }
        String dataTypeName = datatype;
        int basePointerDepth = 0;
        while (dataTypeName.endsWith("*")) {
            ++basePointerDepth;
            dataTypeName = dataTypeName.substring(0, dataTypeName.length() - 1).trim();
        }
        boolean isZeroLengthArray = false;
        ArrayList<Integer> arrayDimensions = null;
        if (dataTypeName.endsWith("]")) {
            arrayDimensions = new ArrayList<Integer>();
            if ((dataTypeName = this.parseArrayDimensions(dataTypeName, arrayDimensions)) == null) {
                Msg.error((Object)this, (Object)("Failed to parse array dimensions: " + datatype));
                return null;
            }
            isZeroLengthArray = (Integer)arrayDimensions.get(arrayDimensions.size() - 1) == 0;
        }
        int pointerDepth = 0;
        if (arrayDimensions != null) {
            while (dataTypeName.endsWith("*")) {
                ++pointerDepth;
                dataTypeName = dataTypeName.substring(0, dataTypeName.length() - 1).trim();
            }
            if (pointerDepth != 0 && isZeroLengthArray) {
                Msg.error((Object)this, (Object)("Unsupported pointer to zero-length array: " + datatype));
                return null;
            }
        }
        if ((dt = this.findBaseDataType(dataTypeName, monitor)) == null) {
            return null;
        }
        while (basePointerDepth-- != 0) {
            dt = this.createPointer(dt);
        }
        if (arrayDimensions != null) {
            dt = this.createArray(dt, arrayDimensions);
        }
        while (pointerDepth-- != 0) {
            dt = this.createPointer(dt);
        }
        return new WrappedDataType(dt, isZeroLengthArray);
    }

    private DataType findBaseDataType(String dataTypeName, TaskMonitor monitor) throws CancelledException {
        DataType dt = this.getCachedDataType(dataTypeName);
        if (dt != null) {
            return dt;
        }
        BuiltInDataTypeManager builtInDTM = BuiltInDataTypeManager.getDataTypeManager();
        dt = builtInDTM.getDataType(new DataTypePath(CategoryPath.ROOT, dataTypeName));
        if (dt == null) {
            dt = this.findDataTypeInArchives(dataTypeName, monitor);
        }
        return dt;
    }

    private DataType createArray(DataType dt, List<Integer> arrayDimensions) {
        boolean zeroLengthArray;
        int dimensionCount = arrayDimensions.size();
        boolean bl = zeroLengthArray = arrayDimensions.get(arrayDimensions.size() - 1) == 0;
        if (zeroLengthArray) {
            --dimensionCount;
        }
        for (int i = 0; i < dimensionCount; ++i) {
            int dimension = arrayDimensions.get(i);
            dt = new ArrayDataType(dt, dimension, dt.getLength(), this.program.getDataTypeManager());
        }
        if (zeroLengthArray) {
            dt = new ArrayDataType(dt, 1, dt.getLength(), this.program.getDataTypeManager());
        }
        return dt;
    }

    private String parseArrayDimensions(String datatype, List<Integer> arrayDimensions) {
        String dataTypeName = datatype;
        boolean zeroLengthArray = false;
        while (dataTypeName.endsWith("]")) {
            int dimension;
            if (zeroLengthArray) {
                return null;
            }
            int rBracketPos = dataTypeName.lastIndexOf(93);
            int lBracketPos = dataTypeName.lastIndexOf(91);
            if (lBracketPos < 0) {
                return null;
            }
            try {
                dimension = Integer.parseInt(dataTypeName.substring(lBracketPos + 1, rBracketPos));
                if (dimension < 0) {
                    return null;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            dataTypeName = dataTypeName.substring(0, lBracketPos).trim();
            arrayDimensions.add(dimension);
        }
        return dataTypeName;
    }

    private DataType findDataTypeInArchives(String datatype, TaskMonitor monitor) throws CancelledException {
        DataTypeManager[] managers = this.service.getDataTypeManagers();
        Arrays.sort(managers, new PdbDataTypeManagerComparator());
        for (DataTypeManager manager : managers) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            DataType dt = DataTypeUtilities.findNamespaceQualifiedDataType((DataTypeManager)manager, (String)datatype, null);
            if (dt == null) continue;
            this.cacheDataType(datatype, dt);
            return dt;
        }
        return null;
    }

    DataType getCachedDataType(String key) {
        return this.dataTypeCache.get(key);
    }

    void cacheDataType(String key, DataType dataType) {
        this.dataTypeCache.put(key, dataType);
    }

    void addDataType(DataType dataType) {
        if (dataType instanceof Composite) {
            DataTypeComponent[] components;
            for (DataTypeComponent component : components = ((Composite)dataType).getComponents()) {
                this.addDataType(component.getDataType());
            }
        }
        DataTypeManager dataTypeMgr = this.program.getDataTypeManager();
        ArrayList oldDataTypeList = new ArrayList();
        dataTypeMgr.findDataTypes(dataType.getName(), oldDataTypeList);
        dataType = dataTypeMgr.addDataType(dataType, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
        this.cacheDataType(dataType.getName(), dataType);
        for (DataType oldDataType : oldDataTypeList) {
            if (oldDataType.getLength() != 0 || !oldDataType.getClass().equals(dataType.getClass())) continue;
            try {
                dataTypeMgr.replaceDataType(oldDataType, dataType, false);
            }
            catch (DataTypeDependencyException dataTypeDependencyException) {}
        }
    }

    CategoryPath getCategory() {
        return this.pdbCategory;
    }

    String stripNamespace(String name) {
        int index = name.lastIndexOf("::");
        if (index <= 0) {
            return name;
        }
        return name.substring(index + "::".length());
    }

    CategoryPath getCategory(String namespaceQualifiedDataTypeName, boolean addPdbRoot) {
        CategoryPath category;
        String[] names = namespaceQualifiedDataTypeName.split("::");
        CategoryPath categoryPath = category = addPdbRoot ? this.pdbCategory : CategoryPath.ROOT;
        if (names.length > 1) {
            String[] categoryNames = new String[names.length - 1];
            System.arraycopy(names, 0, categoryNames, 0, categoryNames.length);
            for (String c : categoryNames) {
                category = new CategoryPath(category, c);
            }
        }
        return category;
    }

    public static PdbProgramAttributes getPdbAttributes(Program program) {
        return new PdbProgramAttributes(program);
    }

    public static File findPDB(Program program) throws PdbException {
        return PdbParserNEW.findPDB(PdbParserNEW.getPdbAttributes(program), null, null);
    }

    public static boolean isAlreadyLoaded(Program program) {
        return PdbParserNEW.getPdbAttributes(program).isPdbLoaded();
    }

    public static File findPDB(Program program, String symbolsRepositoryPath) throws PdbException {
        return PdbParserNEW.findPDB(PdbParserNEW.getPdbAttributes(program), symbolsRepositoryPath, null);
    }

    public static File findPDB(PdbProgramAttributes pdbAttributes, String symbolsRepositoryPath, PdbFileType fileType) throws PdbException {
        HashSet<String> guidSubdirPaths = new HashSet<String>();
        String guidAgeString = pdbAttributes.getGuidAgeCombo();
        if (guidAgeString == null) {
            throw new PdbException("Incomplete PDB information (GUID/Signature and/or age) associated with this program.\nEither the program is not a PE, or it was not compiled with debug information.");
        }
        List<String> potentialPdbNames = pdbAttributes.getPotentialPdbFilenames();
        for (String potentialName : potentialPdbNames) {
            guidSubdirPaths.add(File.separator + potentialName + File.separator + guidAgeString);
        }
        return PdbParserNEW.checkPathsForPdb(symbolsRepositoryPath, guidSubdirPaths, potentialPdbNames, fileType, pdbAttributes);
    }

    private static File checkPathsForPdb(String symbolsRepositoryPath, Set<String> guidSubdirPaths, List<String> potentialPdbNames, PdbFileType fileType, PdbProgramAttributes pdbAttributes) {
        boolean checkForXml;
        boolean fileTypeSpecified;
        File foundPdb = null;
        Set<File> symbolsRepoPaths = PdbParserNEW.getSymbolsRepositoryPaths(symbolsRepositoryPath, guidSubdirPaths);
        Set<File> predefinedPaths = PdbParserNEW.getPredefinedPaths(guidSubdirPaths, pdbAttributes);
        boolean bl = fileTypeSpecified = fileType != null;
        if (fileTypeSpecified) {
            boolean checkForXml2 = fileType == PdbFileType.XML;
            foundPdb = PdbParserNEW.checkForPDBorXML(symbolsRepoPaths, potentialPdbNames, checkForXml2);
            if (foundPdb != null) {
                return foundPdb;
            }
            foundPdb = PdbParserNEW.checkForPDBorXML(predefinedPaths, potentialPdbNames, checkForXml2);
            return foundPdb;
        }
        boolean bl2 = checkForXml = !onWindows;
        if (symbolsRepositoryPath != null) {
            foundPdb = PdbParserNEW.checkSpecificPathsForPdb(symbolsRepoPaths, potentialPdbNames, checkForXml);
        }
        if (foundPdb != null) {
            return foundPdb;
        }
        return PdbParserNEW.checkSpecificPathsForPdb(predefinedPaths, potentialPdbNames, checkForXml);
    }

    private static File checkSpecificPathsForPdb(Set<File> paths, List<String> potentialPdbNames, boolean checkForXmlFirst) {
        File foundPdb = PdbParserNEW.checkForPDBorXML(paths, potentialPdbNames, checkForXmlFirst);
        if (foundPdb != null) {
            return foundPdb;
        }
        foundPdb = PdbParserNEW.checkForPDBorXML(paths, potentialPdbNames, !checkForXmlFirst);
        return foundPdb;
    }

    private static Set<File> getSymbolsRepositoryPaths(String symbolsRepositoryPath, Set<String> guidSubdirPaths) {
        File symRepoFile;
        LinkedHashSet<File> symbolsRepoPaths = new LinkedHashSet<File>();
        if (symbolsRepositoryPath != null && (symRepoFile = new File(symbolsRepositoryPath)).isDirectory()) {
            for (String guidSubdir : guidSubdirPaths) {
                File testDir = new File(symRepoFile, guidSubdir);
                if (!testDir.isDirectory()) continue;
                symbolsRepoPaths.add(testDir);
            }
            symbolsRepoPaths.add(symRepoFile);
        }
        return symbolsRepoPaths;
    }

    private static Set<File> getPredefinedPaths(Set<String> guidSubdirPaths, PdbProgramAttributes pdbAttributes) {
        LinkedHashSet<File> predefinedPaths = new LinkedHashSet<File>();
        PdbParserNEW.getPathsFromAttributes(pdbAttributes, predefinedPaths);
        PdbParserNEW.getWindowsPaths(guidSubdirPaths, predefinedPaths);
        PdbParserNEW.getLibraryPaths(guidSubdirPaths, predefinedPaths);
        return predefinedPaths;
    }

    private static void getLibraryPaths(Set<String> guidSubdirPaths, Set<File> predefinedPaths) {
        String[] libraryPaths;
        for (String path : libraryPaths = LibrarySearchPathManager.getLibraryPaths()) {
            File libFile = new File(path);
            if (!libFile.isDirectory()) continue;
            predefinedPaths.add(libFile);
            for (String guidSubdir : guidSubdirPaths) {
                File subDir = new File(path, guidSubdir);
                if (!subDir.isDirectory()) continue;
                predefinedPaths.add(subDir);
            }
        }
    }

    private static void getWindowsPaths(Set<String> guidSubdirPaths, Set<File> predefinedPaths) {
        if (onWindows && SPECIAL_PDB_LOCATION.isDirectory()) {
            predefinedPaths.add(SPECIAL_PDB_LOCATION);
            String specialPdbPath = SPECIAL_PDB_LOCATION.getAbsolutePath();
            for (String guidSubdir : guidSubdirPaths) {
                File testDir = new File(specialPdbPath + guidSubdir);
                if (!testDir.isDirectory()) continue;
                predefinedPaths.add(testDir);
            }
        }
    }

    private static void getPathsFromAttributes(PdbProgramAttributes pdbAttributes, Set<File> predefinedPaths) {
        if (pdbAttributes != null) {
            File parentDir;
            String currentPath = pdbAttributes.getPdbFile();
            if (currentPath != null && (parentDir = new File(currentPath).getParentFile()) != null && parentDir.exists()) {
                predefinedPaths.add(parentDir);
            }
            if ((currentPath = pdbAttributes.getExecutablePath()) != null && !currentPath.equals("unknown") && (parentDir = new File(currentPath).getParentFile()) != null && parentDir.exists()) {
                predefinedPaths.add(parentDir);
            }
        }
    }

    private static File checkForPDBorXML(Set<File> potentialPdbDirs, List<String> potentialPdbNames, boolean findXML) {
        for (File pdbPath : potentialPdbDirs) {
            for (String filename : potentialPdbNames) {
                File pdb = findXML ? new File(pdbPath, filename + PdbFileType.XML.toString()) : new File(pdbPath, filename);
                if (!pdb.isFile()) continue;
                return pdb;
            }
        }
        return null;
    }

    private class PdbDataTypeManagerComparator
    implements Comparator<DataTypeManager> {
        private PdbDataTypeManagerComparator() {
        }

        @Override
        public int compare(DataTypeManager dtm1, DataTypeManager dtm2) {
            if (dtm1 == PdbParserNEW.this.program.getDataTypeManager()) {
                return -1;
            }
            if (dtm2 == PdbParserNEW.this.program.getDataTypeManager()) {
                return 1;
            }
            if (dtm1 instanceof BuiltInDataTypeManager) {
                return -1;
            }
            if (dtm2 instanceof BuiltInDataTypeManager) {
                return 1;
            }
            return 0;
        }
    }

    static class WrappedDataType {
        final boolean isZeroLengthArray;
        final DataType dataType;

        WrappedDataType(DataType dataType, boolean isZeroLengthArray) {
            this.dataType = dataType;
            this.isZeroLengthArray = isZeroLengthArray;
        }
    }

    public static enum PdbFileType {
        PDB,
        XML;


        public String toString() {
            return "." + this.name().toLowerCase();
        }
    }
}

