/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AlgorithmFilter
extends CheckBoxBasedAncillaryFilter<VTMatch> {
    public AlgorithmFilter() {
        super("Algorithm");
    }

    @Override
    protected JPanel createFilterPanel(JPanel checkBoxPanel) {
        JButton selectButton = new JButton("Select All");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CheckBoxInfo info : AlgorithmFilter.this.checkBoxInfos) {
                    info.getCheckBox().setSelected(true);
                }
            }
        });
        JButton deselectButton = new JButton("Deselect All");
        deselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CheckBoxInfo info : AlgorithmFilter.this.checkBoxInfos) {
                    info.getCheckBox().setSelected(false);
                }
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.add(selectButton);
        southPanel.add(deselectButton);
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)checkBoxPanel, "Center");
        parentPanel.add((Component)southPanel, "South");
        return parentPanel;
    }

    @Override
    protected void createCheckBoxInfos() {
        List<String> algorithmNames = this.getKnowAlgorithms();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AlgorithmFilter.this.fireStatusChanged(AlgorithmFilter.this.getFilterStatus());
            }
        };
        for (String name : algorithmNames) {
            JCheckBox checkBox = new JCheckBox(name);
            checkBox.setSelected(true);
            checkBox.addItemListener(listener);
            AlgorithmNameCheckBoxInfo info = new AlgorithmNameCheckBoxInfo(checkBox, name);
            this.checkBoxInfos.add(info);
        }
    }

    private List<String> getKnowAlgorithms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Manual Match");
        list.add("Implied Match");
        Set instances = ClassSearcher.getInstances(VTAbstractProgramCorrelatorFactory.class);
        for (VTAbstractProgramCorrelatorFactory factory : instances) {
            list.add(factory.getName());
        }
        return list;
    }

    private class AlgorithmNameCheckBoxInfo
    extends CheckBoxInfo<VTMatch> {
        private final String algorithmName;

        public AlgorithmNameCheckBoxInfo(JCheckBox checkBox, String name) {
            super(checkBox);
            this.algorithmName = name;
        }

        @Override
        public boolean matchesStatus(VTMatch match) {
            if (!this.isSelected()) {
                return false;
            }
            VTMatchSet matchSet = match.getMatchSet();
            VTProgramCorrelatorInfo info = matchSet.getProgramCorrelatorInfo();
            String matchCorrelatorName = info.getName();
            return matchCorrelatorName.equals(this.algorithmName);
        }
    }
}

