/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class DataAction
extends ListingContextAction
implements OptionsChangeListener {
    protected DataType dataType;
    protected DataPlugin plugin;
    private String actionName;
    private DummyKeyBindingsOptionsAction dummyKeybindingsAction;

    public DataAction(DataType dataType, DataPlugin plugin) {
        this("Define " + dataType.getDisplayName(), "Data", dataType, plugin);
    }

    public DataAction(String name, String group, DataType dataType, DataPlugin plugin) {
        super(name, plugin.getName(), false);
        this.actionName = name;
        this.plugin = plugin;
        this.dataType = dataType;
        this.setPopupMenuData(new MenuData(new String[]{"Data", dataType.getDisplayName()}, group));
        this.assignHelpID(dataType);
        this.initializeKeybinding();
    }

    private void initializeKeybinding() {
        PluginTool tool = this.plugin.getTool();
        this.dummyKeybindingsAction = new DummyKeyBindingsOptionsAction(this.actionName, this.getDefaultKeyStroke());
        tool.addAction((DockingActionIf)this.dummyKeybindingsAction);
        ToolOptions options = tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(this.dummyKeybindingsAction.getFullName(), this.getDefaultKeyStroke());
        this.initKeyStroke(keyStroke);
    }

    protected KeyStroke getDefaultKeyStroke() {
        return null;
    }

    protected void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
    }

    protected DockingAction getDummyKeyBindingAction() {
        return this.dummyKeybindingsAction;
    }

    public void dispose() {
        this.dataType = null;
        this.plugin = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.doCreateData(context, this.dataType);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        return this.plugin.isCreateDataAllowed(context);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (optionName.startsWith(this.actionName)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    DataType getDataType() {
        return this.dataType;
    }

    private void assignHelpID(DataType dt) {
        String helpID = "Favorites";
        if (dt instanceof Structure) {
            helpID = "Structure";
        } else if (dt instanceof Union) {
            helpID = "Union";
        } else if (dt instanceof Pointer) {
            helpID = "Define_Pointer";
        } else if (dt instanceof Dynamic) {
            helpID = "DynamicDataType";
        }
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), helpID));
    }
}

