/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.pathmanager.PathManager;
import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeIndexer;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.store.FileSystem;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTypeManagerHandler {
    private static final String CONTENT_NAME = "Data Type Archive";
    private static final String ARCHIVE_NAMES = "ArchiveNames";
    private static final String RELATIVE_PATH_PREFIX = ".";
    private static final String PROJECT_NAME_DELIMETER = ":";
    private static final String RECENT_NAMES = "RecentArchiveNames";
    private static final String FAVORITES = "Favorite Dts";
    private static final String[] UNALLOWED_ARCHIVE_PATH_FRAGMENTS = new String[]{"/Ghidra/Extensions/", "/Ghidra/docs/", "/Ghidra/Features/", "/Ghidra/Test/"};
    public static final String OLD_DATA_TYPE_ARCHIVE_PATH_KEY = "DATA_TYPE_ARCHIVE_PATH";
    public static final String DATA_TYPE_ARCHIVE_PATH_KEY = "DATATYPE_ARCHIVE_PATHS";
    public static final String DISABLED_DATA_TYPE_ARCHIVE_PATH_KEY = "DISABLED_DATA_TYPE_ARCHIVE_PATH";
    private ProgramArchive programArchive;
    private List<Archive> openArchives = new ArrayList<Archive>();
    private Set<String> initiallyOpenedFileArchiveNames = new HashSet<String>();
    private Set<String> userOpenedFileArchiveNames = new HashSet<String>();
    private Set<String> knownOpenFileArchiveNames = new HashSet<String>();
    private Map<UniversalID, InvalidFileArchive> invalidArchives = new HashMap<UniversalID, InvalidFileArchive>();
    private DataTreeDialog dataTreeSaveDialog;
    private CreateDataTypeArchiveDataTreeDialog dataTreeCreateDialog;
    private boolean treeDialogCancelled = false;
    private DomainFileFilter domainFileFilter;
    private DataTypeIndexer dataTypeIndexer;
    private List<ArchiveManagerListener> archiveManagerlisteners = new ArrayList<ArchiveManagerListener>();
    private List<DataTypeManagerChangeListener> dataTypeManagerListeners = new ArrayList<DataTypeManagerChangeListener>();
    private RecentlyUsedDataType recentlyUsedDataType = new RecentlyUsedDataType();
    private BuiltInDataTypeManager builtInDataTypesManager;
    private final DataTypeManagerPlugin plugin;
    private PluginTool tool;
    private DataTypeManagerListenerDelegate listenerDelegate;
    private MyFolderListener folderListener;

    public DataTypeManagerHandler(DataTypeManagerPlugin plugin) {
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.listenerDelegate = new DataTypeManagerListenerDelegate();
        this.builtInDataTypesManager = BuiltInDataTypeManager.getDataTypeManager();
        this.builtInDataTypesManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        this.initializeFavorites();
        this.dataTypeIndexer = new DataTypeIndexer();
        this.dataTypeIndexer.addDataTypeManager((DataTypeManager)this.builtInDataTypesManager);
        this.openArchives.add(new BuiltInArchive(this, this.builtInDataTypesManager));
        this.domainFileFilter = f -> {
            Class c = f.getDomainObjectClass();
            return DataTypeArchive.class.isAssignableFrom(c);
        };
        this.folderListener = new MyFolderListener();
        this.tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
    }

    public void dispose() {
        this.dataTypeIndexer.removeDataTypeManager((DataTypeManager)this.builtInDataTypesManager);
        this.builtInDataTypesManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
    }

    public void programOpened(Program program) {
        this.programArchive = new ProgramArchive(program);
        this.openProgramArchives(program);
        this.addArchive(this.programArchive);
    }

    public void programClosed() {
        this.programArchive.getDataTypeManager().removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        this.dataTypeIndexer.removeDataTypeManager(this.programArchive.getDataTypeManager());
        this.openArchives.remove(this.programArchive);
        this.fireArchiveClosed(this.programArchive);
        this.programArchive = null;
    }

    private void openProgramArchives(Program program) {
        DataTypeManager programDataTypeManager = program.getDataTypeManager();
        List sources = programDataTypeManager.getSourceArchives();
        for (SourceArchive dataTypeSource : sources) {
            if (this.isOpen(dataTypeSource) || this.isKnownInvalidArchive(dataTypeSource)) continue;
            switch (dataTypeSource.getArchiveType()) {
                case PROJECT: {
                    this.openProjectArchive(dataTypeSource);
                    break;
                }
                case FILE: {
                    this.openFileArchive(dataTypeSource);
                    break;
                }
            }
        }
    }

    private boolean isOpen(SourceArchive dataTypeSource) {
        List<Archive> allArchives = this.getAllArchives();
        for (Archive archive : allArchives) {
            DataTypeManager dataTypeManager = archive.getDataTypeManager();
            UniversalID universalID = dataTypeManager.getUniversalID();
            if (universalID == null || !universalID.equals((Object)dataTypeSource.getSourceArchiveID())) continue;
            return true;
        }
        return false;
    }

    private void openProjectArchive(SourceArchive dataTypeSource) {
        String domainFileID = dataTypeSource.getDomainFileID();
        DomainFile domainFile = this.plugin.getTool().getProject().getProjectData().getFileByID(domainFileID);
        if (domainFile == null) {
            this.createInvalidArchiveNode(dataTypeSource);
            return;
        }
        this.plugin.openArchive(domainFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSourceArchiveName(DataTypeManager dataTypeManager, String fileID, String name) {
        int transactionID = dataTypeManager.startTransaction("Update Data Type Source Archive Name");
        try {
            dataTypeManager.updateSourceArchiveName(fileID, name);
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private Path[] getArchivePaths() {
        return PathManager.getPathsFromPreferences((String)DATA_TYPE_ARCHIVE_PATH_KEY, null, (String)DISABLED_DATA_TYPE_ARCHIVE_PATH_KEY);
    }

    private FileArchive openFileArchive(String archiveName, UniversalID archiveID, boolean acquireWriteLock) {
        Path[] pathsFromPreferences;
        if (archiveName.endsWith(".gdt")) {
            archiveName = archiveName.substring(0, archiveName.length() - ".gdt".length());
        }
        String archiveFileName = archiveName + ".gdt";
        List<Archive> allArchives = this.getAllArchives();
        for (Archive archive : allArchives) {
            if (!(archive instanceof FileArchive) || !archive.getName().equals(archiveName) || archiveID != null && !archiveID.equals((Object)archive.getDataTypeManager().getUniversalID())) continue;
            if (!acquireWriteLock || archive.isModifiable()) break;
            this.closeArchive(archive);
            break;
        }
        for (Path path : pathsFromPreferences = this.getArchivePaths()) {
            FileArchive archive;
            ResourceFile archiveFile;
            if (!this.isAllowedArchivePath(path.getPathAsString()) || !path.isEnabled() || !(archiveFile = new ResourceFile(path.getPath(), archiveFileName)).exists() || (archive = this.openFileArchive(archiveFile, archiveID, acquireWriteLock)) == null) continue;
            return archive;
        }
        ResourceFile resourceFile = DataTypeArchiveUtility.findArchiveFile(archiveFileName);
        if (resourceFile == null) {
            Msg.showError((Object)this, (Component)this.plugin.getProvider().getComponent(), (String)"Open Archive Failed", (Object)("Archive file not found: " + archiveFileName));
            return null;
        }
        return this.openFileArchive(resourceFile, archiveID, false);
    }

    private FileArchive openFileArchive(ResourceFile archiveFile, UniversalID archiveID, boolean acquireWriteLock) {
        try {
            FileArchive archive = new FileArchive(this, archiveFile, acquireWriteLock);
            if (archiveID == null || archiveID.equals((Object)archive.getDataTypeManager().getUniversalID())) {
                this.addArchive(archive);
                return archive;
            }
            archive.close();
        }
        catch (Throwable t) {
            DataTypeManagerHandler.handleArchiveFileException(this.plugin, archiveFile, t);
        }
        return null;
    }

    private void openFileArchive(SourceArchive dataTypeSource) {
        if (this.openFileArchive(dataTypeSource.getName(), dataTypeSource.getSourceArchiveID(), false) == null) {
            this.createInvalidArchiveNode(dataTypeSource);
        }
    }

    public Archive createArchive(File file) {
        try {
            FileArchive archive = new FileArchive(this, file);
            this.addArchivePath(new ResourceFile(file));
            this.addArchive(archive);
            return archive;
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.plugin.getProvider().getComponent(), (String)"Create Archive Failed", (Object)("Error creating archive file (" + file.getName() + "): " + e.getMessage()));
            return null;
        }
    }

    public Archive createProjectArchive() throws CancelledException {
        CreateDataTypeArchiveDataTreeDialog dialog = this.getCreateDialog();
        this.treeDialogCancelled = true;
        this.tool.showDialog((DialogComponentProvider)dialog);
        if (this.treeDialogCancelled) {
            throw new CancelledException();
        }
        DataTypeArchiveDB dataTypeArchive = dialog.getNewDataTypeArchiveDB();
        ProjectArchive archive = new ProjectArchive(this, (DataTypeArchive)dataTypeArchive, dataTypeArchive.getDomainFile());
        this.addArchive(archive);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArchive(Archive originalArchive, Archive newArchive, TaskMonitor monitor) {
        DataTypeManager originalManager = originalArchive.getDataTypeManager();
        DataTypeManager newManager = newArchive.getDataTypeManager();
        Category originalRoot = originalManager.getRootCategory();
        Category newRoot = newManager.getRootCategory();
        Category[] categories = originalRoot.getCategories();
        monitor.setMessage("Copy Archive " + originalArchive.getName() + " to " + newArchive.getName());
        monitor.initialize((long)categories.length);
        int transactionID = newManager.startTransaction("Copy Archive");
        try {
            DataType[] dataTypes;
            for (Category category : categories) {
                newRoot.copyCategory(category, null, monitor);
                monitor.incrementProgress(1L);
            }
            for (DataType type : dataTypes = originalRoot.getDataTypes()) {
                if (monitor.isCancelled()) {
                    return;
                }
                newRoot.addDataType(type, null);
            }
        }
        finally {
            newManager.endTransaction(transactionID, true);
        }
    }

    private void openArchives(String[] archiveFilenames) {
        for (String filename : archiveFilenames) {
            String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(filename);
            if (projectPathname != null) {
                DomainFile df = this.plugin.getProjectArchiveFile(projectPathname[0], projectPathname[1]);
                if (df == null) continue;
                this.plugin.openArchive(df);
                continue;
            }
            File file = new File(filename);
            if (!file.exists()) continue;
            try {
                this.openArchive(file, false, false);
            }
            catch (Throwable t) {
                DataTypeManagerHandler.handleArchiveFileException(this.plugin, new ResourceFile(file), t);
            }
        }
    }

    public boolean isAllowedArchivePath(String path) {
        if (path.startsWith("$GHIDRA_HOME")) {
            return false;
        }
        for (String unallowed : UNALLOWED_ARCHIVE_PATH_FRAGMENTS) {
            if (path.indexOf(unallowed) <= 0) continue;
            return false;
        }
        return true;
    }

    private void addArchivePath(ResourceFile archiveFilePath) {
        Path[] paths;
        Path newPath = new Path(archiveFilePath.getParentFile());
        if (!this.isAllowedArchivePath(newPath.getPathAsString())) {
            return;
        }
        for (Path path : paths = this.getArchivePaths()) {
            if (!path.equals((Object)newPath)) continue;
            if (!path.isEnabled()) {
                path.setEnabled(true);
                PathManager.savePathsToPreferences((String)DATA_TYPE_ARCHIVE_PATH_KEY, null, (Path[])paths);
            }
            return;
        }
        Path[] newPaths = new Path[paths.length + 1];
        System.arraycopy(paths, 0, newPaths, 0, paths.length);
        newPaths[paths.length] = newPath;
        PathManager.savePathsToPreferences((String)DATA_TYPE_ARCHIVE_PATH_KEY, (String)DISABLED_DATA_TYPE_ARCHIVE_PATH_KEY, (Path[])newPaths);
    }

    public Archive openArchive(File file, boolean acquireWriteLock, boolean isUserAction) throws IOException, DuplicateIdException {
        return this.openArchive(new ResourceFile(file), acquireWriteLock, isUserAction);
    }

    public Archive openArchive(ResourceFile file, boolean acquireWriteLock, boolean isUserAction) throws IOException, DuplicateIdException {
        Archive archive = this.getArchiveForFile(file = file.getCanonicalFile());
        if (archive == null) {
            archive = new FileArchive(this, file, acquireWriteLock);
            Archive existingArchive = this.findOpenFileArchiveWithID(archive.getDataTypeManager().getUniversalID());
            if (existingArchive != null) {
                archive.close();
                throw new DuplicateIdException(archive.getName(), existingArchive.getName());
            }
            this.addArchivePath(file);
            this.addArchive(archive);
        }
        if (isUserAction && archive instanceof FileArchive && file != null) {
            this.userOpenedFileArchiveNames.add(this.getSaveableArchive(file.getAbsolutePath()));
        }
        return archive;
    }

    private Archive findOpenFileArchiveWithID(UniversalID universalID) {
        if (universalID == null) {
            return null;
        }
        List<Archive> allArchives = this.getAllArchives();
        for (Archive archive : allArchives) {
            if (!universalID.equals((Object)archive.getDataTypeManager().getUniversalID())) continue;
            return archive;
        }
        return null;
    }

    public Archive openArchive(DomainFile domainFile, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        Archive archive = this.getArchiveForDomainFile(domainFile);
        if (archive != null) {
            return archive;
        }
        DataTypeArchive dataTypeArchive = (DataTypeArchive)domainFile.getDomainObject((Object)this.tool, okToUpgrade, okToRecover, monitor);
        archive = new ProjectArchive(this, dataTypeArchive, domainFile);
        this.addArchive(archive);
        return archive;
    }

    public Archive openArchive(DataTypeArchive dataTypeArchive) {
        return this.openArchive(dataTypeArchive, dataTypeArchive.getDomainFile());
    }

    public Archive openArchive(DataTypeArchive dataTypeArchive, DomainFile domainFile) {
        Archive archive = this.getArchiveForDomainFile(domainFile);
        if (archive != null) {
            return archive;
        }
        dataTypeArchive.addConsumer((Object)this.tool);
        archive = new ProjectArchive(this, dataTypeArchive, domainFile);
        this.addArchive(archive);
        return archive;
    }

    private void createInvalidArchiveNode(SourceArchive sourceArchive) {
        this.addInvalidArchive(new InvalidFileArchive(this, sourceArchive));
    }

    public DataTypeManager openArchive(String archiveName) throws IOException, DuplicateIdException {
        Archive archive;
        ResourceFile file = DataTypeArchiveUtility.findArchiveFile(archiveName);
        if (file != null && (archive = this.openArchive(file, false, false)) != null) {
            return archive.getDataTypeManager();
        }
        return null;
    }

    private Archive getArchiveForFile(ResourceFile file) {
        for (Archive archive : this.openArchives) {
            FileArchive fileArchive;
            if (!(archive instanceof FileArchive) || !file.equals((Object)(fileArchive = (FileArchive)archive).getFile())) continue;
            return fileArchive;
        }
        return null;
    }

    private Archive getArchiveForDomainFile(DomainFile domainFile) {
        for (Archive archive : this.openArchives) {
            ProjectArchive projectArchive;
            if (!(archive instanceof ProjectArchive) || !domainFile.equals((projectArchive = (ProjectArchive)archive).getDomainFile())) continue;
            return projectArchive;
        }
        return null;
    }

    private void addArchive(Archive archive) {
        String projectPath;
        this.updateArchiveNameInfo(archive);
        this.openArchives.add(archive);
        archive.getDataTypeManager().addDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        this.dataTypeIndexer.addDataTypeManager(archive.getDataTypeManager());
        if (!(archive instanceof ProgramArchive)) {
            this.tool.setConfigChanged(true);
        }
        if (archive instanceof ProjectArchive && (projectPath = this.getProjectPathname((ProjectArchive)archive, true)) != null) {
            this.userOpenedFileArchiveNames.add(projectPath);
        }
        this.fireArchiveOpened(archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArchiveNameInfo(Archive archive) {
        int transactionID;
        DataTypeManager dataTypeManager = archive.getDataTypeManager();
        try {
            transactionID = dataTypeManager.startTransaction("Update Data Type Source Archive Names");
        }
        catch (Exception e) {
            return;
        }
        try {
            for (Archive existingArchive : this.openArchives) {
                if (!existingArchive.isModifiable()) continue;
                DataTypeManager existingDataTypeManager = existingArchive.getDataTypeManager();
                dataTypeManager.updateSourceArchiveName(existingDataTypeManager.getUniversalID(), existingDataTypeManager.getName());
                int existingTxID = existingDataTypeManager.startTransaction("Update Data Type Source Archive Name");
                try {
                    existingDataTypeManager.updateSourceArchiveName(dataTypeManager.getUniversalID(), dataTypeManager.getName());
                }
                finally {
                    existingDataTypeManager.endTransaction(existingTxID, true);
                }
            }
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private boolean isKnownInvalidArchive(SourceArchive sourceArchive) {
        return this.invalidArchives.get(sourceArchive.getSourceArchiveID()) != null;
    }

    private void addInvalidArchive(InvalidFileArchive archive) {
        this.invalidArchives.put(archive.getUniversalID(), archive);
        this.fireArchiveOpened(archive);
    }

    public List<Archive> getAllArchives() {
        return new ArrayList<Archive>(this.openArchives);
    }

    void archiveClosed(Archive archive) {
        if (archive instanceof InvalidFileArchive) {
            this.invalidArchives.remove(((InvalidFileArchive)archive).getUniversalID());
        } else {
            if (archive instanceof ProjectArchive) {
                ((ProjectArchive)archive).getDomainObject().release((Object)this.tool);
            }
            archive.getDataTypeManager().removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
            this.dataTypeIndexer.removeDataTypeManager(archive.getDataTypeManager());
            this.openArchives.remove(archive);
        }
        this.tool.setConfigChanged(true);
        this.fireArchiveClosed(archive);
    }

    void dataTypeManagerChanged(FileArchive archive, DataTypeManager oldManager, DataTypeManager newManager) {
        oldManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        newManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.listenerDelegate);
        this.dataTypeIndexer.removeDataTypeManager(oldManager);
        this.dataTypeIndexer.addDataTypeManager(newManager);
        this.fireDataTypeManagerChanged(archive);
    }

    public void setRecentlyUsedDataType(DataType dataType) {
        this.recentlyUsedDataType = new RecentlyUsedDataType(dataType);
    }

    public DataType getRecentlyDataType() {
        return this.recentlyUsedDataType.getDataType();
    }

    public DataTypeManager getBuiltInDataTypesManager() {
        return this.builtInDataTypesManager;
    }

    public DataTypeIndexer getDataTypeIndexer() {
        return this.dataTypeIndexer;
    }

    public void closeAllArchives() {
        Archive[] archives;
        for (Archive archive : archives = this.openArchives.toArray(new Archive[this.openArchives.size()])) {
            archive.close();
        }
    }

    public void closeArchive(DataTypeManager dtm) {
        if (dtm instanceof BuiltInDataTypeManager) {
            Msg.info((Object)this, (Object)"Cannot close the built-in Data Type Manager");
            return;
        }
        if (dtm instanceof ProgramDataTypeManager) {
            Msg.info((Object)this, (Object)"Cannot close the Program's Data Type Manager");
            return;
        }
        Archive archive = this.getArchive(dtm);
        if (archive == null) {
            Msg.info((Object)this, (Object)("Unable close archive; archive not open: '" + dtm.getName() + "'"));
        }
        this.closeArchive(archive);
        Msg.info((Object)this, (Object)("Closed archive: '" + archive.getName() + "'"));
    }

    private Archive getArchive(DataTypeManager dtm) {
        for (Archive archive : this.openArchives) {
            DataTypeManager dataTypeManager = archive.getDataTypeManager();
            if (!dataTypeManager.equals(dtm)) continue;
            return archive;
        }
        return null;
    }

    public void closeArchive(Archive archive) {
        DataTypeEditorManager editorManager = this.plugin.getEditorManager();
        editorManager.dismissEditors(archive.getDataTypeManager());
        archive.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidArchive(InvalidFileArchive archive) {
        archive.close();
        if (this.programArchive == null) {
            return;
        }
        ProgramDataTypeManager programDataTypeManager = (ProgramDataTypeManager)this.programArchive.getDataTypeManager();
        Program program = this.programArchive.getProgram();
        int ID = program.startTransaction("Remove Invalid Source Archive From Program");
        try {
            UniversalID sourceArchiveID = archive.getUniversalID();
            SourceArchive sourceArchive = programDataTypeManager.getSourceArchive(sourceArchiveID);
            if (sourceArchive != null) {
                programDataTypeManager.removeSourceArchive(sourceArchive);
            }
        }
        finally {
            program.endTransaction(ID, true);
        }
    }

    public void addArchiveManagerListener(ArchiveManagerListener listener) {
        this.archiveManagerlisteners.add(listener);
    }

    public void removeArchiveManagerListener(ArchiveManagerListener listener) {
        this.archiveManagerlisteners.remove(listener);
    }

    private void fireArchiveOpened(Archive archive) {
        SystemUtilities.runSwingNow(() -> {
            for (ArchiveManagerListener listener : this.archiveManagerlisteners) {
                listener.archiveOpened(archive);
            }
        });
    }

    private void fireArchiveClosed(Archive archive) {
        SystemUtilities.runSwingNow(() -> {
            for (ArchiveManagerListener listener : this.archiveManagerlisteners) {
                listener.archiveClosed(archive);
            }
        });
    }

    public void fireDataTypeManagerChanged(FileArchive archive) {
        SystemUtilities.runSwingNow(() -> {
            for (ArchiveManagerListener listener : this.archiveManagerlisteners) {
                listener.archiveDataTypeManagerChanged(archive);
            }
        });
    }

    public void fireArchiveStateChanged(Archive archive) {
        SystemUtilities.runSwingNow(() -> {
            for (ArchiveManagerListener listener : this.archiveManagerlisteners) {
                listener.archiveStateChanged(archive);
            }
        });
    }

    public boolean isInUse(File file) {
        for (Archive archive : this.openArchives) {
            if (!(archive instanceof FileArchive) || !file.equals(((FileArchive)archive).getFile().getFile(false))) continue;
            return true;
        }
        return false;
    }

    public List<Archive> getAllFileOrProjectArchives() {
        ArrayList<Archive> archiveList = new ArrayList<Archive>();
        for (Archive archive : this.openArchives) {
            if (!(archive instanceof FileArchive) && !(archive instanceof ProjectArchive)) continue;
            archiveList.add(archive);
        }
        return archiveList;
    }

    public List<Archive> getAllModifiedFileArchives() {
        ArrayList<Archive> archiveList = new ArrayList<Archive>();
        for (Archive archive : this.openArchives) {
            if (!archive.isModifiable() || !(archive instanceof FileArchive)) continue;
            archiveList.add(archive);
        }
        return archiveList;
    }

    public List<DataType> getFavoriteDataTypes() {
        ArrayList<DataType> list = new ArrayList<DataType>();
        List<Archive> allArchives = this.getAllArchives();
        for (Archive archive : allArchives) {
            DataTypeManager dataTypeManager = archive.getDataTypeManager();
            list.addAll(dataTypeManager.getFavorites());
        }
        return list;
    }

    private void initializeFavorites() {
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)PointerDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)CharDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)StringDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)TerminatedStringDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)TerminatedUnicodeDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)FloatDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)DoubleDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)LongDoubleDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)IntegerDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)LongDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)UnsignedIntegerDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)UnsignedLongDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)ByteDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)WordDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)DWordDataType.dataType, null), true);
        this.builtInDataTypesManager.setFavorite(this.builtInDataTypesManager.resolve((DataType)QWordDataType.dataType, null), true);
    }

    public void save(SaveState saveState) {
        this.saveArchiveNames(saveState);
        this.saveFavorites(saveState);
    }

    public void restore(SaveState saveState) {
        this.restoreArchiveNames(saveState);
        this.restoreFavorites(saveState);
    }

    private void saveArchiveNames(SaveState saveState) {
        ArrayList<String> openNameList = new ArrayList<String>();
        if (this.knownOpenFileArchiveNames.isEmpty()) {
            for (Archive archive : this.openArchives) {
                String filePath = null;
                if (archive instanceof FileArchive) {
                    FileArchive fileArchive = (FileArchive)archive;
                    ResourceFile file = fileArchive.getFile();
                    if (file != null) {
                        filePath = file.getAbsolutePath();
                    }
                } else if (archive instanceof ProjectArchive) {
                    filePath = this.getProjectPathname((ProjectArchive)archive, true);
                }
                if (filePath == null) continue;
                openNameList.add(filePath);
            }
        } else {
            openNameList.addAll(this.knownOpenFileArchiveNames);
        }
        saveState.putStrings(ARCHIVE_NAMES, this.getSaveableArchiveNames(openNameList));
        ArrayList<String> recentMenuList = new ArrayList<String>();
        Collection<String> recentlyOpenedArchives = this.plugin.getRecentlyOpenedArchives();
        for (String file : recentlyOpenedArchives) {
            recentMenuList.add(file);
        }
        saveState.putStrings(RECENT_NAMES, this.getSaveableArchiveNames(recentMenuList));
        this.initiallyOpenedFileArchiveNames = this.getOpenFileArchiveNames(this.openArchives);
    }

    private String[] getSaveableArchiveNames(List<String> absoluteFilenameList) {
        String[] saveableFilenames = new String[absoluteFilenameList.size()];
        for (int i = 0; i < absoluteFilenameList.size(); ++i) {
            saveableFilenames[i] = this.getSaveableArchive(absoluteFilenameList.get(i));
        }
        return saveableFilenames;
    }

    private String getSaveableArchive(String absoluteFilename) {
        if (absoluteFilename.startsWith(PROJECT_NAME_DELIMETER)) {
            return absoluteFilename;
        }
        Path path = new Path(absoluteFilename);
        return path.getPathAsString();
    }

    private void restoreArchiveNames(SaveState saveState) {
        String[] savedFilenames = saveState.getStrings(ARCHIVE_NAMES, new String[0]);
        String[] filenames = DataTypeManagerHandler.getAbsoluteArchiveNames(savedFilenames);
        this.openArchives(filenames);
        String[] recentFilenames = saveState.getStrings(RECENT_NAMES, null);
        for (String filename : filenames = DataTypeManagerHandler.getAbsoluteArchiveNames(recentFilenames)) {
            if (filename.startsWith(PROJECT_NAME_DELIMETER)) {
                String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(filename);
                if (projectPathname == null) continue;
                this.plugin.addRecentlyOpenedProjectArchive(projectPathname[0], projectPathname[1]);
                continue;
            }
            ResourceFile file = new ResourceFile(filename);
            if (!file.exists()) continue;
            file = file.getCanonicalFile();
            this.plugin.addRecentlyOpenedArchiveFile(file);
        }
        for (String filename : savedFilenames) {
            this.initiallyOpenedFileArchiveNames.add(filename);
        }
        this.userOpenedFileArchiveNames = new HashSet<String>();
        this.knownOpenFileArchiveNames = new HashSet<String>();
    }

    public String getProjectPathname(ProjectArchive pa, boolean activeProjectOnly) {
        String projectName;
        DomainFile df = pa.getDomainObject().getDomainFile();
        ProjectLocator projectLocator = df.getProjectLocator();
        String dfProjectName = projectName = projectLocator.getName();
        boolean remember = df.isInWritableProject();
        if (!remember) {
            Project project = this.tool.getProjectManager().getActiveProject();
            remember = project != null && project.getName().equals(dfProjectName) && df.getVersion() == -1;
        }
        return remember ? DataTypeManagerHandler.getProjectPathname(projectName, df.getPathname()) : null;
    }

    private static String[] getAbsoluteArchiveNames(String[] saveableFilenames) {
        if (saveableFilenames == null) {
            return new String[0];
        }
        ArrayList<String> absoluteFilenameList = new ArrayList<String>();
        for (String filename : saveableFilenames) {
            try {
                filename = filename.startsWith(PROJECT_NAME_DELIMETER) ? filename : DataTypeManagerHandler.getAbsoluteArchive(filename);
                absoluteFilenameList.add(filename);
            }
            catch (FileNotFoundException e) {
                Msg.error(DataTypeManagerHandler.class, (Object)e.getMessage());
            }
        }
        String[] absoluteFilenames = new String[absoluteFilenameList.size()];
        for (int i = 0; i < absoluteFilenames.length; ++i) {
            absoluteFilenames[i] = (String)absoluteFilenameList.get(i);
        }
        return absoluteFilenames;
    }

    private static String getAbsoluteArchive(String saveableFilename) throws FileNotFoundException {
        if (saveableFilename.startsWith(RELATIVE_PATH_PREFIX)) {
            ResourceFile file = DataTypeArchiveUtility.findArchiveFile(saveableFilename);
            if (file == null) {
                throw new FileNotFoundException("Archive not found: " + saveableFilename);
            }
            return file.getAbsolutePath();
        }
        Path path = new Path(saveableFilename);
        return path.getPath().getAbsolutePath();
    }

    void saveFavorites(SaveState saveState) {
        List favoritesList = this.builtInDataTypesManager.getFavorites();
        String[] names = new String[favoritesList.size()];
        for (int i = 0; i < names.length; ++i) {
            DataType dataType = (DataType)favoritesList.get(i);
            names[i] = dataType.getPathName();
        }
        saveState.putStrings(FAVORITES, names);
    }

    void restoreFavorites(SaveState saveState) {
        String[] names = saveState.getStrings(FAVORITES, new String[0]);
        if (names.length == 0) {
            return;
        }
        HashSet<DataType> favorites = new HashSet<DataType>();
        for (String name : names) {
            DataType dataType = this.builtInDataTypesManager.getDataType(name);
            if (dataType == null) continue;
            favorites.add(dataType);
        }
        List currentFavoritesList = this.builtInDataTypesManager.getFavorites();
        for (DataType type : currentFavoritesList) {
            if (favorites.contains(type)) {
                favorites.remove(type);
                continue;
            }
            this.builtInDataTypesManager.setFavorite(type, false);
        }
        for (DataType dataType : favorites) {
            this.builtInDataTypesManager.setFavorite(dataType, true);
        }
    }

    public DataTypeManager[] getDataTypeManagers() {
        DataTypeManager[] managers = new DataTypeManager[this.openArchives.size()];
        for (int i = 0; i < managers.length; ++i) {
            managers[i] = this.openArchives.get(i).getDataTypeManager();
        }
        return managers;
    }

    public void addDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        this.dataTypeManagerListeners.add(listener);
    }

    public void removeDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        this.dataTypeManagerListeners.remove(listener);
    }

    public void updateKnownOpenArchives() {
        this.knownOpenFileArchiveNames = this.getOpenFileArchiveNames(this.openArchives);
        if (!this.knownOpenFileArchiveNames.equals(this.initiallyOpenedFileArchiveNames)) {
            this.tool.setConfigChanged(true);
        }
    }

    private Set<String> getOpenFileArchiveNames(List<Archive> archives) {
        HashSet<String> newSet = new HashSet<String>();
        for (Archive archive : archives) {
            String filePath = null;
            if (archive instanceof FileArchive) {
                ResourceFile file = ((FileArchive)archive).getFile();
                if (file != null) {
                    filePath = this.getSaveableArchive(file.getAbsolutePath());
                }
            } else if (archive instanceof ProjectArchive) {
                filePath = this.getProjectPathname((ProjectArchive)archive, true);
            }
            if (filePath == null || !this.initiallyOpenedFileArchiveNames.contains(filePath) && !this.userOpenedFileArchiveNames.contains(filePath)) continue;
            newSet.add(filePath);
        }
        return newSet;
    }

    public Set<String> getPossibleEquateNames(long value) {
        HashSet<String> equateNames = new HashSet<String>();
        for (int i = 0; i < this.openArchives.size(); ++i) {
            DataTypeManager dtMgr = this.openArchives.get(i).getDataTypeManager();
            dtMgr.findEnumValueNames(value, equateNames);
        }
        return equateNames;
    }

    public void save(UndoableDomainObject undoableDomainObject) {
        this.tool.prepareToSave((DomainObject)undoableDomainObject);
        if (this.acquireSaveLock(undoableDomainObject)) {
            try {
                DomainFileSaveTask task = new DomainFileSaveTask(CONTENT_NAME, undoableDomainObject.getDomainFile(), this.tool);
                new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
            }
            finally {
                undoableDomainObject.unlock();
            }
        }
    }

    public void saveAs(UndoableDomainObject undoableDomainObject) {
        if (!this.getSaveAsLock(undoableDomainObject)) {
            return;
        }
        try {
            DataTreeDialog dialog = this.getSaveDialog();
            this.treeDialogCancelled = true;
            this.tool.showDialog((DialogComponentProvider)dialog);
            if (!this.treeDialogCancelled) {
                this.saveAs(undoableDomainObject, dialog.getDomainFolder(), dialog.getNameText());
            }
        }
        finally {
            undoableDomainObject.unlock();
        }
    }

    private void saveAs(UndoableDomainObject undoableDomainObject, DomainFolder folder, String name) {
        DomainFile existingFile = folder.getFile(name);
        if (existingFile == undoableDomainObject.getDomainFile()) {
            this.save(undoableDomainObject);
            return;
        }
        if (existingFile != null) {
            String msg = "Program " + name + " already exists.\nDo you want to overwrite it?";
            if (OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Duplicate Name", (String)msg, (String)"Overwrite", (int)3) == 0) {
                return;
            }
        }
        this.tool.prepareToSave((DomainObject)undoableDomainObject);
        DomainObjectSaveAsTask task = new DomainObjectSaveAsTask(CONTENT_NAME, undoableDomainObject, folder, name, existingFile != null);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    private boolean acquireSaveLock(UndoableDomainObject undoableDomainObject) {
        if (!undoableDomainObject.lock(null)) {
            String title = "Save Data Type Archive (Busy)";
            StringBuffer buf = new StringBuffer();
            buf.append("The Data Type Archive is currently being modified by \n");
            buf.append("the following actions:\n ");
            Transaction t = undoableDomainObject.getCurrentTransaction();
            ArrayList list = t.getOpenSubTransactions();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                buf.append("\n     ");
                buf.append((String)it.next());
            }
            buf.append("\n \n");
            buf.append("WARNING! The above task(s) should be cancelled before attempting a Save.\n");
            buf.append("Only proceed if unable to cancel them.\n \n");
            buf.append("If you continue, all changes made by these tasks, as well as any other overlapping task,\n");
            buf.append("will be LOST and subsequent transaction errors may occur while these tasks remain active.\n \n");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)"Save Archive!", (int)2);
            if (result == 1) {
                undoableDomainObject.forceLock(true, "Save Archive");
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean getSaveAsLock(UndoableDomainObject undoableDomainObject) {
        if (!undoableDomainObject.lock(null)) {
            String title = "Save Data Type Archive As (Busy)";
            StringBuffer buf = new StringBuffer();
            buf.append("The Data Type Archive is currently being modified by the following actions/tasks:\n \n");
            Transaction t = undoableDomainObject.getCurrentTransaction();
            ArrayList list = t.getOpenSubTransactions();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                buf.append("\n     ");
                buf.append((String)it.next());
            }
            buf.append("\n \n");
            buf.append("WARNING! The above task(s) should be cancelled before attempting a Save As...\n");
            buf.append("Only proceed if unable to cancel them.\n \n");
            buf.append("If you click 'Save Archive As (Rollback)' {recommended}, all changes made\n");
            buf.append("by these tasks, as well as any other overlapping task, will be LOST!\n");
            buf.append("If you click 'Save As (As Is)', the archive will be saved in its current\n");
            buf.append("state which may contain some incomplete data.\n");
            buf.append("Any forced save may also result in subsequent transaction errors while\n");
            buf.append("the above tasks remain active.\n ");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)"Save Archive As (Rollback)!", (String)"Save Archive As (As Is)!", (int)2);
            if (result == 1) {
                undoableDomainObject.forceLock(true, "Save Archive As");
                return true;
            }
            if (result == 2) {
                undoableDomainObject.forceLock(false, "Save Archive As");
                return true;
            }
            return false;
        }
        return true;
    }

    private DataTreeDialog getSaveDialog() {
        if (this.dataTreeSaveDialog == null) {
            ActionListener listener = event -> {
                DomainFolder folder = this.dataTreeSaveDialog.getDomainFolder();
                String newName = this.dataTreeSaveDialog.getNameText();
                if (newName.length() == 0) {
                    this.dataTreeSaveDialog.setStatusText("Please enter a name");
                    return;
                }
                if (folder == null) {
                    this.dataTreeSaveDialog.setStatusText("Please select a folder");
                    return;
                }
                DomainFile file = folder.getFile(newName);
                if (file != null && file.isReadOnly()) {
                    this.dataTreeSaveDialog.setStatusText("Read Only.  Choose new name/folder");
                } else {
                    this.dataTreeSaveDialog.close();
                    this.treeDialogCancelled = false;
                }
            };
            this.dataTreeSaveDialog = new DataTreeDialog(null, "Save As", 1, this.domainFileFilter);
            this.dataTreeSaveDialog.addOkActionListener(listener);
            this.dataTreeSaveDialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Save_As_File"));
        }
        return this.dataTreeSaveDialog;
    }

    private CreateDataTypeArchiveDataTreeDialog getCreateDialog() {
        if (this.dataTreeCreateDialog == null) {
            ActionListener listener = event -> {
                DomainFolder folder = this.dataTreeCreateDialog.getDomainFolder();
                String newName = this.dataTreeCreateDialog.getNameText();
                if (newName.length() == 0) {
                    this.dataTreeCreateDialog.setStatusText("Please enter a name");
                    return;
                }
                if (folder == null) {
                    this.dataTreeCreateDialog.setStatusText("Please select a folder");
                    return;
                }
                DomainFile file = folder.getFile(newName);
                if (file != null) {
                    this.dataTreeCreateDialog.setStatusText("Choose a name that doesn't exist.");
                    return;
                }
                if (!this.dataTreeCreateDialog.createNewDataTypeArchive()) {
                    return;
                }
                this.dataTreeCreateDialog.close();
                this.treeDialogCancelled = false;
            };
            this.dataTreeCreateDialog = new CreateDataTypeArchiveDataTreeDialog(null, "Create", 3, this.domainFileFilter);
            this.dataTreeCreateDialog.addOkActionListener(listener);
            this.dataTreeCreateDialog.setHelpLocation(new HelpLocation("DataManagerPlugin", "Create_Data_Type_Archive"));
        }
        return this.dataTreeCreateDialog;
    }

    public DataTypeManager getDataTypeManager(SourceArchive source) {
        List<Archive> allArchives = this.getAllArchives();
        for (Archive archive : allArchives) {
            DataTypeManager dataTypeManager = archive.getDataTypeManager();
            UniversalID universalID = dataTypeManager.getUniversalID();
            if (universalID == null || !universalID.equals((Object)source.getSourceArchiveID())) continue;
            return dataTypeManager;
        }
        return null;
    }

    public static void handleArchiveFileException(DataTypeManagerPlugin plugin, ResourceFile archiveFile, Throwable t) {
        if (t instanceof FileNotFoundException) {
            Msg.showError((Object)plugin, (Component)plugin.getProvider().getComponent(), (String)"File Not Found", (Object)(archiveFile.getAbsolutePath() + " not found!"));
        } else if (t instanceof IOException) {
            Throwable cause = t.getCause();
            if (cause instanceof VersionException) {
                VersionExceptionHandler.showVersionError(null, (String)archiveFile.getName(), (String)"Archive", (String)"open", (VersionException)((VersionException)cause));
            } else {
                Msg.showError((Object)plugin, (Component)plugin.getProvider().getComponent(), (String)"Open Archive Failed", (Object)(t.getMessage() + ": " + archiveFile.getName()));
            }
        } else if (t instanceof DuplicateIdException) {
            DuplicateIdException dupIdExc = (DuplicateIdException)t;
            Msg.showError((Object)plugin, (Component)plugin.getProvider().getComponent(), (String)"Duplicate Archive ID Error", (Object)("Attempted to open a datatype archive with the same ID as datatype archive that is already open. " + dupIdExc.getNewArchiveName() + " has same id as " + dupIdExc.getExistingArchiveName()));
        } else {
            Msg.showError((Object)plugin, (Component)plugin.getProvider().getComponent(), (String)"Open Archive Failed", (Object)("Unexpected exception opening archive: " + archiveFile.getName()), (Throwable)t);
        }
    }

    public static String getProjectPathname(String projectName, String pathname) {
        if (pathname.length() < 2 || !pathname.startsWith(FileSystem.SEPARATOR)) {
            throw new IllegalArgumentException("Absolute project pathname required");
        }
        return PROJECT_NAME_DELIMETER + projectName + PROJECT_NAME_DELIMETER + pathname;
    }

    public static String[] parseProjectPathname(String projectFilePath) {
        int index;
        if (projectFilePath.startsWith(PROJECT_NAME_DELIMETER) && (index = projectFilePath.indexOf(PROJECT_NAME_DELIMETER, 1)) > 0) {
            String projectName = projectFilePath.substring(1, index);
            String pathname = projectFilePath.substring(index + 1);
            if (pathname.length() > 1 && pathname.startsWith(FileSystem.SEPARATOR)) {
                return new String[]{projectName, pathname};
            }
        }
        return null;
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            if (!"Archive".equals(file.getContentType())) {
                return;
            }
            for (Archive archive : DataTypeManagerHandler.this.openArchives) {
                ProjectArchive projectArchive;
                DomainFile domainFile;
                if (!(archive instanceof ProjectArchive) || !file.equals(domainFile = (projectArchive = (ProjectArchive)archive).getDomainFile()) || projectArchive.isModifiable() || !file.isCheckedOut()) continue;
                this.replaceArchiveWithFile(projectArchive, file);
                return;
            }
        }

        public void domainFileRemoved(DomainFolder parentFolder, String name, String fileID) {
        }

        public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
            if (oldObject instanceof DataTypeArchiveDB) {
                for (Archive archive : DataTypeManagerHandler.this.openArchives) {
                    ProjectArchive projectArchive;
                    DataTypeArchive domainObject;
                    if (!(archive instanceof ProjectArchive) || (domainObject = (projectArchive = (ProjectArchive)archive).getDomainObject()) != oldObject) continue;
                    this.replaceArchiveWithFile(projectArchive, file);
                    return;
                }
            }
        }

        public void domainFileRenamed(DomainFile file, String oldName) {
            if (!"Archive".equals(file.getContentType())) {
                return;
            }
            String newName = file.getName();
            String fileID = file.getFileID();
            for (Archive archive : DataTypeManagerHandler.this.openArchives) {
                if (!archive.isModifiable()) continue;
                DataTypeManager dataTypeManager = archive.getDataTypeManager();
                DataTypeManagerHandler.this.updateSourceArchiveName(dataTypeManager, fileID, newName);
            }
        }

        private void replaceArchiveWithFile(ProjectArchive projectArchive, DomainFile newDomainFile) {
            DataTypeArchive archiveDomainObject;
            DomainFile objectDomainFile;
            DomainFile archiveDomainFile = projectArchive.getDomainFile();
            if (archiveDomainFile == (objectDomainFile = (archiveDomainObject = projectArchive.getDomainObject()).getDomainFile())) {
                return;
            }
            DataTypeManagerHandler.this.closeArchive(projectArchive);
            String contentType = null;
            try {
                contentType = newDomainFile.getContentType();
                try {
                    DataTypeManagerHandler.this.openArchive(newDomainFile, false, false, TaskMonitorAdapter.DUMMY_MONITOR);
                }
                catch (VersionException e) {
                    if (VersionExceptionHandler.isUpgradeOK(null, (DomainFile)newDomainFile, (String)"Re-open", (VersionException)e)) {
                        DataTypeManagerHandler.this.openArchive(newDomainFile, true, false, TaskMonitorAdapter.DUMMY_MONITOR);
                    }
                }
            }
            catch (VersionException e) {
                VersionExceptionHandler.showVersionError(null, (String)newDomainFile.getName(), (String)contentType, (String)"Re-open", (VersionException)e);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
            catch (Exception e) {
                if (newDomainFile.isInWritableProject() && e instanceof IOException) {
                    RepositoryAdapter repo = newDomainFile.getParent().getProjectData().getRepository();
                    ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Re-open File", null);
                }
                Msg.showError((Object)((Object)this), null, (String)("Error Opening " + newDomainFile.getName()), (Object)("Opening data type archive failed.\n" + e.getMessage()));
            }
        }
    }

    static class DomainObjectSaveAsTask
    extends Task {
        private String domainObjectType;
        private UndoableDomainObject domainObject;
        private DomainFolder parentFolder;
        private String newName;
        private boolean doOverwrite;

        DomainObjectSaveAsTask(String domainObjectType, UndoableDomainObject domainObject, DomainFolder folder, String newName, boolean doOverwrite) {
            super("Save " + domainObjectType + " As", true, true, true);
            this.domainObjectType = domainObjectType;
            this.domainObject = domainObject;
            this.parentFolder = folder;
            this.newName = newName;
            this.doOverwrite = doOverwrite;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMessage("Saving " + this.domainObjectType + "...");
            try {
                if (this.doOverwrite) {
                    DomainFile df = this.parentFolder.getFile(this.newName);
                    df.delete();
                }
                this.parentFolder.createFile(this.newName, (DomainObject)this.domainObject, monitor);
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)("Error Overwriting " + this.domainObjectType), (Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)((Object)this), null, (String)"Invalid Name", (Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                Msg.showError((Object)((Object)this), null, (String)"Error", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    static class DomainFileSaveTask
    extends Task {
        private String domainObjectType;
        private DomainFile domainFile;
        private PluginTool pluginTool;

        DomainFileSaveTask(String domainObjectType, DomainFile df, PluginTool tool) {
            super("Save " + domainObjectType, true, true, true);
            this.domainObjectType = domainObjectType;
            this.domainFile = df;
            this.pluginTool = tool;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMessage("Saving " + this.domainObjectType + "...");
            try {
                this.domainFile.save(monitor);
            }
            catch (CancelledException cancelledException) {
            }
            catch (NotConnectedException e) {
                ClientUtil.promptForReconnect((RepositoryAdapter)this.pluginTool.getProject().getRepository(), (Component)this.pluginTool.getToolFrame());
            }
            catch (ConnectException e) {
                ClientUtil.promptForReconnect((RepositoryAdapter)this.pluginTool.getProject().getRepository(), (Component)this.pluginTool.getToolFrame());
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)this.pluginTool.getProject().getRepository(), (Exception)e, (String)"Save File", (Component)this.pluginTool.getToolFrame());
            }
        }
    }

    private class CreateDataTypeArchiveDataTreeDialog
    extends DataTreeDialog {
        private DataTypeArchiveDB dataTypeArchiveDB;

        CreateDataTypeArchiveDataTreeDialog(Component parent, String title, int type, DomainFileFilter filter) {
            super(parent, title, type, filter);
        }

        boolean createNewDataTypeArchive() {
            this.dataTypeArchiveDB = null;
            DomainFolder domainFolder = this.getDomainFolder();
            String archiveName = this.getNameText();
            try {
                this.dataTypeArchiveDB = new DataTypeArchiveDB(domainFolder, archiveName, (Object)DataTypeManagerHandler.this.tool);
                return true;
            }
            catch (DuplicateNameException e) {
                DataTypeManagerHandler.this.dataTreeCreateDialog.setStatusText("Duplicate Name: " + e.getMessage());
            }
            catch (InvalidNameException e) {
                DataTypeManagerHandler.this.dataTreeCreateDialog.setStatusText("Invalid Name: " + e.getMessage());
            }
            catch (IOException e) {
                DataTypeManagerHandler.this.dataTreeCreateDialog.setStatusText("Unexpected IOException!");
                Msg.showError(null, (Component)DataTypeManagerHandler.this.dataTreeCreateDialog.getComponent(), (String)"Unexpected Exception", (Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }

        DataTypeArchiveDB getNewDataTypeArchiveDB() {
            return this.dataTypeArchiveDB;
        }
    }

    class DataTypeManagerListenerDelegate
    implements DataTypeManagerChangeListener {
        DataTypeManagerListenerDelegate() {
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.categoryAdded(dtm, path);
            }
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.categoryMoved(dtm, oldPath, newPath);
            }
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.categoryRemoved(dtm, path);
            }
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.categoryRenamed(dtm, oldPath, newPath);
            }
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeAdded(dtm, path);
            }
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeChanged(dtm, path);
            }
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeMoved(dtm, oldPath, newPath);
            }
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeRemoved(dtm, path);
            }
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeRenamed(dtm, oldPath, newPath);
            }
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.dataTypeReplaced(dtm, oldPath, newPath, newDataType);
            }
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.favoritesChanged(dtm, path, isFavorite);
            }
        }

        public void sourceArchiveAdded(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.sourceArchiveAdded(dataTypeManager, dataTypeSource);
            }
        }

        public void sourceArchiveChanged(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
            for (DataTypeManagerChangeListener listener : DataTypeManagerHandler.this.dataTypeManagerListeners) {
                listener.sourceArchiveChanged(dataTypeManager, dataTypeSource);
            }
        }
    }

    class RecentlyUsedDataType {
        private String dataTypeManagerName;
        private CategoryPath path;
        private String dataTypeName;

        RecentlyUsedDataType() {
        }

        RecentlyUsedDataType(DataType dt) {
            this.dataTypeName = dt.getName();
            this.path = dt.getCategoryPath();
            DataTypeManager dtMgr = dt.getDataTypeManager();
            String string = this.dataTypeManagerName = dtMgr == null ? null : dtMgr.getName();
            if (this.dataTypeManagerName == null && DataTypeManagerHandler.this.programArchive != null) {
                DataTypeManager programDataTypeManager = DataTypeManagerHandler.this.programArchive.getDataTypeManager();
                this.dataTypeManagerName = programDataTypeManager.getName();
            }
        }

        public DataType getDataType() {
            DataType dt;
            if (this.dataTypeName == null) {
                return null;
            }
            DataTypeManager dtMgr = this.findDataTypeManager();
            Category category = dtMgr.getCategory(this.path);
            if (category != null && (dt = category.getDataType(this.dataTypeName)) != null) {
                return dt;
            }
            return this.getBuiltInDataType();
        }

        private DataType getBuiltInDataType() {
            DataType dt;
            DataTypeManager dtMgr = DataTypeManagerHandler.this.getBuiltInDataTypesManager();
            Category category = dtMgr.getCategory(this.path);
            if (category != null && (dt = category.getDataType(this.dataTypeName)) != null) {
                return dt;
            }
            return null;
        }

        private DataTypeManager findDataTypeManager() {
            for (Archive archive : DataTypeManagerHandler.this.openArchives) {
                if (!archive.getName().equals(this.dataTypeManagerName)) continue;
                return archive.getDataTypeManager();
            }
            return DataTypeManagerHandler.this.builtInDataTypesManager;
        }
    }
}

