/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.TLSDirectory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class TLSDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_TLS";
    private TLSDirectory tls;

    static TLSDataDirectory createTLSDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        TLSDataDirectory tlsDataDirectory = (TLSDataDirectory)reader.getFactory().create(TLSDataDirectory.class, new Object[0]);
        tlsDataDirectory.initTLSDataDirectory(ntHeader, reader);
        return tlsDataDirectory;
    }

    private void initTLSDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    public TLSDirectory getTLSDirectory() {
        return this.tls;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, DataTypeConflictException, IOException {
        monitor.setMessage(program.getName() + ": TLS...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        PeUtils.createData(program, addr, this.tls.toDataType(), log);
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        this.tls = TLSDirectory.createTLSDirectory(this.reader, ptr, this.ntHeader.getOptionalHeader().is64bit());
        return true;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        return this.tls.toDataType();
    }
}

