/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.XReferenceUtil;
import ghidra.app.util.exporter.AbstractLineDispenser;
import ghidra.app.util.exporter.ProgramTextOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ReferenceLineDispenser
extends AbstractLineDispenser {
    private static final Address[] EMPTY_ADDR_ARR = new Address[0];
    private static final String XREFS_DELIM = ",";
    private int headerWidth;
    private boolean displayRefHeader;
    private String header;
    private Memory memory;
    private ReferenceManager referenceManager;
    private List<String> lines = new ArrayList<String>();

    ReferenceLineDispenser() {
    }

    ReferenceLineDispenser(boolean forwardRefs, CodeUnit cu, Program program, ProgramTextOptions options) {
        this.memory = program.getMemory();
        this.referenceManager = program.getReferenceManager();
        this.displayRefHeader = options.isShowReferenceHeaders();
        this.prefix = options.getCommentPrefix();
        this.header = forwardRefs ? " FWD" : "XREF";
        this.headerWidth = options.getRefHeaderWidth();
        this.width = options.getRefWidth();
        this.fillAmount = options.getAddrWidth() + options.getBytesWidth() + options.getLabelWidth();
        this.isHTML = options.isHTML();
        Address[] refs = forwardRefs ? this.getForwardRefs(cu) : XReferenceUtil.getXRefList(cu);
        Address[] offcuts = forwardRefs ? EMPTY_ADDR_ARR : XReferenceUtil.getOffcutXRefList(cu);
        this.processRefs(cu.getMinAddress(), refs, offcuts);
    }

    ReferenceLineDispenser(Variable var, Program program, ProgramTextOptions options) {
        this.memory = program.getMemory();
        this.referenceManager = program.getReferenceManager();
        this.displayRefHeader = options.isShowReferenceHeaders();
        this.header = "XREF";
        this.headerWidth = options.getRefHeaderWidth();
        this.prefix = options.getCommentPrefix();
        this.width = options.getStackVarXrefWidth();
        this.fillAmount = options.getStackVarPreNameWidth() + options.getStackVarNameWidth() + options.getStackVarDataTypeWidth() + options.getStackVarOffsetWidth() + options.getStackVarCommentWidth();
        this.isHTML = options.isHTML();
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        XReferenceUtil.getVariableRefs(var, xrefs, offcuts);
        Address[] xrefAddr = this.extractFromAddr(xrefs);
        Address[] offcutsAddr = this.extractFromAddr(offcuts);
        this.processRefs(var.getFunction().getEntryPoint(), xrefAddr, offcutsAddr);
    }

    private Address[] extractFromAddr(List<Reference> refs) {
        Object[] addrs = new Address[refs.size()];
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = refs.get(i).getFromAddress();
        }
        Arrays.sort(addrs);
        return addrs;
    }

    @Override
    void dispose() {
        this.memory = null;
    }

    @Override
    boolean hasMoreLines() {
        return this.index < this.lines.size();
    }

    @Override
    String getNextLine() {
        if (this.hasMoreLines()) {
            return this.lines.get(this.index++);
        }
        return null;
    }

    private Address[] getForwardRefs(CodeUnit cu) {
        boolean showRefs = false;
        Address cuAddr = cu.getMinAddress();
        Reference[] monRefs = cu.getMnemonicReferences();
        Reference primMonRef = this.referenceManager.getPrimaryReferenceFrom(cuAddr, -1);
        boolean bl = showRefs = monRefs.length == 1 && primMonRef == null || monRefs.length > 1;
        if (!showRefs) {
            int opCount = cu.getNumOperands();
            for (int i = 0; i < opCount; ++i) {
                Reference[] opRefs = cu.getOperandReferences(i);
                if (opRefs.length <= 1) continue;
                showRefs = true;
                break;
            }
        }
        if (!showRefs) {
            return EMPTY_ADDR_ARR;
        }
        Reference[] mRefs = cu.getReferencesFrom();
        Object[] refs = new Address[mRefs.length];
        for (int i = 0; i < mRefs.length; ++i) {
            refs[i] = mRefs[i].getToAddress();
        }
        Arrays.sort(refs);
        return refs;
    }

    private void processRefs(Address addr, Address[] refs, Address[] offcuts) {
        if (this.width < 1) {
            return;
        }
        if (refs.length == 0 && offcuts.length == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        Address[] all = new Address[refs.length + offcuts.length];
        System.arraycopy(refs, 0, all, 0, refs.length);
        System.arraycopy(offcuts, 0, all, refs.length, offcuts.length);
        if (this.displayRefHeader && (refs.length > 0 || offcuts.length > 0)) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.header);
            tmp.append("[");
            tmp.append(refs.length);
            tmp.append(XREFS_DELIM);
            tmp.append(offcuts.length);
            tmp.append("]: ");
            buf.append(ReferenceLineDispenser.clip(tmp.toString(), this.headerWidth));
        }
        int refsPerLine = this.width / (all[0].toString().length() + XREFS_DELIM.length());
        int refsInCurrLine = 0;
        for (int i = 0; i < all.length; ++i) {
            if (i == 0 && !this.displayRefHeader) {
                buf.append(ReferenceLineDispenser.getFill(this.headerWidth));
                buf.append(this.prefix);
            }
            if (refsInCurrLine == 0 && i != 0) {
                buf.append(ReferenceLineDispenser.getFill(this.headerWidth));
                if (!this.displayRefHeader) {
                    buf.append(this.prefix);
                }
            }
            if (refsInCurrLine > 0) {
                buf.append(XREFS_DELIM);
            }
            boolean isInMem = this.memory.contains(all[i]);
            if (this.isHTML && isInMem) {
                buf.append("<A HREF=\"#" + ReferenceLineDispenser.getUniqueAddressString(all[i]) + "\">");
            }
            buf.append(all[i].toString());
            if (this.isHTML && isInMem) {
                buf.append("</A>");
            }
            if (++refsInCurrLine != refsPerLine) continue;
            this.lines.add((this.displayRefHeader ? this.prefix : "") + buf.toString());
            buf.delete(0, buf.length());
            refsInCurrLine = 0;
        }
        if (refsInCurrLine > 0) {
            this.lines.add((this.displayRefHeader ? this.prefix : "") + buf.toString());
            buf.delete(0, buf.length());
        }
    }
}

