/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AddressSetPartitioner
implements Iterable<AddressRange> {
    private static final Comparator<AddressRange> MIN_ADDRESS_ASC = new Comparator<AddressRange>(){

        @Override
        public int compare(AddressRange lhs, AddressRange rhs) {
            return lhs.getMinAddress().compareTo((Object)rhs.getMinAddress());
        }
    };
    private final ArrayList<AddressRange> addressRangeCache;
    private final HashMap<AddressRange, byte[]> rangeMapCache;

    public AddressSetPartitioner(AddressSet set, Map<AddressRange, byte[]> rangeMap, Set<Address> partitionSet) {
        ArrayList<Object> ranges = new ArrayList<Object>();
        ArrayList<Address> partitionsMaster = new ArrayList<Address>(partitionSet);
        Collections.sort(partitionsMaster);
        ArrayList<Address> partitions = new ArrayList<Address>(partitionsMaster);
        AddressRangeIterator addressRanges = set.getAddressRanges();
        for (AddressRange addressRange : addressRanges) {
            ranges.add(addressRange);
        }
        Collections.sort(ranges, MIN_ADDRESS_ASC);
        this.addressRangeCache = new ArrayList();
        while (!ranges.isEmpty()) {
            AddressRange range = (AddressRange)ranges.get(0);
            ranges.remove(0);
            boolean split = false;
            for (Address part : partitions) {
                if (!range.contains(part) || part.equals((Object)range.getMinAddress())) continue;
                split = true;
                Address firstMax = part.previous();
                AddressRangeImpl first = new AddressRangeImpl(range.getMinAddress(), firstMax);
                AddressRangeImpl second = new AddressRangeImpl(part, range.getMaxAddress());
                this.addressRangeCache.add((AddressRange)first);
                ranges.add(0, second);
                partitions.remove(part);
                break;
            }
            if (split) continue;
            this.addressRangeCache.add(range);
        }
        partitions = new ArrayList<Address>(partitionsMaster);
        HashMap<AddressRange, byte[]> original = new HashMap<AddressRange, byte[]>(rangeMap);
        this.rangeMapCache = new HashMap();
        while (!original.isEmpty()) {
            AddressRange range = original.keySet().iterator().next();
            byte[] bytes = original.get(range);
            original.remove(range);
            boolean split = false;
            for (Address part : partitions) {
                if (!range.contains(part) || part.equals((Object)range.getMinAddress())) continue;
                split = true;
                Address firstMax = part.previous();
                AddressRangeImpl first = new AddressRangeImpl(range.getMinAddress(), firstMax);
                AddressRangeImpl second = new AddressRangeImpl(part, range.getMaxAddress());
                byte[] firstBytes = new byte[(int)first.getLength()];
                byte[] secondBytes = new byte[(int)second.getLength()];
                System.arraycopy(bytes, 0, firstBytes, 0, firstBytes.length);
                System.arraycopy(bytes, firstBytes.length, secondBytes, 0, secondBytes.length);
                this.rangeMapCache.put((AddressRange)first, firstBytes);
                original.put((AddressRange)second, secondBytes);
                partitions.remove(part);
                break;
            }
            if (split) continue;
            this.rangeMapCache.put(range, bytes);
        }
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return Collections.unmodifiableList(this.addressRangeCache).iterator();
    }

    public Map<AddressRange, byte[]> getPartionedRangeMap() {
        return Collections.unmodifiableMap(this.rangeMapCache);
    }
}

