/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.preferences.Preferences;
import ghidra.program.database.data.DataTypeArchiveTransformer;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataTypeArchiveTransformerPanel
extends JPanel {
    private static final String DOT_DOT_DOT = ". . .";
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORM_CURSOR = new Cursor(0);
    private GhidraFileChooser chooser;
    private JPanel filePanel;
    private JTextField oldFileTextField;
    private JTextField newFileTextField;
    private JTextField destinationFileTextField;
    private JCheckBox useOldFileIDCheckBox;

    public DataTypeArchiveTransformerPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.filePanel = new JPanel(new GridBagLayout());
        this.setupDescription();
        this.setupOldFileField();
        this.setupNewFileField();
        this.setupDestinationFileField();
        this.add((Component)this.filePanel, "Center");
    }

    private void setupDescription() {
        String description = "<HTML>Specify the files for converting a new data type archive (.gdt)<BR>to match the IDs of data types in an old data type archive.<BR>The result will be saved to the destination archive.</HTML>";
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        label.setHorizontalAlignment(0);
        this.add((Component)label, "North");
    }

    private void setupOldFileField() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.filePanel.add((Component)new JLabel("Old file name "), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        this.oldFileTextField = new JTextField(30);
        this.filePanel.add((Component)this.oldFileTextField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        JButton oldBrowseButton = new JButton(DOT_DOT_DOT);
        oldBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeArchiveTransformerPanel.this.setCursor(WAIT_CURSOR);
                File file = DataTypeArchiveTransformerPanel.this.chooseFile("Choose old data type archive");
                DataTypeArchiveTransformerPanel.this.setCursor(NORM_CURSOR);
                if (file != null) {
                    DataTypeArchiveTransformerPanel.this.oldFileTextField.setText(file.getAbsolutePath());
                }
            }
        });
        Font font = oldBrowseButton.getFont();
        oldBrowseButton.setFont(new Font(font.getName(), 1, font.getSize()));
        this.filePanel.add((Component)oldBrowseButton, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        this.useOldFileIDCheckBox = new JCheckBox("  Use Old File ID");
        this.filePanel.add((Component)this.useOldFileIDCheckBox, gbc);
    }

    private void setupNewFileField() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.filePanel.add((Component)new JLabel("New file name "), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        this.newFileTextField = new JTextField(30);
        this.filePanel.add((Component)this.newFileTextField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        JButton newBrowseButton = new JButton(DOT_DOT_DOT);
        newBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeArchiveTransformerPanel.this.setCursor(WAIT_CURSOR);
                File file = DataTypeArchiveTransformerPanel.this.chooseFile("Choose new data type archive");
                DataTypeArchiveTransformerPanel.this.setCursor(NORM_CURSOR);
                if (file != null) {
                    DataTypeArchiveTransformerPanel.this.newFileTextField.setText(file.getAbsolutePath());
                }
            }
        });
        Font font = newBrowseButton.getFont();
        newBrowseButton.setFont(new Font(font.getName(), 1, font.getSize()));
        this.filePanel.add((Component)newBrowseButton, gbc);
    }

    private void setupDestinationFileField() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.filePanel.add((Component)new JLabel("Destination file name "), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        this.destinationFileTextField = new JTextField(30);
        this.filePanel.add((Component)this.destinationFileTextField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        JButton destinationBrowseButton = new JButton(DOT_DOT_DOT);
        destinationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeArchiveTransformerPanel.this.setCursor(WAIT_CURSOR);
                File file = DataTypeArchiveTransformerPanel.this.chooseFile("Choose destination file");
                DataTypeArchiveTransformerPanel.this.setCursor(NORM_CURSOR);
                if (file != null) {
                    DataTypeArchiveTransformerPanel.this.destinationFileTextField.setText(file.getAbsolutePath());
                }
            }
        });
        Font font = destinationBrowseButton.getFont();
        destinationBrowseButton.setFont(new Font(font.getName(), 1, font.getSize()));
        this.filePanel.add((Component)destinationBrowseButton, gbc);
    }

    File chooseFile(String buttonText) {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this);
            this.chooser.setCurrentDirectory(this.getLastDataTypeArchiveDirectory());
        }
        this.chooser.setTitle(buttonText);
        this.chooser.setApproveButtonText(buttonText);
        this.chooser.setApproveButtonToolTipText(buttonText);
        File file = this.chooser.getSelectedFile();
        if (file != null && file.exists()) {
            Preferences.setProperty((String)"LastOpenedArchiveDirectory", (String)file.getAbsolutePath());
            Preferences.store();
        }
        return file;
    }

    File getLastDataTypeArchiveDirectory() {
        String lastDirStr = Preferences.getProperty((String)"LastOpenedArchiveDirectory", (String)System.getProperty("user.home"));
        return new File(lastDirStr);
    }

    protected void transform(TaskMonitor monitor) throws InvalidInputException, DuplicateFileException, IOException, CancelledException {
        DataTypeArchiveTransformer.transform(this.getOldFile(), this.getNewFile(), this.getDestinationFile(), this.useOldFileIDCheckBox.isSelected(), monitor);
    }

    protected File getDestinationFile() {
        return new File(this.destinationFileTextField.getText());
    }

    protected File getNewFile() {
        return new File(this.newFileTextField.getText());
    }

    protected File getOldFile() {
        return new File(this.oldFileTextField.getText());
    }
}

