/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeMnemonicSettingsDefinition;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.Integer16DataType;
import ghidra.program.model.data.Integer3DataType;
import ghidra.program.model.data.Integer5DataType;
import ghidra.program.model.data.Integer6DataType;
import ghidra.program.model.data.Integer7DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.PaddingSettingsDefinition;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.SignedDWordDataType;
import ghidra.program.model.data.SignedQWordDataType;
import ghidra.program.model.data.SignedWordDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnsignedInteger16DataType;
import ghidra.program.model.data.UnsignedInteger3DataType;
import ghidra.program.model.data.UnsignedInteger5DataType;
import ghidra.program.model.data.UnsignedInteger6DataType;
import ghidra.program.model.data.UnsignedInteger7DataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringFormat;
import java.math.BigInteger;

public abstract class AbstractIntegerDataType
extends BuiltIn
implements ArrayStringable {
    private static final long serialVersionUID = 1L;
    static final String C_SIGNED_CHAR = "signed char";
    static final String C_UNSIGNED_CHAR = "unsigned char";
    static final String C_SIGNED_SHORT = "short";
    static final String C_UNSIGNED_SHORT = "unsigned short";
    static final String C_SIGNED_INT = "int";
    static final String C_UNSIGNED_INT = "unsigned int";
    static final String C_SIGNED_LONG = "long";
    static final String C_UNSIGNED_LONG = "unsigned long";
    static final String C_SIGNED_LONGLONG = "long long";
    static final String C_UNSIGNED_LONGLONG = "unsigned long long";
    protected static final PaddingSettingsDefinition PADDING = PaddingSettingsDefinition.DEF;
    protected static final EndianSettingsDefinition ENDIAN = EndianSettingsDefinition.DEF;
    protected static final DataTypeMnemonicSettingsDefinition MNEMONIC = DataTypeMnemonicSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{FormatSettingsDefinition.DEF_HEX, PADDING, ENDIAN, MNEMONIC};
    private final boolean signed;
    private static AbstractIntegerDataType[] signedTypes;
    private static AbstractIntegerDataType[] unsignedTypes;

    public AbstractIntegerDataType(String name, boolean signed, DataTypeManager dtm) {
        super(null, name, dtm);
        this.signed = signed;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    protected FormatSettingsDefinition getFormatSettingsDefinition() {
        return FormatSettingsDefinition.DEF_HEX;
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public boolean isSigned() {
        return this.signed;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name.toUpperCase();
    }

    @Override
    public String getMnemonic(Settings settings) {
        int mnemonicStyle = MNEMONIC.getMnemonicStyle(settings);
        if (mnemonicStyle == 1) {
            return this.getAssemblyMnemonic();
        }
        if (mnemonicStyle == 2) {
            return this.getCMnemonic();
        }
        return this.name;
    }

    public String getAssemblyMnemonic() {
        return this.name;
    }

    public String getCMnemonic() {
        String str = this.getCDeclaration();
        return str != null ? str : this.name;
    }

    public String getCDeclaration() {
        int size = this.getLength();
        if (size <= 0) {
            return null;
        }
        DataOrganization dataOrganization = this.getDataOrganization();
        if (size == dataOrganization.getCharSize()) {
            return this.signed ? C_SIGNED_CHAR : C_UNSIGNED_CHAR;
        }
        if (size == dataOrganization.getIntegerSize()) {
            return this.signed ? C_SIGNED_INT : C_UNSIGNED_INT;
        }
        if (size == dataOrganization.getShortSize()) {
            return this.signed ? C_SIGNED_SHORT : C_UNSIGNED_SHORT;
        }
        if (size == dataOrganization.getLongSize()) {
            return this.signed ? C_SIGNED_LONG : C_UNSIGNED_LONG;
        }
        if (size == dataOrganization.getLongLongSize()) {
            return this.signed ? C_SIGNED_LONGLONG : C_UNSIGNED_LONGLONG;
        }
        return null;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        int size = this.getLength();
        if (size <= 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return null;
        }
        boolean isBigEndian = ENDIAN.isBigEndian(settings, buf);
        if (!isBigEndian) {
            byte[] flipped = new byte[size];
            for (int i = 0; i < size; ++i) {
                flipped[i] = bytes[size - i - 1];
            }
            bytes = flipped;
        }
        if (size > 8) {
            if (!this.isSigned()) {
                byte[] unsignedBytes = new byte[bytes.length + 1];
                System.arraycopy(bytes, 0, unsignedBytes, 1, bytes.length);
                bytes = unsignedBytes;
            }
            return new BigInteger(bytes);
        }
        long val = 0L;
        for (byte b : bytes) {
            val = (val << 8) + ((long)b & 0xFFL);
        }
        return new Scalar(size * 8, val, this.isSigned());
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        if (this.getLength() > 8) {
            return BigInteger.class;
        }
        return Scalar.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        int nominalLen;
        Object valStr;
        boolean negative;
        int size = this.getLength();
        if (size <= 0 && (size = length) <= 0) {
            return "??";
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return "??";
        }
        int format = this.getFormatSettingsDefinition().getFormat(settings);
        boolean padded = PADDING.isPadded(settings);
        boolean isBigEndian = ENDIAN.isBigEndian(settings, buf);
        if (!isBigEndian) {
            byte[] flipped = new byte[size];
            for (int i = 0; i < size; ++i) {
                flipped[i] = bytes[size - i - 1];
            }
            bytes = flipped;
        }
        if (format == 4) {
            int charSize = Math.min(this.getDataOrganization().getCharSize(), this.getLength());
            return new StringDataInstance(this, settings, buf, charSize).getCharRepresentation();
        }
        boolean bl = negative = bytes[0] < 0;
        if (size >= 8) {
            if (negative && !this.signed || format != 1) {
                byte[] unsignedBytes = new byte[size + 1];
                unsignedBytes[size] = 0;
                System.arraycopy(bytes, 0, unsignedBytes, 1, size);
                bytes = unsignedBytes;
            }
            BigInteger bigInt = new BigInteger(bytes);
            switch (format) {
                default: {
                    valStr = bigInt.toString(16).toUpperCase() + "h";
                    nominalLen = 2 * size + 1;
                    break;
                }
                case 1: {
                    String sign = "";
                    if (negative && this.signed) {
                        sign = "-";
                        bigInt = bigInt.negate();
                    }
                    return sign + bigInt.toString(10);
                }
                case 2: {
                    valStr = bigInt.toString(2) + "b";
                    nominalLen = 8 * size + 1;
                    break;
                }
                case 3: {
                    valStr = bigInt.toString(8) + "o";
                    nominalLen = 3 * size + 1;
                    break;
                }
            }
        } else {
            long val = 0L;
            for (byte b : bytes) {
                val = (val << 8) + ((long)b & 0xFFL);
            }
            switch (format) {
                default: {
                    valStr = Long.toString(val, 16).toUpperCase() + "h";
                    nominalLen = 2 * size + 1;
                    break;
                }
                case 1: {
                    String sign = "";
                    if (negative && this.signed) {
                        sign = "-";
                        val = (val ^ 0xFFFFFFFFFFFFFFFFL) + 1L & (-(1L << 8 * size) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    return sign + Long.toString(val);
                }
                case 2: {
                    valStr = Long.toString(val, 2) + "b";
                    nominalLen = 8 * size + 1;
                    break;
                }
                case 3: {
                    valStr = Long.toString(val, 8) + "o";
                    nominalLen = 3 * size + 1;
                }
            }
        }
        if (padded) {
            valStr = StringFormat.padIt((String)valStr, (int)nominalLen, (char)'\u0000', (boolean)true);
        }
        return valStr;
    }

    @Override
    public boolean hasStringValue(Settings settings) {
        int format = this.getFormatSettingsDefinition().getFormat(settings);
        return format == 4;
    }

    @Override
    public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        if (!this.hasStringValue(settings)) {
            return null;
        }
        return new StringDataInstance(this, settings, buf, len).getLabel("s_", "STR", "STRING", options);
    }

    @Override
    public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        if (!this.hasStringValue(settings)) {
            return null;
        }
        return new StringDataInstance(this, settings, buf, len).getOffcutLabelString("s_", "STR", "STRING", options, offcutOffset);
    }

    public abstract DataType getOppositeSignednessDataType();

    @Override
    public boolean isEquivalent(DataType dt) {
        return dt.getClass().equals(this.getClass());
    }

    private static AbstractIntegerDataType[] getSignedTypes() {
        if (signedTypes == null) {
            signedTypes = new AbstractIntegerDataType[]{SignedByteDataType.dataType, SignedWordDataType.dataType, Integer3DataType.dataType, SignedDWordDataType.dataType, Integer5DataType.dataType, Integer6DataType.dataType, Integer7DataType.dataType, SignedQWordDataType.dataType, Integer16DataType.dataType};
        }
        return signedTypes;
    }

    private static AbstractIntegerDataType[] getUnsignedTypes() {
        if (unsignedTypes == null) {
            unsignedTypes = new AbstractIntegerDataType[]{ByteDataType.dataType, WordDataType.dataType, UnsignedInteger3DataType.dataType, DWordDataType.dataType, UnsignedInteger5DataType.dataType, UnsignedInteger6DataType.dataType, UnsignedInteger7DataType.dataType, QWordDataType.dataType, UnsignedInteger16DataType.dataType};
        }
        return unsignedTypes;
    }

    public static DataType getSignedDataType(int size, DataTypeManager dtm) {
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size == 16) {
            return Integer16DataType.dataType;
        }
        if (size > 8) {
            return new ArrayDataType(SignedByteDataType.dataType, size, 1);
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (size == dataOrganization.getIntegerSize()) {
                return IntegerDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getShortSize()) {
                return ShortDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongSize()) {
                return LongDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongLongSize()) {
                return LongLongDataType.dataType.clone(dtm);
            }
        }
        return AbstractIntegerDataType.getSignedTypes()[size - 1];
    }

    public static AbstractIntegerDataType[] getSignedDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        AbstractIntegerDataType[] dataTypes = (AbstractIntegerDataType[])AbstractIntegerDataType.getSignedTypes().clone();
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            int index = dataOrganization.getLongLongSize() - 1;
            if (index >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)LongLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getLongSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)LongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getShortSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)ShortDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getIntegerSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)IntegerDataType.dataType.clone(dtm);
            }
        }
        return dataTypes;
    }

    public static DataType getUnsignedDataType(int size, DataTypeManager dtm) {
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size == 16) {
            return UnsignedInteger16DataType.dataType;
        }
        if (size > 8) {
            return Undefined.getUndefinedDataType(size);
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (size == dataOrganization.getIntegerSize()) {
                return UnsignedIntegerDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getShortSize()) {
                return UnsignedShortDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongSize()) {
                return UnsignedLongDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongLongSize()) {
                return UnsignedLongLongDataType.dataType.clone(dtm);
            }
        }
        return AbstractIntegerDataType.getUnsignedTypes()[size - 1];
    }

    public static AbstractIntegerDataType[] getUnsignedDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        AbstractIntegerDataType[] dataTypes = (AbstractIntegerDataType[])AbstractIntegerDataType.getUnsignedTypes().clone();
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            int index = dataOrganization.getLongLongSize() - 1;
            if (index >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)UnsignedLongLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getLongSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)UnsignedLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getShortSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)UnsignedShortDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getIntegerSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = (AbstractIntegerDataType)UnsignedIntegerDataType.dataType.clone(dtm);
            }
        }
        return dataTypes;
    }
}

