/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.jar.ResourceFile;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.LanguagePostUpgradeInstructionHandler;
import ghidra.program.util.LanguageTranslatorAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

class SimpleLanguageTranslator
extends LanguageTranslatorAdapter {
    static final Logger log = LogManager.getLogger(SimpleLanguageTranslator.class);
    private boolean isValid = false;
    private final String translatorSpecSource;
    private final HashMap<String, String> spaceNameMap = new HashMap();
    private final Map<String, String> registerNameMap = new HashMap<String, String>();
    private final Map<String, BigInteger> contextSettings = new HashMap<String, BigInteger>();
    private final Map<String, String> compilerSpecMap = new HashMap<String, String>();
    private boolean clearAllContext;
    private Class<? extends LanguagePostUpgradeInstructionHandler> postUpgradeInstructionHandlerClass;

    private SimpleLanguageTranslator(String translatorSpecSource, LanguageID oldLanguageID, int oldLanguageVersion, LanguageID newLanguageID, int newLanguageVersion) {
        super(oldLanguageID, oldLanguageVersion, newLanguageID, newLanguageVersion);
        this.translatorSpecSource = translatorSpecSource;
    }

    @Override
    public boolean isValid() {
        if (this.isValid) {
            return true;
        }
        if (!super.isValid()) {
            return false;
        }
        if (this.spaceNameMap.isEmpty()) {
            try {
                this.validateDefaultSpaceMap();
            }
            catch (IncompatibleLanguageException e) {
                log.error("Bad translation spec (" + e.getMessage() + "): " + this);
                return false;
            }
        } else {
            AddressFactory oldFactory = this.getOldLanguage().getAddressFactory();
            AddressFactory newFactory = this.getNewLanguage().getAddressFactory();
            StringBuffer errBuf = new StringBuffer();
            ArrayList<AddressSpace> oldSpaces = new ArrayList<AddressSpace>(Arrays.asList(oldFactory.getPhysicalSpaces()));
            for (String name : this.spaceNameMap.keySet()) {
                AddressSpace space = oldFactory.getAddressSpace(name);
                oldSpaces.remove(space);
                if (space == null) {
                    errBuf.append("  Mapped address space not found (from): " + name + "\r\n");
                    continue;
                }
                String newName = this.spaceNameMap.get(name);
                if (newName == null) {
                    if (oldFactory.getDefaultAddressSpace() != space) continue;
                    errBuf.append("  Default space must be mapped: " + name + "\r\n");
                    continue;
                }
                AddressSpace newSpace = newFactory.getAddressSpace(newName);
                if (newSpace != null) continue;
                errBuf.append("  Mapped address space not found (to): " + name + "\r\n");
            }
            if (!oldSpaces.isEmpty()) {
                errBuf.append("  Failed to map old address spaces: ");
                for (AddressSpace space : oldSpaces) {
                    errBuf.append(space.getName());
                    errBuf.append(" ");
                }
                errBuf.append("\r\n");
            }
            if (errBuf.length() != 0) {
                log.error("Bad translation spec (details follow): " + this);
                log.error(errBuf.toString());
                return false;
            }
        }
        this.isValid = true;
        return true;
    }

    @Override
    public AddressSpace getNewAddressSpace(String oldSpaceName) {
        if (!this.isValid) {
            throw new IllegalStateException("Translator has not been validated");
        }
        if (this.spaceNameMap.isEmpty()) {
            return super.getNewAddressSpace(oldSpaceName);
        }
        String newName = this.spaceNameMap.get(oldSpaceName);
        if (newName != null) {
            return this.getNewLanguage().getAddressFactory().getAddressSpace(newName);
        }
        return null;
    }

    @Override
    public boolean isValueTranslationRequired(Register oldReg) {
        if ((this.clearAllContext || this.contextSettings != null) && oldReg.isBaseRegister() && oldReg.isProcessorContext()) {
            return true;
        }
        return super.isValueTranslationRequired(oldReg);
    }

    @Override
    public RegisterValue getNewRegisterValue(RegisterValue oldRegisterValue) {
        Register oldReg = oldRegisterValue.getRegister();
        if (!oldReg.isProcessorContext()) {
            return super.getNewRegisterValue(oldRegisterValue);
        }
        Register newContextReg = this.getNewLanguage().getContextBaseRegister();
        if (newContextReg == null || this.clearAllContext && this.contextSettings == null) {
            return null;
        }
        RegisterValue newValue = null;
        if (!this.clearAllContext) {
            newValue = super.getNewRegisterValue(oldRegisterValue);
        }
        if (this.contextSettings == null) {
            return newValue;
        }
        if (newValue == null) {
            newValue = new RegisterValue(newContextReg);
        }
        for (Register subReg : newContextReg.getChildRegisters()) {
            BigInteger val = this.contextSettings.get(subReg.getName());
            if (val == null) continue;
            newValue = newValue.combineValues(new RegisterValue(subReg, val));
        }
        return newValue;
    }

    @Override
    public CompilerSpecID getNewCompilerSpecID(CompilerSpecID oldCompilerSpecID) {
        String oldSpecId = oldCompilerSpecID.getIdAsString();
        String newSpecId = this.compilerSpecMap.get(oldSpecId);
        if (newSpecId != null) {
            return new CompilerSpecID(newSpecId);
        }
        return super.getNewCompilerSpecID(oldCompilerSpecID);
    }

    @Override
    public Register getNewRegister(Register oldReg) {
        String newName;
        if (this.registerNameMap != null && (newName = this.registerNameMap.get(oldReg.getName())) != null) {
            return this.getNewLanguage().getRegister(newName);
        }
        return super.getNewRegister(oldReg);
    }

    @Override
    public void fixupInstructions(Program program, Language oldLanguage, TaskMonitor monitor) throws Exception, CancelledException {
        if (this.postUpgradeInstructionHandlerClass != null) {
            LanguagePostUpgradeInstructionHandler postUpgradeInstructionHandler = SimpleLanguageTranslator.getPostUpgradeInstructionHandler(program, this.postUpgradeInstructionHandlerClass);
            postUpgradeInstructionHandler.fixupInstructions(oldLanguage, monitor);
        }
    }

    private static LanguagePostUpgradeInstructionHandler getPostUpgradeInstructionHandler(Program program, Class<?> handlerClass) throws Exception {
        if (!LanguagePostUpgradeInstructionHandler.class.isAssignableFrom(handlerClass)) {
            throw new Exception(handlerClass.getName() + " must extend " + LanguagePostUpgradeInstructionHandler.class.getName());
        }
        Constructor<?> constructor = handlerClass.getConstructor(Program.class);
        return (LanguagePostUpgradeInstructionHandler)constructor.newInstance(program);
    }

    @Override
    public String toString() {
        return "[" + this.getOldLanguageID() + " (Version " + this.getOldVersion() + ")] -> [" + this.getNewLanguageID() + " (Version " + this.getNewVersion() + ")] {" + this.translatorSpecSource + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleLanguageTranslator getSimpleLanguageTranslator(ResourceFile translatorSpecFile) throws SAXException, JDOMException, IOException {
        BufferedInputStream is = new BufferedInputStream(translatorSpecFile.getInputStream());
        try {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document document = sax.build((InputStream)is);
            Element root = document.getRootElement();
            SimpleLanguageTranslator simpleLanguageTranslator = SimpleLanguageTranslator.getSimpleLanguageTranslator(translatorSpecFile.getAbsolutePath(), root);
            return simpleLanguageTranslator;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    static SimpleLanguageTranslator getSimpleLanguageTranslator(String translatorSpecSource, Element languageTranslationElement) throws SAXException {
        if (!"language_translation".equals(languageTranslationElement.getName())) {
            throw new SAXNotRecognizedException("Expected language_translation document");
        }
        LanguageID fromLanguageID = null;
        LanguageID toLanguageID = null;
        int fromLanguageVersion = -1;
        int toLanguageVersion = -1;
        HashMap<String, String> spaceMap = new HashMap<String, String>();
        HashMap<String, String> registerMap = new HashMap<String, String>();
        HashMap<String, BigInteger> contextSettings = new HashMap<String, BigInteger>();
        HashMap<String, String> compilerSpecMap = new HashMap<String, String>();
        boolean clearAllContext = false;
        Class<? extends LanguagePostUpgradeInstructionHandler> postUpgradeInstructionHandlerClass = null;
        HashSet<String> newSpacesMapped = new HashSet<String>();
        for (Element element : languageTranslationElement.getChildren()) {
            String elementName = element.getName();
            if ("from_language".equals(elementName)) {
                if (fromLanguageID != null) {
                    throw new SAXException("only one 'from_language' element permitted");
                }
                fromLanguageVersion = SimpleLanguageTranslator.parseIntAttribute(element, "version");
                fromLanguageID = SimpleLanguageTranslator.getLanguageId(element.getText());
                continue;
            }
            if ("to_language".equals(elementName)) {
                if (toLanguageID != null) {
                    throw new SAXException("only one 'to_language' element permitted");
                }
                toLanguageVersion = SimpleLanguageTranslator.parseIntAttribute(element, "version");
                toLanguageID = SimpleLanguageTranslator.getLanguageId(element.getText());
                continue;
            }
            if ("map_space".equals(elementName)) {
                SimpleLanguageTranslator.parseMapEntry(element, spaceMap, newSpacesMapped);
                continue;
            }
            if ("delete_space".equals(elementName)) {
                SimpleLanguageTranslator.parseDeleteEntry(element, spaceMap);
                continue;
            }
            if ("map_register".equals(elementName)) {
                SimpleLanguageTranslator.parseMapEntry(element, registerMap, null);
                continue;
            }
            if ("set_context".equals(elementName)) {
                SimpleLanguageTranslator.parseSetContext(element, contextSettings);
                continue;
            }
            if ("clear_all_context".equals(elementName)) {
                clearAllContext = true;
                continue;
            }
            if ("map_compiler_spec".equals(elementName)) {
                SimpleLanguageTranslator.parseMapEntry(element, compilerSpecMap, null);
                continue;
            }
            if ("post_upgrade_handler".equals(elementName)) {
                if (postUpgradeInstructionHandlerClass != null) {
                    throw new SAXException("Only a single post_upgrade_analzer may be specified");
                }
                postUpgradeInstructionHandlerClass = SimpleLanguageTranslator.parsePostUpgradeHandlerEntry(element);
                continue;
            }
            throw new SAXException("Unsupported language translator element '" + elementName + "'");
        }
        if (fromLanguageID == null || fromLanguageID.getIdAsString().trim().length() == 0) {
            throw new SAXException("Missing valid 'from_language' element");
        }
        if (toLanguageID == null || toLanguageID.getIdAsString().trim().length() == 0) {
            throw new SAXException("Missing valid 'to_language' element");
        }
        if (fromLanguageID.equals(toLanguageID) && fromLanguageVersion >= toLanguageVersion) {
            throw new SAXException("Invalid language translator versions: " + fromLanguageVersion + " -> " + toLanguageVersion);
        }
        SimpleLanguageTranslator translator = new SimpleLanguageTranslator(translatorSpecSource, fromLanguageID, fromLanguageVersion, toLanguageID, toLanguageVersion);
        translator.spaceNameMap.putAll(spaceMap);
        translator.registerNameMap.putAll(registerMap);
        translator.contextSettings.putAll(contextSettings);
        translator.compilerSpecMap.putAll(compilerSpecMap);
        translator.clearAllContext = clearAllContext;
        translator.postUpgradeInstructionHandlerClass = postUpgradeInstructionHandlerClass;
        return translator;
    }

    private static LanguageID getLanguageId(String name) {
        LanguageCompilerSpecPair pair = OldLanguageMappingService.lookupMagicString(name, false);
        if (pair != null) {
            return pair.languageID;
        }
        return new LanguageID(name);
    }

    private static int parseIntAttribute(Element element, String name) throws SAXException {
        String valStr = element.getAttributeValue(name);
        if (valStr == null) {
            throw new SAXException("Missing required " + element.getName() + " '" + name + "' attribute");
        }
        try {
            return XmlUtilities.parseInt((String)valStr);
        }
        catch (NumberFormatException e) {
            throw new SAXException("invalid integer attribute value: " + name + "=\"" + valStr + "\"");
        }
    }

    private static Class<? extends LanguagePostUpgradeInstructionHandler> parsePostUpgradeHandlerEntry(Element element) throws SAXException {
        String className = element.getAttributeValue("class");
        if (className == null) {
            throw new SAXException(element.getName() + " must specify 'class' attribute");
        }
        try {
            Class<?> clazz = Class.forName(className);
            SimpleLanguageTranslator.getPostUpgradeInstructionHandler(null, clazz);
            return clazz;
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException("Failed to instantiate: " + className, e);
        }
    }

    private static void parseMapEntry(Element element, Map<String, String> nameMap, HashSet<String> toDuplicateCheckSet) throws SAXException {
        String fromName = element.getAttributeValue("from");
        String toName = element.getAttributeValue("to");
        if (fromName == null || toName == null) {
            throw new SAXException(element.getName() + " must include both 'from' and 'to' attributes");
        }
        if (toDuplicateCheckSet != null) {
            if (toDuplicateCheckSet.contains(toName)) {
                throw new SAXException(element.getName() + " may not map to the same name more than once: " + toName);
            }
            toDuplicateCheckSet.add(toName);
        }
        if (nameMap.containsKey(fromName)) {
            throw new SAXException(element.getName() + " may not map the same name more than once: " + fromName);
        }
        nameMap.put(fromName, toName);
    }

    private static void parseDeleteEntry(Element element, Map<String, String> nameMap) throws SAXException {
        String name = element.getAttributeValue("name");
        if (name == null) {
            throw new SAXException(element.getName() + " must include 'name' attribute");
        }
        if (nameMap.containsKey(name)) {
            throw new SAXException(element.getName() + " may not map the same name more than once: " + name);
        }
        nameMap.put(name, null);
    }

    private static void parseSetContext(Element element, Map<String, BigInteger> contextSettings) throws SAXException {
        BigInteger val;
        String name = element.getAttributeValue("name");
        if (name == null) {
            throw new SAXException("Missing required set_context 'name' attribute");
        }
        String valStr = element.getAttributeValue("value");
        if (valStr == null) {
            throw new SAXException("Missing required set_context 'value' attribute");
        }
        try {
            if (valStr.startsWith("0x")) {
                valStr = valStr.substring(2);
                val = new BigInteger(valStr, 16);
            } else {
                val = new BigInteger(valStr);
            }
        }
        catch (NumberFormatException e) {
            throw new SAXException("invalid set_context attribute value: " + name + "=\"" + valStr + "\"");
        }
        contextSettings.put(name, val);
    }

    public CompilerSpec getCompilerSpec() {
        return null;
    }
}

