/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedTypeParameterDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.backend.common.lower.BOUND_VALUE_PARAMETER;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceKey;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001NB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010)\u001a\u00020\r2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0016H\u0002J6\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010&\u001a\u00020\r2\u001e\u00101\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u001a\u0012\u0004\u0012\u0002050302H\u0002J6\u00106\u001a\b\u0012\u0004\u0012\u0002070\u001a2\u0006\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020\r2\u0006\u0010%\u001a\u00020$2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\r2\u0006\u0010E\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020\f2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u00108\u001a\u00020(2\u0006\u0010L\u001a\u00020$H\u0002J\f\u0010M\u001a\u00020\u001c*\u00020\u001cH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\tR\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00020 *\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "callableNameConst", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getCallableNameConst", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "callableToFactoryFunction", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceKey;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getterConst", "getGetterConst", "implicitDeclarationFile", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFileImpl;", "newDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setterConst", "getSetterConst", "arguments", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getArguments", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/util/List;", "arity", "", "getArity", "(Lorg/jetbrains/kotlin/ir/types/IrType;)I", "buildClosureFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "declaration", "factoryFunction", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "buildFactoryFunction", "getterName", "createClosureInstanceName", "createFunctionFactoryName", "createHelperFunctionName", "suffix", "createPropertyFactoryName", "generateFactoryBodyWithGuard", "builder", "Lkotlin/Function0;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "generateSignatureForClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "callable", "factory", "closure", "getReferenceName", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerKFunctionReference", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "lowerKPropertyReference", "getterDeclaration", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "lowerLocalKPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "makeCallableKey", "redirectToFunction", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "newTarget", "boxIfInlined", "CallableReferenceLowerTransformer", "backend.js"})
public final class CallableReferenceLowering
implements FileLoweringPass {
    private final Map<CallableReferenceKey, IrSimpleFunction> callableToFactoryFunction;
    private final List<IrDeclaration> newDeclarations;
    private final IrFileImpl implicitDeclarationFile;
    @NotNull
    private final JsIrBackendContext context;

    private final IrConstImpl<String> getCallableNameConst() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKCALLABLE_NAME());
    }

    private final IrConstImpl<String> getGetterConst() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKPROPERTY_GET());
    }

    private final IrConstImpl<String> getSetterConst() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKPROPERTY_SET());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        this.newDeclarations.clear();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new CallableReferenceLowerTransformer());
        Collection collection = this.implicitDeclarationFile.getDeclarations();
        Iterable iterable = this.newDeclarations;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    private final CallableReferenceKey makeCallableKey(IrFunction declaration2, IrCallableReference reference) {
        return new CallableReferenceKey(declaration2, reference.getDispatchReceiver() != null, reference.getExtensionReceiver() != null, IrTypeUtilsKt.asString(reference.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private final IrCallImpl redirectToFunction(IrCallableReference callable, IrFunction newTarget) {
        int n;
        IrExpression it;
        boolean bl;
        int n2;
        IrExpression irExpression;
        IrCallImpl irCallImpl = new IrCallImpl(callable.getStartOffset(), callable.getEndOffset(), newTarget.getSymbol().getOwner().getReturnType(), newTarget.getSymbol(), newTarget.getSymbol().getDescriptor(), callable.getOrigin(), null, 64, null);
        boolean bl2 = false;
        boolean bl3 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl4 = false;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom($this$apply, callable);
        int index2 = 0;
        IrExpression irExpression2 = callable.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            n2 = 0;
            bl = false;
            it = irExpression;
            boolean bl5 = false;
            n = index2;
            index2 = n + 1;
            $this$apply.putValueArgument(n, it);
        }
        IrExpression irExpression3 = callable.getExtensionReceiver();
        if (irExpression3 != null) {
            irExpression = irExpression3;
            n2 = 0;
            bl = false;
            it = irExpression;
            boolean bl6 = false;
            n = index2;
            index2 = n + 1;
            $this$apply.putValueArgument(n, it);
        }
        int n3 = 0;
        n2 = callable.getValueArgumentsCount();
        while (n3 < n2) {
            void i;
            IrExpression arg = callable.getValueArgument((int)i);
            if (arg != null) {
                int n4 = index2;
                index2 = n4 + 1;
                $this$apply.putValueArgument(n4, arg);
            }
            ++i;
        }
        return irCallImpl;
    }

    private final String createFunctionFactoryName(IrDeclaration declaration2) {
        return this.createHelperFunctionName(declaration2, "KFunctionFactory");
    }

    private final String createPropertyFactoryName(IrDeclaration declaration2) {
        return this.createHelperFunctionName(declaration2, "KPropertyFactory");
    }

    private final String createClosureInstanceName(IrDeclaration declaration2) {
        return this.createHelperFunctionName(declaration2, "KReferenceClosure");
    }

    private final String createHelperFunctionName(IrDeclaration declaration2, String suffix) {
        IrDeclaration irDeclaration;
        StringBuilder nameBuilder = new StringBuilder();
        if (declaration2 instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            IrClass klass2 = (IrClass)irDeclarationParent;
            nameBuilder.append(klass2.getName().asString());
            nameBuilder.append('_');
        }
        if ((irDeclaration = declaration2) instanceof IrFunction) {
            nameBuilder.append(((IrFunction)declaration2).getName());
        } else if (irDeclaration instanceof IrProperty) {
            nameBuilder.append(((IrProperty)declaration2).getName());
        } else if (irDeclaration instanceof IrVariable) {
            nameBuilder.append(((IrVariable)declaration2).getName());
        } else {
            String string = "Unexpected declaration type";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        nameBuilder.append('_');
        nameBuilder.append(suffix);
        String string = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameBuilder.toString()");
        return string;
    }

    private final String getReferenceName(IrDeclaration declaration2) {
        String string;
        IrDeclaration irDeclaration = declaration2;
        if (irDeclaration instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            string = ((IrClass)irDeclarationParent).getName().getIdentifier();
        } else if (irDeclaration instanceof IrProperty) {
            string = ((IrProperty)declaration2).getName().getIdentifier();
        } else if (irDeclaration instanceof IrSimpleFunction) {
            string = ((IrSimpleFunction)declaration2).getName().asString();
        } else if (irDeclaration instanceof IrVariable) {
            String string2 = ((IrVariable)declaration2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.name.asString()");
            string = StringsKt.replace$default((String)string2, (String)"$delegate", (String)"", (boolean)false, (int)4, null);
        } else {
            String string3 = "Unexpected declaration type";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string3);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (declaration) {\n   \u2026 declaration type\")\n    }");
        return string;
    }

    private final IrSimpleFunction lowerKFunctionReference(IrFunction declaration2, IrFunctionReference functionReference2) {
        IrSimpleFunction factoryFunction = this.buildFactoryFunction(declaration2, functionReference2, this.createFunctionFactoryName(declaration2));
        IrFunction closureFunction = this.buildClosureFunction(declaration2, factoryFunction, functionReference2, this.getArity(functionReference2.getType()));
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, functionReference2, closureFunction, factoryFunction, declaration2){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunctionReference $functionReference;
            final /* synthetic */ IrFunction $closureFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrFunction $declaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                IrFunctionReferenceImpl irClosureReference = JsIrBuilder.INSTANCE.buildFunctionReference(this.$functionReference.getType(), this.$closureFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, irClosureReference.getType(), this.$factoryFunction, null, false, false, false, irClosureReference, 60, null);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irVar.getSymbol()));
                $this$apply.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getStringType(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$declaration)));
                IrCall irSetName = irCall;
                return new Pair((Object)CollectionsKt.listOf((Object[])new IrStatement[]{this.$closureFunction, irVar, irSetName}), irVar.getSymbol());
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$functionReference = irFunctionReference;
                this.$closureFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$declaration = irFunction2;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    private final IrSimpleFunction lowerKPropertyReference(IrSimpleFunction getterDeclaration, IrPropertyReference propertyReference) {
        IrFunction irFunction;
        IrFunction irFunction2;
        boolean bl;
        int arity = this.getArity(propertyReference.getType());
        IrPropertySymbol irPropertySymbol = getterDeclaration.getCorrespondingPropertySymbol();
        if (irPropertySymbol == null) {
            Intrinsics.throwNpe();
        }
        String factoryName = this.createPropertyFactoryName((IrDeclaration)irPropertySymbol.getOwner());
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        if (irSimpleFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunction factoryFunction = this.buildFactoryFunction((IrFunction)irSimpleFunctionSymbol.getOwner(), propertyReference, factoryName);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = propertyReference.getGetter();
        if (irSimpleFunctionSymbol2 != null) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2;
            boolean bl2 = false;
            bl = false;
            IrSimpleFunctionSymbol it = irSimpleFunctionSymbol3;
            boolean bl3 = false;
            irFunction2 = this.buildClosureFunction((IrFunction)it.getOwner(), factoryFunction, propertyReference, arity);
        } else {
            irFunction2 = null;
        }
        if (irFunction2 == null) {
            Intrinsics.throwNpe();
        }
        IrFunction getterFunction = irFunction2;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = propertyReference.getSetter();
        if (irSimpleFunctionSymbol4 != null) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = irSimpleFunctionSymbol4;
            bl = false;
            boolean bl4 = false;
            IrSimpleFunctionSymbol it = irSimpleFunctionSymbol5;
            boolean bl5 = false;
            irFunction = this.buildClosureFunction((IrFunction)it.getOwner(), factoryFunction, propertyReference, arity + 1);
        } else {
            irFunction = null;
        }
        IrFunction setterFunction = irFunction;
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, getterFunction, factoryFunction, setterFunction, getterDeclaration){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunction $getterFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrFunction $setterFunction;
            final /* synthetic */ IrSimpleFunction $getterDeclaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                List statements = CollectionsKt.mutableListOf((Object[])new IrStatement[]{this.$getterFunction});
                IrClassSymbol getterFunctionTypeSymbol = this.this$0.getContext().getIr().getSymbols().functionN(this.$getterFunction.getValueParameters().size() + 1);
                IrSimpleTypeImpl getterFunctionIrType = new IrSimpleTypeImpl(getterFunctionTypeSymbol, false, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                IrFunctionReferenceImpl irGetReference = JsIrBuilder.INSTANCE.buildFunctionReference(getterFunctionIrType, this.$getterFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, getterFunctionIrType, this.$factoryFunction, null, false, false, false, irGetReference, 60, null);
                Collection collection = statements;
                boolean bl = false;
                collection.add(irVar);
                collection = statements;
                IrStatement irStatement = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                IrCall $this$apply = irStatement;
                boolean bl4 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irVar.getSymbol()));
                $this$apply.putValueArgument(1, CallableReferenceLowering.access$getGetterConst$p(this.this$0));
                $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irVar.getSymbol()));
                bl2 = false;
                collection.add(irStatement);
                if (this.$setterFunction != null) {
                    collection = statements;
                    irStatement = this.$setterFunction;
                    bl2 = false;
                    collection.add(irStatement);
                    IrClassSymbol setterFunctionTypeSymbol = this.this$0.getContext().getIr().getSymbols().functionN(this.$setterFunction.getValueParameters().size() + 1);
                    IrSimpleTypeImpl setterFunctionIrType = new IrSimpleTypeImpl(setterFunctionTypeSymbol, false, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                    IrFunctionReferenceImpl irSetReference = JsIrBuilder.INSTANCE.buildFunctionReference(setterFunctionIrType, this.$setterFunction.getSymbol());
                    Collection collection2 = statements;
                    $this$apply = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                    bl4 = false;
                    boolean bl5 = false;
                    IrCall $this$apply2 = $this$apply;
                    boolean bl6 = false;
                    $this$apply2.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irVar.getSymbol()));
                    $this$apply2.putValueArgument(1, CallableReferenceLowering.access$getSetterConst$p(this.this$0));
                    $this$apply2.putValueArgument(2, irSetReference);
                    bl4 = false;
                    collection2.add($this$apply);
                }
                collection = statements;
                irStatement = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                boolean bl7 = false;
                bl3 = false;
                $this$apply = irStatement;
                boolean bl8 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irVar.getSymbol()));
                $this$apply.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                IrType irType = this.this$0.getContext().getIrBuiltIns().getStringType();
                IrPropertySymbol irPropertySymbol = this.$getterDeclaration.getCorrespondingPropertySymbol();
                if (irPropertySymbol == null) {
                    Intrinsics.throwNpe();
                }
                $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(irType, CallableReferenceLowering.access$getReferenceName(this.this$0, (IrDeclaration)irPropertySymbol.getOwner())));
                bl7 = false;
                collection.add(irStatement);
                return new Pair((Object)statements, irVar.getSymbol());
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$getterFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$setterFunction = irFunction2;
                this.$getterDeclaration = irSimpleFunction2;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        boolean bl6 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    private final IrSimpleFunction lowerLocalKPropertyReference(IrLocalDelegatedPropertyReference propertyReference) {
        int arity = this.getArity(propertyReference.getType());
        IrVariable declaration2 = (IrVariable)propertyReference.getDelegate().getOwner();
        String factoryName = this.createPropertyFactoryName(declaration2);
        IrSimpleFunction factoryFunction = this.buildFactoryFunction((IrFunction)propertyReference.getGetter().getOwner(), propertyReference, factoryName);
        IrFunction closureFunction = this.buildClosureFunction((IrFunction)this.context.getIrBuiltIns().getThrowIseSymbol().getOwner(), factoryFunction, propertyReference, arity);
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, closureFunction, factoryFunction, declaration2){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunction $closureFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrVariable $declaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                List statements = CollectionsKt.mutableListOf((Object[])new IrStatement[]{this.$closureFunction});
                IrClassSymbol getterFunctionTypeSymbol = this.this$0.getContext().getIr().getSymbols().functionN(this.$closureFunction.getValueParameters().size() + 1);
                IrSimpleTypeImpl getterFunctionIrType = new IrSimpleTypeImpl(getterFunctionTypeSymbol, false, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                IrFunctionReferenceImpl irGetReference = JsIrBuilder.INSTANCE.buildFunctionReference(getterFunctionIrType, this.$closureFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, getterFunctionIrType, this.$factoryFunction, null, false, false, false, irGetReference, 60, null);
                IrVariableSymbol irVarSymbol = (IrVariableSymbol)irVar.getSymbol();
                Collection collection = statements;
                boolean bl = false;
                collection.add(irVar);
                collection = statements;
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                IrCall $this$apply = irCall;
                boolean bl4 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                $this$apply.putValueArgument(1, CallableReferenceLowering.access$getGetterConst$p(this.this$0));
                $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                bl2 = false;
                collection.add(irCall);
                collection = statements;
                irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                bl2 = false;
                bl3 = false;
                $this$apply = irCall;
                boolean bl5 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                $this$apply.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getStringType(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$declaration)));
                bl2 = false;
                collection.add(irCall);
                return new Pair((Object)statements, (Object)irVarSymbol);
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$closureFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$declaration = irVariable2;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> generateFactoryBodyWithGuard(IrSimpleFunction factoryFunction, Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>> builder) {
        Collection collection;
        void bodyStatements;
        Pair pair = (Pair)builder.invoke();
        List list2 = (List)pair.component1();
        IrValueSymbol varSymbol = (IrValueSymbol)pair.component2();
        boolean bl = false;
        List statements = new ArrayList();
        IrExpression returnValue = null;
        List returnStatements = null;
        if (factoryFunction.getValueParameters().isEmpty()) {
            String cacheName = factoryFunction.getName() + '_' + Namer.INSTANCE.getKCALLABLE_CACHE_SUFFIX();
            IrType type2 = factoryFunction.getReturnType();
            Function0 irNull2 = (Function0)new Function0<IrConstImpl>(this){
                final /* synthetic */ CallableReferenceLowering this$0;

                @NotNull
                public final IrConstImpl invoke() {
                    return JsIrBuilder.INSTANCE.buildNull(this.this$0.getContext().getIrBuiltIns().getNothingNType());
                }
                {
                    this.this$0 = callableReferenceLowering;
                    super(0);
                }
            };
            IrVariable cacheVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type2, factoryFunction.getParent(), cacheName, true, false, false, (IrExpression)irNull2.invoke(), 48, null);
            Function0 irCacheValue2 = (Function0)new Function0<IrGetValueImpl>(cacheVar){
                final /* synthetic */ IrVariable $cacheVar;

                @NotNull
                public final IrGetValueImpl invoke() {
                    return JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)this.$cacheVar.getSymbol());
                }
                {
                    this.$cacheVar = irVariable2;
                    super(0);
                }
            };
            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getEqeqSymbol(), null, null, 6, null);
            boolean bl2 = false;
            boolean bl3 = false;
            IrCall $this$apply22 = irCall;
            boolean bl4 = false;
            $this$apply22.putValueArgument(0, (IrExpression)irCacheValue2.invoke());
            $this$apply22.putValueArgument(1, (IrExpression)irNull2.invoke());
            IrCall irIfCondition = irCall;
            IrSetVariableImpl irSetCache = JsIrBuilder.INSTANCE.buildSetVariable((IrVariableSymbol)cacheVar.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue(varSymbol), this.context.getIrBuiltIns().getUnitType());
            bl3 = false;
            List list3 = new ArrayList();
            boolean $this$apply22 = false;
            boolean bl5 = false;
            List $this$apply = list3;
            boolean bl6 = false;
            $this$apply.addAll((Collection)bodyStatements);
            $this$apply.add(irSetCache);
            List thenStatements = list3;
            IrBlockImpl irThenBranch = JsIrBuilder.INSTANCE.buildBlock(this.context.getIrBuiltIns().getUnitType(), thenStatements);
            IrWhen irIfNode = JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getUnitType(), irIfCondition, irThenBranch, null, 8, null);
            Collection collection2 = statements;
            boolean bl7 = false;
            collection2.add(irIfNode);
            returnValue = (IrExpression)irCacheValue2.invoke();
            returnStatements = CollectionsKt.listOf((Object)cacheVar);
        } else {
            collection = statements;
            boolean bl8 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)bodyStatements));
            returnValue = JsIrBuilder.INSTANCE.buildGetValue(varSymbol);
            returnStatements = CollectionsKt.emptyList();
        }
        collection = statements;
        IrReturnImpl irReturnImpl = JsIrBuilder.INSTANCE.buildReturn(factoryFunction.getSymbol(), returnValue, this.context.getIrBuiltIns().getNothingType());
        boolean bl9 = false;
        collection.add(irReturnImpl);
        factoryFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(statements));
        return returnStatements;
    }

    private final IrType boxIfInlined(@NotNull IrType $this$boxIfInlined) {
        return InlineClassesKt.isInlined($this$boxIfInlined) ? this.context.getIrBuiltIns().getAnyNType() : $this$boxIfInlined;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameter> generateSignatureForClosure(IrFunction callable, IrFunction factory2, IrSimpleFunction closure, IrCallableReference reference, int arity) {
        IrValueParameter irValueParameter;
        IrValueParameter it;
        Object object;
        boolean bl;
        void $this$mapTo$iv$iv2;
        boolean bl2 = false;
        List result2 = new ArrayList();
        int capturedParams = factory2.getValueParameters().size();
        Object $this$map$iv2 = CollectionsKt.dropLast(this.getArguments(reference.getType()), (int)1);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl = false;
            void v0 = it2;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
            }
            IrType irType = ((IrTypeProjection)v0).getType();
            collection.add(irType);
        }
        List functionSignature = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        IrValueParameter irValueParameter2 = callable.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            $this$map$iv2 = irValueParameter2;
            $i$f$map2 = false;
            boolean $this$mapTo$iv$iv2 = false;
            Object dispatch = $this$map$iv2;
            boolean bl3 = false;
            if (reference.getDispatchReceiver() == null) {
                IrValueParameter irValueParameter3 = JsIrBuilder.buildValueParameter$default(JsIrBuilder.INSTANCE, dispatch.getName(), result2.size(), this.boxIfInlined(dispatch.getType()), null, 8, null);
                object = result2;
                boolean bl4 = false;
                bl = false;
                it = irValueParameter3;
                boolean bl5 = false;
                it.setParent(closure);
                irValueParameter = irValueParameter3;
                object.add(irValueParameter);
            } else {
                int n = capturedParams;
                capturedParams = n + -1;
            }
        }
        IrValueParameter irValueParameter4 = callable.getExtensionReceiverParameter();
        if (irValueParameter4 != null) {
            $this$map$iv2 = irValueParameter4;
            $i$f$map2 = false;
            boolean $this$mapTo$iv$iv2 = false;
            Object ext = $this$map$iv2;
            boolean bl6 = false;
            if (reference.getExtensionReceiver() == null) {
                IrValueParameter irValueParameter5 = JsIrBuilder.buildValueParameter$default(JsIrBuilder.INSTANCE, ext.getName(), result2.size(), this.boxIfInlined(ext.getType()), null, 8, null);
                object = result2;
                boolean bl7 = false;
                bl = false;
                it = irValueParameter5;
                boolean bl8 = false;
                it.setParent(closure);
                irValueParameter = irValueParameter5;
                object.add(irValueParameter);
            } else {
                int n = capturedParams;
                capturedParams = n + -1;
            }
        }
        for (Object $this$map$iv2 : CollectionsKt.zip((Iterable)((Iterable)RangesKt.until((int)result2.size(), (int)arity)), (Iterable)CollectionsKt.drop((Iterable)callable.getValueParameters(), (int)capturedParams))) {
            String paramName;
            int index2 = ((Number)$this$map$iv2.component1()).intValue();
            IrValueParameter param = (IrValueParameter)$this$map$iv2.component2();
            IrType type2 = index2 < functionSignature.size() ? (IrType)functionSignature.get(index2) : param.getType();
            object = param.getName();
            boolean bl9 = false;
            bl = false;
            Object $this$run22 = object;
            boolean bl10 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)(!((Name)$this$run22).isSpecial() ? ((Name)$this$run22).getIdentifier() : "" + 'p' + index2), (String)"param.name.run { if (!is\u2026entifier else \"p$index\" }");
            paramName = paramName;
            object = result2;
            IrValueParameter irValueParameter6 = JsIrBuilder.INSTANCE.buildValueParameter(paramName, result2.size(), this.boxIfInlined(type2));
            bl = false;
            boolean $this$run22 = false;
            IrValueParameter it3 = irValueParameter6;
            boolean bl11 = false;
            it3.setParent(closure);
            bl = false;
            object.add(irValueParameter6);
        }
        if (result2.size() < arity) {
            IrValueParameter lastParam = (IrValueParameter)CollectionsKt.last((List)result2);
            int $i$f$map2 = result2.size();
            int n = arity;
            while ($i$f$map2 < n) {
                void index3;
                String paramName = "" + lastParam.getName() + '_' + (int)index3;
                Collection collection = result2;
                IrValueParameter irValueParameter7 = JsIrBuilder.INSTANCE.buildValueParameter(paramName, result2.size(), lastParam.getType());
                boolean bl12 = false;
                boolean bl13 = false;
                IrValueParameter it4 = irValueParameter7;
                boolean bl14 = false;
                it4.setParent(closure);
                bl12 = false;
                collection.add(irValueParameter7);
                ++index3;
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction buildFactoryFunction(IrFunction declaration2, IrCallableReference reference, String getterName) {
        List<IrTypeParameter> list2;
        IrDeclarationBase it;
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        boolean bl2;
        Object object;
        Collection collection;
        IrExpression it2;
        boolean bl3;
        boolean bl4;
        boolean bl5 = false;
        List receivers = new ArrayList();
        IrExpression irExpression = reference.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression irExpression2 = irExpression;
            bl4 = false;
            bl3 = false;
            it2 = irExpression2;
            boolean bl6 = false;
            collection = receivers;
            IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = declaration2.getValueParameters().get(0);
            }
            object = irValueParameter;
            bl2 = false;
            collection.add(object);
        }
        IrExpression irExpression3 = reference.getExtensionReceiver();
        if (irExpression3 != null) {
            IrExpression irExpression4 = irExpression3;
            bl4 = false;
            bl3 = false;
            it2 = irExpression4;
            boolean bl7 = false;
            collection = receivers;
            IrValueParameter irValueParameter = declaration2.getExtensionReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            object = irValueParameter;
            bl2 = false;
            collection.add(object);
        }
        Iterable iterable = declaration2.getValueParameters();
        Collection collection2 = receivers;
        boolean $i$f$filter = false;
        it2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrValueParameter it3 = (IrValueParameter)element$iv$iv;
            boolean bl8 = false;
            if (!Intrinsics.areEqual((Object)it3.getOrigin(), (Object)BOUND_VALUE_PARAMETER.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List boundValueParameters = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
        IrSimpleFunction factoryDeclaration = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, getterName, reference.getType(), (IrDeclarationParent)this.implicitDeclarationFile, declaration2.getVisibility(), null, false, false, false, false, null, 1008, null);
        $i$f$filter = false;
        for (IrValueParameter p : (Iterable)boundValueParameters) {
            void i;
            WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
            object = factoryDeclaration.getValueParameters();
            IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(p.getStartOffset(), p.getEndOffset(), p.getOrigin(), new IrValueParameterSymbolImpl(descriptor2), p.getName(), (int)i, p.getType(), p.getVarargElementType(), p.isCrossinline(), p.isNoinline());
            boolean bl9 = false;
            bl = false;
            it = irValueParameterImpl;
            boolean bl10 = false;
            descriptor2.bind((IrDeclaration)it);
            it.setParent(factoryDeclaration);
            bl9 = false;
            object.add(irValueParameterImpl);
            ++i;
        }
        if (declaration2 instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            list2 = ((IrClass)irDeclarationParent).getTypeParameters();
        } else {
            list2 = declaration2.getTypeParameters();
        }
        List<IrTypeParameter> typeParameters2 = list2;
        for (IrTypeParameter t : typeParameters2) {
            WrappedTypeParameterDescriptor descriptor3 = new WrappedTypeParameterDescriptor(null, null, 3, null);
            object = factoryDeclaration.getTypeParameters();
            IrTypeParameterImpl irTypeParameterImpl = new IrTypeParameterImpl(t.getStartOffset(), t.getEndOffset(), t.getOrigin(), new IrTypeParameterSymbolImpl(descriptor3), t.getName(), t.getIndex(), t.isReified(), t.getVariance());
            boolean bl11 = false;
            bl = false;
            it = irTypeParameterImpl;
            boolean bl12 = false;
            descriptor3.bind((IrDeclaration)it);
            it.setParent(factoryDeclaration);
            bl11 = false;
            object.add(irTypeParameterImpl);
        }
        return factoryDeclaration;
    }

    private final List<IrTypeArgument> getArguments(@NotNull IrType $this$arguments) {
        Object object;
        IrType irType = $this$arguments;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        if ((object = (IrSimpleType)irType) == null || (object = object.getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final int getArity(@NotNull IrType $this$arity) {
        return this.getArguments($this$arity).size() - 1;
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction buildClosureFunction(IrFunction declaration2, IrSimpleFunction factoryFunction, IrCallableReference reference, int arity) {
        int i;
        void $this$mapTo$iv$iv;
        IrValueParameterSymbol irValueParameterSymbol;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String closureName = this.createClosureInstanceName(declaration2);
        IrType returnType2 = this.boxIfInlined(declaration2.getReturnType());
        IrDeclarationParent irDeclarationParent = factoryFunction;
        Visibility visibility = Visibilities.LOCAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.LOCAL");
        IrSimpleFunction closureFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, closureName, returnType2, irDeclarationParent, visibility, null, false, false, false, false, (IrDeclarationOrigin)JsIrBackendContext.Companion.getCallableClosureOrigin(), 496, null);
        Iterable $this$map$iv = factoryFunction.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            irValueParameterSymbol = (IrValueParameterSymbol)it.getSymbol();
            collection.add(irValueParameterSymbol);
        }
        List boundParamSymbols = (List)destination$iv$iv;
        List<IrValueParameter> unboundParamDeclarations = this.generateSignatureForClosure(declaration2, factoryFunction, closureFunction, reference, arity);
        Iterable $this$map$iv2 = unboundParamDeclarations;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            irValueParameterSymbol = (IrValueParameterSymbol)it.getSymbol();
            collection.add(irValueParameterSymbol);
        }
        List unboundParamSymbols = (List)destination$iv$iv2;
        $this$map$iv2 = closureFunction.getValueParameters();
        $i$f$map2 = false;
        CollectionsKt.addAll((Collection)$this$map$iv2, (Iterable)unboundParamDeclarations);
        IrFunction irFunction = this.context.getIr().getDefaultParameterDeclarationsCache().get(declaration2);
        if (irFunction == null) {
            irFunction = declaration2;
        }
        IrFunction callTarget = irFunction;
        IrFunctionSymbol target = callTarget.getSymbol();
        IrFunctionAccessExpression irCall = target instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, returnType2, (IrConstructorSymbol)target, null, 4, null) : (IrFunctionAccessExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, callTarget.getSymbol(), returnType2, null, 4, null);
        int cp = 0;
        int gp = 0;
        if (callTarget.getDispatchReceiverParameter() != null) {
            IrValueParameterSymbol dispatchReceiverDeclaration = reference.getDispatchReceiver() != null ? (IrValueParameterSymbol)boundParamSymbols.get(gp++) : (IrValueParameterSymbol)unboundParamSymbols.get(cp++);
            irCall.setDispatchReceiver(JsIrBuilder.INSTANCE.buildGetValue(dispatchReceiverDeclaration));
        }
        if (callTarget.getExtensionReceiverParameter() != null) {
            IrValueParameterSymbol extensionReceiverDeclaration = reference.getExtensionReceiver() != null ? (IrValueParameterSymbol)boundParamSymbols.get(gp++) : (IrValueParameterSymbol)unboundParamSymbols.get(cp++);
            irCall.setExtensionReceiver(JsIrBuilder.INSTANCE.buildGetValue(extensionReceiverDeclaration));
        }
        int j = 0;
        int item$iv$iv = gp;
        int n = boundParamSymbols.size();
        while (item$iv$iv < n) {
            irCall.putValueArgument(j++, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)boundParamSymbols.get(i)));
            ++i;
        }
        n = unboundParamSymbols.size();
        for (i = cp; i < n; ++i) {
            IrExpressionBase irExpressionBase;
            IrValueParameter closureParam = (IrValueParameter)((IrValueParameterSymbol)unboundParamSymbols.get(i)).getOwner();
            IrGetValueImpl value = JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)unboundParamSymbols.get(i));
            IrValueParameter parameter2 = callTarget.getValueParameters().get(j);
            if (Intrinsics.areEqual((Object)parameter2.getVarargElementType(), (Object)closureParam.getType())) {
                IrType irType;
                Collection<IrGetValueImpl> collection2;
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                List tailValues = CollectionsKt.drop((Iterable)unboundParamSymbols, (int)i);
                IrType irType2 = parameter2.getType();
                if (parameter2.getVarargElementType() == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable2 = tailValues;
                IrType irType3 = irType2;
                int n2 = -1;
                int n3 = -1;
                boolean $i$f$map3 = false;
                void var26_40 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void it;
                    IrValueParameterSymbol irValueParameterSymbol2 = (IrValueParameterSymbol)item$iv$iv2;
                    collection2 = destination$iv$iv3;
                    boolean bl = false;
                    IrGetValueImpl irGetValueImpl = JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)it);
                    collection2.add(irGetValueImpl);
                }
                Collection<IrGetValueImpl> collection3 = collection2 = (List)destination$iv$iv3;
                IrType irType4 = irType;
                IrType irType5 = irType3;
                int n4 = n2;
                int n5 = n3;
                irExpressionBase = new IrVarargImpl(n5, n4, irType5, irType4, (List<? extends IrVarargElement>)collection3);
            } else {
                irExpressionBase = value;
            }
            IrExpressionBase argument = irExpressionBase;
            irCall.putValueArgument(j++, argument);
            if (j == callTarget.getValueParameters().size()) break;
        }
        IrReturnImpl irClosureReturn = JsIrBuilder.INSTANCE.buildReturn(closureFunction.getSymbol(), irCall, this.context.getIrBuiltIns().getNothingType());
        closureFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf((Object)irClosureReturn)));
        return closureFunction;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public CallableReferenceLowering(@NotNull JsIrBackendContext context) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.callableToFactoryFunction = this.context.getCallableReferencesCache();
        CallableReferenceLowering callableReferenceLowering = this;
        boolean bl = false;
        callableReferenceLowering.newDeclarations = list2 = (List)new ArrayList();
        this.implicitDeclarationFile = this.context.getImplicitDeclarationFile();
    }

    public static final /* synthetic */ IrConstImpl access$getCallableNameConst$p(CallableReferenceLowering $this) {
        return $this.getCallableNameConst();
    }

    public static final /* synthetic */ String access$getReferenceName(CallableReferenceLowering $this, IrDeclaration declaration2) {
        return $this.getReferenceName(declaration2);
    }

    public static final /* synthetic */ IrConstImpl access$getGetterConst$p(CallableReferenceLowering $this) {
        return $this.getGetterConst();
    }

    public static final /* synthetic */ IrConstImpl access$getSetterConst$p(CallableReferenceLowering $this) {
        return $this.getSetterConst();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceLowerTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;)V", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "backend.js"})
    public final class CallableReferenceLowerTransformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrFunction declaration2 = expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JsIrBackendContext.Companion.getCallableClosureOrigin())) {
                return expression2;
            }
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(declaration2, expression2);
            Map $this$getOrPut$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerKFunctionReference(declaration2, expression2);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }

        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol == null) {
                Intrinsics.throwNpe();
            }
            IrSimpleFunction declaration2 = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(declaration2, expression2);
            Map $this$getOrPut$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerKPropertyReference(declaration2, expression2);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }

        @Override
        @NotNull
        public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(expression2.getGetter().getOwner(), expression2);
            Map $this$getOrPut$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerLocalKPropertyReference(expression2);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }
    }
}

