/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.keytool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.Timestamp;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.security.spec.PSSParameterSpec;
import java.text.Collator;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs10.PKCS10;
import sun.security.pkcs10.PKCS10Attribute;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.PathList;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.tools.keytool.Pair;
import sun.security.util.DerValue;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.util.Password;
import sun.security.util.Pem;
import sun.security.util.SecurityProviderConstants;
import sun.security.util.SignatureUtil;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.DistributionPoint;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectInfoAccessExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class Main {
    private static final byte[] CRLF = new byte[]{13, 10};
    private boolean debug = false;
    private Command command = null;
    private String sigAlgName = null;
    private String keyAlgName = null;
    private boolean verbose = false;
    private int keysize = -1;
    private boolean rfc = false;
    private long validity = 90L;
    private String alias = null;
    private String dname = null;
    private String dest = null;
    private String filename = null;
    private String infilename = null;
    private String outfilename = null;
    private String srcksfname = null;
    private Set<Pair<String, String>> providers = null;
    private String storetype = null;
    private String srcProviderName = null;
    private String providerName = null;
    private String pathlist = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] newPass = null;
    private char[] destKeyPass = null;
    private char[] srckeyPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private String sslserver = null;
    private String jarfile = null;
    private KeyStore keyStore = null;
    private boolean token = false;
    private boolean nullStream = false;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private boolean nowarn = false;
    private boolean protectedPath = false;
    private boolean srcprotectedPath = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private char[] srcstorePass = null;
    private String srcstoretype = null;
    private Set<char[]> passwords = new HashSet<char[]>();
    private String startDate = null;
    private List<String> ids = new ArrayList<String>();
    private List<String> v3ext = new ArrayList<String>();
    private boolean inplaceImport = false;
    private String inplaceBackupName = null;
    private List<String> weakWarnings = new ArrayList<String>();
    private static final DisabledAlgorithmConstraints DISABLED_CHECK = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");
    private static final Set<CryptoPrimitive> SIG_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Class<?>[] PARAM_STRING = new Class[]{String.class};
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String P12KEYSTORE = "PKCS12";
    private static final String keyAlias = "mykey";
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.keytool.Resources");
    private static final Collator collator = Collator.getInstance();
    private static final String[] extSupported;

    private Main() {
    }

    public static void main(String[] stringArray) throws Exception {
        Main main = new Main();
        main.run(stringArray, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray, PrintStream printStream) throws Exception {
        block10: {
            try {
                this.parseArgs(stringArray);
                if (this.command != null) {
                    this.doCommands(printStream);
                }
            }
            catch (Exception exception) {
                System.out.println(rb.getString("keytool.error.") + exception);
                if (this.verbose) {
                    exception.printStackTrace(System.out);
                }
                if (!this.debug) {
                    System.exit(1);
                    break block10;
                }
                throw exception;
            }
            finally {
                this.printWeakWarnings(false);
                for (char[] cArray : this.passwords) {
                    if (cArray == null) continue;
                    Arrays.fill(cArray, ' ');
                    cArray = null;
                }
                if (this.ksStream != null) {
                    this.ksStream.close();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void parseArgs(String[] stringArray) {
        int n = 0;
        boolean bl = stringArray.length == 0;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            void object3;
            String string = stringArray[n];
            if (n == stringArray.length - 1) {
                for (Option option : Option.values()) {
                    if (collator.compare(string, option.toString()) != 0) continue;
                    if (option.arg == null) break;
                    this.errorNeedArgument(string);
                    break;
                }
            }
            Object var5_8 = null;
            int n2 = string.indexOf(58);
            if (n2 > 0) {
                String string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            int n3 = 0;
            for (Command command : Command.values()) {
                if (collator.compare(string, command.toString()) != 0) continue;
                this.command = command;
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            if (collator.compare(string, "-export") == 0) {
                this.command = Command.EXPORTCERT;
                continue;
            }
            if (collator.compare(string, "-genkey") == 0) {
                this.command = Command.GENKEYPAIR;
                continue;
            }
            if (collator.compare(string, "-import") == 0) {
                this.command = Command.IMPORTCERT;
                continue;
            }
            if (collator.compare(string, "-importpassword") == 0) {
                this.command = Command.IMPORTPASS;
                continue;
            }
            if (collator.compare(string, "-help") == 0) {
                bl = true;
                continue;
            }
            if (collator.compare(string, "-nowarn") == 0) {
                this.nowarn = true;
                continue;
            }
            if (collator.compare(string, "-keystore") == 0 || collator.compare(string, "-destkeystore") == 0) {
                this.ksfname = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-storepass") == 0 || collator.compare(string, "-deststorepass") == 0) {
                this.storePass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.storePass);
                continue;
            }
            if (collator.compare(string, "-storetype") == 0 || collator.compare(string, "-deststoretype") == 0) {
                this.storetype = KeyStoreUtil.niceStoreTypeName(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-srcstorepass") == 0) {
                this.srcstorePass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.srcstorePass);
                continue;
            }
            if (collator.compare(string, "-srcstoretype") == 0) {
                this.srcstoretype = KeyStoreUtil.niceStoreTypeName(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-srckeypass") == 0) {
                this.srckeyPass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.srckeyPass);
                continue;
            }
            if (collator.compare(string, "-srcprovidername") == 0) {
                this.srcProviderName = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-providername") == 0 || collator.compare(string, "-destprovidername") == 0) {
                this.providerName = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-providerpath") == 0) {
                this.pathlist = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-keypass") == 0) {
                this.keyPass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.keyPass);
                continue;
            }
            if (collator.compare(string, "-new") == 0) {
                this.newPass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.newPass);
                continue;
            }
            if (collator.compare(string, "-destkeypass") == 0) {
                this.destKeyPass = this.getPass((String)object3, stringArray[++n]);
                this.passwords.add(this.destKeyPass);
                continue;
            }
            if (collator.compare(string, "-alias") == 0 || collator.compare(string, "-srcalias") == 0) {
                this.alias = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-dest") == 0 || collator.compare(string, "-destalias") == 0) {
                this.dest = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-dname") == 0) {
                this.dname = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-keysize") == 0) {
                this.keysize = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-keyalg") == 0) {
                this.keyAlgName = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-sigalg") == 0) {
                this.sigAlgName = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-startdate") == 0) {
                this.startDate = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-validity") == 0) {
                this.validity = Long.parseLong(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-ext") == 0) {
                this.v3ext.add(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-id") == 0) {
                this.ids.add(stringArray[++n]);
                continue;
            }
            if (collator.compare(string, "-file") == 0) {
                this.filename = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-infile") == 0) {
                this.infilename = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-outfile") == 0) {
                this.outfilename = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-sslserver") == 0) {
                this.sslserver = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-jarfile") == 0) {
                this.jarfile = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-srckeystore") == 0) {
                this.srcksfname = stringArray[++n];
                continue;
            }
            if (collator.compare(string, "-provider") == 0 || collator.compare(string, "-providerclass") == 0) {
                if (this.providers == null) {
                    this.providers = new HashSet<Pair<String, String>>(3);
                }
                String string3 = stringArray[++n];
                String string4 = null;
                if (stringArray.length > n + 1 && collator.compare(string = stringArray[n + 1], "-providerarg") == 0) {
                    if (stringArray.length == n + 2) {
                        this.errorNeedArgument(string);
                    }
                    string4 = stringArray[n + 2];
                    n += 2;
                }
                this.providers.add(Pair.of(string3, string4));
                continue;
            }
            if (collator.compare(string, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(string, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(string, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare(string, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare(string, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            if (collator.compare(string, "-protected") == 0 || collator.compare(string, "-destprotected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(string, "-srcprotected") == 0) {
                this.srcprotectedPath = true;
                continue;
            }
            System.err.println(rb.getString("Illegal.option.") + string);
            this.tinyHelp();
        }
        if (n < stringArray.length) {
            System.err.println(rb.getString("Illegal.option.") + stringArray[n]);
            this.tinyHelp();
        }
        if (this.command == null) {
            if (bl) {
                this.usage();
            } else {
                System.err.println(rb.getString("Usage.error.no.command.provided"));
                this.tinyHelp();
            }
        } else if (bl) {
            this.usage();
            this.command = null;
        }
    }

    boolean isKeyStoreRelated(Command command) {
        return command != Command.PRINTCERT && command != Command.PRINTCERTREQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    void doCommands(PrintStream var1_1) throws Exception {
        block228: {
            if ("PKCS11".equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.token = true;
                if (this.ksfname == null) {
                    this.ksfname = "NONE";
                }
            }
            if ("NONE".equals(this.ksfname)) {
                this.nullStream = true;
            }
            if (this.token && !this.nullStream) {
                System.err.println(MessageFormat.format(Main.rb.getString(".keystore.must.be.NONE.if.storetype.is.{0}"), new Object[]{this.storetype}));
                System.err.println();
                this.tinyHelp();
            }
            if (this.token && (this.command == Command.KEYPASSWD || this.command == Command.STOREPASSWD)) {
                throw new UnsupportedOperationException(MessageFormat.format(Main.rb.getString(".storepasswd.and.keypasswd.commands.not.supported.if.storetype.is.{0}"), new Object[]{this.storetype}));
            }
            if (this.token && (this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(MessageFormat.format(Main.rb.getString(".keypass.and.new.can.not.be.specified.if.storetype.is.{0}"), new Object[]{this.storetype}));
            }
            if (this.protectedPath && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.protected.is.specified.then.storepass.keypass.and.new.must.not.be.specified"));
            }
            if (this.srcprotectedPath && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.srcprotected.is.specified.then.srcstorepass.and.srckeypass.must.not.be.specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.keystore.is.not.password.protected.then.storepass.keypass.and.new.must.not.be.specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.srcstoretype) && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(Main.rb.getString("if.source.keystore.is.not.password.protected.then.srcstorepass.and.srckeypass.must.not.be.specified"));
            }
            if (this.validity <= 0L) {
                throw new Exception(Main.rb.getString("Validity.must.be.greater.than.zero"));
            }
            if (this.providers != null) {
                var2_2 = null;
                if (this.pathlist != null) {
                    var3_3 = null;
                    var3_3 = PathList.appendPath(var3_3, System.getProperty("java.class.path"));
                    var3_3 = PathList.appendPath((String)var3_3, System.getProperty("env.class.path"));
                    var3_3 = PathList.appendPath((String)var3_3, this.pathlist);
                    var4_21 = PathList.pathToURLs((String)var3_3);
                    var2_2 = new URLClassLoader((URL[])var4_21);
                } else {
                    var2_2 = ClassLoader.getSystemClassLoader();
                }
                for (Object var4_21 : this.providers) {
                    var5_22 = (String)var4_21.fst;
                    var6_35 = var2_2 != null ? var2_2.loadClass((String)var5_22) : Class.forName((String)var5_22);
                    var7_36 = (String)var4_21.snd;
                    if (var7_36 == null) {
                        var8_39 = var6_35.newInstance();
                    } else {
                        var9_40 = var6_35.getConstructor(Main.PARAM_STRING);
                        var8_39 = var9_40.newInstance(new Object[]{var7_36});
                    }
                    if (!(var8_39 instanceof Provider)) {
                        var9_40 = new MessageFormat(Main.rb.getString("provName.not.a.provider"));
                        var10_41 = new Object[]{var5_22};
                        throw new Exception(var9_40.format(var10_41));
                    }
                    Security.addProvider((Provider)var8_39);
                }
            }
            if (this.command == Command.LIST && this.verbose && this.rfc) {
                System.err.println(Main.rb.getString("Must.not.specify.both.v.and.rfc.with.list.command"));
                this.tinyHelp();
            }
            if (this.command == Command.GENKEYPAIR && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(Main.rb.getString("Key.password.must.be.at.least.6.characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(Main.rb.getString("New.password.must.be.at.least.6.characters"));
            }
            if (this.destKeyPass != null && this.destKeyPass.length < 6) {
                throw new Exception(Main.rb.getString("New.password.must.be.at.least.6.characters"));
            }
            if (this.ksfname == null) {
                this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
            }
            var2_2 = null;
            if (this.command == Command.IMPORTKEYSTORE) {
                this.inplaceImport = this.inplaceImportCheck();
                if (this.inplaceImport) {
                    var2_2 = this.loadSourceKeyStore();
                    if (this.storePass == null) {
                        this.storePass = this.srcstorePass;
                    }
                }
            }
            if (this.isKeyStoreRelated(this.command) && !this.nullStream && !this.inplaceImport) {
                try {
                    this.ksfile = new File(this.ksfname);
                    if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                        throw new Exception(Main.rb.getString("Keystore.file.exists.but.is.empty.") + this.ksfname);
                    }
                    this.ksStream = new FileInputStream(this.ksfile);
                }
                catch (FileNotFoundException var3_4) {
                    if (this.command == Command.GENKEYPAIR || this.command == Command.GENSECKEY || this.command == Command.IDENTITYDB || this.command == Command.IMPORTCERT || this.command == Command.IMPORTPASS || this.command == Command.IMPORTKEYSTORE || this.command == Command.PRINTCRL) break block228;
                    throw new Exception(Main.rb.getString("Keystore.file.does.not.exist.") + this.ksfname);
                }
            }
        }
        if ((this.command == Command.KEYCLONE || this.command == Command.CHANGEALIAS) && this.dest == null) {
            this.dest = this.getAlias("destination");
            if ("".equals(this.dest)) {
                throw new Exception(Main.rb.getString("Must.specify.destination.alias"));
            }
        }
        if (this.command == Command.DELETE && this.alias == null) {
            this.alias = this.getAlias(null);
            if ("".equals(this.alias)) {
                throw new Exception(Main.rb.getString("Must.specify.alias"));
            }
        }
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
        if (!this.nullStream) {
            if (this.inplaceImport) {
                this.keyStore.load(null, this.storePass);
            } else {
                this.keyStore.load(this.ksStream, this.storePass);
            }
            if (this.ksStream != null) {
                this.ksStream.close();
            }
        }
        if ("PKCS12".equalsIgnoreCase(this.storetype) && this.command == Command.KEYPASSWD) {
            throw new UnsupportedOperationException(Main.rb.getString(".keypasswd.commands.not.supported.if.storetype.is.PKCS12"));
        }
        if (this.nullStream && this.storePass != null) {
            this.keyStore.load(null, this.storePass);
        } else if (!this.nullStream && this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(Main.rb.getString("Keystore.password.must.be.at.least.6.characters"));
            }
        } else if (this.storePass == null) {
            if (!(this.protectedPath || KeyStoreUtil.isWindowsKeyStore(this.storetype) || this.command != Command.CERTREQ && this.command != Command.DELETE && this.command != Command.GENKEYPAIR && this.command != Command.GENSECKEY && this.command != Command.IMPORTCERT && this.command != Command.IMPORTPASS && this.command != Command.IMPORTKEYSTORE && this.command != Command.KEYCLONE && this.command != Command.CHANGEALIAS && this.command != Command.SELFCERT && this.command != Command.STOREPASSWD && this.command != Command.KEYPASSWD && this.command != Command.IDENTITYDB)) {
                var3_5 = 0;
                do {
                    if (this.command == Command.IMPORTKEYSTORE) {
                        System.err.print(Main.rb.getString("Enter.destination.keystore.password."));
                    } else {
                        System.err.print(Main.rb.getString("Enter.keystore.password."));
                    }
                    System.err.flush();
                    this.storePass = Password.readPassword(System.in);
                    this.passwords.add(this.storePass);
                    if (!(this.nullStream || this.storePass != null && this.storePass.length >= 6)) {
                        System.err.println(Main.rb.getString("Keystore.password.is.too.short.must.be.at.least.6.characters"));
                        this.storePass = null;
                    }
                    if (this.storePass == null || this.nullStream || this.ksStream != null) continue;
                    System.err.print(Main.rb.getString("Re.enter.new.password."));
                    var4_21 = Password.readPassword(System.in);
                    this.passwords.add((char[])var4_21);
                    if (Arrays.equals(this.storePass, (char[])var4_21)) continue;
                    System.err.println(Main.rb.getString("They.don.t.match.Try.again"));
                    this.storePass = null;
                } while (this.storePass == null && ++var3_5 < 3);
                if (this.storePass == null) {
                    System.err.println(Main.rb.getString("Too.many.failures.try.later"));
                    return;
                }
            } else if (!this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype) && this.isKeyStoreRelated(this.command) && this.command != Command.PRINTCRL) {
                System.err.print(Main.rb.getString("Enter.keystore.password."));
                System.err.flush();
                this.storePass = Password.readPassword(System.in);
                this.passwords.add(this.storePass);
            }
            if (this.nullStream) {
                this.keyStore.load(null, this.storePass);
            } else if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.storePass != null && "PKCS12".equalsIgnoreCase(this.storetype)) {
            var3_6 = new MessageFormat(Main.rb.getString("Warning.Different.store.and.key.passwords.not.supported.for.PKCS12.KeyStores.Ignoring.user.specified.command.value."));
            if (this.keyPass != null && !Arrays.equals(this.storePass, this.keyPass)) {
                var4_21 = new Object[]{"-keypass"};
                System.err.println(var3_6.format(var4_21));
                this.keyPass = this.storePass;
            }
            if (this.newPass != null && !Arrays.equals(this.storePass, this.newPass)) {
                var4_21 = new Object[]{"-new"};
                System.err.println(var3_6.format(var4_21));
                this.newPass = this.storePass;
            }
            if (this.destKeyPass != null && !Arrays.equals(this.storePass, this.destKeyPass)) {
                var4_21 = new Object[]{"-destkeypass"};
                System.err.println(var3_6.format(var4_21));
                this.destKeyPass = this.storePass;
            }
        }
        if (this.command == Command.PRINTCERT || this.command == Command.IMPORTCERT || this.command == Command.IDENTITYDB || this.command == Command.PRINTCRL) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.command != Command.IMPORTCERT) {
            this.trustcacerts = false;
        }
        if (this.trustcacerts) {
            this.caks = KeyStoreUtil.getCacertsKeyStore();
        }
        if (this.command == Command.CERTREQ) {
            if (this.filename != null) {
                var3_7 = new PrintStream(new FileOutputStream(this.filename));
                var4_21 = null;
                try {
                    this.doCertReq(this.alias, this.sigAlgName, var3_7);
                }
                catch (Throwable var5_24) {
                    var4_21 = var5_24;
                    throw var5_24;
                }
                finally {
                    if (var3_7 != null) {
                        if (var4_21 != null) {
                            try {
                                var3_7.close();
                            }
                            catch (Throwable var5_23) {
                                var4_21.addSuppressed(var5_23);
                            }
                        } else {
                            var3_7.close();
                        }
                    }
                }
            } else {
                this.doCertReq(this.alias, this.sigAlgName, (PrintStream)var1_1);
            }
            if (this.verbose && this.filename != null) {
                var3_8 = new MessageFormat(Main.rb.getString("Certification.request.stored.in.file.filename."));
                var4_21 = new Object[]{this.filename};
                System.err.println(var3_8.format(var4_21));
                System.err.println(Main.rb.getString("Submit.this.to.your.CA"));
            }
        } else if (this.command == Command.DELETE) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command == Command.EXPORTCERT) {
            if (this.filename != null) {
                var3_9 = new PrintStream(new FileOutputStream(this.filename));
                var4_21 = null;
                try {
                    this.doExportCert(this.alias, var3_9);
                }
                catch (Throwable var5_26) {
                    var4_21 = var5_26;
                    throw var5_26;
                }
                finally {
                    if (var3_9 != null) {
                        if (var4_21 != null) {
                            try {
                                var3_9.close();
                            }
                            catch (Throwable var5_25) {
                                var4_21.addSuppressed(var5_25);
                            }
                        } else {
                            var3_9.close();
                        }
                    }
                }
            } else {
                this.doExportCert(this.alias, (PrintStream)var1_1);
            }
            if (this.filename != null) {
                var3_10 = new MessageFormat(Main.rb.getString("Certificate.stored.in.file.filename."));
                var4_21 = new Object[]{this.filename};
                System.err.println(var3_10.format(var4_21));
            }
        } else if (this.command == Command.GENKEYPAIR) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DSA";
            }
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == Command.GENSECKEY) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DES";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else if (this.command == Command.IMPORTPASS) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "PBE";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else if (this.command == Command.IDENTITYDB) {
            if (this.filename != null) {
                var3_11 = new FileInputStream(this.filename);
                var4_21 = null;
                try {
                    this.doImportIdentityDatabase(var3_11);
                }
                catch (Throwable var5_28) {
                    var4_21 = var5_28;
                    throw var5_28;
                }
                finally {
                    if (var3_11 != null) {
                        if (var4_21 != null) {
                            try {
                                var3_11.close();
                            }
                            catch (Throwable var5_27) {
                                var4_21.addSuppressed(var5_27);
                            }
                        } else {
                            var3_11.close();
                        }
                    }
                }
            } else {
                this.doImportIdentityDatabase(System.in);
            }
        } else if (this.command == Command.IMPORTCERT) {
            var3_12 = System.in;
            if (this.filename != null) {
                var3_12 = new FileInputStream(this.filename);
            }
            var4_21 = this.alias != null ? this.alias : "mykey";
            try {
                if (this.keyStore.entryInstanceOf((String)var4_21, KeyStore.PrivateKeyEntry.class)) {
                    this.kssave = this.installReply((String)var4_21, var3_12);
                    if (this.kssave) {
                        System.err.println(Main.rb.getString("Certificate.reply.was.installed.in.keystore"));
                    }
                    System.err.println(Main.rb.getString("Certificate.reply.was.not.installed.in.keystore"));
                }
                if (this.keyStore.containsAlias((String)var4_21) && !this.keyStore.entryInstanceOf((String)var4_21, KeyStore.TrustedCertificateEntry.class)) ** GOTO lbl416
                this.kssave = this.addTrustedCert((String)var4_21, var3_12);
                if (this.kssave) {
                    System.err.println(Main.rb.getString("Certificate.was.added.to.keystore"));
                }
                System.err.println(Main.rb.getString("Certificate.was.not.added.to.keystore"));
            }
            finally {
                if (var3_12 != System.in) {
                    var3_12.close();
                }
            }
        } else if (this.command == Command.IMPORTKEYSTORE) {
            if (var2_2 == null) {
                var2_2 = this.loadSourceKeyStore();
            }
            this.doImportKeyStore((KeyStore)var2_2);
            this.kssave = true;
        } else if (this.command == Command.KEYCLONE) {
            this.keyPassNew = this.newPass;
            if (this.alias == null) {
                this.alias = "mykey";
            }
            if (!this.keyStore.containsAlias(this.alias)) {
                var3_13 = new MessageFormat(Main.rb.getString("Alias.alias.does.not.exist"));
                var4_21 = new Object[]{this.alias};
                throw new Exception(var3_13.format(var4_21));
            }
            if (!this.keyStore.entryInstanceOf(this.alias, KeyStore.PrivateKeyEntry.class)) {
                var3_14 = new MessageFormat(Main.rb.getString("Alias.alias.references.an.entry.type.that.is.not.a.private.key.entry.The.keyclone.command.only.supports.cloning.of.private.key"));
                var4_21 = new Object[]{this.alias};
                throw new Exception(var3_14.format(var4_21));
            }
            this.doCloneEntry(this.alias, this.dest, true);
            this.kssave = true;
        } else if (this.command == Command.CHANGEALIAS) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            this.doCloneEntry(this.alias, this.dest, false);
            if (this.keyStore.containsAlias(this.alias)) {
                this.doDeleteEntry(this.alias);
            }
            this.kssave = true;
        } else if (this.command == Command.KEYPASSWD) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command == Command.LIST) {
            if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.printNoIntegrityWarning();
            }
            if (this.alias != null) {
                this.doPrintEntry(Main.rb.getString("the.certificate"), this.alias, (PrintStream)var1_1);
            } else {
                this.doPrintEntries((PrintStream)var1_1);
            }
        } else if (this.command == Command.PRINTCERT) {
            this.doPrintCert((PrintStream)var1_1);
        } else if (this.command == Command.SELFCERT) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == Command.STOREPASSWD) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        } else if (this.command == Command.GENCERT) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            var3_15 = System.in;
            if (this.infilename != null) {
                var3_15 = new FileInputStream(this.infilename);
            }
            var4_21 = null;
            if (this.outfilename != null) {
                var1_1 = var4_21 = new PrintStream(new FileOutputStream(this.outfilename));
            }
            try {
                this.doGenCert(this.alias, this.sigAlgName, var3_15, (PrintStream)var1_1);
            }
            finally {
                if (var3_15 != System.in) {
                    var3_15.close();
                }
                if (var4_21 != null) {
                    var4_21.close();
                }
            }
        } else if (this.command == Command.GENCRL) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            if (this.filename != null) {
                var3_16 = new PrintStream(new FileOutputStream(this.filename));
                var4_21 = null;
                try {
                    this.doGenCRL(var3_16);
                }
                catch (Throwable var5_30) {
                    var4_21 = var5_30;
                    throw var5_30;
                }
                finally {
                    if (var3_16 != null) {
                        if (var4_21 != null) {
                            try {
                                var3_16.close();
                            }
                            catch (Throwable var5_29) {
                                var4_21.addSuppressed(var5_29);
                            }
                        } else {
                            var3_16.close();
                        }
                    }
                }
            } else {
                this.doGenCRL((PrintStream)var1_1);
            }
        } else if (this.command == Command.PRINTCERTREQ) {
            if (this.filename != null) {
                var3_17 = new FileInputStream(this.filename);
                var4_21 = null;
                try {
                    this.doPrintCertReq(var3_17, (PrintStream)var1_1);
                }
                catch (Throwable var5_32) {
                    var4_21 = var5_32;
                    throw var5_32;
                }
                finally {
                    if (var3_17 != null) {
                        if (var4_21 != null) {
                            try {
                                var3_17.close();
                            }
                            catch (Throwable var5_31) {
                                var4_21.addSuppressed(var5_31);
                            }
                        } else {
                            var3_17.close();
                        }
                    }
                }
            } else {
                this.doPrintCertReq(System.in, (PrintStream)var1_1);
            }
        } else if (this.command == Command.PRINTCRL) {
            this.doPrintCRL(this.filename, (PrintStream)var1_1);
        }
lbl416:
        // 30 sources

        if (this.kssave) {
            if (this.verbose) {
                var3_18 = new MessageFormat(Main.rb.getString(".Storing.ksfname."));
                var4_21 = new Object[]{this.nullStream != false ? "keystore" : this.ksfname};
                System.err.println(var3_18.format(var4_21));
            }
            if (this.token) {
                this.keyStore.store(null, null);
            } else {
                v0 = var3_19 = this.storePassNew != null ? this.storePassNew : this.storePass;
                if (this.nullStream) {
                    this.keyStore.store(null, var3_19);
                } else {
                    var4_21 = new ByteArrayOutputStream();
                    this.keyStore.store((OutputStream)var4_21, var3_19);
                    var5_22 = new FileOutputStream(this.ksfname);
                    var6_35 = null;
                    try {
                        var5_22.write(var4_21.toByteArray());
                    }
                    catch (Throwable var7_38) {
                        var6_35 = var7_38;
                        throw var7_38;
                    }
                    finally {
                        if (var5_22 != null) {
                            if (var6_35 != null) {
                                try {
                                    var5_22.close();
                                }
                                catch (Throwable var7_37) {
                                    var6_35.addSuppressed(var7_37);
                                }
                            } else {
                                var5_22.close();
                            }
                        }
                    }
                }
            }
        }
        if (this.isKeyStoreRelated(this.command) && !this.token && !this.nullStream && this.ksfname != null && (var3_20 = new File(this.ksfname)).exists()) {
            var4_21 = this.keyStoreType(var3_20);
            if (var4_21.equalsIgnoreCase("JKS") || var4_21.equalsIgnoreCase("JCEKS")) {
                var5_33 = true;
                for (String var7_36 : Collections.list(this.keyStore.aliases())) {
                    if (this.keyStore.entryInstanceOf(var7_36, KeyStore.TrustedCertificateEntry.class)) continue;
                    var5_33 = false;
                    break;
                }
                if (!var5_33) {
                    this.weakWarnings.add(String.format(Main.rb.getString("jks.storetype.warning"), new Object[]{var4_21, this.ksfname}));
                }
            }
            if (this.inplaceImport) {
                var5_34 = this.keyStoreType(new File(this.inplaceBackupName));
                var6_35 = var4_21.equalsIgnoreCase(var5_34) != false ? Main.rb.getString("backup.keystore.warning") : Main.rb.getString("migrate.keystore.warning");
                this.weakWarnings.add(String.format((String)var6_35, new Object[]{this.srcksfname, var5_34, this.inplaceBackupName, var4_21}));
            }
        }
    }

    private String keyStoreType(File file) throws IOException {
        int n = -17957139;
        int n2 = -825307442;
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            int n3 = dataInputStream.readInt();
            if (n3 == n) {
                String string = "JKS";
                return string;
            }
            if (n3 == n2) {
                String string = "JCEKS";
                return string;
            }
            String string = "Non JKS/JCEKS";
            return string;
        }
    }

    private void doGenCert(String string, String string2, InputStream inputStream, PrintStream printStream) throws Exception {
        Object object2;
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Certificate certificate = this.keyStore.getCertificate(string);
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        X500Name x500Name = (X500Name)x509CertInfo.get("subject.dname");
        Date date = Main.getStartDate(this.startDate);
        Date date2 = new Date();
        date2.setTime(date.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        PrivateKey privateKey = (PrivateKey)this.recoverKey((String)string, (char[])this.storePass, (char[])this.keyPass).fst;
        if (string2 == null) {
            string2 = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(string2);
        PSSParameterSpec pSSParameterSpec = AlgorithmId.getDefaultAlgorithmParameterSpec(string2, privateKey);
        SignatureUtil.initSignWithParam(signature, privateKey, pSSParameterSpec, null);
        X509CertInfo x509CertInfo2 = new X509CertInfo();
        AlgorithmId algorithmId = AlgorithmId.getWithParameterSpec(string2, pSSParameterSpec);
        x509CertInfo2.set("validity", certificateValidity);
        x509CertInfo2.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        x509CertInfo2.set("version", new CertificateVersion(2));
        x509CertInfo2.set("algorithmID", new CertificateAlgorithmId(algorithmId));
        x509CertInfo2.set("issuer", x500Name);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while ((object2 = bufferedReader.readLine()) != null) {
            if (((String)object2).startsWith("-----BEGIN") && ((String)object2).indexOf("REQUEST") >= 0) {
                bl = true;
                continue;
            }
            if (((String)object2).startsWith("-----END") && ((String)object2).indexOf("REQUEST") >= 0) break;
            if (!bl) continue;
            stringBuffer.append((String)object2);
        }
        object2 = Pem.decode(new String(stringBuffer));
        PKCS10 pKCS10 = new PKCS10((byte[])object2);
        this.checkWeak(rb.getString("the.certificate.request"), pKCS10);
        x509CertInfo2.set("key", new CertificateX509Key(pKCS10.getSubjectPublicKeyInfo()));
        x509CertInfo2.set("subject", this.dname == null ? pKCS10.getSubjectName() : new X500Name(this.dname));
        CertificateExtensions certificateExtensions = null;
        for (PKCS10Attribute object3 : pKCS10.getAttributes().getAttributes()) {
            if (!object3.getAttributeId().equals((Object)PKCS9Attribute.EXTENSION_REQUEST_OID)) continue;
            certificateExtensions = (CertificateExtensions)object3.getAttributeValue();
        }
        CertificateExtensions certificateExtensions2 = this.createV3Extensions(certificateExtensions, null, this.v3ext, pKCS10.getSubjectPublicKeyInfo(), certificate.getPublicKey());
        x509CertInfo2.set("extensions", certificateExtensions2);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo2);
        x509CertImpl2.sign(privateKey, pSSParameterSpec, string2, null);
        this.dumpCert(x509CertImpl2, printStream);
        for (Certificate certificate2 : this.keyStore.getCertificateChain(string)) {
            X509Certificate x509Certificate;
            if (!(certificate2 instanceof X509Certificate) || KeyStoreUtil.isSelfSigned(x509Certificate = (X509Certificate)certificate2)) continue;
            this.dumpCert(x509Certificate, printStream);
        }
        this.checkWeak(rb.getString("the.issuer"), this.keyStore.getCertificateChain(string));
        this.checkWeak(rb.getString("the.generated.certificate"), x509CertImpl2);
    }

    private void doGenCRL(PrintStream printStream) throws Exception {
        if (this.ids == null) {
            throw new Exception("Must provide -id when -gencrl");
        }
        Certificate certificate = this.keyStore.getCertificate(this.alias);
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        X500Name x500Name = (X500Name)x509CertInfo.get("subject.dname");
        Date date = Main.getStartDate(this.startDate);
        Date date2 = (Date)date.clone();
        date2.setTime(date2.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        PrivateKey privateKey = (PrivateKey)this.recoverKey((String)this.alias, (char[])this.storePass, (char[])this.keyPass).fst;
        if (this.sigAlgName == null) {
            this.sigAlgName = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        X509CRLEntry[] x509CRLEntryArray = new X509CRLEntry[this.ids.size()];
        for (int i = 0; i < this.ids.size(); ++i) {
            String string = this.ids.get(i);
            int n = string.indexOf(58);
            if (n >= 0) {
                CRLExtensions cRLExtensions = new CRLExtensions();
                cRLExtensions.set("Reason", new CRLReasonCodeExtension(Integer.parseInt(string.substring(n + 1))));
                x509CRLEntryArray[i] = new X509CRLEntryImpl(new BigInteger(string.substring(0, n)), date, cRLExtensions);
                continue;
            }
            x509CRLEntryArray[i] = new X509CRLEntryImpl(new BigInteger(this.ids.get(i)), date);
        }
        X509CRLImpl x509CRLImpl = new X509CRLImpl(x500Name, date, date2, x509CRLEntryArray);
        x509CRLImpl.sign(privateKey, this.sigAlgName);
        if (this.rfc) {
            printStream.println("-----BEGIN X509 CRL-----");
            printStream.println(Base64.getMimeEncoder(64, CRLF).encodeToString(x509CRLImpl.getEncodedInternal()));
            printStream.println("-----END X509 CRL-----");
        } else {
            printStream.write(x509CRLImpl.getEncodedInternal());
        }
        this.checkWeak(rb.getString("the.generated.crl"), x509CRLImpl, (Key)privateKey);
    }

    private void doCertReq(String string, String string2, PrintStream printStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = keyAlias;
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias.has.no.public.key.certificate."));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        PKCS10 pKCS10 = new PKCS10(certificate.getPublicKey());
        CertificateExtensions certificateExtensions = this.createV3Extensions(null, null, this.v3ext, certificate.getPublicKey(), null);
        pKCS10.getAttributes().setAttribute("extensions", new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, certificateExtensions));
        if (string2 == null) {
            string2 = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(string2);
        PSSParameterSpec pSSParameterSpec = AlgorithmId.getDefaultAlgorithmParameterSpec(string2, privateKey);
        SignatureUtil.initSignWithParam(signature, privateKey, pSSParameterSpec, null);
        X500Name x500Name = this.dname == null ? new X500Name(((X509Certificate)certificate).getSubjectDN().toString()) : new X500Name(this.dname);
        pKCS10.encodeAndSign(x500Name, signature);
        pKCS10.print(printStream);
        this.checkWeak(rb.getString("the.generated.certificate.request"), pKCS10);
    }

    private void doDeleteEntry(String string) throws Exception {
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.keyStore.deleteEntry(string);
    }

    private void doExportCert(String string, PrintStream printStream) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printNoIntegrityWarning();
        }
        if (string == null) {
            string = keyAlias;
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(string);
        if (x509Certificate == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.has.no.certificate"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.dumpCert(x509Certificate, printStream);
        this.checkWeak(rb.getString("the.certificate"), x509Certificate);
    }

    private char[] promptForKeyPass(String string, String string2, char[] cArray) throws Exception {
        if (P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            return cArray;
        }
        if (!this.token && !this.protectedPath) {
            int n;
            for (n = 0; n < 3; ++n) {
                Object[] objectArray;
                MessageFormat messageFormat = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                Object[] objectArray2 = new Object[]{string};
                System.err.println(messageFormat.format(objectArray2));
                if (string2 == null) {
                    System.err.print(rb.getString(".RETURN.if.same.as.keystore.password."));
                } else {
                    messageFormat = new MessageFormat(rb.getString(".RETURN.if.same.as.for.otherAlias."));
                    objectArray = new Object[]{string2};
                    System.err.print(messageFormat.format(objectArray));
                }
                System.err.flush();
                objectArray = Password.readPassword(System.in);
                this.passwords.add((char[])objectArray);
                if (objectArray == null) {
                    return cArray;
                }
                if (objectArray.length >= 6) {
                    System.err.print(rb.getString("Re.enter.new.password."));
                    char[] cArray2 = Password.readPassword(System.in);
                    this.passwords.add(cArray2);
                    if (!Arrays.equals(objectArray, cArray2)) {
                        System.err.println(rb.getString("They.don.t.match.Try.again"));
                        continue;
                    }
                    return objectArray;
                }
                System.err.println(rb.getString("Key.password.is.too.short.must.be.at.least.6.characters"));
            }
            if (n == 3) {
                if (this.command == Command.KEYCLONE) {
                    throw new Exception(rb.getString("Too.many.failures.Key.entry.not.cloned"));
                }
                throw new Exception(rb.getString("Too.many.failures.key.not.added.to.keystore"));
            }
        }
        return null;
    }

    private char[] promptForCredential() throws Exception {
        int n;
        if (System.console() == null) {
            char[] cArray = Password.readPassword(System.in);
            this.passwords.add(cArray);
            return cArray;
        }
        for (n = 0; n < 3; ++n) {
            System.err.print(rb.getString("Enter.the.password.to.be.stored."));
            System.err.flush();
            char[] cArray = Password.readPassword(System.in);
            this.passwords.add(cArray);
            System.err.print(rb.getString("Re.enter.password."));
            char[] cArray2 = Password.readPassword(System.in);
            this.passwords.add(cArray2);
            if (Arrays.equals(cArray, cArray2)) {
                return cArray;
            }
            System.err.println(rb.getString("They.don.t.match.Try.again"));
        }
        if (n == 3) {
            throw new Exception(rb.getString("Too.many.failures.key.not.added.to.keystore"));
        }
        return null;
    }

    private void doGenSecretKey(String string, String string2, int n) throws Exception {
        if (string == null) {
            string = keyAlias;
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Secret.key.not.generated.alias.alias.already.exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        boolean bl = true;
        SecretKey secretKey = null;
        if (string2.toUpperCase(Locale.ENGLISH).startsWith("PBE")) {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(this.promptForCredential()));
            if (!"PBE".equalsIgnoreCase(string2)) {
                bl = false;
            }
            if (this.verbose) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Generated.keyAlgName.secret.key"));
                Object[] objectArray = new Object[]{bl ? "PBE" : secretKey.getAlgorithm()};
                System.err.println(messageFormat.format(objectArray));
            }
        } else {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string2);
            if (n == -1) {
                if ("DES".equalsIgnoreCase(string2)) {
                    n = 56;
                } else if ("DESede".equalsIgnoreCase(string2)) {
                    n = 168;
                } else {
                    throw new Exception(rb.getString("Please.provide.keysize.for.secret.key.generation"));
                }
            }
            keyGenerator.init(n);
            secretKey = keyGenerator.generateKey();
            if (this.verbose) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Generated.keysize.bit.keyAlgName.secret.key"));
                Object[] objectArray = new Object[]{new Integer(n), secretKey.getAlgorithm()};
                System.err.println(messageFormat.format(objectArray));
            }
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(string, null, this.storePass);
        }
        if (bl) {
            this.keyStore.setKeyEntry(string, secretKey, this.keyPass, null);
        } else {
            this.keyStore.setEntry(string, new KeyStore.SecretKeyEntry(secretKey), new KeyStore.PasswordProtection(this.keyPass, string2, null));
        }
    }

    private static String getCompatibleSigAlgName(String string) throws Exception {
        if ("DSA".equalsIgnoreCase(string)) {
            return "SHA256WithDSA";
        }
        if ("RSA".equalsIgnoreCase(string)) {
            return "SHA256WithRSA";
        }
        if ("EC".equalsIgnoreCase(string)) {
            return "SHA256withECDSA";
        }
        throw new Exception(rb.getString("Cannot.derive.signature.algorithm"));
    }

    private void doGenKeyPair(String string, String string2, String string3, int n, String string4) throws Exception {
        if (n == -1) {
            if ("EC".equalsIgnoreCase(string3)) {
                n = SecurityProviderConstants.DEF_EC_KEY_SIZE;
            } else if ("RSA".equalsIgnoreCase(string3)) {
                n = SecurityProviderConstants.DEF_RSA_KEY_SIZE;
            } else if ("RSASSA-PSS".equalsIgnoreCase(string3)) {
                n = SecurityProviderConstants.DEF_RSASSA_PSS_KEY_SIZE;
            } else if ("DSA".equalsIgnoreCase(string3)) {
                n = SecurityProviderConstants.DEF_DSA_KEY_SIZE;
            }
        }
        if (string == null) {
            string = keyAlias;
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Key.pair.not.generated.alias.alias.already.exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (string4 == null) {
            string4 = Main.getCompatibleSigAlgName(string3);
        }
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen(string3, string4, this.providerName);
        X500Name x500Name = string2 == null ? this.getX500Name() : new X500Name(string2);
        certAndKeyGen.generate(n);
        PrivateKey privateKey = certAndKeyGen.getPrivateKey();
        CertificateExtensions certificateExtensions = this.createV3Extensions(null, null, this.v3ext, certAndKeyGen.getPublicKeyAnyway(), null);
        Certificate[] certificateArray = new X509Certificate[]{certAndKeyGen.getSelfCertificate(x500Name, Main.getStartDate(this.startDate), this.validity * 24L * 60L * 60L, certificateExtensions)};
        if (this.verbose) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Generating.keysize.bit.keyAlgName.key.pair.and.self.signed.certificate.sigAlgName.with.a.validity.of.validality.days.for"));
            Object[] objectArray = new Object[]{new Integer(n), privateKey.getAlgorithm(), ((X509Certificate)certificateArray[0]).getSigAlgName(), new Long(this.validity), x500Name};
            System.err.println(messageFormat.format(objectArray));
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(string, null, this.storePass);
        }
        this.checkWeak(rb.getString("the.generated.certificate"), certificateArray[0]);
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass, certificateArray);
    }

    private void doCloneEntry(String string, String string2, boolean bl) throws Exception {
        if (string == null) {
            string = keyAlias;
        }
        if (this.keyStore.containsAlias(string2)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Destination.alias.dest.already.exists"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        Pair<KeyStore.Entry, char[]> pair = this.recoverEntry(this.keyStore, string, this.storePass, this.keyPass);
        KeyStore.Entry entry = (KeyStore.Entry)pair.fst;
        this.keyPass = (char[])pair.snd;
        KeyStore.PasswordProtection passwordProtection = null;
        if (this.keyPass != null) {
            if (!bl || P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
                this.keyPassNew = this.keyPass;
            } else if (this.keyPassNew == null) {
                this.keyPassNew = this.promptForKeyPass(string2, string, this.keyPass);
            }
            passwordProtection = new KeyStore.PasswordProtection(this.keyPassNew);
        }
        this.keyStore.setEntry(string2, entry, passwordProtection);
    }

    private void doChangeKeyPasswd(String string) throws Exception {
        if (string == null) {
            string = keyAlias;
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        Key key = (Key)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if (this.keyPassNew == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("key.password.for.alias."));
            Object[] objectArray = new Object[]{string};
            this.keyPassNew = this.getNewPasswd(messageFormat.format(objectArray), this.keyPass);
        }
        this.keyStore.setKeyEntry(string, key, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    private void doImportIdentityDatabase(InputStream inputStream) throws Exception {
        System.err.println(rb.getString("No.entries.from.identity.database.added"));
    }

    private void doPrintEntry(String string, String string2, PrintStream printStream) throws Exception {
        Object object;
        Object[] objectArray;
        Object object2;
        if (!this.keyStore.containsAlias(string2)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray2 = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray2));
        }
        if (this.verbose || this.rfc || this.debug) {
            object2 = new MessageFormat(rb.getString("Alias.name.alias"));
            objectArray = new Object[]{string2};
            printStream.println(((Format)object2).format(objectArray));
            if (!this.token) {
                object2 = new MessageFormat(rb.getString("Creation.date.keyStore.getCreationDate.alias."));
                object = new Object[]{this.keyStore.getCreationDate(string2)};
                printStream.println(((Format)object2).format(object));
            }
        } else if (!this.token) {
            object2 = new MessageFormat(rb.getString("alias.keyStore.getCreationDate.alias."));
            objectArray = new Object[]{string2, this.keyStore.getCreationDate(string2)};
            printStream.print(((Format)object2).format(objectArray));
        } else {
            object2 = new MessageFormat(rb.getString("alias."));
            objectArray = new Object[]{string2};
            printStream.print(((Format)object2).format(objectArray));
        }
        if (this.keyStore.entryInstanceOf(string2, KeyStore.SecretKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                object2 = new Object[]{"SecretKeyEntry"};
                printStream.println(new MessageFormat(rb.getString("Entry.type.type.")).format(object2));
            } else {
                printStream.println("SecretKeyEntry, ");
            }
        } else if (this.keyStore.entryInstanceOf(string2, KeyStore.PrivateKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                object2 = new Object[]{"PrivateKeyEntry"};
                printStream.println(new MessageFormat(rb.getString("Entry.type.type.")).format(object2));
            } else {
                printStream.println("PrivateKeyEntry, ");
            }
            object2 = this.keyStore.getCertificateChain(string2);
            if (object2 != null) {
                if (this.verbose || this.rfc || this.debug) {
                    printStream.println(rb.getString("Certificate.chain.length.") + ((Object[])object2).length);
                    for (int i = 0; i < ((Object[])object2).length; ++i) {
                        object = new MessageFormat(rb.getString("Certificate.i.1."));
                        Object[] objectArray3 = new Object[]{new Integer(i + 1)};
                        printStream.println(((Format)object).format(objectArray3));
                        if (this.verbose && object2[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)object2[i], printStream);
                        } else if (this.debug) {
                            printStream.println(((Certificate)object2[i]).toString());
                        } else {
                            this.dumpCert((Certificate)object2[i], printStream);
                        }
                        this.checkWeak(string, (Certificate)object2[i]);
                    }
                } else {
                    printStream.println(rb.getString("Certificate.fingerprint.SHA1.") + this.getCertFingerPrint("SHA1", (Certificate)object2[0]));
                    this.checkWeak(string, (Certificate)object2[0]);
                }
            }
        } else if (this.keyStore.entryInstanceOf(string2, KeyStore.TrustedCertificateEntry.class)) {
            object2 = this.keyStore.getCertificate(string2);
            objectArray = new Object[]{"trustedCertEntry"};
            object = new MessageFormat(rb.getString("Entry.type.type.")).format(objectArray) + "\n";
            if (this.verbose && object2 instanceof X509Certificate) {
                printStream.println((String)object);
                this.printX509Cert((X509Certificate)object2, printStream);
            } else if (this.rfc) {
                printStream.println((String)object);
                this.dumpCert((Certificate)object2, printStream);
            } else if (this.debug) {
                printStream.println(((Certificate)object2).toString());
            } else {
                printStream.println("trustedCertEntry, ");
                printStream.println(rb.getString("Certificate.fingerprint.SHA1.") + this.getCertFingerPrint("SHA1", (Certificate)object2));
            }
            this.checkWeak(string, (Certificate)object2);
        } else {
            printStream.println(rb.getString("Unknown.Entry.Type"));
        }
    }

    boolean inplaceImportCheck() throws Exception {
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            return false;
        }
        if (this.srcksfname != null) {
            File file = new File(this.srcksfname);
            if (file.exists() && file.length() == 0L) {
                throw new Exception(rb.getString("Source.keystore.file.exists.but.is.empty.") + this.srcksfname);
            }
            if (file.getCanonicalFile().equals(new File(this.ksfname).getCanonicalFile())) {
                return true;
            }
            System.err.println(String.format(rb.getString("importing.keystore.status"), this.srcksfname, this.ksfname));
            return false;
        }
        throw new Exception(rb.getString("Please.specify.srckeystore"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadSourceKeyStore() throws Exception {
        KeyStore keyStore;
        InputStream inputStream = null;
        File file = null;
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            if (!NONE.equals(this.srcksfname)) {
                System.err.println(MessageFormat.format(rb.getString(".keystore.must.be.NONE.if.storetype.is.{0}"), this.srcstoretype));
                System.err.println();
                this.tinyHelp();
            }
        } else {
            file = new File(this.srcksfname);
            inputStream = new FileInputStream(file);
        }
        try {
            if (this.srcstoretype == null) {
                this.srcstoretype = KeyStore.getDefaultType();
            }
            keyStore = this.srcProviderName == null ? KeyStore.getInstance(this.srcstoretype) : KeyStore.getInstance(this.srcstoretype, this.srcProviderName);
            if (this.srcstorePass == null && !this.srcprotectedPath && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
                System.err.print(rb.getString("Enter.source.keystore.password."));
                System.err.flush();
                this.srcstorePass = Password.readPassword(System.in);
                this.passwords.add(this.srcstorePass);
            }
            if (P12KEYSTORE.equalsIgnoreCase(this.srcstoretype) && this.srckeyPass != null && this.srcstorePass != null && !Arrays.equals(this.srcstorePass, this.srckeyPass)) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Warning.Different.store.and.key.passwords.not.supported.for.PKCS12.KeyStores.Ignoring.user.specified.command.value."));
                Object[] objectArray = new Object[]{"-srckeypass"};
                System.err.println(messageFormat.format(objectArray));
                this.srckeyPass = this.srcstorePass;
            }
            keyStore.load(inputStream, this.srcstorePass);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (this.srcstorePass == null && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            System.err.println();
            System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
            System.err.println(rb.getString(".The.integrity.of.the.information.stored.in.the.srckeystore."));
            System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
            System.err.println();
        }
        return keyStore;
    }

    private void doImportKeyStore(KeyStore keyStore) throws Exception {
        if (this.alias != null) {
            this.doImportKeyStoreSingle(keyStore, this.alias);
        } else {
            if (this.dest != null || this.srckeyPass != null) {
                throw new Exception(rb.getString("if.alias.not.specified.destalias.and.srckeypass.must.not.be.specified"));
            }
            this.doImportKeyStoreAll(keyStore);
        }
        if (this.inplaceImport) {
            int n = 1;
            while (true) {
                this.inplaceBackupName = this.srcksfname + ".old" + (n == 1 ? "" : Integer.valueOf(n));
                File file = new File(this.inplaceBackupName);
                if (!file.exists()) {
                    Files.copy(Paths.get(this.srcksfname, new String[0]), file.toPath(), new CopyOption[0]);
                    break;
                }
                ++n;
            }
        }
    }

    private int doImportKeyStoreSingle(KeyStore keyStore, String string) throws Exception {
        Object object;
        Object object2;
        String string2;
        String string3 = string2 = this.dest == null ? string : this.dest;
        if (this.keyStore.containsAlias(string2)) {
            object2 = new Object[]{string};
            if (this.noprompt) {
                System.err.println(new MessageFormat(rb.getString("Warning.Overwriting.existing.alias.alias.in.destination.keystore")).format(object2));
            } else {
                object = this.getYesNoReply(new MessageFormat(rb.getString("Existing.entry.alias.alias.exists.overwrite.no.")).format(object2));
                if ("NO".equals(object) && "".equals(string2 = this.inputStringFromStdin(rb.getString("Enter.new.alias.name.RETURN.to.cancel.import.for.this.entry.")))) {
                    System.err.println(new MessageFormat(rb.getString("Entry.for.alias.alias.not.imported.")).format(object2));
                    return 0;
                }
            }
        }
        object2 = this.recoverEntry(keyStore, string, this.srcstorePass, this.srckeyPass);
        object = (KeyStore.Entry)object2.fst;
        KeyStore.PasswordProtection passwordProtection = null;
        char[] cArray = null;
        if (this.destKeyPass != null) {
            cArray = this.destKeyPass;
            passwordProtection = new KeyStore.PasswordProtection(this.destKeyPass);
        } else if (object2.snd != null) {
            cArray = (char[])object2.snd;
            passwordProtection = new KeyStore.PasswordProtection((char[])object2.snd);
        }
        try {
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate != null) {
                this.checkWeak("<" + string2 + ">", certificate);
            }
            this.keyStore.setEntry(string2, (KeyStore.Entry)object, passwordProtection);
            if (P12KEYSTORE.equalsIgnoreCase(this.storetype) && cArray != null && !Arrays.equals(cArray, this.storePass)) {
                throw new Exception(rb.getString("The.destination.pkcs12.keystore.has.different.storepass.and.keypass.Please.retry.with.destkeypass.specified."));
            }
            return 1;
        }
        catch (KeyStoreException keyStoreException) {
            Object[] objectArray = new Object[]{string, keyStoreException.toString()};
            MessageFormat messageFormat = new MessageFormat(rb.getString("Problem.importing.entry.for.alias.alias.exception.Entry.for.alias.alias.not.imported."));
            System.err.println(messageFormat.format(objectArray));
            return 2;
        }
    }

    private void doImportKeyStoreAll(KeyStore keyStore) throws Exception {
        Object object;
        int n = 0;
        int n2 = keyStore.size();
        Object[] objectArray = keyStore.aliases();
        while (objectArray.hasMoreElements()) {
            Object object2;
            object = objectArray.nextElement();
            int n3 = this.doImportKeyStoreSingle(keyStore, (String)object);
            if (n3 == 1) {
                ++n;
                object2 = new Object[]{object};
                MessageFormat messageFormat = new MessageFormat(rb.getString("Entry.for.alias.alias.successfully.imported."));
                System.err.println(messageFormat.format(object2));
                continue;
            }
            if (n3 != 2 || this.noprompt || !"YES".equals(object2 = this.getYesNoReply("Do you want to quit the import process? [no]:  "))) continue;
            break;
        }
        objectArray = new Object[]{n, n2 - n};
        object = new MessageFormat(rb.getString("Import.command.completed.ok.entries.successfully.imported.fail.entries.failed.or.cancelled"));
        System.err.println(((Format)object).format(objectArray));
    }

    private void doPrintEntries(PrintStream printStream) throws Exception {
        Object object;
        String string = this.keyStore.getType();
        if ("JKS".equalsIgnoreCase(string) && this.ksfile != null && this.ksfile.exists() && !"JKS".equalsIgnoreCase((String)(object = this.keyStoreType(this.ksfile)))) {
            string = P12KEYSTORE;
        }
        printStream.println(rb.getString("Keystore.type.") + string);
        printStream.println(rb.getString("Keystore.provider.") + this.keyStore.getProvider().getName());
        printStream.println();
        object = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your.keystore.contains.keyStore.size.entry")) : new MessageFormat(rb.getString("Your.keystore.contains.keyStore.size.entries"));
        Object[] objectArray = new Object[]{new Integer(this.keyStore.size())};
        printStream.println(((Format)object).format(objectArray));
        printStream.println();
        ArrayList<String> arrayList = Collections.list(this.keyStore.aliases());
        arrayList.sort(String::compareTo);
        for (String string2 : arrayList) {
            this.doPrintEntry("<" + string2 + ">", string2, printStream);
            if (!this.verbose && !this.rfc) continue;
            printStream.println(rb.getString("NEWLINE"));
            printStream.println(rb.getString("STAR"));
            printStream.println(rb.getString("STARNN"));
        }
    }

    private static <T> Iterable<T> e2i(final Enumeration<T> enumeration) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends CRL> loadCRLs(String string) throws Exception {
        InputStream inputStream = null;
        URI uRI = null;
        if (string == null) {
            inputStream = System.in;
        } else {
            try {
                uRI = new URI(string);
                if (!uRI.getScheme().equals("ldap")) {
                    inputStream = uRI.toURL().openStream();
                }
            }
            catch (Exception exception) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (Exception exception2) {
                    if (uRI == null || uRI.getScheme() == null) {
                        throw exception2;
                    }
                    throw exception;
                }
            }
        }
        if (inputStream != null) {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                Collection<? extends CRL> collection = CertificateFactory.getInstance("X509").generateCRLs(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                return collection;
            }
            finally {
                if (inputStream != System.in) {
                    inputStream.close();
                }
            }
        }
        CertStoreHelper certStoreHelper = CertStoreHelper.getInstance("LDAP");
        String string2 = uRI.getPath();
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        CertStore certStore = certStoreHelper.getCertStore(uRI);
        X509CRLSelector x509CRLSelector = certStoreHelper.wrap(new X509CRLSelector(), null, string2);
        return certStore.getCRLs(x509CRLSelector);
    }

    public static List<CRL> readCRLsFromCert(X509Certificate x509Certificate) throws Exception {
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        CRLDistributionPointsExtension cRLDistributionPointsExtension = X509CertImpl.toImpl(x509Certificate).getCRLDistributionPointsExtension();
        if (cRLDistributionPointsExtension == null) {
            return arrayList;
        }
        Object object = cRLDistributionPointsExtension.get("points");
        Iterator iterator = object.iterator();
        block0: while (iterator.hasNext()) {
            DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
            GeneralNames generalNames = distributionPoint.getFullName();
            if (generalNames == null) continue;
            for (GeneralName generalName : generalNames.names()) {
                if (generalName.getType() != 6) continue;
                URIName uRIName = (URIName)generalName.getName();
                for (CRL cRL : Main.loadCRLs(uRIName.getName())) {
                    if (!(cRL instanceof X509CRL)) continue;
                    arrayList.add((X509CRL)cRL);
                }
                continue block0;
            }
        }
        return arrayList;
    }

    private static String verifyCRL(KeyStore keyStore, CRL cRL) throws Exception {
        X509CRLImpl x509CRLImpl = (X509CRLImpl)cRL;
        X500Principal x500Principal = x509CRLImpl.getIssuerX500Principal();
        for (String string : Main.e2i(keyStore.aliases())) {
            X509Certificate x509Certificate;
            Certificate certificate = keyStore.getCertificate(string);
            if (!(certificate instanceof X509Certificate) || !(x509Certificate = (X509Certificate)certificate).getSubjectX500Principal().equals(x500Principal)) continue;
            try {
                ((X509CRLImpl)cRL).verify(certificate.getPublicKey());
                return string;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private void doPrintCRL(String string, PrintStream printStream) throws Exception {
        for (CRL cRL : Main.loadCRLs(string)) {
            this.printCRL(cRL, printStream);
            String string2 = null;
            Certificate certificate = null;
            if (this.caks != null && (string2 = Main.verifyCRL(this.caks, cRL)) != null) {
                certificate = this.caks.getCertificate(string2);
                printStream.printf(rb.getString("verified.by.s.in.s.weak"), string2, "cacerts", this.withWeak(certificate.getPublicKey()));
                printStream.println();
            }
            if (string2 == null && this.keyStore != null && (string2 = Main.verifyCRL(this.keyStore, cRL)) != null) {
                certificate = this.keyStore.getCertificate(string2);
                printStream.printf(rb.getString("verified.by.s.in.s.weak"), string2, "keystore", this.withWeak(certificate.getPublicKey()));
                printStream.println();
            }
            if (string2 == null) {
                printStream.println(rb.getString("STAR"));
                printStream.println(rb.getString("warning.not.verified.make.sure.keystore.is.correct"));
                printStream.println(rb.getString("STARNN"));
            }
            this.checkWeak(rb.getString("the.crl"), cRL, (Key)(certificate == null ? null : certificate.getPublicKey()));
        }
    }

    private void printCRL(CRL cRL, PrintStream printStream) throws Exception {
        X509CRL x509CRL = (X509CRL)cRL;
        if (this.rfc) {
            printStream.println("-----BEGIN X509 CRL-----");
            printStream.println(Base64.getMimeEncoder(64, CRLF).encodeToString(x509CRL.getEncoded()));
            printStream.println("-----END X509 CRL-----");
        } else {
            String string;
            if (cRL instanceof X509CRLImpl) {
                X509CRLImpl x509CRLImpl = (X509CRLImpl)cRL;
                string = x509CRLImpl.toStringWithAlgName(this.withWeak("" + x509CRLImpl.getSigAlgId()));
            } else {
                string = cRL.toString();
            }
            printStream.println(string);
        }
    }

    private void doPrintCertReq(InputStream inputStream, PrintStream printStream) throws Exception {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while ((object = bufferedReader.readLine()) != null) {
            if (!bl) {
                if (!((String)object).startsWith("-----")) continue;
                bl = true;
                continue;
            }
            if (((String)object).startsWith("-----")) break;
            stringBuffer.append((String)object);
        }
        object = new PKCS10(Pem.decode(new String(stringBuffer)));
        PublicKey publicKey = ((PKCS10)object).getSubjectPublicKeyInfo();
        printStream.printf(rb.getString("PKCS.10.with.weak"), ((PKCS10)object).getSubjectName(), publicKey.getFormat(), this.withWeak(publicKey), this.withWeak(((PKCS10)object).getSigAlg()));
        for (PKCS10Attribute pKCS10Attribute : ((PKCS10)object).getAttributes().getAttributes()) {
            Object object2;
            ObjectIdentifier objectIdentifier = pKCS10Attribute.getAttributeId();
            if (objectIdentifier.equals((Object)PKCS9Attribute.EXTENSION_REQUEST_OID)) {
                object2 = (CertificateExtensions)pKCS10Attribute.getAttributeValue();
                if (object2 == null) continue;
                Main.printExtensions(rb.getString("Extension.Request."), (CertificateExtensions)object2, printStream);
                continue;
            }
            printStream.println("Attribute: " + pKCS10Attribute.getAttributeId());
            object2 = new PKCS9Attribute(pKCS10Attribute.getAttributeId(), pKCS10Attribute.getAttributeValue());
            printStream.print(((PKCS9Attribute)object2).getName() + ": ");
            Object object3 = pKCS10Attribute.getAttributeValue();
            printStream.println(object3 instanceof String[] ? Arrays.toString((String[])object3) : object3);
        }
        if (this.debug) {
            printStream.println(object);
        }
        this.checkWeak(rb.getString("the.certificate.request"), (PKCS10)object);
    }

    private void printCertFromStream(InputStream inputStream, PrintStream printStream) throws Exception {
        Collection<? extends Certificate> collection = null;
        try {
            collection = this.cf.generateCertificates(inputStream);
        }
        catch (CertificateException certificateException) {
            throw new Exception(rb.getString("Failed.to.parse.input"), certificateException);
        }
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Empty.input"));
        }
        Certificate[] certificateArray = collection.toArray(new Certificate[collection.size()]);
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = (X509Certificate)certificateArray[i];
            }
            catch (ClassCastException classCastException) {
                throw new Exception(rb.getString("Not.X.509.certificate"));
            }
            if (certificateArray.length > 1) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate.i.1."));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                printStream.println(messageFormat.format(objectArray));
            }
            if (this.rfc) {
                this.dumpCert(x509Certificate, printStream);
            } else {
                this.printX509Cert(x509Certificate, printStream);
            }
            if (i < certificateArray.length - 1) {
                printStream.println();
            }
            this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), i, certificateArray.length), x509Certificate);
        }
    }

    private static String oneInMany(String string, int n, int n2) {
        if (n2 == 1) {
            return string;
        }
        return String.format(rb.getString("one.in.many"), string, n + 1, n2);
    }

    private void doPrintCert(PrintStream printStream) throws Exception {
        if (this.jarfile != null) {
            JarFile jarFile = new JarFile(this.jarfile, true);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            HashSet<CodeSigner> hashSet = new HashSet<CodeSigner>();
            byte[] byArray = new byte[8192];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                CodeSigner[] codeSignerArray = null;
                try (CodeSigner[] codeSignerArray2 = jarFile.getInputStream(jarEntry);){
                    while (codeSignerArray2.read(byArray) != -1) {
                    }
                }
                catch (Throwable object) {
                    codeSignerArray = object;
                    throw object;
                }
                codeSignerArray2 = jarEntry.getCodeSigners();
                if (codeSignerArray2 == null) continue;
                for (CodeSigner codeSigner : codeSignerArray2) {
                    Certificate certificate;
                    if (hashSet.contains(codeSigner)) continue;
                    hashSet.add(codeSigner);
                    printStream.printf(rb.getString("Signer.d."), ++n);
                    printStream.println();
                    printStream.println();
                    printStream.println(rb.getString("Signature."));
                    printStream.println();
                    List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
                    int n2 = 0;
                    for (Certificate certificate2 : list) {
                        certificate = (X509Certificate)certificate2;
                        if (this.rfc) {
                            printStream.println(rb.getString("Certificate.owner.") + ((X509Certificate)certificate).getSubjectDN() + "\n");
                            this.dumpCert(certificate, printStream);
                        } else {
                            this.printX509Cert((X509Certificate)certificate, printStream);
                        }
                        printStream.println();
                        this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), n2++, list.size()), certificate);
                    }
                    Timestamp timestamp = codeSigner.getTimestamp();
                    if (timestamp == null) continue;
                    printStream.println(rb.getString("Timestamp."));
                    printStream.println();
                    list = timestamp.getSignerCertPath().getCertificates();
                    n2 = 0;
                    Iterator<? extends Certificate> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Certificate certificate3 = certificate = iterator.next();
                        if (this.rfc) {
                            printStream.println(rb.getString("Certificate.owner.") + ((X509Certificate)certificate3).getSubjectDN() + "\n");
                            this.dumpCert(certificate3, printStream);
                        } else {
                            this.printX509Cert((X509Certificate)certificate3, printStream);
                        }
                        printStream.println();
                        this.checkWeak(Main.oneInMany(rb.getString("the.tsa.certificate"), n2++, list.size()), certificate3);
                    }
                }
            }
            jarFile.close();
            if (hashSet.isEmpty()) {
                printStream.println(rb.getString("Not.a.signed.jar.file"));
            }
        } else if (this.sslserver != null) {
            Collection<? extends Certificate> collection;
            CertStoreHelper certStoreHelper = CertStoreHelper.getInstance("SSLServer");
            CertStore certStore = certStoreHelper.getCertStore(new URI("https://" + this.sslserver));
            try {
                collection = certStore.getCertificates(null);
                if (collection.isEmpty()) {
                    throw new Exception(rb.getString("No.certificate.from.the.SSL.server"));
                }
            }
            catch (CertStoreException certStoreException) {
                if (certStoreException.getCause() instanceof IOException) {
                    throw new Exception(rb.getString("No.certificate.from.the.SSL.server"), certStoreException.getCause());
                }
                throw certStoreException;
            }
            int n = 0;
            for (Certificate certificate : collection) {
                try {
                    if (this.rfc) {
                        this.dumpCert(certificate, printStream);
                    } else {
                        printStream.println("Certificate #" + n);
                        printStream.println("====================================");
                        this.printX509Cert((X509Certificate)certificate, printStream);
                        printStream.println();
                    }
                    this.checkWeak(Main.oneInMany(rb.getString("the.certificate"), n++, collection.size()), certificate);
                }
                catch (Exception exception) {
                    if (!this.debug) continue;
                    exception.printStackTrace();
                }
            }
        } else if (this.filename != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.filename);){
                this.printCertFromStream(fileInputStream, printStream);
            }
        } else {
            this.printCertFromStream(System.in, printStream);
        }
    }

    private void doSelfCert(String string, String string2, String string3) throws Exception {
        X500Name x500Name;
        Certificate certificate;
        if (string == null) {
            string = keyAlias;
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if (string3 == null) {
            string3 = Main.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias.has.no.public.key"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (!(certificate instanceof X509Certificate)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias.has.no.X.509.certificate"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        Date date = Main.getStartDate(this.startDate);
        Date date2 = new Date();
        date2.setTime(date.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        if (string2 == null) {
            x500Name = (X500Name)x509CertInfo.get("subject.dname");
        } else {
            x500Name = new X500Name(string2);
            x509CertInfo.set("subject.dname", x500Name);
        }
        x509CertInfo.set("issuer.dname", x500Name);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo);
        PSSParameterSpec pSSParameterSpec = AlgorithmId.getDefaultAlgorithmParameterSpec(string3, privateKey);
        x509CertImpl2.sign(privateKey, pSSParameterSpec, string3, null);
        AlgorithmId algorithmId = (AlgorithmId)x509CertImpl2.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        x509CertInfo.set("version", new CertificateVersion(2));
        CertificateExtensions certificateExtensions = this.createV3Extensions(null, (CertificateExtensions)x509CertInfo.get("extensions"), this.v3ext, certificate.getPublicKey(), null);
        x509CertInfo.set("extensions", certificateExtensions);
        x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, pSSParameterSpec, string3, null);
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{x509CertImpl2});
        if (this.verbose) {
            System.err.println(rb.getString("New.certificate.self.signed."));
            System.err.print(x509CertImpl2.toString());
            System.err.println();
        }
    }

    private boolean installReply(String string, InputStream inputStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = keyAlias;
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias.has.no.public.key.certificate."));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Collection<? extends Certificate> collection = this.cf.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Reply.has.no.certificates"));
        }
        Certificate[] certificateArray = collection.toArray(new Certificate[collection.size()]);
        Certificate[] certificateArray2 = certificateArray.length == 1 ? this.establishCertChain(certificate, certificateArray[0]) : this.validateReply(string, certificate, certificateArray);
        if (certificateArray2 != null) {
            this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, certificateArray2);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String string, InputStream inputStream) throws Exception {
        Object object;
        if (string == null) {
            throw new Exception(rb.getString("Must.specify.alias"));
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate.not.imported.alias.alias.already.exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.cf.generateCertificate(inputStream);
        }
        catch (ClassCastException | CertificateException exception) {
            throw new Exception(rb.getString("Input.not.an.X.509.certificate"));
        }
        if (this.noprompt) {
            this.checkWeak(rb.getString("the.input"), x509Certificate);
            this.keyStore.setCertificateEntry(string, x509Certificate);
            return true;
        }
        boolean bl = false;
        if (KeyStoreUtil.isSelfSigned(x509Certificate)) {
            x509Certificate.verify(x509Certificate.getPublicKey());
            bl = true;
        }
        String string2 = null;
        String string3 = this.keyStore.getCertificateAlias(x509Certificate);
        if (string3 != null) {
            object = new MessageFormat(rb.getString("Certificate.already.exists.in.keystore.under.alias.trustalias."));
            Object[] objectArray = new Object[]{string3};
            System.err.println(((Format)object).format(objectArray));
            this.checkWeak(rb.getString("the.input"), x509Certificate);
            this.printWeakWarnings(true);
            string2 = this.getYesNoReply(rb.getString("Do.you.still.want.to.add.it.no."));
        } else if (bl) {
            if (this.trustcacerts && this.caks != null && (string3 = this.caks.getCertificateAlias(x509Certificate)) != null) {
                object = new MessageFormat(rb.getString("Certificate.already.exists.in.system.wide.CA.keystore.under.alias.trustalias."));
                Object[] objectArray = new Object[]{string3};
                System.err.println(((Format)object).format(objectArray));
                this.checkWeak(rb.getString("the.input"), x509Certificate);
                this.printWeakWarnings(true);
                string2 = this.getYesNoReply(rb.getString("Do.you.still.want.to.add.it.to.your.own.keystore.no."));
            }
            if (string3 == null) {
                this.printX509Cert(x509Certificate, System.out);
                this.checkWeak(rb.getString("the.input"), x509Certificate);
                this.printWeakWarnings(true);
                string2 = this.getYesNoReply(rb.getString("Trust.this.certificate.no."));
            }
        }
        if (string2 != null) {
            if ("YES".equals(string2)) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        try {
            object = this.establishCertChain(null, x509Certificate);
            if (object != null) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
        }
        catch (Exception exception) {
            this.printX509Cert(x509Certificate, System.out);
            this.checkWeak(rb.getString("the.input"), x509Certificate);
            this.printWeakWarnings(true);
            string2 = this.getYesNoReply(rb.getString("Trust.this.certificate.no."));
            if ("YES".equals(string2)) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String string, char[] cArray) throws Exception {
        char[] cArray2 = null;
        char[] cArray3 = null;
        for (int i = 0; i < 3; ++i) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("New.prompt."));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
            cArray2 = Password.readPassword(System.in);
            this.passwords.add(cArray2);
            if (cArray2 == null || cArray2.length < 6) {
                System.err.println(rb.getString("Password.is.too.short.must.be.at.least.6.characters"));
            } else if (Arrays.equals(cArray2, cArray)) {
                System.err.println(rb.getString("Passwords.must.differ"));
            } else {
                messageFormat = new MessageFormat(rb.getString("Re.enter.new.prompt."));
                Object[] objectArray2 = new Object[]{string};
                System.err.print(messageFormat.format(objectArray2));
                cArray3 = Password.readPassword(System.in);
                this.passwords.add(cArray3);
                if (!Arrays.equals(cArray2, cArray3)) {
                    System.err.println(rb.getString("They.don.t.match.Try.again"));
                } else {
                    Arrays.fill(cArray3, ' ');
                    return cArray2;
                }
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, ' ');
                cArray2 = null;
            }
            if (cArray3 == null) continue;
            Arrays.fill(cArray3, ' ');
            cArray3 = null;
        }
        throw new Exception(rb.getString("Too.many.failures.try.later"));
    }

    private String getAlias(String string) throws Exception {
        if (string != null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Enter.prompt.alias.name."));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
        } else {
            System.err.print(rb.getString("Enter.alias.name."));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private String inputStringFromStdin(String string) throws Exception {
        System.err.print(string);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String string, String string2, char[] cArray) throws Exception {
        int n = 0;
        char[] cArray2 = null;
        do {
            Object[] objectArray;
            MessageFormat messageFormat;
            if (cArray != null) {
                messageFormat = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                objectArray = new Object[]{string};
                System.err.println(messageFormat.format(objectArray));
                messageFormat = new MessageFormat(rb.getString(".RETURN.if.same.as.for.otherAlias."));
                Object[] objectArray2 = new Object[]{string2};
                System.err.print(messageFormat.format(objectArray2));
            } else {
                messageFormat = new MessageFormat(rb.getString("Enter.key.password.for.alias."));
                objectArray = new Object[]{string};
                System.err.print(messageFormat.format(objectArray));
            }
            System.err.flush();
            cArray2 = Password.readPassword(System.in);
            this.passwords.add(cArray2);
            if (cArray2 != null) continue;
            cArray2 = cArray;
        } while (cArray2 == null && ++n < 3);
        if (cArray2 == null) {
            throw new Exception(rb.getString("Too.many.failures.try.later"));
        }
        return cArray2;
    }

    private String withWeak(String string) {
        if (DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, string, null)) {
            return string;
        }
        return String.format(rb.getString("with.weak"), string);
    }

    private String withWeak(PublicKey publicKey) {
        if (DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, publicKey)) {
            return String.format(rb.getString("key.bit"), KeyUtil.getKeySize(publicKey), publicKey.getAlgorithm());
        }
        return String.format(rb.getString("key.bit.weak"), KeyUtil.getKeySize(publicKey), publicKey.getAlgorithm());
    }

    private void printX509Cert(X509Certificate x509Certificate, PrintStream printStream) throws Exception {
        X509CertImpl x509CertImpl;
        X509CertInfo x509CertInfo;
        CertificateExtensions certificateExtensions;
        MessageFormat messageFormat = new MessageFormat(rb.getString(".PATTERN.printX509Cert.with.weak"));
        PublicKey publicKey = x509Certificate.getPublicKey();
        String string = x509Certificate.getSigAlgName();
        if (!this.isTrustedCert(x509Certificate)) {
            string = this.withWeak(string);
        }
        Object[] objectArray = new Object[]{x509Certificate.getSubjectDN().toString(), x509Certificate.getIssuerDN().toString(), x509Certificate.getSerialNumber().toString(16), x509Certificate.getNotBefore().toString(), x509Certificate.getNotAfter().toString(), this.getCertFingerPrint("MD5", x509Certificate), this.getCertFingerPrint("SHA1", x509Certificate), this.getCertFingerPrint("SHA-256", x509Certificate), string, this.withWeak(publicKey), x509Certificate.getVersion()};
        printStream.println(messageFormat.format(objectArray));
        if (x509Certificate instanceof X509CertImpl && (certificateExtensions = (CertificateExtensions)(x509CertInfo = (X509CertInfo)(x509CertImpl = (X509CertImpl)x509Certificate).get("x509.info")).get("extensions")) != null) {
            Main.printExtensions(rb.getString("Extensions."), certificateExtensions, printStream);
        }
    }

    private static void printExtensions(String string, CertificateExtensions certificateExtensions, PrintStream printStream) throws Exception {
        int n = 0;
        Iterator<Extension> iterator = certificateExtensions.getAllExtensions().iterator();
        Iterator<Extension> iterator2 = certificateExtensions.getUnparseableExtensions().values().iterator();
        while (iterator.hasNext() || iterator2.hasNext()) {
            Extension extension;
            Extension extension2 = extension = iterator.hasNext() ? iterator.next() : iterator2.next();
            if (n == 0) {
                printStream.println();
                printStream.println(string);
                printStream.println();
            }
            printStream.print("#" + ++n + ": " + extension);
            if (extension.getClass() == Extension.class) {
                byte[] byArray = extension.getExtensionValue();
                if (byArray.length == 0) {
                    printStream.println(rb.getString(".Empty.value."));
                } else {
                    new HexDumpEncoder().encodeBuffer(extension.getExtensionValue(), (OutputStream)printStream);
                    printStream.println();
                }
            }
            printStream.println();
        }
    }

    private static Pair<String, Certificate> getSigner(Certificate certificate, KeyStore keyStore) throws Exception {
        if (keyStore.getCertificateAlias(certificate) != null) {
            return new Pair<String, Certificate>("", certificate);
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = keyStore.getCertificate(string);
            if (certificate2 == null) continue;
            try {
                certificate.verify(certificate2.getPublicKey());
                return new Pair<String, Certificate>(string, certificate2);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name x500Name;
        Object[] objectArray;
        MessageFormat messageFormat;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "Unknown";
        String string2 = "Unknown";
        String string3 = "Unknown";
        String string4 = "Unknown";
        String string5 = "Unknown";
        String string6 = "Unknown";
        String string7 = null;
        int n = 20;
        do {
            if (n-- < 0) {
                throw new RuntimeException(rb.getString("Too.many.retries.program.terminated"));
            }
            string = this.inputString(bufferedReader, rb.getString("What.is.your.first.and.last.name."), string);
            string2 = this.inputString(bufferedReader, rb.getString("What.is.the.name.of.your.organizational.unit."), string2);
            string3 = this.inputString(bufferedReader, rb.getString("What.is.the.name.of.your.organization."), string3);
            string4 = this.inputString(bufferedReader, rb.getString("What.is.the.name.of.your.City.or.Locality."), string4);
            string5 = this.inputString(bufferedReader, rb.getString("What.is.the.name.of.your.State.or.Province."), string5);
            string6 = this.inputString(bufferedReader, rb.getString("What.is.the.two.letter.country.code.for.this.unit."), string6);
            x500Name = new X500Name(string, string2, string3, string4, string5, string6);
        } while (collator.compare(string7 = this.inputString(bufferedReader, (messageFormat = new MessageFormat(rb.getString("Is.name.correct."))).format(objectArray = new Object[]{x500Name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(string7, rb.getString("y")) != 0);
        System.err.println();
        return x500Name;
    }

    private String inputString(BufferedReader bufferedReader, String string, String string2) throws IOException {
        System.err.println(string);
        MessageFormat messageFormat = new MessageFormat(rb.getString(".defaultValue."));
        Object[] objectArray = new Object[]{string2};
        System.err.print(messageFormat.format(objectArray));
        System.err.flush();
        String string3 = bufferedReader.readLine();
        if (string3 == null || collator.compare(string3, "") == 0) {
            string3 = string2;
        }
        return string3;
    }

    private void dumpCert(Certificate certificate, PrintStream printStream) throws IOException, CertificateException {
        if (this.rfc) {
            printStream.println("-----BEGIN CERTIFICATE-----");
            printStream.println(Base64.getMimeEncoder(64, CRLF).encodeToString(certificate.getEncoded()));
            printStream.println("-----END CERTIFICATE-----");
        } else {
            printStream.write(certificate.getEncoded());
        }
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private Pair<Key, char[]> recoverKey(String string, char[] cArray, char[] cArray2) throws Exception {
        Key key = null;
        if (KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            key = this.keyStore.getKey(string, null);
            return Pair.of(key, null);
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (!this.keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(string, KeyStore.SecretKeyEntry.class)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.has.no.key"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (cArray2 == null) {
            try {
                key = this.keyStore.getKey(string, cArray);
                cArray2 = cArray;
                this.passwords.add(cArray2);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                if (!this.token) {
                    cArray2 = this.getKeyPasswd(string, null, null);
                    key = this.keyStore.getKey(string, cArray2);
                }
                throw unrecoverableKeyException;
            }
        } else {
            key = this.keyStore.getKey(string, cArray2);
        }
        return Pair.of(key, cArray2);
    }

    private Pair<KeyStore.Entry, char[]> recoverEntry(KeyStore keyStore, String string, char[] cArray, char[] cArray2) throws Exception {
        KeyStore.Entry entry;
        if (!keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias.alias.does.not.exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        KeyStore.PasswordProtection passwordProtection = null;
        try {
            entry = keyStore.getEntry(string, passwordProtection);
            cArray2 = null;
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            if (P11KEYSTORE.equalsIgnoreCase(keyStore.getType()) || KeyStoreUtil.isWindowsKeyStore(keyStore.getType())) {
                throw unrecoverableEntryException;
            }
            if (cArray2 != null) {
                passwordProtection = new KeyStore.PasswordProtection(cArray2);
                entry = keyStore.getEntry(string, passwordProtection);
            }
            try {
                passwordProtection = new KeyStore.PasswordProtection(cArray);
                entry = keyStore.getEntry(string, passwordProtection);
                cArray2 = cArray;
            }
            catch (UnrecoverableEntryException unrecoverableEntryException2) {
                if (P12KEYSTORE.equalsIgnoreCase(keyStore.getType())) {
                    throw unrecoverableEntryException2;
                }
                cArray2 = this.getKeyPasswd(string, null, null);
                passwordProtection = new KeyStore.PasswordProtection(cArray2);
                entry = keyStore.getEntry(string, passwordProtection);
            }
        }
        return Pair.of(entry, cArray2);
    }

    private String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.toHexString(byArray2);
    }

    private void printNoIntegrityWarning() {
        System.err.println();
        System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
        System.err.println(rb.getString(".The.integrity.of.the.information.stored.in.your.keystore."));
        System.err.println(rb.getString(".WARNING.WARNING.WARNING."));
        System.err.println();
    }

    private Certificate[] validateReply(String string, Certificate certificate, Certificate[] certificateArray) throws Exception {
        int n;
        this.checkWeak(rb.getString("reply"), certificateArray);
        PublicKey publicKey = certificate.getPublicKey();
        for (n = 0; n < certificateArray.length && !publicKey.equals(certificateArray[n].getPublicKey()); ++n) {
        }
        if (n == certificateArray.length) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate.reply.does.not.contain.public.key.for.alias."));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Certificate certificate2 = certificateArray[0];
        certificateArray[0] = certificateArray[n];
        certificateArray[n] = certificate2;
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        for (n = 1; n < certificateArray.length - 1; ++n) {
            int n2;
            for (n2 = n; n2 < certificateArray.length; ++n2) {
                if (!KeyStoreUtil.signedBy(x509Certificate, (X509Certificate)certificateArray[n2])) continue;
                certificate2 = certificateArray[n];
                certificateArray[n] = certificateArray[n2];
                certificateArray[n2] = certificate2;
                x509Certificate = (X509Certificate)certificateArray[n];
                break;
            }
            if (n2 != certificateArray.length) continue;
            throw new Exception(rb.getString("Incomplete.certificate.chain.in.reply"));
        }
        if (this.noprompt) {
            return certificateArray;
        }
        Certificate certificate3 = certificateArray[certificateArray.length - 1];
        boolean bl = true;
        Pair<String, Certificate> pair = Main.getSigner(certificate3, this.keyStore);
        if (pair == null && this.trustcacerts && this.caks != null) {
            pair = Main.getSigner(certificate3, this.caks);
            bl = false;
        }
        if (pair == null) {
            System.err.println();
            System.err.println(rb.getString("Top.level.certificate.in.reply."));
            this.printX509Cert((X509Certificate)certificate3, System.out);
            System.err.println();
            System.err.print(rb.getString(".is.not.trusted."));
            this.printWeakWarnings(true);
            String string2 = this.getYesNoReply(rb.getString("Install.reply.anyway.no."));
            if ("NO".equals(string2)) {
                return null;
            }
        } else if (pair.snd != certificate3) {
            Certificate[] certificateArray2 = new Certificate[certificateArray.length + 1];
            System.arraycopy(certificateArray, 0, certificateArray2, 0, certificateArray.length);
            certificateArray2[certificateArray2.length - 1] = (Certificate)pair.snd;
            certificateArray = certificateArray2;
            this.checkWeak(String.format(rb.getString(bl ? "alias.in.keystore" : "alias.in.cacerts"), pair.fst), (Certificate)pair.snd);
        }
        return certificateArray;
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate2) throws Exception {
        Serializable serializable;
        Serializable serializable2;
        if (certificate != null) {
            serializable2 = certificate.getPublicKey();
            if (!serializable2.equals(serializable = certificate2.getPublicKey())) {
                throw new Exception(rb.getString("Public.keys.in.reply.and.keystore.don.t.match"));
            }
            if (certificate2.equals(certificate)) {
                throw new Exception(rb.getString("Certificate.reply.and.certificate.in.keystore.are.identical"));
            }
        }
        serializable2 = null;
        if (this.keyStore.size() > 0) {
            serializable2 = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, (Hashtable<Principal, Vector<Pair<String, X509Certificate>>>)serializable2);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (serializable2 == null) {
                serializable2 = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, (Hashtable<Principal, Vector<Pair<String, X509Certificate>>>)serializable2);
        }
        serializable = new Vector(2);
        if (this.buildChain(new Pair<String, X509Certificate>(rb.getString("the.input"), (X509Certificate)certificate2), (Vector<Pair<String, X509Certificate>>)serializable, (Hashtable<Principal, Vector<Pair<String, X509Certificate>>>)serializable2)) {
            Certificate[] certificateArray = ((Vector)serializable).iterator();
            while (certificateArray.hasNext()) {
                Pair pair = (Pair)certificateArray.next();
                this.checkWeak((String)pair.fst, (Certificate)pair.snd);
            }
            certificateArray = new Certificate[((Vector)serializable).size()];
            int n = 0;
            for (int i = ((Vector)serializable).size() - 1; i >= 0; --i) {
                certificateArray[n] = (Certificate)((Pair)((Vector)serializable).elementAt((int)i)).snd;
                ++n;
            }
            return certificateArray;
        }
        throw new Exception(rb.getString("Failed.to.establish.chain.from.reply"));
    }

    private boolean buildChain(Pair<String, X509Certificate> pair, Vector<Pair<String, X509Certificate>> vector, Hashtable<Principal, Vector<Pair<String, X509Certificate>>> hashtable) {
        if (KeyStoreUtil.isSelfSigned((X509Certificate)pair.snd)) {
            vector.addElement(pair);
            return true;
        }
        Principal principal = ((X509Certificate)pair.snd).getIssuerDN();
        Vector<Pair<String, X509Certificate>> vector2 = hashtable.get(principal);
        if (vector2 == null) {
            return false;
        }
        Enumeration<Pair<String, X509Certificate>> enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Pair<String, X509Certificate> pair2 = enumeration.nextElement();
            PublicKey publicKey = ((X509Certificate)pair2.snd).getPublicKey();
            try {
                ((X509Certificate)pair.snd).verify(publicKey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(pair2, vector, hashtable)) continue;
            vector.addElement(pair);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String string) throws IOException {
        String string2 = null;
        int n = 20;
        do {
            if (n-- < 0) {
                throw new RuntimeException(rb.getString("Too.many.retries.program.terminated"));
            }
            System.err.print(string);
            System.err.flush();
            string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(string2, "") == 0 || collator.compare(string2, rb.getString("n")) == 0 || collator.compare(string2, rb.getString("no")) == 0) {
                string2 = "NO";
                continue;
            }
            if (collator.compare(string2, rb.getString("y")) == 0 || collator.compare(string2, rb.getString("yes")) == 0) {
                string2 = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong.answer.try.again"));
            string2 = null;
        } while (string2 == null);
        return string2;
    }

    private void keystorecerts2Hashtable(KeyStore keyStore, Hashtable<Principal, Vector<Pair<String, X509Certificate>>> hashtable) throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Pair<String, X509Certificate> pair = new Pair<String, X509Certificate>(String.format(rb.getString(keyStore == this.caks ? "alias.in.cacerts" : "alias.in.keystore"), string), (X509Certificate)certificate);
            Vector<Pair<String, X509Certificate>> vector = hashtable.get(principal);
            if (vector == null) {
                vector = new Vector();
                vector.addElement(pair);
            } else if (!vector.contains(pair)) {
                vector.addElement(pair);
            }
            hashtable.put(principal, vector);
        }
    }

    private static Date getStartDate(String string) throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (string != null) {
            IOException iOException = new IOException(rb.getString("Illegal.startdate.value"));
            int n = string.length();
            if (n == 0) {
                throw iOException;
            }
            if (string.charAt(0) == '-' || string.charAt(0) == '+') {
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4;
                    int n5 = 0;
                    switch (string.charAt(n2)) {
                        case '+': {
                            n5 = 1;
                            break;
                        }
                        case '-': {
                            n5 = -1;
                            break;
                        }
                        default: {
                            throw iOException;
                        }
                    }
                    for (n4 = n2 + 1; n4 < n && (n3 = string.charAt(n4)) >= 48 && n3 <= 57; ++n4) {
                    }
                    if (n4 == n2 + 1) {
                        throw iOException;
                    }
                    n3 = Integer.parseInt(string.substring(n2 + 1, n4));
                    if (n4 >= n) {
                        throw iOException;
                    }
                    int n6 = 0;
                    switch (string.charAt(n4)) {
                        case 'y': {
                            n6 = 1;
                            break;
                        }
                        case 'm': {
                            n6 = 2;
                            break;
                        }
                        case 'd': {
                            n6 = 5;
                            break;
                        }
                        case 'H': {
                            n6 = 10;
                            break;
                        }
                        case 'M': {
                            n6 = 12;
                            break;
                        }
                        case 'S': {
                            n6 = 13;
                            break;
                        }
                        default: {
                            throw iOException;
                        }
                    }
                    ((Calendar)gregorianCalendar).add(n6, n5 * n3);
                    n2 = n4 + 1;
                }
            } else {
                String string2 = null;
                String string3 = null;
                if (n == 19) {
                    string2 = string.substring(0, 10);
                    string3 = string.substring(11);
                    if (string.charAt(10) != ' ') {
                        throw iOException;
                    }
                } else if (n == 10) {
                    string2 = string;
                } else if (n == 8) {
                    string3 = string;
                } else {
                    throw iOException;
                }
                if (string2 != null) {
                    if (string2.matches("\\d\\d\\d\\d\\/\\d\\d\\/\\d\\d")) {
                        gregorianCalendar.set(Integer.valueOf(string2.substring(0, 4)), Integer.valueOf(string2.substring(5, 7)) - 1, Integer.valueOf(string2.substring(8, 10)));
                    } else {
                        throw iOException;
                    }
                }
                if (string3 != null) {
                    if (string3.matches("\\d\\d:\\d\\d:\\d\\d")) {
                        gregorianCalendar.set(11, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(12, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(13, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(14, 0);
                    } else {
                        throw iOException;
                    }
                }
            }
        }
        return gregorianCalendar.getTime();
    }

    private static int oneOf(String string, String ... stringArray) throws Exception {
        int n;
        Object[] objectArray;
        Object object;
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (object == null) {
                n3 = i;
                continue;
            }
            if (((String)object).toLowerCase(Locale.ENGLISH).startsWith(string.toLowerCase(Locale.ENGLISH))) {
                nArray[n2++] = i;
                continue;
            }
            objectArray = new StringBuffer();
            n = 1;
            for (char c : ((String)object).toCharArray()) {
                if (n != 0) {
                    objectArray.append(c);
                    n = 0;
                    continue;
                }
                if (Character.isLowerCase(c)) continue;
                objectArray.append(c);
            }
            if (!objectArray.toString().equalsIgnoreCase(string)) continue;
            nArray[n2++] = i;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return nArray[0];
        }
        if (nArray[1] > n3) {
            return nArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = new MessageFormat(rb.getString("command.{0}.is.ambiguous."));
        objectArray = new Object[]{string};
        stringBuffer.append(((Format)object).format(objectArray));
        stringBuffer.append("\n    ");
        for (n = 0; n < n2 && nArray[n] < n3; ++n) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[nArray[n]]);
        }
        throw new Exception(stringBuffer.toString());
    }

    private GeneralName createGeneralName(String string, String string2) throws Exception {
        GeneralNameInterface generalNameInterface;
        int n = Main.oneOf(string, "EMAIL", "URI", "DNS", "IP", "OID");
        if (n < 0) {
            throw new Exception(rb.getString("Unrecognized.GeneralName.type.") + string);
        }
        switch (n) {
            case 0: {
                generalNameInterface = new RFC822Name(string2);
                break;
            }
            case 1: {
                generalNameInterface = new URIName(string2);
                break;
            }
            case 2: {
                generalNameInterface = new DNSName(string2);
                break;
            }
            case 3: {
                generalNameInterface = new IPAddressName(string2);
                break;
            }
            default: {
                generalNameInterface = new OIDName(string2);
            }
        }
        return new GeneralName(generalNameInterface);
    }

    private ObjectIdentifier findOidForExtName(String string) throws Exception {
        switch (Main.oneOf(string, extSupported)) {
            case 0: {
                return PKIXExtensions.BasicConstraints_Id;
            }
            case 1: {
                return PKIXExtensions.KeyUsage_Id;
            }
            case 2: {
                return PKIXExtensions.ExtendedKeyUsage_Id;
            }
            case 3: {
                return PKIXExtensions.SubjectAlternativeName_Id;
            }
            case 4: {
                return PKIXExtensions.IssuerAlternativeName_Id;
            }
            case 5: {
                return PKIXExtensions.SubjectInfoAccess_Id;
            }
            case 6: {
                return PKIXExtensions.AuthInfoAccess_Id;
            }
            case 8: {
                return PKIXExtensions.CRLDistributionPoints_Id;
            }
        }
        return new ObjectIdentifier(string);
    }

    private CertificateExtensions createV3Extensions(CertificateExtensions certificateExtensions, CertificateExtensions certificateExtensions2, List<String> list, PublicKey publicKey, PublicKey publicKey2) throws Exception {
        if (certificateExtensions2 != null && certificateExtensions != null) {
            throw new Exception("One of request and original should be null.");
        }
        if (certificateExtensions2 == null) {
            certificateExtensions2 = new CertificateExtensions();
        }
        try {
            int n;
            int n2;
            List<String> list2;
            if (certificateExtensions != null) {
                for (String string : list) {
                    if (!string.toLowerCase(Locale.ENGLISH).startsWith("honored=")) continue;
                    list2 = Arrays.asList(string.toLowerCase(Locale.ENGLISH).substring(8).split(","));
                    if (list2.contains("all")) {
                        certificateExtensions2 = certificateExtensions;
                    }
                    for (String string2 : list2) {
                        if (string2.equals("all")) continue;
                        n2 = 1;
                        n = -1;
                        String string3 = null;
                        if (string2.startsWith("-")) {
                            n2 = 0;
                            string3 = string2.substring(1);
                        } else {
                            int n3 = string2.indexOf(58);
                            if (n3 >= 0) {
                                string3 = string2.substring(0, n3);
                                n = Main.oneOf(string2.substring(n3 + 1), "critical", "non-critical");
                                if (n == -1) {
                                    throw new Exception(rb.getString("Illegal.value.") + string2);
                                }
                            }
                        }
                        String string4 = certificateExtensions.getNameByOid(this.findOidForExtName(string3));
                        if (n2 != 0) {
                            Extension extension = certificateExtensions.get(string4);
                            if ((extension.isCritical() || n != 0) && (!extension.isCritical() || n != 1)) continue;
                            extension = Extension.newExtension(extension.getExtensionId(), !extension.isCritical(), extension.getExtensionValue());
                            certificateExtensions2.set(string4, extension);
                            continue;
                        }
                        certificateExtensions2.delete(string4);
                    }
                }
            }
            for (String string : list) {
                Object object;
                boolean bl = false;
                n2 = string.indexOf(61);
                if (n2 >= 0) {
                    list2 = string.substring(0, n2);
                    object = string.substring(n2 + 1);
                } else {
                    list2 = string;
                    object = null;
                }
                n = ((String)((Object)list2)).indexOf(58);
                if (n >= 0) {
                    if (Main.oneOf(((String)((Object)list2)).substring(n + 1), "critical") == 0) {
                        bl = true;
                    }
                    list2 = ((String)((Object)list2)).substring(0, n);
                }
                if (((String)((Object)list2)).equalsIgnoreCase("honored")) continue;
                int n4 = Main.oneOf((String)((Object)list2), extSupported);
                switch (n4) {
                    case 0: {
                        int n5 = -1;
                        boolean bl2 = false;
                        if (object == null) {
                            bl2 = true;
                        } else {
                            try {
                                n5 = Integer.parseInt((String)object);
                                bl2 = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                for (String string5 : ((String)object).split(",")) {
                                    String[] stringArray = string5.split(":");
                                    if (stringArray.length != 2) {
                                        throw new Exception(rb.getString("Illegal.value.") + string);
                                    }
                                    if (stringArray[0].equalsIgnoreCase("ca")) {
                                        bl2 = Boolean.parseBoolean(stringArray[1]);
                                        continue;
                                    }
                                    if (stringArray[0].equalsIgnoreCase("pathlen")) {
                                        n5 = Integer.parseInt(stringArray[1]);
                                        continue;
                                    }
                                    throw new Exception(rb.getString("Illegal.value.") + string);
                                }
                            }
                        }
                        certificateExtensions2.set("BasicConstraints", new BasicConstraintsExtension(bl, bl2, n5));
                        break;
                    }
                    case 1: {
                        Object object2;
                        Object object3;
                        if (object != null) {
                            object3 = new boolean[9];
                            for (String string6 : ((String)object).split(",")) {
                                int n6 = Main.oneOf(string6, "digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly", "contentCommitment");
                                if (n6 < 0) {
                                    throw new Exception(rb.getString("Unknown.keyUsage.type.") + string6);
                                }
                                if (n6 == 9) {
                                    n6 = 1;
                                }
                                object3[n6] = true;
                            }
                            object2 = new KeyUsageExtension((boolean[])object3);
                            certificateExtensions2.set("KeyUsage", Extension.newExtension(((Extension)object2).getExtensionId(), bl, ((Extension)object2).getExtensionValue()));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + string);
                    }
                    case 2: {
                        Object object3;
                        if (object != null) {
                            object3 = new Vector();
                            for (String string7 : ((String)object).split(",")) {
                                int n7 = Main.oneOf(string7, "anyExtendedKeyUsage", "serverAuth", "clientAuth", "codeSigning", "emailProtection", "", "", "", "timeStamping", "OCSPSigning");
                                if (n7 < 0) {
                                    try {
                                        ((Vector)object3).add(new ObjectIdentifier(string7));
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        throw new Exception(rb.getString("Unknown.extendedkeyUsage.type.") + string7);
                                    }
                                }
                                if (n7 == 0) {
                                    ((Vector)object3).add(new ObjectIdentifier("2.5.29.37.0"));
                                    continue;
                                }
                                ((Vector)object3).add(new ObjectIdentifier("1.3.6.1.5.5.7.3." + n7));
                            }
                            certificateExtensions2.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension((Boolean)bl, (Vector<ObjectIdentifier>)object3));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + string);
                    }
                    case 3: 
                    case 4: {
                        String string8;
                        int n8;
                        Object object2;
                        Object object3;
                        if (object != null) {
                            object3 = ((String)object).split(",");
                            object2 = new GeneralNames();
                            Object object4 = object3;
                            int n9 = ((boolean[])object4).length;
                            for (n8 = 0; n8 < n9; ++n8) {
                                Object object5 = object4[n8];
                                n = ((String)object5).indexOf(58);
                                if (n < 0) {
                                    throw new Exception("Illegal item " + (String)object5 + " in " + string);
                                }
                                String string9 = ((String)object5).substring(0, n);
                                string8 = ((String)object5).substring(n + 1);
                                ((GeneralNames)object2).add(this.createGeneralName(string9, string8));
                            }
                            if (n4 == 3) {
                                certificateExtensions2.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)bl, (GeneralNames)object2));
                                break;
                            }
                            certificateExtensions2.set("IssuerAlternativeName", new IssuerAlternativeNameExtension((Boolean)bl, (GeneralNames)object2));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + string);
                    }
                    case 5: 
                    case 6: {
                        String string8;
                        int n8;
                        Object object2;
                        Object object3;
                        if (bl) {
                            throw new Exception(rb.getString("This.extension.cannot.be.marked.as.critical.") + string);
                        }
                        if (object != null) {
                            object3 = new ArrayList();
                            object2 = ((String)object).split(",");
                            Object object6 = object2;
                            int n10 = ((String[])object6).length;
                            for (n8 = 0; n8 < n10; ++n8) {
                                ObjectIdentifier objectIdentifier;
                                String string10 = object6[n8];
                                n = string10.indexOf(58);
                                int n11 = string10.indexOf(58, n + 1);
                                if (n < 0 || n11 < 0) {
                                    throw new Exception(rb.getString("Illegal.value.") + string);
                                }
                                string8 = string10.substring(0, n);
                                String string11 = string10.substring(n + 1, n11);
                                String string12 = string10.substring(n11 + 1);
                                int n12 = Main.oneOf(string8, "", "ocsp", "caIssuers", "timeStamping", "", "caRepository");
                                if (n12 < 0) {
                                    try {
                                        objectIdentifier = new ObjectIdentifier(string8);
                                    }
                                    catch (Exception exception) {
                                        throw new Exception(rb.getString("Unknown.AccessDescription.type.") + string8);
                                    }
                                } else {
                                    objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48." + n12);
                                }
                                object3.add(new AccessDescription(objectIdentifier, this.createGeneralName(string11, string12)));
                            }
                            if (n4 == 5) {
                                certificateExtensions2.set("SubjectInfoAccess", new SubjectInfoAccessExtension((List<AccessDescription>)object3));
                                break;
                            }
                            certificateExtensions2.set("AuthorityInfoAccess", new AuthorityInfoAccessExtension((List<AccessDescription>)object3));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + string);
                    }
                    case 8: {
                        String string8;
                        int n8;
                        Object object2;
                        Object object3;
                        if (object != null) {
                            object3 = ((String)object).split(",");
                            object2 = new GeneralNames();
                            Object object7 = object3;
                            int n13 = ((boolean[])object7).length;
                            for (n8 = 0; n8 < n13; ++n8) {
                                Object object8 = object7[n8];
                                n = ((String)object8).indexOf(58);
                                if (n < 0) {
                                    throw new Exception("Illegal item " + (String)object8 + " in " + string);
                                }
                                String string13 = ((String)object8).substring(0, n);
                                string8 = ((String)object8).substring(n + 1);
                                ((GeneralNames)object2).add(this.createGeneralName(string13, string8));
                            }
                            certificateExtensions2.set("CRLDistributionPoints", new CRLDistributionPointsExtension(bl, Collections.singletonList(new DistributionPoint((GeneralNames)object2, null, null))));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal.value.") + string);
                    }
                    case -1: {
                        int n8;
                        Object object3 = new ObjectIdentifier((String)((Object)list2));
                        Object object2 = null;
                        if (object != null) {
                            object2 = new byte[((String)object).length() / 2 + 1];
                            int n14 = 0;
                            char[] cArray = ((String)object).toCharArray();
                            n8 = cArray.length;
                            for (int i = 0; i < n8; ++i) {
                                int n15;
                                char c = cArray[i];
                                if (c >= '0' && c <= '9') {
                                    n15 = c - 48;
                                } else if (c >= 'A' && c <= 'F') {
                                    n15 = c - 65 + 10;
                                } else {
                                    if (c < 'a' || c > 'f') continue;
                                    n15 = c - 97 + 10;
                                }
                                if (n14 % 2 == 0) {
                                    object2[n14 / 2] = (byte)(n15 << 4);
                                } else {
                                    Object object9 = object2;
                                    int n16 = n14 / 2;
                                    object9[n16] = (byte)(object9[n16] + n15);
                                }
                                ++n14;
                            }
                            if (n14 % 2 != 0) {
                                throw new Exception(rb.getString("Odd.number.of.hex.digits.found.") + string);
                            }
                            object2 = Arrays.copyOf((byte[])object2, n14 / 2);
                        } else {
                            object2 = new byte[0];
                        }
                        certificateExtensions2.set(((ObjectIdentifier)object3).toString(), new Extension((ObjectIdentifier)object3, bl, new DerValue(4, (byte[])object2).toByteArray()));
                        break;
                    }
                    default: {
                        throw new Exception(rb.getString("Unknown.extension.type.") + string);
                    }
                }
            }
            certificateExtensions2.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
            if (publicKey2 != null && !publicKey.equals(publicKey2)) {
                certificateExtensions2.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(publicKey2), null, null));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return certificateExtensions2;
    }

    private boolean isTrustedCert(Certificate certificate) throws KeyStoreException {
        if (this.caks != null && this.caks.getCertificateAlias(certificate) != null) {
            return true;
        }
        String string = this.keyStore.getCertificateAlias(certificate);
        return string != null && this.keyStore.isCertificateEntry(string);
    }

    private void checkWeak(String string, String string2, Key key) {
        if (string2 != null && !DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, string2, null)) {
            this.weakWarnings.add(String.format(rb.getString("whose.sigalg.risk"), string, string2));
        }
        if (key != null && !DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, key)) {
            this.weakWarnings.add(String.format(rb.getString("whose.key.risk"), string, String.format(rb.getString("key.bit"), KeyUtil.getKeySize(key), key.getAlgorithm())));
        }
    }

    private void checkWeak(String string, Certificate[] certificateArray) throws KeyStoreException {
        for (int i = 0; i < certificateArray.length; ++i) {
            Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String string2 = string;
            if (certificateArray.length > 1) {
                string2 = Main.oneInMany(string, i, certificateArray.length);
            }
            this.checkWeak(string2, x509Certificate);
        }
    }

    private void checkWeak(String string, Certificate certificate) throws KeyStoreException {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String string2 = this.isTrustedCert(certificate) ? null : x509Certificate.getSigAlgName();
            this.checkWeak(string, string2, (Key)x509Certificate.getPublicKey());
        }
    }

    private void checkWeak(String string, PKCS10 pKCS10) {
        this.checkWeak(string, pKCS10.getSigAlg(), (Key)pKCS10.getSubjectPublicKeyInfo());
    }

    private void checkWeak(String string, CRL cRL, Key key) {
        if (cRL instanceof X509CRLImpl) {
            X509CRLImpl x509CRLImpl = (X509CRLImpl)cRL;
            this.checkWeak(string, x509CRLImpl.getSigAlgName(), key);
        }
    }

    private void printWeakWarnings(boolean bl) {
        if (!this.weakWarnings.isEmpty() && !this.nowarn) {
            System.err.println("\nWarning:");
            for (String string : this.weakWarnings) {
                System.err.println(string);
            }
            if (bl) {
                System.err.println();
            }
        }
        this.weakWarnings.clear();
    }

    private void usage() {
        if (this.command != null) {
            int n;
            System.err.println("keytool " + (Object)((Object)this.command) + rb.getString(".OPTION."));
            System.err.println();
            System.err.println(rb.getString(this.command.description));
            System.err.println();
            System.err.println(rb.getString("Options."));
            System.err.println();
            String[] stringArray = new String[this.command.options.length];
            String[] stringArray2 = new String[this.command.options.length];
            boolean bl = false;
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                Option option = this.command.options[n];
                stringArray[n] = option.toString();
                if (option.arg != null) {
                    int n3 = n;
                    stringArray[n3] = stringArray[n3] + " " + option.arg;
                }
                if (stringArray[n].length() > n2) {
                    n2 = stringArray[n].length();
                }
                stringArray2[n] = rb.getString(option.description);
            }
            for (n = 0; n < stringArray.length; ++n) {
                System.err.printf(" %-" + n2 + "s  %s\n", stringArray[n], stringArray2[n]);
            }
            System.err.println();
            System.err.println(rb.getString("Use.keytool.help.for.all.available.commands"));
        } else {
            System.err.println(rb.getString("Key.and.Certificate.Management.Tool"));
            System.err.println();
            System.err.println(rb.getString("Commands."));
            System.err.println();
            for (Command command : Command.values()) {
                if (command == Command.KEYCLONE) break;
                System.err.printf(" %-20s%s\n", new Object[]{command, rb.getString(command.description)});
            }
            System.err.println();
            System.err.println(rb.getString("Use.keytool.command.name.help.for.usage.of.command.name"));
        }
    }

    private void tinyHelp() {
        this.usage();
        if (this.debug) {
            throw new RuntimeException("NO BIG ERROR, SORRY");
        }
        System.exit(1);
    }

    private void errorNeedArgument(String string) {
        Object[] objectArray = new Object[]{string};
        System.err.println(new MessageFormat(rb.getString("Command.option.flag.needs.an.argument.")).format(objectArray));
        this.tinyHelp();
    }

    private char[] getPass(String string, String string2) {
        char[] cArray = KeyStoreUtil.getPassWithModifier(string, string2, rb);
        if (cArray != null) {
            return cArray;
        }
        this.tinyHelp();
        return null;
    }

    static {
        collator.setStrength(0);
        extSupported = new String[]{"BasicConstraints", "KeyUsage", "ExtendedKeyUsage", "SubjectAlternativeName", "IssuerAlternativeName", "SubjectInfoAccess", "AuthorityInfoAccess", null, "CRLDistributionPoints"};
    }

    static enum Option {
        ALIAS("alias", "<alias>", "alias.name.of.the.entry.to.process"),
        DESTALIAS("destalias", "<destalias>", "destination.alias"),
        DESTKEYPASS("destkeypass", "<arg>", "destination.key.password"),
        DESTKEYSTORE("destkeystore", "<destkeystore>", "destination.keystore.name"),
        DESTPROTECTED("destprotected", null, "destination.keystore.password.protected"),
        DESTPROVIDERNAME("destprovidername", "<destprovidername>", "destination.keystore.provider.name"),
        DESTSTOREPASS("deststorepass", "<arg>", "destination.keystore.password"),
        DESTSTORETYPE("deststoretype", "<deststoretype>", "destination.keystore.type"),
        DNAME("dname", "<dname>", "distinguished.name"),
        EXT("ext", "<value>", "X.509.extension"),
        FILEOUT("file", "<filename>", "output.file.name"),
        FILEIN("file", "<filename>", "input.file.name"),
        ID("id", "<id:reason>", "Serial.ID.of.cert.to.revoke"),
        INFILE("infile", "<filename>", "input.file.name"),
        KEYALG("keyalg", "<keyalg>", "key.algorithm.name"),
        KEYPASS("keypass", "<arg>", "key.password"),
        KEYSIZE("keysize", "<keysize>", "key.bit.size"),
        KEYSTORE("keystore", "<keystore>", "keystore.name"),
        NEW("new", "<arg>", "new.password"),
        NOPROMPT("noprompt", null, "do.not.prompt"),
        OUTFILE("outfile", "<filename>", "output.file.name"),
        PROTECTED("protected", null, "password.through.protected.mechanism"),
        PROVIDERARG("providerarg", "<arg>", "provider.argument"),
        PROVIDERCLASS("providerclass", "<providerclass>", "provider.class.name"),
        PROVIDERNAME("providername", "<providername>", "provider.name"),
        PROVIDERPATH("providerpath", "<pathlist>", "provider.classpath"),
        RFC("rfc", null, "output.in.RFC.style"),
        SIGALG("sigalg", "<sigalg>", "signature.algorithm.name"),
        SRCALIAS("srcalias", "<srcalias>", "source.alias"),
        SRCKEYPASS("srckeypass", "<arg>", "source.key.password"),
        SRCKEYSTORE("srckeystore", "<srckeystore>", "source.keystore.name"),
        SRCPROTECTED("srcprotected", null, "source.keystore.password.protected"),
        SRCPROVIDERNAME("srcprovidername", "<srcprovidername>", "source.keystore.provider.name"),
        SRCSTOREPASS("srcstorepass", "<arg>", "source.keystore.password"),
        SRCSTORETYPE("srcstoretype", "<srcstoretype>", "source.keystore.type"),
        SSLSERVER("sslserver", "<server[:port]>", "SSL.server.host.and.port"),
        JARFILE("jarfile", "<filename>", "signed.jar.file"),
        STARTDATE("startdate", "<startdate>", "certificate.validity.start.date.time"),
        STOREPASS("storepass", "<arg>", "keystore.password"),
        STORETYPE("storetype", "<storetype>", "keystore.type"),
        TRUSTCACERTS("trustcacerts", null, "trust.certificates.from.cacerts"),
        V("v", null, "verbose.output"),
        VALIDITY("validity", "<valDays>", "validity.number.of.days");

        final String name;
        final String arg;
        final String description;

        private Option(String string2, String string3, String string4) {
            this.name = string2;
            this.arg = string3;
            this.description = string4;
        }

        public String toString() {
            return "-" + this.name;
        }
    }

    static enum Command {
        CERTREQ("Generates.a.certificate.request", Option.ALIAS, Option.SIGALG, Option.FILEOUT, Option.KEYPASS, Option.KEYSTORE, Option.DNAME, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        CHANGEALIAS("Changes.an.entry.s.alias", Option.ALIAS, Option.DESTALIAS, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        DELETE("Deletes.an.entry", Option.ALIAS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        EXPORTCERT("Exports.certificate", Option.RFC, Option.ALIAS, Option.FILEOUT, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENKEYPAIR("Generates.a.key.pair", Option.ALIAS, Option.KEYALG, Option.KEYSIZE, Option.SIGALG, Option.DESTALIAS, Option.DNAME, Option.STARTDATE, Option.EXT, Option.VALIDITY, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENSECKEY("Generates.a.secret.key", Option.ALIAS, Option.KEYPASS, Option.KEYALG, Option.KEYSIZE, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        GENCERT("Generates.certificate.from.a.certificate.request", Option.RFC, Option.INFILE, Option.OUTFILE, Option.ALIAS, Option.SIGALG, Option.DNAME, Option.STARTDATE, Option.EXT, Option.VALIDITY, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IMPORTCERT("Imports.a.certificate.or.a.certificate.chain", Option.NOPROMPT, Option.TRUSTCACERTS, Option.PROTECTED, Option.ALIAS, Option.FILEIN, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        IMPORTPASS("Imports.a.password", Option.ALIAS, Option.KEYPASS, Option.KEYALG, Option.KEYSIZE, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IMPORTKEYSTORE("Imports.one.or.all.entries.from.another.keystore", Option.SRCKEYSTORE, Option.DESTKEYSTORE, Option.SRCSTORETYPE, Option.DESTSTORETYPE, Option.SRCSTOREPASS, Option.DESTSTOREPASS, Option.SRCPROTECTED, Option.SRCPROVIDERNAME, Option.DESTPROVIDERNAME, Option.SRCALIAS, Option.DESTALIAS, Option.SRCKEYPASS, Option.DESTKEYPASS, Option.NOPROMPT, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        KEYPASSWD("Changes.the.key.password.of.an.entry", Option.ALIAS, Option.KEYPASS, Option.NEW, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        LIST("Lists.entries.in.a.keystore", Option.RFC, Option.ALIAS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        PRINTCERT("Prints.the.content.of.a.certificate", Option.RFC, Option.FILEIN, Option.SSLSERVER, Option.JARFILE, Option.V),
        PRINTCERTREQ("Prints.the.content.of.a.certificate.request", Option.FILEIN, Option.V),
        PRINTCRL("Prints.the.content.of.a.CRL.file", Option.FILEIN, Option.V),
        STOREPASSWD("Changes.the.store.password.of.a.keystore", Option.NEW, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        KEYCLONE("Clones.a.key.entry", Option.ALIAS, Option.DESTALIAS, Option.KEYPASS, Option.NEW, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        SELFCERT("Generates.a.self.signed.certificate", Option.ALIAS, Option.SIGALG, Option.DNAME, Option.STARTDATE, Option.VALIDITY, Option.KEYPASS, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V),
        GENCRL("Generates.CRL", Option.RFC, Option.FILEOUT, Option.ID, Option.ALIAS, Option.SIGALG, Option.EXT, Option.KEYPASS, Option.KEYSTORE, Option.STOREPASS, Option.STORETYPE, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V, Option.PROTECTED),
        IDENTITYDB("Imports.entries.from.a.JDK.1.1.x.style.identity.database", Option.FILEIN, Option.STORETYPE, Option.KEYSTORE, Option.STOREPASS, Option.PROVIDERNAME, Option.PROVIDERCLASS, Option.PROVIDERARG, Option.PROVIDERPATH, Option.V);

        final String description;
        final Option[] options;

        private Command(String string2, Option ... optionArray) {
            this.description = string2;
            this.options = optionArray;
        }

        public String toString() {
            return "-" + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

