"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getFinalAnnotationTooltipPosition(
/** the dimensions of the chart parent container */
container, chartDimensions, 
/** the dimensions of the tooltip container */
tooltip, 
/** the tooltip computed position not adjusted within chart bounds */
tooltipAnchor, padding) {
    if (padding === void 0) { padding = 10; }
    var left = 0;
    var annotationXOffset = window.pageXOffset + container.left + chartDimensions.left + tooltipAnchor.left;
    if (chartDimensions.left + tooltipAnchor.left + tooltip.width + padding >= container.width) {
        left = annotationXOffset - tooltip.width - padding;
    }
    else {
        left = annotationXOffset + padding;
    }
    var top = window.pageYOffset + container.top + chartDimensions.top + tooltipAnchor.top;
    if (chartDimensions.top + tooltipAnchor.top + tooltip.height + padding >= container.height) {
        top -= tooltip.height + padding;
    }
    else {
        top += padding;
    }
    return {
        left: Math.round(left) + "px",
        top: Math.round(top) + "px",
    };
}
exports.getFinalAnnotationTooltipPosition = getFinalAnnotationTooltipPosition;
//# sourceMappingURL=annotation_tooltip.js.map