"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_specs_1 = require("./get_specs");
var specs_1 = require("../../utils/specs");
var annotation_utils_1 = require("../../annotations/annotation_utils");
var compute_annotations_1 = require("./compute_annotations");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getAnnotationTooltipStateSelector = re_reselect_1.default([
    getCurrentPointerPosition,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    get_chart_rotation_1.getChartRotationSelector,
    get_specs_1.getAnnotationSpecsSelector,
    get_specs_1.getAxisSpecsSelector,
    compute_annotations_1.computeAnnotationDimensionsSelector,
    get_tooltip_values_highlighted_geoms_1.getTooltipValuesSelector,
], getAnnotationTooltipState)(get_chart_id_1.getChartIdSelector);
function getAnnotationTooltipState(_a, _b, geometries, chartRotation, annotationSpecs, axesSpecs, annotationDimensions, tooltipValues) {
    var x = _a.x, y = _a.y;
    var chartDimensions = _b.chartDimensions;
    // get positions relative to chart
    if (x < 0 || y < 0) {
        return null;
    }
    var _c = geometries.scales, xScale = _c.xScale, yScales = _c.yScales;
    // only if we have a valid cursor position and the necessary scale
    if (!xScale || !yScales) {
        return null;
    }
    // use area chart projected coordinates of the pointer
    var chartAreaProjectedPointer = { x: x - chartDimensions.left, y: y - chartDimensions.top };
    var tooltipState = annotation_utils_1.computeAnnotationTooltipState(chartAreaProjectedPointer, annotationDimensions, annotationSpecs, chartRotation, axesSpecs, chartDimensions);
    // If there's a highlighted chart element tooltip value, don't show annotation tooltip
    var isChartTooltipDisplayed = tooltipValues.some(function (_a) {
        var isHighlighted = _a.isHighlighted;
        return isHighlighted;
    });
    if (tooltipState &&
        tooltipState.isVisible &&
        tooltipState.annotationType === specs_1.AnnotationTypes.Rectangle &&
        isChartTooltipDisplayed) {
        return null;
    }
    return tooltipState;
}
//# sourceMappingURL=get_annotation_tooltip_state.js.map