"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var konva_1 = __importDefault(require("konva"));
var uuid_1 = __importDefault(require("uuid"));
var specs_parser_1 = require("../specs/specs_parser");
var chart_resizer_1 = require("./chart_resizer");
var legend_1 = require("./legend/legend");
var chart_container_1 = require("./chart_container");
var axis_utils_1 = require("../chart_types/xy_chart/utils/axis_utils");
var specs_1 = require("../chart_types/xy_chart/utils/specs");
var chart_size_1 = require("../utils/chart_size");
var chart_status_1 = require("./chart_status");
var chart_state_1 = require("../state/chart_state");
var is_initialized_1 = require("../state/selectors/is_initialized");
var on_element_out_caller_1 = require("../chart_types/xy_chart/state/selectors/on_element_out_caller");
var on_element_over_caller_1 = require("../chart_types/xy_chart/state/selectors/on_element_over_caller");
var on_element_click_caller_1 = require("../chart_types/xy_chart/state/selectors/on_element_click_caller");
var index_1 = require("../chart_types/index");
var get_settings_specs_1 = require("../state/selectors/get_settings_specs");
var on_brush_end_caller_1 = require("../chart_types/xy_chart/state/selectors/on_brush_end_caller");
var events_1 = require("../state/actions/events");
var on_pointer_move_caller_1 = require("../chart_types/xy_chart/state/selectors/on_pointer_move_caller");
function getContainerStyle(size) {
    if (size) {
        return __assign({ position: 'relative' }, chart_size_1.getChartSize(size));
    }
    return {};
}
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart(props) {
        var _this = _super.call(this, props) || this;
        _this.getChartContainerRef = function () {
            return _this.chartContainerRef;
        };
        _this.chartContainerRef = react_1.createRef();
        _this.chartStageRef = react_1.createRef();
        var id = uuid_1.default.v4();
        var storeReducer = chart_state_1.chartStoreReducer(id);
        var enhancers = typeof window !== 'undefined' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__
            ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({ trace: true, name: "@elastic/charts (id: " + id + ")" })()
            : undefined;
        _this.chartStore = redux_1.createStore(storeReducer, enhancers);
        _this.state = {
            legendPosition: specs_1.Position.Right,
        };
        var onElementClickCaller = on_element_click_caller_1.createOnElementClickCaller();
        var onElementOverCaller = on_element_over_caller_1.createOnElementOverCaller();
        var onElementOutCaller = on_element_out_caller_1.createOnElementOutCaller();
        var onBrushEndCaller = on_brush_end_caller_1.createOnBrushEndCaller();
        var onPointerMoveCaller = on_pointer_move_caller_1.createOnPointerMoveCaller();
        _this.chartStore.subscribe(function () {
            var state = _this.chartStore.getState();
            if (!is_initialized_1.isInitialized(state)) {
                return;
            }
            var settings = get_settings_specs_1.getSettingsSpecSelector(state);
            if (_this.state.legendPosition !== settings.legendPosition) {
                _this.setState({
                    legendPosition: settings.legendPosition,
                });
            }
            if (state.chartType !== index_1.ChartTypes.XYAxis) {
                return;
            }
            onElementOverCaller(state);
            onElementOutCaller(state);
            onElementClickCaller(state);
            onBrushEndCaller(state);
            onPointerMoveCaller(state);
        });
        return _this;
    }
    Chart.prototype.dispatchExternalPointerEvent = function (event) {
        this.chartStore.dispatch(events_1.onExternalPointerEvent(event));
    };
    Chart.prototype.getPNGSnapshot = function (options) {
        if (options === void 0) { options = {
            backgroundColor: 'transparent',
            pixelRatio: 2,
        }; }
        if (!this.chartStageRef.current) {
            return null;
        }
        var stage = this.chartStageRef.current.getStage().clone(null);
        var width = stage.getWidth();
        var height = stage.getHeight();
        var backgroundLayer = new konva_1.default.Layer();
        var backgroundRect = new konva_1.default.Rect({
            fill: options.backgroundColor,
            x: 0,
            y: 0,
            width: width,
            height: height,
        });
        backgroundLayer.add(backgroundRect);
        stage.add(backgroundLayer);
        backgroundLayer.moveToBottom();
        stage.draw();
        var canvasStage = stage.toCanvas({
            width: width,
            height: height,
            callback: function () { return undefined; },
        });
        // @ts-ignore
        if (canvasStage.msToBlob) {
            // @ts-ignore
            var blobOrDataUrl = canvasStage.msToBlob();
            return {
                blobOrDataUrl: blobOrDataUrl,
                browser: 'IE11',
            };
        }
        else {
            return {
                blobOrDataUrl: stage.toDataURL({ pixelRatio: options.pixelRatio }),
                browser: 'other',
            };
        }
    };
    Chart.prototype.render = function () {
        var _a = this.props, size = _a.size, className = _a.className;
        var containerStyle = getContainerStyle(size);
        var horizontal = axis_utils_1.isHorizontalAxis(this.state.legendPosition);
        var chartClassNames = classnames_1.default('echChart', className, {
            'echChart--column': horizontal,
        });
        return (react_1.default.createElement(react_redux_1.Provider, { store: this.chartStore },
            react_1.default.createElement("div", { style: containerStyle, className: chartClassNames, ref: this.chartContainerRef },
                react_1.default.createElement(chart_status_1.ChartStatus, null),
                react_1.default.createElement(chart_resizer_1.ChartResizer, null),
                react_1.default.createElement(legend_1.Legend, null),
                react_1.default.createElement(specs_parser_1.SpecsParser, null, this.props.children),
                react_1.default.createElement("div", { className: "echContainer" },
                    react_1.default.createElement(chart_container_1.ChartContainer, { getChartContainerRef: this.getChartContainerRef, forwardStageRef: this.chartStageRef })))));
    };
    Chart.defaultProps = {
        renderer: 'canvas',
    };
    return Chart;
}(react_1.default.Component));
exports.Chart = Chart;
//# sourceMappingURL=chart.js.map