"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_array_1 = require("d3-array");
var d3_collection_1 = require("d3-collection");
function computeOrdinalDataDomain(data, accessor, sorted, removeNull) {
    var domain = data.map(accessor).filter(function (d) { return (removeNull ? d !== null : true); });
    var uniqueValues = __spread(new Set(domain));
    return sorted
        ? uniqueValues.sort(function (a, b) {
            return ("" + a).localeCompare("" + b);
        })
        : uniqueValues;
}
exports.computeOrdinalDataDomain = computeOrdinalDataDomain;
function computeFittedDomain(start, end) {
    if (start === undefined || end === undefined) {
        return [start, end];
    }
    var delta = Math.abs(end - start);
    var padding = (delta === 0 ? end - 0 : delta) / 12;
    var newStart = start - padding;
    var newEnd = end + padding;
    return [start >= 0 && newStart < 0 ? 0 : newStart, end <= 0 && newEnd > 0 ? 0 : newEnd];
}
function computeDomainExtent(computedDomain, scaleToExtent, fitToExtent) {
    if (fitToExtent === void 0) { fitToExtent = false; }
    var _a = __read(fitToExtent && !scaleToExtent ? computeFittedDomain.apply(void 0, __spread(computedDomain)) : computedDomain, 2), start = _a[0], end = _a[1];
    if (start != null && end != null) {
        if (start >= 0 && end >= 0) {
            return scaleToExtent || fitToExtent ? [start, end] : [0, end];
        }
        else if (start < 0 && end < 0) {
            return scaleToExtent || fitToExtent ? [start, end] : [start, 0];
        }
        return [start, end];
    }
    // if any of the values are null
    return [0, 0];
}
exports.computeDomainExtent = computeDomainExtent;
function computeContinuousDataDomain(data, accessor, scaleToExtent, fitToExtent) {
    if (scaleToExtent === void 0) { scaleToExtent = false; }
    if (fitToExtent === void 0) { fitToExtent = false; }
    var range = d3_array_1.extent(data, accessor);
    return computeDomainExtent(range, scaleToExtent, fitToExtent);
}
exports.computeContinuousDataDomain = computeContinuousDataDomain;
// TODO: remove or incorporate this function
function computeStackedContinuousDomain(data, xAccessor, yAccessor, scaleToExtent) {
    if (scaleToExtent === void 0) { scaleToExtent = false; }
    var groups = d3_collection_1.nest()
        .key(function (datum) { return "" + xAccessor(datum); })
        .rollup(function (values) {
        return d3_array_1.sum(values, yAccessor);
    })
        .entries(data);
    var cumulativeSumAccessor = function (d) { return d.value; };
    return computeContinuousDataDomain(groups, cumulativeSumAccessor, scaleToExtent);
}
exports.computeStackedContinuousDomain = computeStackedContinuousDomain;
//# sourceMappingURL=domain.js.map